/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.ui.UIFunctionsUserPrompter;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectImage;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.views.skin.SkinnedDialog;
import com.aelitis.azureus.ui.swt.views.skin.VuzeMessageBoxListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore2;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;

public class VuzeMessageBox
implements UIFunctionsUserPrompter,
SkinnedDialog.SkinnedDialogClosedListener {
    private static final int BUTTON_PADDING = 2;
    private static final int MIN_BUTTON_WIDTH = 50;
    private String title;
    private String text;
    private String[] buttonIDs;
    private Integer[] buttonVals;
    private Button def_button;
    private int defaultButtonPos;
    private int result = -1;
    private ArrayList<UserPrompterResultListener> resultListeners = new ArrayList(1);
    private VuzeMessageBoxListener vuzeMessageBoxListener;
    private SWTSkinObjectContainer soExtra;
    private SkinnedDialog dlg;
    private String iconResource;
    private String subtitle;
    private List<rbInfo> listRBs = new ArrayList<rbInfo>();
    private SWTSkin skin;
    private String textIconResource;
    private boolean closed;
    private boolean opened;
    private Button[] buttons;
    private Map<Integer, Boolean> buttonsEnabled = new HashMap<Integer, Boolean>();

    public VuzeMessageBox(String title, String text, String[] buttons, int defaultOption) {
        this.title = title;
        this.text = text;
        this.buttonIDs = buttons == null ? new String[]{} : buttons;
        this.defaultButtonPos = defaultOption;
    }

    public void setButtonEnabled(final int buttonVal, final boolean enable) {
        this.buttonsEnabled.put(buttonVal, enable);
        if (this.buttons == null) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Button button;
                if (VuzeMessageBox.this.buttons == null) {
                    return;
                }
                int pos = VuzeMessageBox.this.getButtonPosFromVal(buttonVal);
                if (pos >= 0 && pos < VuzeMessageBox.this.buttons.length && (button = VuzeMessageBox.this.buttons[pos]) != null && !button.isDisposed()) {
                    button.setEnabled(enable);
                }
            }
        });
    }

    public void setButtonVals(Integer[] buttonVals) {
        this.buttonVals = buttonVals;
        int cancelPos = -1;
        for (int i = 0; i < buttonVals.length; ++i) {
            Integer val = buttonVals[i];
            if (val != 256) continue;
            cancelPos = i;
            break;
        }
        if (cancelPos >= 0 && Constants.isOSX && cancelPos != 0) {
            String cancelButton = this.buttonIDs[cancelPos];
            for (int i = cancelPos; i > 0; --i) {
                if (this.defaultButtonPos == i) {
                    this.defaultButtonPos = i - 1;
                }
                this.buttonIDs[i] = this.buttonIDs[i - 1];
                this.buttonVals[i] = this.buttonVals[i - 1];
            }
            if (this.defaultButtonPos == 0) {
                this.defaultButtonPos = 1;
            }
            this.buttonIDs[0] = cancelButton;
            buttonVals[0] = 256;
        }
    }

    private int getButtonVal(int buttonPos) {
        if (this.buttonVals == null) {
            return buttonPos;
        }
        if (buttonPos < 0 || buttonPos >= this.buttonVals.length) {
            return 256;
        }
        return this.buttonVals[buttonPos];
    }

    public void setSubTitle(String s) {
        this.subtitle = s;
    }

    public int getAutoCloseInMS() {
        return 0;
    }

    public String getHtml() {
        return null;
    }

    public String getRememberID() {
        return null;
    }

    public String getRememberText() {
        return null;
    }

    public boolean isAutoClosed() {
        return false;
    }

    public void open(final UserPrompterResultListener l) {
        this.opened = true;
        Utils.execSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                if (VuzeMessageBox.this.closed) {
                    return;
                }
                VuzeMessageBox vuzeMessageBox = VuzeMessageBox.this;
                synchronized (vuzeMessageBox) {
                    VuzeMessageBox.this._open(l);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void _open(UserPrompterResultListener l) {
        SWTSkinObjectContainer soBottomArea;
        SWTSkinObjectImage soIcon;
        SWTSkinObjectImage soTopLogo;
        SWTSkinObjectText soText;
        if (l != null) {
            ArrayList<UserPrompterResultListener> arrayList = this.resultListeners;
            synchronized (arrayList) {
                this.resultListeners.add(l);
            }
        }
        this.dlg = new SkinnedDialog("skin3_dlg_generic", "shell", 2144){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void setSkin(SWTSkin skin) {
                super.setSkin(skin);
                VuzeMessageBox.this.skin = skin;
                List list = VuzeMessageBox.this.listRBs;
                synchronized (list) {
                    for (rbInfo rb : VuzeMessageBox.this.listRBs) {
                        VuzeMessageBox.this.addResourceBundle(rb.cla, rb.path, rb.name);
                    }
                    VuzeMessageBox.this.listRBs.clear();
                }
            }

            public void open() {
                super.open();
                if (VuzeMessageBox.this.def_button != null) {
                    VuzeMessageBox.this.def_button.getShell().setDefaultButton(VuzeMessageBox.this.def_button);
                }
            }
        };
        this.dlg.setTitle(this.title);
        this.dlg.addCloseListener(this);
        SWTSkinObjectText soTopTitle = (SWTSkinObjectText)this.skin.getSkinObject("top-title");
        if (soTopTitle != null) {
            soTopTitle.setText(this.subtitle == null ? this.title : this.subtitle);
        }
        if ((soText = (SWTSkinObjectText)this.skin.getSkinObject("middle-title")) != null) {
            soText.setText(this.text);
        }
        if (this.iconResource != null && (soTopLogo = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("top-logo")) != null) {
            soTopLogo.setImageByID(this.iconResource, null);
        }
        if (this.textIconResource != null && (soIcon = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("text-icon")) != null) {
            soIcon.setImageByID(this.textIconResource, null);
        }
        if ((soBottomArea = (SWTSkinObjectContainer)this.skin.getSkinObject("bottom-area")) != null) {
            if (this.buttonIDs.length == 0) {
                soBottomArea.setVisible(false);
            } else {
                this.createButtons(soBottomArea);
            }
        }
        if (this.vuzeMessageBoxListener != null) {
            this.soExtra = (SWTSkinObjectContainer)this.skin.getSkinObject("middle-extra");
            try {
                this.vuzeMessageBoxListener.shellReady(this.dlg.getShell(), this.soExtra);
            }
            catch (Exception e) {
                Debug.out(e);
            }
        }
        if (this.closed) {
            return;
        }
        this.dlg.open();
    }

    private void createButtons(SWTSkinObjectContainer soBottomArea) {
        Composite cBottomArea = soBottomArea.getComposite();
        Composite cCenterH = new Composite(cBottomArea, 0);
        FormData fd = new FormData();
        fd.height = 1;
        fd.width = 1;
        fd.left = new FormAttachment(0);
        fd.right = new FormAttachment(100);
        cCenterH.setLayoutData(fd);
        Composite cCenterV = new Composite(cBottomArea, 0);
        fd = new FormData();
        fd.width = 1;
        fd.height = 1;
        fd.top = new FormAttachment(0);
        fd.bottom = new FormAttachment(100);
        cCenterV.setLayoutData(fd);
        Composite cButtonArea = new Composite(cBottomArea, 0);
        cButtonArea.setBackgroundMode(2);
        fd = new FormData();
        fd.top = new FormAttachment(cCenterV, 0, 0x1000000);
        fd.left = new FormAttachment(cCenterH, 0, 0x1000000);
        cButtonArea.setLayoutData(fd);
        RowLayout rowLayout = new RowLayout(256);
        rowLayout.center = true;
        rowLayout.spacing = 8;
        rowLayout.pack = false;
        cButtonArea.setLayout(rowLayout);
        this.buttons = new Button[this.buttonIDs.length];
        for (int i = 0; i < this.buttonIDs.length; ++i) {
            String buttonText = this.buttonIDs[i];
            if (buttonText == null) continue;
            Button button = this.buttons[i] = new Button(cButtonArea, 8);
            int buttonVal = this.buttonVals == null || i >= this.buttonVals.length ? i : this.buttonVals[i];
            Boolean b = this.buttonsEnabled.get(buttonVal);
            if (b == null) {
                b = Boolean.TRUE;
            }
            button.setEnabled(b);
            button.setText(buttonText);
            RowData rowData = new RowData();
            Point size = button.computeSize(-1, -1);
            size.x += 2;
            if (size.x < 50) {
                size.x = 50;
            }
            rowData.width = size.x;
            button.setLayoutData(rowData);
            if (this.defaultButtonPos == i) {
                this.def_button = button;
            }
            button.setData("ButtonNo", new Integer(i));
            button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    VuzeMessageBox.this.close(((Number)event2.widget.getData("ButtonNo")).intValue());
                }
            });
        }
        cBottomArea.getParent().layout(true, true);
    }

    public void setAutoCloseInMS(int autoCloseInMS) {
    }

    public void setHtml(String html) {
    }

    public void setIconResource(String resource) {
        SWTSkinObjectImage soTopLogo;
        this.iconResource = resource;
        if (this.dlg != null && (soTopLogo = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("top-logo")) != null) {
            soTopLogo.setImageByID(this.iconResource, null);
        }
    }

    public void setRelatedObject(Object relatedObject) {
    }

    public void setRelatedObjects(Object[] relatedObjects) {
    }

    public void setRemember(String rememberID, boolean rememberByDefault, String rememberText) {
    }

    public void setRememberText(String rememberText) {
    }

    public void setUrl(String url) {
    }

    public int waitUntilClosed() {
        if (this.opened) {
            final AESemaphore2 sem = new AESemaphore2("waitUntilClosed");
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    Shell shell;
                    if (VuzeMessageBox.this.dlg == null) {
                        sem.release();
                        return;
                    }
                    if (!VuzeMessageBox.this.opened) {
                        VuzeMessageBox.this.dlg.open();
                    }
                    if ((shell = VuzeMessageBox.this.dlg.getShell()) == null || shell.isDisposed()) {
                        sem.release();
                        return;
                    }
                    shell.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            sem.release();
                        }
                    });
                }
            });
            if (Utils.isThisThreadSWT() && this.dlg != null) {
                Shell shell = this.dlg.getShell();
                if (shell != null) {
                    Display d = shell.getDisplay();
                    while (!shell.isDisposed()) {
                        if (d.readAndDispatch()) continue;
                        d.sleep();
                    }
                }
                return this.getButtonVal(this.result);
            }
            sem.reserve();
        }
        return this.getButtonVal(this.result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void skinDialogClosed(SkinnedDialog dialog) {
        ArrayList<UserPrompterResultListener> arrayList = this.resultListeners;
        synchronized (arrayList) {
            int realResult = this.getButtonVal(this.result);
            for (UserPrompterResultListener l : this.resultListeners) {
                try {
                    l.prompterClosed(realResult);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public void setListener(VuzeMessageBoxListener l) {
        this.vuzeMessageBoxListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int buttonNo) {
        VuzeMessageBox vuzeMessageBox = this;
        synchronized (vuzeMessageBox) {
            this.closed = true;
            this.result = buttonNo;
            if (this.dlg != null) {
                this.dlg.close();
            }
        }
    }

    private int getButtonPosFromVal(int buttonVal) {
        int pos = buttonVal;
        if (this.buttonVals != null) {
            for (int i = 0; i < this.buttonVals.length; ++i) {
                int val = this.buttonVals[i];
                if (buttonVal != val) continue;
                pos = i;
                break;
            }
        }
        return pos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeWithButtonVal(int buttonVal) {
        VuzeMessageBox vuzeMessageBox = this;
        synchronized (vuzeMessageBox) {
            this.closed = true;
            this.result = this.getButtonPosFromVal(buttonVal);
            if (this.dlg != null) {
                this.dlg.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceBundle(Class cla, String path, String name) {
        List<rbInfo> list = this.listRBs;
        synchronized (list) {
            if (this.skin == null) {
                this.listRBs.add(new rbInfo(cla, path, name));
                return;
            }
        }
        String sFile = path + name;
        ClassLoader loader = cla.getClassLoader();
        ResourceBundle subBundle = ResourceBundle.getBundle(sFile, Locale.getDefault(), loader);
        SWTSkinProperties skinProperties = this.skin.getSkinProperties();
        skinProperties.addResourceBundle(subBundle, path, loader);
    }

    public void setTextIconResource(String resource) {
        SWTSkinObjectImage soIcon;
        this.textIconResource = resource;
        if (this.dlg != null && (soIcon = (SWTSkinObjectImage)this.dlg.getSkin().getSkinObject("text-icon")) != null) {
            soIcon.setImageByID(this.textIconResource, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(UserPrompterResultListener l) {
        if (l == null) {
            return;
        }
        ArrayList<UserPrompterResultListener> arrayList = this.resultListeners;
        synchronized (arrayList) {
            this.resultListeners.add(l);
        }
    }

    public void setDefaultButtonByPos(int pos) {
        if (this.dlg == null) {
            this.defaultButtonPos = pos;
        }
    }

    private static class rbInfo {
        Class cla;
        String path;
        String name;

        public rbInfo(Class cla, String path, String name) {
            this.cla = cla;
            this.path = path;
            this.name = name;
        }
    }
}

