/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.views.skin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.ui.InitializerListener;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarEnabler;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.Initializer;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.aelitis.azureus.ui.swt.skin.SWTSkinButtonUtility;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectText;
import com.aelitis.azureus.ui.swt.toolbar.ToolBarItem;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.SB_Transfers;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.ui.swt.views.skin.SkinViewManager;
import com.aelitis.azureus.ui.swt.views.skin.ToolBarView;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SBC_LibraryView
extends SkinView
implements ToolBarEnabler {
    private static final String ID = "library-list";
    public static final int MODE_BIGTABLE = 0;
    public static final int MODE_SMALLTABLE = 1;
    public static final int TORRENTS_ALL = 0;
    public static final int TORRENTS_COMPLETE = 1;
    public static final int TORRENTS_INCOMPLETE = 2;
    public static final int TORRENTS_UNOPENED = 3;
    private static final String[] modeViewIDs = new String[]{"library-big-area", "library-small-area"};
    private static final String[] modeIDs = new String[]{"library.table.big", "library.table.small"};
    private int viewMode = -1;
    private SWTSkinButtonUtility btnSmallTable;
    private SWTSkinButtonUtility btnBigTable;
    private SWTSkinObject soListArea;
    private int torrentFilterMode = 0;
    private String torrentFilter;
    private SWTSkinObject soWait;
    private SWTSkinObject soWaitProgress;
    private SWTSkinObjectText soWaitTask;
    private int waitProgress = 0;
    private SWTSkinObjectText soLibraryInfo;
    private Object datasource;

    public void setViewMode(int viewMode, boolean save) {
        MultipleDocumentInterface mdi;
        MdiEntry entry;
        SWTSkinObject soOldViewArea;
        if (viewMode >= modeViewIDs.length || viewMode < 0 || viewMode == this.viewMode) {
            return;
        }
        int oldViewMode = this.viewMode;
        this.viewMode = viewMode;
        if (oldViewMode >= 0 && oldViewMode < modeViewIDs.length && (soOldViewArea = this.getSkinObject(modeViewIDs[oldViewMode])) != null) {
            soOldViewArea.setVisible(false);
        }
        SelectedContentManager.clearCurrentlySelectedContent();
        SWTSkinObject soViewArea = this.getSkinObject(modeViewIDs[viewMode]);
        if (soViewArea == null) {
            soViewArea = this.skin.createSkinObject(modeIDs[viewMode] + this.torrentFilterMode, modeIDs[viewMode], this.soListArea);
            this.skin.layout();
            soViewArea.setVisible(true);
            soViewArea.getControl().setLayoutData(Utils.getFilledFormData());
        } else {
            soViewArea.setVisible(true);
        }
        if (save) {
            COConfigurationManager.setParameter(this.torrentFilter + ".viewmode", viewMode);
        }
        String entryID = null;
        if (this.torrentFilterMode == 0) {
            entryID = "Library";
        } else if (this.torrentFilterMode == 1) {
            entryID = "LibraryCD";
        } else if (this.torrentFilterMode == 2) {
            entryID = "LibraryDL";
        } else if (this.torrentFilterMode == 3) {
            entryID = "LibraryUnopened";
        }
        if (entryID != null && (entry = (mdi = UIFunctionsManager.getUIFunctions().getMDI()).getEntry(entryID)) != null) {
            entry.setLogID(entryID + "-" + viewMode);
        }
        SB_Transfers.triggerCountRefreshListeners();
        this.setupModeButtons();
    }

    @Override
    public Object skinObjectInitialShow(final SWTSkinObject skinObject, Object params) {
        this.soWait = null;
        try {
            this.soWait = this.getSkinObject("library-wait");
            this.soWaitProgress = this.getSkinObject("library-wait-progress");
            this.soWaitTask = (SWTSkinObjectText)this.getSkinObject("library-wait-task");
            if (this.soWaitProgress != null) {
                this.soWaitProgress.getControl().addPaintListener(new PaintListener(){

                    public void paintControl(PaintEvent e) {
                        Control c = (Control)e.widget;
                        Point size = c.getSize();
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#23a7df"));
                        int breakX = size.x * SBC_LibraryView.this.waitProgress / 100;
                        e.gc.fillRectangle(0, 0, breakX, size.y);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, "#cccccc"));
                        e.gc.fillRectangle(breakX, 0, size.x - breakX, size.y);
                    }
                });
            }
            this.soLibraryInfo = (SWTSkinObjectText)this.getSkinObject("library-info");
            if (this.soLibraryInfo != null) {
                SB_Transfers.addCountRefreshListener(new SB_Transfers.countRefreshListener(){

                    public void countRefreshed(SB_Transfers.stats statsWithLowNoise, SB_Transfers.stats statsNoLowNoise) {
                        SB_Transfers.stats stats2;
                        SB_Transfers.stats stats3 = stats2 = SBC_LibraryView.this.viewMode == 1 ? statsWithLowNoise : statsNoLowNoise;
                        if (SBC_LibraryView.this.torrentFilterMode == 2) {
                            String id = "library.incomplete.header";
                            if (stats2.numDownloading != 1) {
                                id = id + ".p";
                            }
                            String s = MessageText.getString(id, new String[]{String.valueOf(stats2.numDownloading), String.valueOf(stats2.numIncomplete - stats2.numDownloading)});
                            SBC_LibraryView.this.soLibraryInfo.setText(s);
                        } else if (SBC_LibraryView.this.torrentFilterMode == 0) {
                            if (SBC_LibraryView.this.datasource instanceof Category) {
                                Category cat = (Category)SBC_LibraryView.this.datasource;
                                String id = "library.category.header";
                                String s = MessageText.getString(id, new String[]{cat.getName()});
                                SBC_LibraryView.this.soLibraryInfo.setText(s);
                            } else {
                                String id = "library.all.header";
                                if (stats2.numComplete + stats2.numIncomplete != 1) {
                                    id = id + ".p";
                                }
                                String s = MessageText.getString(id, new String[]{String.valueOf(stats2.numComplete + stats2.numIncomplete), String.valueOf(stats2.numSeeding + stats2.numDownloading)});
                                SBC_LibraryView.this.soLibraryInfo.setText(s);
                            }
                        } else if (SBC_LibraryView.this.torrentFilterMode == 3) {
                            String id = "library.unopened.header";
                            if (stats2.numUnOpened != 1) {
                                id = id + ".p";
                            }
                            String s = MessageText.getString(id, new String[]{String.valueOf(stats2.numUnOpened)});
                            SBC_LibraryView.this.soLibraryInfo.setText(s);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        AzureusCore core = AzureusCoreFactory.getSingleton();
        if (!AzureusCoreFactory.isCoreRunning()) {
            Initializer initializer;
            if (this.soWait != null) {
                this.soWait.setVisible(true);
            }
            if ((initializer = Initializer.getLastInitializer()) != null) {
                initializer.addListener(new InitializerListener(){

                    public void reportPercent(final int percent) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                if (SBC_LibraryView.this.soWaitProgress != null && !SBC_LibraryView.this.soWaitProgress.isDisposed()) {
                                    SBC_LibraryView.this.waitProgress = percent;
                                    SBC_LibraryView.this.soWaitProgress.getControl().redraw();
                                    SBC_LibraryView.this.soWaitProgress.getControl().update();
                                }
                            }
                        });
                        if (percent > 100) {
                            initializer.removeListener(this);
                        }
                    }

                    public void reportCurrentTask(String currentTask) {
                        if (SBC_LibraryView.this.soWaitTask != null && !SBC_LibraryView.this.soWaitTask.isDisposed()) {
                            SBC_LibraryView.this.soWaitTask.setText(currentTask);
                        }
                    }
                });
            }
        }
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(final AzureusCore core) {
                PluginInterface pi = PluginInitializer.getDefaultInterface();
                final UIManager uim = pi.getUIManager();
                uim.addUIListener(new UIManagerListener(){

                    public void UIDetached(UIInstance instance) {
                    }

                    public void UIAttached(UIInstance instance) {
                        if (instance instanceof UISWTInstance) {
                            uim.removeUIListener(this);
                            Utils.execSWTThread(new AERunnable(){

                                public void runSupport() {
                                    if (SBC_LibraryView.this.soWait != null) {
                                        SBC_LibraryView.this.soWait.setVisible(false);
                                    }
                                    SBC_LibraryView.this.setupView(core, skinObject);
                                }
                            });
                        }
                    }
                });
            }
        });
        return null;
    }

    protected void setupView(AzureusCore core, SWTSkinObject skinObject) {
        MdiEntrySWT entry;
        MultipleDocumentInterfaceSWT mdi;
        this.torrentFilter = skinObject.getSkinObjectID();
        if (this.torrentFilter.equalsIgnoreCase("LibraryDL")) {
            this.torrentFilterMode = 2;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryCD")) {
            this.torrentFilterMode = 1;
        } else if (this.torrentFilter.equalsIgnoreCase("LibraryUnopened")) {
            this.torrentFilterMode = 3;
        }
        this.soListArea = this.getSkinObject("library-list-area");
        this.soListArea.getControl().setData("TorrentFilterMode", new Long(this.torrentFilterMode));
        this.soListArea.getControl().setData("DataSource", this.datasource);
        this.setViewMode(COConfigurationManager.getIntParameter(this.torrentFilter + ".viewmode"), false);
        SWTSkinObject so = this.getSkinObject("library-list-button-smalltable");
        if (so != null) {
            this.btnSmallTable = new SWTSkinButtonUtility(so);
            this.btnSmallTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(1, true);
                }
            });
        }
        if ((so = this.getSkinObject("library-list-button-bigtable")) != null) {
            this.btnBigTable = new SWTSkinButtonUtility(so);
            this.btnBigTable.addSelectionListener(new SWTSkinButtonUtility.ButtonListenerAdapter(){

                public void pressed(SWTSkinButtonUtility buttonUtility, SWTSkinObject skinObject, int stateMask) {
                    SBC_LibraryView.this.setViewMode(0, true);
                }
            });
        }
        if ((mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT()) != null && (entry = mdi.getEntryFromSkinObject(skinObject)) != null) {
            entry.addToolbarEnabler(this);
        }
        SkinViewManager.addListener(ToolBarView.class, new SkinViewManager.SkinViewManagerListener(){

            public void skinViewAdded(SkinView skinview) {
                if (skinview instanceof ToolBarView) {
                    ToolBarView tbv = (ToolBarView)skinview;
                    tbv.addListener(new ToolBarView.ToolBarViewListener(){

                        public void toolbarViewInitialized(ToolBarView tbv) {
                            SBC_LibraryView.this.setupModeButtons();
                        }
                    });
                }
            }
        });
        SB_Transfers.setupViewTitleWithCore(core);
    }

    @Override
    public void refreshToolBar(Map<String, Boolean> list) {
        list.put("modeSmall", true);
        list.put("modeBig", true);
    }

    @Override
    public boolean toolBarItemActivated(String itemKey) {
        if (itemKey.equals("modeSmall") && this.isVisible()) {
            this.setViewMode(1, true);
        }
        if (itemKey.equals("modeBig") && this.isVisible()) {
            this.setViewMode(0, true);
        }
        return false;
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        this.setupModeButtons();
        return null;
    }

    private void setupModeButtons() {
        ToolBarView tb = (ToolBarView)SkinViewManager.getByClass(ToolBarView.class);
        if (tb != null) {
            ToolBarItem itemModeBig;
            ToolBarItem itemModeSmall = tb.getToolBarItem("modeSmall");
            if (itemModeSmall != null) {
                itemModeSmall.getSkinButton().getSkinObject().switchSuffix(this.viewMode == 0 ? "" : "-down");
            }
            if ((itemModeBig = tb.getToolBarItem("modeBig")) != null) {
                itemModeBig.getSkinButton().getSkinObject().switchSuffix(this.viewMode == 0 ? "-down" : "");
            }
        }
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        return super.skinObjectHidden(skinObject, params);
    }

    @Override
    public Object dataSourceChanged(SWTSkinObject skinObject, Object params) {
        this.datasource = params;
        if (this.soListArea != null) {
            this.soListArea.getControl().setData("DataSource", params);
        }
        return null;
    }

    public int getViewMode() {
        return this.viewMode;
    }
}

