/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionManagerFactory;
import com.aelitis.azureus.core.subs.SubscriptionUtils;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.shells.main.MainWindow;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionManagerUI;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.CustomTableTooltipHandler;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class SubscriptionWizard {
    private static final int MODE_OPT_IN = 1;
    private static final int MODE_SUBSCRIBE = 2;
    private static final int MODE_CREATE_SEARCH = 3;
    private static final int MODE_CREATE_RSS = 4;
    private static final int RANK_COLUMN_WIDTH = 85;
    private final String TITLE_OPT_IN = MessageText.getString("Wizard.Subscription.optin.title");
    private final String TITLE_SUBSCRIBE = MessageText.getString("Wizard.Subscription.subscribe.title");
    private final String TITLE_CREATE = MessageText.getString("Wizard.Subscription.create.title");
    Display display;
    Shell shell;
    Image rankingBars;
    Color rankingBorderColor;
    Label title;
    Button cancelButton;
    Button searchButton;
    Button saveButton;
    Button yesButton;
    Button addButton;
    Button availableButton;
    Button createButton;
    Font boldFont;
    Font titleFont;
    Font subTitleFont;
    Font textInputFont;
    Composite main;
    StackLayout mainLayout;
    Composite optinComposite;
    Composite subscribeComposite;
    Composite createComposite;
    TabFolder createTabFolder;
    TabItem createRSSTabItem;
    TabItem createSearchTabItem;
    Composite availableSubscriptionComposite;
    Table libraryTable;
    Listener rssSaveListener;
    Listener searchListener;
    Text searchInput;
    Text feedUrl;
    SubscriptionUtils.SubscriptionDownloadDetails[] availableSubscriptions;
    Subscription[] subscriptions;
    DownloadManager download;
    private ImageLoader imageLoader;

    public SubscriptionWizard() {
        this(null);
    }

    public SubscriptionWizard(final DownloadManager download) {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                SubscriptionWizard.this.init(core, download);
            }
        });
    }

    protected void init(AzureusCore core, DownloadManager download) {
        this.imageLoader = ImageLoader.getInstance();
        this.download = download;
        this.availableSubscriptions = SubscriptionUtils.getAllCachedDownloadDetails(core);
        Arrays.sort(this.availableSubscriptions, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (!(o1 instanceof SubscriptionUtils.SubscriptionDownloadDetails) || !(o2 instanceof SubscriptionUtils.SubscriptionDownloadDetails)) {
                    return 0;
                }
                SubscriptionUtils.SubscriptionDownloadDetails sub1 = (SubscriptionUtils.SubscriptionDownloadDetails)o1;
                SubscriptionUtils.SubscriptionDownloadDetails sub2 = (SubscriptionUtils.SubscriptionDownloadDetails)o2;
                return sub1.getDownload().getDisplayName().compareTo(sub2.getDownload().getDisplayName());
            }
        });
        this.shell = ShellFactory.createMainShell(112);
        this.shell.setSize(650, 400);
        Utils.centreWindow(this.shell);
        this.shell.setMinimumSize(550, 400);
        this.display = this.shell.getDisplay();
        Utils.setShellIcon(this.shell);
        this.rankingBars = this.imageLoader.getImage("ranking_bars");
        this.rankingBorderColor = new Color(this.display, 200, 200, 200);
        this.createFonts();
        this.shell.setText(MessageText.getString("Wizard.Subscription.title"));
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                SubscriptionWizard.this.imageLoader.releaseImage("ranking_bars");
                SubscriptionWizard.this.imageLoader.releaseImage("wizard_header_bg");
                SubscriptionWizard.this.imageLoader.releaseImage("icon_rss");
                if (SubscriptionWizard.this.titleFont != null && !SubscriptionWizard.this.titleFont.isDisposed()) {
                    SubscriptionWizard.this.titleFont.dispose();
                }
                if (SubscriptionWizard.this.textInputFont != null && !SubscriptionWizard.this.textInputFont.isDisposed()) {
                    SubscriptionWizard.this.textInputFont.dispose();
                }
                if (SubscriptionWizard.this.boldFont != null && !SubscriptionWizard.this.boldFont.isDisposed()) {
                    SubscriptionWizard.this.boldFont.dispose();
                }
                if (SubscriptionWizard.this.subTitleFont != null && !SubscriptionWizard.this.subTitleFont.isDisposed()) {
                    SubscriptionWizard.this.subTitleFont.dispose();
                }
                if (SubscriptionWizard.this.rankingBorderColor != null && !SubscriptionWizard.this.rankingBorderColor.isDisposed()) {
                    SubscriptionWizard.this.rankingBorderColor.dispose();
                }
            }
        });
        Composite header = new Composite(this.shell, 0);
        header.setBackgroundMode(1);
        header.setBackgroundImage(this.imageLoader.getImage("wizard_header_bg"));
        Label topSeparator = new Label(this.shell, 258);
        this.main = new Composite(this.shell, 0);
        Label bottomSeparator = new Label(this.shell, 258);
        Composite footer = new Composite(this.shell, 0);
        FormLayout layout = new FormLayout();
        this.shell.setLayout(layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        header.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(topSeparator, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(bottomSeparator, 0);
        this.main.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(footer, 0);
        bottomSeparator.setLayoutData(data);
        data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        footer.setLayoutData(data);
        this.populateHeader(header);
        this.populateFooter(footer);
        this.mainLayout = new StackLayout();
        this.main.setLayout(this.mainLayout);
        this.optinComposite = this.createOptInComposite(this.main);
        this.createComposite = this.createCreateComposite(this.main);
        this.availableSubscriptionComposite = this.createAvailableSubscriptionComposite(this.main);
        this.setDefaultAvailableMode();
        this.shell.layout();
        this.shell.open();
        this.setInitialViews();
    }

    protected void setInitialViews() {
        if (this.availableSubscriptions != null) {
            for (int i = 0; i < this.availableSubscriptions.length; ++i) {
                SubscriptionUtils.SubscriptionDownloadDetails details = this.availableSubscriptions[i];
                if (details.getDownload() != this.download) continue;
                final int f_i = i;
                Utils.execSWTThread(new Runnable(){

                    public void run() {
                        SubscriptionWizard.this.libraryTable.setTopIndex(f_i);
                    }
                });
            }
        }
    }

    private void populateHeader(Composite header) {
        header.setBackground(this.display.getSystemColor(1));
        this.title = new Label(header, 64);
        this.title.setFont(this.titleFont);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        header.setLayout(layout);
    }

    private Composite createOptInComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(2);
        Label description = new Label(composite, 64);
        description.setFont(this.boldFont);
        description.setText(MessageText.getString("Wizard.Subscription.optin.description"));
        FormLayout layout = new FormLayout();
        composite.setLayout(layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 40);
        data.left = new FormAttachment(0, 50);
        data.right = new FormAttachment(100, -50);
        description.setLayoutData(data);
        return composite;
    }

    private Composite createCreateComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        composite.setLayout(layout);
        this.createTabFolder = new TabFolder(composite, 0);
        this.createTabFolder.setFont(this.subTitleFont);
        this.createSearchTabItem = new TabItem(this.createTabFolder, 0);
        this.createSearchTabItem.setText(MessageText.getString("Wizard.Subscription.create.search"));
        this.createSearchTabItem.setControl(this.createCreateSearchComposite(this.createTabFolder));
        this.createRSSTabItem = new TabItem(this.createTabFolder, 0);
        this.createRSSTabItem.setText("  " + MessageText.getString("Wizard.Subscription.create.rss"));
        this.createRSSTabItem.setControl(this.createCreateRSSComposite(this.createTabFolder));
        this.createTabFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                TabItem[] selectedItems = SubscriptionWizard.this.createTabFolder.getSelection();
                if (selectedItems.length != 1) {
                    return;
                }
                TabItem selectedItem = selectedItems[0];
                if (selectedItem == SubscriptionWizard.this.createRSSTabItem) {
                    SubscriptionWizard.this.setMode(4);
                } else {
                    SubscriptionWizard.this.setMode(3);
                }
            }
        });
        return composite;
    }

    private Composite createCreateRSSComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label subTitle1 = new Label(composite, 64);
        subTitle1.setFont(this.subTitleFont);
        subTitle1.setText(MessageText.getString("Wizard.Subscription.rss.subtitle1"));
        this.feedUrl = new Text(composite, 4);
        this.feedUrl.setFont(this.textInputFont);
        this.feedUrl.setText("http://");
        this.feedUrl.addListener(14, this.rssSaveListener);
        this.feedUrl.addListener(24, new Listener(){

            public void handleEvent(Event event2) {
                boolean valid_url = false;
                try {
                    URL url = new URL(SubscriptionWizard.this.feedUrl.getText());
                    String protocol = url.getProtocol().toLowerCase();
                    valid_url = protocol.equals("azplug") || protocol.equals("file") || url.getHost().trim().length() > 0;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SubscriptionWizard.this.saveButton.setEnabled(valid_url);
            }
        });
        Label rssBackground = new Label(composite, 0);
        this.imageLoader.setLabelImage(rssBackground, "rss_bg");
        int width = rssBackground.getImage().getBounds().width;
        Label subTitle2 = new Label(composite, 64);
        subTitle2.setText(MessageText.getString("Wizard.Subscription.rss.subtitle2"));
        Label rssBullet = new Label(composite, 0);
        this.imageLoader.setLabelImage(rssBullet, "rss");
        Label subTitle3 = new Label(composite, 64);
        subTitle3.setFont(this.subTitleFont);
        subTitle3.setText(MessageText.getString("Wizard.Subscription.rss.subtitle3"));
        FormLayout layout = new FormLayout();
        layout.marginWidth = 50;
        layout.marginTop = 25;
        composite.setLayout(layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle1.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(subTitle1, 5);
        data.left = new FormAttachment(50, -width / 2);
        rssBackground.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(rssBackground, 7, 128);
        data.left = new FormAttachment(rssBackground, 45, 16384);
        data.right = new FormAttachment(rssBackground, -8, 131072);
        this.feedUrl.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(rssBackground, 15);
        data.left = new FormAttachment(0);
        rssBullet.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(rssBullet, -3, 128);
        data.left = new FormAttachment(rssBullet, 5);
        data.right = new FormAttachment(100);
        subTitle2.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(subTitle2, 20);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle3.setLayoutData(data);
        return composite;
    }

    private Composite createCreateSearchComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label subTitle1 = new Label(composite, 64);
        subTitle1.setFont(this.subTitleFont);
        subTitle1.setText(MessageText.getString("Wizard.Subscription.search.subtitle1"));
        this.searchInput = new Text(composite, 4);
        this.searchInput.setFont(this.textInputFont);
        this.searchInput.addListener(14, this.searchListener);
        Label searchBackground = new Label(composite, 0);
        this.imageLoader.setLabelImage(searchBackground, "search_bg");
        int width = searchBackground.getImage().getBounds().width;
        Label subTitle2 = new Label(composite, 64);
        subTitle2.setFont(this.subTitleFont);
        subTitle2.setText(MessageText.getString("Wizard.Subscription.search.subtitle2"));
        Label checkBullet1 = new Label(composite, 0);
        this.imageLoader.setLabelImage(checkBullet1, "icon_check");
        Label checkBullet2 = new Label(composite, 0);
        this.imageLoader.setLabelImage(checkBullet2, "icon_check");
        Label description1 = new Label(composite, 0);
        description1.setText(MessageText.getString("Wizard.Subscription.search.subtitle2.sub1"));
        Label description2 = new Label(composite, 0);
        description2.setText(MessageText.getString("Wizard.Subscription.search.subtitle2.sub2"));
        Label subTitle3 = new Label(composite, 64);
        subTitle3.setFont(this.subTitleFont);
        subTitle3.setText(MessageText.getString("Wizard.Subscription.search.subtitle3"));
        FormLayout layout = new FormLayout();
        layout.marginLeft = 50;
        layout.marginRight = 50;
        layout.marginTop = 25;
        composite.setLayout(layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle1.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(subTitle1, 5);
        data.left = new FormAttachment(50, -width / 2);
        searchBackground.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(searchBackground, 7, 128);
        data.left = new FormAttachment(searchBackground, 45, 16384);
        data.right = new FormAttachment(searchBackground, -8, 131072);
        this.searchInput.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(searchBackground, 15);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle2.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(subTitle2, 5);
        data.left = new FormAttachment(0);
        checkBullet1.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(checkBullet1, 5);
        data.left = new FormAttachment(0);
        checkBullet2.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(checkBullet1, 0, 128);
        data.left = new FormAttachment(checkBullet1, 5);
        description1.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(checkBullet2, 0, 128);
        data.left = new FormAttachment(checkBullet2, 5);
        description2.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(checkBullet2, 15);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        subTitle3.setLayoutData(data);
        return composite;
    }

    private Composite createAvailableSubscriptionComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        Label hsep1 = new Label(composite, 258);
        Label hsep2 = new Label(composite, 258);
        Label vsep = new Label(composite, 514);
        Label subtitle1 = new Label(composite, 0);
        Label subtitle2 = new Label(composite, 0);
        subtitle1.setFont(this.subTitleFont);
        subtitle2.setFont(this.subTitleFont);
        subtitle1.setText(MessageText.getString("Wizard.Subscription.subscribe.library"));
        subtitle2.setText(MessageText.getString("Wizard.Subscription.subscribe.subscriptions"));
        this.libraryTable = new Table(composite, 268501508);
        TableColumn torrentColumn = new TableColumn(this.libraryTable, 0);
        torrentColumn.setWidth(50);
        Composite compEmpty = new Composite(composite, 0);
        compEmpty.setBackground(this.display.getSystemColor(1));
        compEmpty.setBackgroundMode(1);
        FillLayout fl = new FillLayout();
        fl.marginHeight = 15;
        fl.marginWidth = 15;
        compEmpty.setLayout(fl);
        compEmpty.setVisible(false);
        Link labelEmpty = new Link(compEmpty, 64);
        labelEmpty.setText(MessageText.getString("Wizard.Subscription.subscribe.library.empty"));
        labelEmpty.setFont(this.subTitleFont);
        labelEmpty.setForeground(ColorCache.getColor((Device)composite.getDisplay(), "#6D6F6E"));
        labelEmpty.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                    Utils.launch(event2.text);
                }
            }
        });
        final Table subscriptionTable = new Table(composite, 268501508);
        TableColumn nameColumn = new TableColumn(subscriptionTable, 0);
        TableColumn rankColumn = new TableColumn(subscriptionTable, 0);
        Listener resizeListener = new Listener(){
            int last_width;

            public void handleEvent(Event event2) {
                Table table = (Table)event2.widget;
                Rectangle rect = table.getClientArea();
                int width = rect.width - 3;
                if (width == this.last_width) {
                    return;
                }
                this.last_width = width;
                int nbColumns = table.getColumnCount();
                if (nbColumns == 1) {
                    table.getColumns()[0].setWidth(width);
                } else if (width > 185) {
                    table.getColumns()[1].setWidth(85);
                    table.getColumns()[0].setWidth(width - 85);
                } else {
                    table.getColumns()[0].setWidth(100);
                    table.getColumns()[1].setWidth(width - 85);
                }
                ((Table)event2.widget).update();
            }
        };
        subscriptionTable.addListener(11, resizeListener);
        this.libraryTable.addListener(11, resizeListener);
        final Listener subscriptionSelectionListener = new Listener(){

            public void handleEvent(Event event2) {
                if (subscriptionTable.getSelectionCount() == 1) {
                    SubscriptionWizard.this.addButton.setEnabled(true);
                    Subscription subscription = SubscriptionWizard.this.subscriptions[subscriptionTable.getSelectionIndex()];
                    if (subscription.isSubscribed()) {
                        SubscriptionWizard.this.addButton.setEnabled(false);
                    } else {
                        SubscriptionWizard.this.addButton.setEnabled(true);
                    }
                    SubscriptionWizard.this.addButton.setData("subscription", subscription);
                } else {
                    SubscriptionWizard.this.addButton.setEnabled(false);
                }
            }
        };
        final Listener selectionListener = new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                SubscriptionWizard.this.subscriptions = (Subscription[])item.getData("subscriptions");
                if (SubscriptionWizard.this.subscriptions != null) {
                    Arrays.sort(SubscriptionWizard.this.subscriptions, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            if (!(o1 instanceof Subscription) || !(o2 instanceof Subscription)) {
                                return 0;
                            }
                            Subscription sub1 = (Subscription)o1;
                            Subscription sub2 = (Subscription)o2;
                            return (int)(sub2.getCachedPopularity() - sub1.getCachedPopularity());
                        }
                    });
                    subscriptionTable.setItemCount(SubscriptionWizard.this.subscriptions.length);
                }
                SubscriptionWizard.this.addButton.setEnabled(false);
                SubscriptionWizard.this.addButton.setData("subscription", null);
                subscriptionTable.clearAll();
                subscriptionTable.deselectAll();
                if (subscriptionTable.getItemCount() > 0) {
                    subscriptionTable.setSelection(0);
                    subscriptionSelectionListener.handleEvent(null);
                }
            }
        };
        this.libraryTable.addListener(13, selectionListener);
        if (this.availableSubscriptions != null) {
            this.libraryTable.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    int index = SubscriptionWizard.this.libraryTable.indexOf(item);
                    SubscriptionUtils.SubscriptionDownloadDetails subInfo = SubscriptionWizard.this.availableSubscriptions[index];
                    item.setText(subInfo.getDownload().getDisplayName());
                    item.setData("subscriptions", subInfo.getSubscriptions());
                    boolean isSubscribed = false;
                    Subscription[] subs = subInfo.getSubscriptions();
                    for (int i = 0; i < subs.length; ++i) {
                        if (!subs[i].isSubscribed()) continue;
                        isSubscribed = true;
                    }
                    if (isSubscribed) {
                        item.setForeground(SubscriptionWizard.this.display.getSystemColor(15));
                    }
                    if (subInfo.getDownload() == SubscriptionWizard.this.download) {
                        SubscriptionWizard.this.libraryTable.setSelection(item);
                        selectionListener.handleEvent(event2);
                    }
                    if (index == 0 && SubscriptionWizard.this.download == null) {
                        SubscriptionWizard.this.libraryTable.setSelection(item);
                        selectionListener.handleEvent(event2);
                    }
                    if (SubscriptionWizard.this.libraryTable.getSelectionIndex() == index) {
                        selectionListener.handleEvent(event2);
                    }
                }
            });
            this.libraryTable.setItemCount(this.availableSubscriptions.length);
            if (this.availableSubscriptions.length == 0) {
                this.libraryTable.setVisible(false);
                compEmpty.setVisible(true);
            }
        } else {
            this.libraryTable.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    int index = SubscriptionWizard.this.libraryTable.indexOf(item);
                    item.setText("test " + index);
                }
            });
            this.libraryTable.setItemCount(20);
        }
        this.addButton.setEnabled(false);
        this.addButton.setData("subscription", null);
        subscriptionTable.addListener(13, subscriptionSelectionListener);
        final Image rssIcon = this.imageLoader.getImage("icon_rss");
        if (this.availableSubscriptions != null) {
            subscriptionTable.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    int index = subscriptionTable.indexOf(item);
                    Subscription subscription = SubscriptionWizard.this.subscriptions[index];
                    item.setImage(rssIcon);
                    item.setText(0, subscription.getName());
                    item.setData("tooltip", subscription.getNameEx());
                    item.setData("popularity", new Long(subscription.getCachedPopularity()));
                    if (subscription.isSubscribed()) {
                        item.setForeground(SubscriptionWizard.this.display.getSystemColor(15));
                        subscriptionTable.setSelection(item);
                    }
                }
            });
        } else {
            subscriptionTable.addListener(36, new Listener(){

                public void handleEvent(Event event2) {
                    TableItem item = (TableItem)event2.item;
                    int index = subscriptionTable.indexOf(item);
                    item.setImage(rssIcon);
                    item.setText(0, "sub test " + index);
                    item.setData("popularity", new Long((int)(700.0 * Math.random() - 100.0)));
                }
            });
        }
        Listener paintListener = new Listener(){

            public void handleEvent(Event event2) {
                GC gc = event2.gc;
                TableItem item = (TableItem)event2.item;
                switch (event2.type) {
                    case 41: {
                        event2.height = 20;
                        break;
                    }
                    case 40: {
                        Rectangle bounds = item.getBounds(1);
                        gc.setBackground(item.getBackground(1));
                        gc.setForeground(item.getBackground(1));
                        gc.fillRectangle(bounds);
                        break;
                    }
                    case 42: {
                        Rectangle bounds = item.getBounds(1);
                        bounds.width -= 3;
                        bounds.height -= 7;
                        ++bounds.x;
                        bounds.y += 3;
                        gc.setBackground(SubscriptionWizard.this.display.getSystemColor(1));
                        gc.fillRectangle(bounds);
                        gc.setForeground(SubscriptionWizard.this.rankingBorderColor);
                        gc.drawRectangle(bounds);
                        bounds.width -= 2;
                        bounds.height -= 2;
                        ++bounds.x;
                        ++bounds.y;
                        Long pop = (Long)item.getData("popularity");
                        if (pop == null) break;
                        long popularity = pop;
                        int rank = 80 * (int)popularity / 1000;
                        if (rank > 80) {
                            rank = 80;
                        }
                        if (rank < 5) {
                            rank = 5;
                        }
                        Rectangle clipping = gc.getClipping();
                        bounds.width = rank;
                        --bounds.height;
                        ++bounds.x;
                        ++bounds.y;
                        gc.setClipping(bounds);
                        gc.drawImage(SubscriptionWizard.this.rankingBars, bounds.x, bounds.y);
                        gc.setClipping(clipping);
                        break;
                    }
                }
            }
        };
        new CustomTableTooltipHandler(subscriptionTable);
        subscriptionTable.addListener(40, paintListener);
        subscriptionTable.addListener(42, paintListener);
        subscriptionTable.addListener(41, paintListener);
        this.libraryTable.addListener(41, paintListener);
        FormLayout layout = new FormLayout();
        composite.setLayout(layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(40, 0);
        data.bottom = new FormAttachment(100, 0);
        vsep.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(vsep, 0);
        data.left = new FormAttachment(0, 5);
        subtitle1.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(vsep, 5);
        data.right = new FormAttachment(100, 0);
        subtitle2.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(subtitle1, 5);
        data.right = new FormAttachment(vsep, 0);
        data.left = new FormAttachment(0, 0);
        hsep1.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(subtitle2, 5);
        data.left = new FormAttachment(vsep, -1);
        data.right = new FormAttachment(100, 0);
        hsep2.setLayoutData(data);
        data = new FormData();
        data.top = new FormAttachment(hsep1, 0);
        data.right = new FormAttachment(vsep, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        if (this.availableSubscriptions != null && this.availableSubscriptions.length > 0) {
            this.libraryTable.setLayoutData(data);
        } else {
            this.libraryTable.dispose();
            this.cancelButton.setFocus();
            this.shell.setDefaultButton(this.cancelButton);
            compEmpty.setLayoutData(data);
        }
        data = new FormData();
        data.top = new FormAttachment(hsep2, 0);
        data.left = new FormAttachment(vsep, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        subscriptionTable.setLayoutData(data);
        return composite;
    }

    private void createFonts() {
        int i;
        FontData[] fDatas = this.shell.getFont().getFontData();
        for (i = 0; i < fDatas.length; ++i) {
            fDatas[i].setStyle(1);
        }
        this.boldFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(12);
                continue;
            }
            fDatas[i].setHeight(10);
        }
        this.subTitleFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(17);
                continue;
            }
            fDatas[i].setHeight(14);
        }
        this.titleFont = new Font((Device)this.display, fDatas);
        for (i = 0; i < fDatas.length; ++i) {
            if (Constants.isOSX) {
                fDatas[i].setHeight(14);
            } else {
                fDatas[i].setHeight(12);
            }
            fDatas[i].setStyle(0);
        }
        this.textInputFont = new Font((Device)this.display, fDatas);
    }

    private void populateFooter(Composite footer) {
        this.yesButton = new Button(footer, 8);
        this.yesButton.setText(MessageText.getString("Button.yes"));
        this.yesButton.setFont(this.boldFont);
        this.addButton = new Button(footer, 8);
        this.addButton.setText(MessageText.getString("Button.add"));
        this.addButton.setFont(this.boldFont);
        this.saveButton = new Button(footer, 8);
        this.saveButton.setText(MessageText.getString("Button.save"));
        this.saveButton.setEnabled(false);
        this.saveButton.setFont(this.boldFont);
        this.searchButton = new Button(footer, 8);
        this.searchButton.setText(MessageText.getString("Button.search"));
        this.searchButton.setFont(this.boldFont);
        this.cancelButton = new Button(footer, 8);
        this.createButton = new Button(footer, 8);
        this.createButton.setText(MessageText.getString("Button.createNewSubscription"));
        this.availableButton = new Button(footer, 8);
        this.availableButton.setText(MessageText.getString("Button.availableSubscriptions"));
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        footer.setLayout(layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.width = 100;
        this.yesButton.setLayoutData(data);
        this.addButton.setLayoutData(data);
        this.searchButton.setLayoutData(data);
        data = new FormData();
        data.right = new FormAttachment(100);
        data.width = 100;
        this.saveButton.setLayoutData(data);
        data = new FormData();
        data.right = new FormAttachment(this.saveButton);
        data.width = 100;
        this.cancelButton.setLayoutData(data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.width = 175;
        this.createButton.setLayoutData(data);
        this.availableButton.setLayoutData(data);
        this.yesButton.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                COConfigurationManager.setParameter("subscriptions.opted_in", true);
                COConfigurationManager.save();
                SubscriptionWizard.this.setMode(2);
            }
        });
        this.createButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionWizard.this.setMode(3);
            }
        });
        this.availableButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionWizard.this.setDefaultAvailableMode();
            }
        });
        this.cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SubscriptionWizard.this.shell.close();
            }
        });
        this.rssSaveListener = new Listener(){

            public void handleEvent(Event event2) {
                try {
                    String url_str = SubscriptionWizard.this.feedUrl.getText();
                    URL url = new URL(url_str);
                    HashMap<Object, Boolean> user_data = new HashMap<Object, Boolean>();
                    user_data.put(SubscriptionManagerUI.SUB_EDIT_MODE_KEY, new Boolean(true));
                    Subscription subRSS = SubscriptionManagerFactory.getSingleton().createRSS(url_str, url, 120, user_data);
                    SubscriptionWizard.this.shell.close();
                    String key = "Subscription_" + ByteFormatter.encodeString(subRSS.getPublicKey());
                    MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                    mdi.showEntryByID(key);
                }
                catch (Throwable e) {
                    Utils.reportError(e);
                }
            }
        };
        this.saveButton.addListener(13, this.rssSaveListener);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                Subscription subscription = (Subscription)SubscriptionWizard.this.addButton.getData("subscription");
                if (subscription != null) {
                    subscription.setSubscribed(true);
                    SubscriptionWizard.this.shell.close();
                }
            }
        });
        this.searchListener = new Listener(){

            public void handleEvent(Event event2) {
                MainWindow.doSearch(SubscriptionWizard.this.searchInput.getText(), true);
                SubscriptionWizard.this.shell.close();
            }
        };
        this.searchButton.addListener(13, this.searchListener);
    }

    private void setDefaultAvailableMode() {
        boolean opted_in = COConfigurationManager.getBooleanParameter("subscriptions.opted_in");
        if (!opted_in) {
            this.setMode(1);
        } else {
            this.setMode(2);
        }
    }

    private void setMode(int mode) {
        this.addButton.setVisible(false);
        this.searchButton.setVisible(false);
        this.saveButton.setVisible(false);
        this.yesButton.setVisible(false);
        this.createButton.setVisible(false);
        this.availableButton.setVisible(false);
        this.cancelButton.setText(MessageText.getString("Button.cancel"));
        String titleText = this.TITLE_OPT_IN;
        switch (mode) {
            case 2: {
                this.mainLayout.topControl = this.availableSubscriptionComposite;
                titleText = this.TITLE_SUBSCRIBE;
                this.createButton.setVisible(true);
                this.addButton.setVisible(true);
                this.shell.setDefaultButton(this.addButton);
                break;
            }
            case 4: {
                this.mainLayout.topControl = this.createComposite;
                this.createTabFolder.setSelection(this.createRSSTabItem);
                titleText = this.TITLE_CREATE;
                this.availableButton.setVisible(true);
                this.saveButton.setVisible(true);
                this.shell.setDefaultButton(this.saveButton);
                break;
            }
            case 3: {
                this.mainLayout.topControl = this.createComposite;
                this.createTabFolder.setSelection(this.createSearchTabItem);
                titleText = this.TITLE_CREATE;
                this.availableButton.setVisible(true);
                this.searchButton.setVisible(true);
                this.shell.setDefaultButton(this.searchButton);
                break;
            }
            default: {
                this.mainLayout.topControl = this.optinComposite;
                this.cancelButton.setText(MessageText.getString("Button.no"));
                this.createButton.setVisible(true);
                this.yesButton.setVisible(true);
                this.shell.setDefaultButton(this.yesButton);
            }
        }
        this.main.layout(true, true);
        this.title.setText(titleText);
    }

    public static void main(String[] args) {
        SubscriptionWizard sw = new SubscriptionWizard();
        while (!sw.shell.isDisposed()) {
            if (sw.display.readAndDispatch()) continue;
            sw.display.sleep();
        }
        sw.display.dispose();
    }
}

