/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.subscriptions;

import com.aelitis.azureus.core.metasearch.Engine;
import com.aelitis.azureus.core.metasearch.impl.web.WebEngine;
import com.aelitis.azureus.core.subs.Subscription;
import com.aelitis.azureus.core.subs.SubscriptionException;
import com.aelitis.azureus.core.subs.SubscriptionHistory;
import com.aelitis.azureus.core.subs.SubscriptionListener;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryVitalityImage;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.subscriptions.SubscriptionView;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.gudy.azureus2.core3.category.Category;
import org.gudy.azureus2.core3.category.CategoryManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputReceiverListener;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.CategoryAdderWindow;
import org.gudy.azureus2.ui.swt.PropertiesWindow;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.views.IView;

public class SubscriptionMDIEntry
implements SubscriptionListener {
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final String AUTH_IMAGE_ID = "image.sidebar.vitality.auth";
    private final MdiEntry mdiEntry;
    MdiEntryVitalityImage spinnerImage;
    private MdiEntryVitalityImage warningImage;
    private final Subscription subs;
    private String key;

    public SubscriptionMDIEntry(Subscription subs, MdiEntry entry) {
        this.subs = subs;
        this.mdiEntry = entry;
        this.key = "Subscription_" + ByteFormatter.encodeString(subs.getPublicKey());
        this.setupMdiEntry();
    }

    private void setupMdiEntry() {
        if (this.mdiEntry == null) {
            return;
        }
        this.mdiEntry.setImageLeftID("image.sidebar.subscriptions");
        this.warningImage = this.mdiEntry.addVitalityImage(ALERT_IMAGE_ID);
        this.spinnerImage = this.mdiEntry.addVitalityImage("image.sidebar.vitality.dots");
        if (this.spinnerImage != null) {
            this.spinnerImage.setVisible(false);
        }
        this.setWarning();
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        final MenuManager menuManager = uim.getMenuManager();
        MenuItem menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.forcecheck");
        menuItem.setText(MessageText.getString("Subscription.menu.forcecheck"));
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                try {
                    subs.getManager().getScheduler().downloadAsync(subs, true);
                }
                catch (SubscriptionException e) {
                    Debug.out(e);
                }
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.clearall");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().markAllResultsRead();
                SubscriptionMDIEntry.this.refreshView();
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.dirtyall");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().markAllResultsUnread();
                SubscriptionMDIEntry.this.refreshView();
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.deleteall");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().deleteAllResults();
                SubscriptionMDIEntry.this.refreshView();
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.reset");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.getHistory().reset();
                try {
                    subs.getEngine().reset();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                try {
                    subs.getManager().getScheduler().downloadAsync(subs, true);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        });
        try {
            Engine engine = this.subs.getEngine();
            if (engine instanceof WebEngine && ((WebEngine)engine).isNeedsAuth()) {
                menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.resetauth");
                menuItem.addListener(new SubsMenuItemListener(){

                    public void selected(MdiEntry info, Subscription subs) {
                        try {
                            Engine engine = subs.getEngine();
                            if (engine instanceof WebEngine) {
                                ((WebEngine)engine).setCookies(null);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                        try {
                            subs.getManager().getScheduler().downloadAsync(subs, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                });
                menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.setcookies");
                menuItem.addListener(new SubsMenuItemListener(){

                    public void selected(MdiEntry info, final Subscription subs) {
                        try {
                            Engine engine = subs.getEngine();
                            if (engine instanceof WebEngine) {
                                final WebEngine we = (WebEngine)engine;
                                SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                                String[] req = we.getRequiredCookies();
                                String req_str = "";
                                for (String r : req) {
                                    req_str = req_str + (req_str.length() == 0 ? "" : ";") + r + "=?";
                                }
                                entry.setPreenteredText(req_str, true);
                                entry.maintainWhitespace(false);
                                entry.allowEmptyInput(false);
                                entry.setTitle("general.enter.cookies");
                                entry.prompt(new UIInputReceiverListener(){

                                    public void UIInputReceiverClosed(UIInputReceiver entry) {
                                        if (!entry.hasSubmittedInput()) {
                                            return;
                                        }
                                        try {
                                            String input = entry.getSubmittedInput().trim();
                                            if (input.length() > 0) {
                                                we.setCookies(input);
                                                subs.getManager().getScheduler().downloadAsync(subs, true);
                                            }
                                        }
                                        catch (Throwable e) {
                                            Debug.printStackTrace(e);
                                        }
                                    }
                                });
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        menuManager.addMenuItem("sidebar." + this.key, "s1").setStyle(4);
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "MyTorrentsView.menu.setCategory");
        menuItem.setStyle(5);
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                SubscriptionMDIEntry.this.addCategorySubMenu(menuManager, menu);
            }
        });
        if (this.subs.isUpdateable()) {
            menuItem = menuManager.addMenuItem("sidebar." + this.key, "MyTorrentsView.menu.rename");
            menuItem.addListener(new SubsMenuItemListener(){

                public void selected(MdiEntry info, final Subscription subs) {
                    SimpleTextEntryWindow entry = new SimpleTextEntryWindow();
                    entry.setPreenteredText(subs.getName(), false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{subs.getName()}));
                    entry.prompt(new UIInputReceiverListener(){

                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                try {
                                    subs.setName(input);
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                        }
                    });
                }
            });
        }
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.upgrade");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                subs.resetHighestVersion();
            }
        });
        menuItem.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setVisible(SubscriptionMDIEntry.this.subs.getHighestVersion() > SubscriptionMDIEntry.this.subs.getVersion());
            }
        });
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.export");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                SubscriptionMDIEntry.this.export();
            }
        });
        menuManager.addMenuItem("sidebar." + this.key, "s2").setStyle(4);
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.remove");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                SubscriptionMDIEntry.this.removeWithConfirm();
            }
        });
        menuManager.addMenuItem("sidebar." + this.key, "s3").setStyle(4);
        menuItem = menuManager.addMenuItem("sidebar." + this.key, "Subscription.menu.properties");
        menuItem.addListener(new SubsMenuItemListener(){

            public void selected(MdiEntry info, Subscription subs) {
                SubscriptionMDIEntry.this.showProperties();
            }
        });
        this.subs.addListener(this);
    }

    public void subscriptionDownloaded(Subscription subs, boolean auto) {
    }

    public void subscriptionChanged(Subscription subs) {
        this.mdiEntry.redraw();
        ViewTitleInfoManager.refreshTitleInfo(this.mdiEntry.getViewTitleInfo());
    }

    protected void refreshView() {
        if (!(this.mdiEntry instanceof MdiEntrySWT)) {
            return;
        }
        IView iView = ((MdiEntrySWT)this.mdiEntry).getIView();
        if (iView instanceof SubscriptionView) {
            SubscriptionView subsView = (SubscriptionView)iView;
            subsView.refreshView();
        }
    }

    protected void setWarning() {
        boolean trouble;
        if (this.warningImage == null) {
            return;
        }
        SubscriptionHistory history = this.subs.getHistory();
        String last_error = history.getLastError();
        boolean auth_fail = history.isAuthFail();
        if (history.getConsecFails() < 3 && !auth_fail) {
            last_error = null;
        }
        boolean bl = trouble = last_error != null;
        if (trouble) {
            this.warningImage.setToolTip(last_error);
            this.warningImage.setImageID(auth_fail ? AUTH_IMAGE_ID : ALERT_IMAGE_ID);
            this.warningImage.setVisible(true);
        } else {
            this.warningImage.setVisible(false);
            this.warningImage.setToolTip("");
        }
    }

    private void addCategorySubMenu(MenuManager menu_manager, MenuItem menu) {
        MenuItem m;
        menu.removeAllChildItems();
        Object[] categories = CategoryManager.getCategories();
        Arrays.sort(categories);
        if (categories.length > 0) {
            String assigned_category = this.subs.getCategory();
            final Category uncat = CategoryManager.getCategory(2);
            if (uncat != null) {
                m = menu_manager.addMenuItem(menu, uncat.getName());
                m.setStyle(3);
                m.setData(new Boolean(assigned_category == null));
                m.addListener(new MenuItemListener(){

                    public void selected(MenuItem menu, Object target) {
                        SubscriptionMDIEntry.this.assignSelectedToCategory(uncat);
                    }
                });
                m = menu_manager.addMenuItem(menu, "sep1");
                m.setStyle(4);
            }
            for (int i = 0; i < categories.length; ++i) {
                Object cat = categories[i];
                if (cat.getType() != 0) continue;
                m = menu_manager.addMenuItem(menu, "!" + cat.getName() + "!");
                m.setStyle(3);
                m.setData(new Boolean(assigned_category != null && assigned_category.equals(cat.getName())));
                m.addListener(new MenuItemListener((Category)cat){
                    final /* synthetic */ Category val$cat;
                    {
                        this.val$cat = category;
                    }

                    public void selected(MenuItem menu, Object target) {
                        SubscriptionMDIEntry.this.assignSelectedToCategory(this.val$cat);
                    }
                });
            }
            m = menu_manager.addMenuItem(menu, "sep2");
            m.setStyle(4);
        }
        m = menu_manager.addMenuItem(menu, "MyTorrentsView.menu.setCategory.add");
        m.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                SubscriptionMDIEntry.this.addCategory();
            }
        });
    }

    private void addCategory() {
        CategoryAdderWindow adderWindow = new CategoryAdderWindow(Display.getDefault());
        Category newCategory = adderWindow.getNewCategory();
        if (newCategory != null) {
            this.assignSelectedToCategory(newCategory);
        }
    }

    private void assignSelectedToCategory(Category category) {
        if (category.getType() == 2) {
            this.subs.setCategory(null);
        } else {
            this.subs.setCategory(category.getName());
        }
    }

    protected void export() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                FileDialog dialog = new FileDialog(Utils.findAnyShell(), 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("subscript.export.select.template.file"));
                dialog.setFilterExtensions(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                dialog.setFilterNames(new String[]{"*.vuze", "*.vuz", Constants.FILE_WILDCARD});
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    String lc = path.toLowerCase();
                    if (!lc.endsWith(".vuze") && !lc.endsWith(".vuz")) {
                        path = path + ".vuze";
                    }
                    try {
                        VuzeFile vf = SubscriptionMDIEntry.this.subs.getVuzeFile();
                        vf.write(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void removeWithConfirm() {
        MessageBoxShell mb = new MessageBoxShell(MessageText.getString("message.confirm.delete.title"), MessageText.getString("message.confirm.delete.text", new String[]{this.subs.getName()}), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 1);
        mb.open(new UserPrompterResultListener(){

            public void prompterClosed(int result) {
                if (result == 0) {
                    SubscriptionMDIEntry.this.subs.setSubscribed(false);
                }
            }
        });
    }

    protected void showProperties() {
        String engine_str;
        SubscriptionHistory history = this.subs.getHistory();
        SimpleDateFormat df = new SimpleDateFormat();
        String last_error = history.getLastError();
        if (last_error == null) {
            last_error = "";
        }
        String auth_str = String.valueOf(false);
        try {
            WebEngine web_engine;
            Engine engine = this.subs.getEngine();
            engine_str = engine.getNameEx();
            if (engine instanceof WebEngine && (web_engine = (WebEngine)engine).isNeedsAuth()) {
                auth_str = String.valueOf(true) + ": cookies=" + this.toString(web_engine.getRequiredCookies());
            }
        }
        catch (Throwable e) {
            engine_str = "Unknown";
            auth_str = "";
        }
        String[] keys = new String[]{"subs.prop.enabled", "subs.prop.is_public", "subs.prop.is_auto", "subs.prop.is_auto_ok", "subs.prop.update_period", "subs.prop.last_scan", "subs.prop.last_result", "subs.prop.next_scan", "subs.prop.last_error", "subs.prop.num_read", "subs.prop.num_unread", "subs.prop.assoc", "subs.prop.version", "subs.prop.high_version", "subscriptions.listwindow.popularity", "subs.prop.template", "subs.prop.auth", "TableColumn.header.category"};
        String category = this.subs.getCategory();
        String category_str = category == null ? MessageText.getString("Categories.uncategorized") : category;
        int check_freq = history.getCheckFrequencyMins();
        long last_new_result = history.getLastNewResultTime();
        long next_scan = history.getNextScanTime();
        String[] values = new String[]{String.valueOf(history.isEnabled()), String.valueOf(this.subs.isPublic()), String.valueOf(history.isAutoDownload()), String.valueOf(this.subs.isAutoDownloadSupported()), check_freq == Integer.MAX_VALUE ? "" : String.valueOf(history.getCheckFrequencyMins() + " " + MessageText.getString("ConfigView.text.minutes")), df.format(new Date(history.getLastScanTime())), last_new_result == 0L ? "" : df.format(new Date(last_new_result)), next_scan == Long.MAX_VALUE ? "" : df.format(new Date(next_scan)), last_error.length() == 0 ? MessageText.getString("PeersView.uniquepiece.none") : last_error, String.valueOf(history.getNumRead()), String.valueOf(history.getNumUnread()), String.valueOf(this.subs.getAssociationCount()), String.valueOf(this.subs.getVersion()), this.subs.getHighestVersion() > this.subs.getVersion() ? String.valueOf(this.subs.getHighestVersion()) : null, this.subs.getCachedPopularity() <= 1L ? null : String.valueOf(this.subs.getCachedPopularity()), engine_str, auth_str, category_str};
        new PropertiesWindow(this.subs.getName(), keys, values);
    }

    private String toString(String[] strs) {
        String res = "";
        for (int i = 0; i < strs.length; ++i) {
            res = res + (i == 0 ? "" : ",") + strs[i];
        }
        return res;
    }

    public static abstract class SubsMenuItemListener
    implements MenuItemListener {
        public final void selected(MenuItem menu, Object target) {
            if (target instanceof MdiEntry) {
                MdiEntry info = (MdiEntry)target;
                Subscription subs = (Subscription)info.getDatasource();
                try {
                    this.selected(info, subs);
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
        }

        public abstract void selected(MdiEntry var1, Subscription var2);
    }
}

