/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectBasic;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import java.util.ArrayList;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AERunnableObject;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.CompositeMinSize;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.views.table.TableOrTreeSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableOrTreeUtils;

public class SWTSkinObjectContainer
extends SWTSkinObjectBasic {
    boolean bPropogate = false;
    boolean bPropogateDown = false;
    private String[] sTypeParams = null;
    private int minWidth;
    private int minHeight;

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String[] sTypeParams, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, "container", parent);
        this.sTypeParams = sTypeParams;
        this.createComposite();
    }

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, "container", parent);
        this.createComposite();
    }

    public SWTSkinObjectContainer(SWTSkin skin, SWTSkinProperties properties, Control control, String sID, String sConfigID, String type, SWTSkinObject parent) {
        super(skin, properties, sID, sConfigID, type, parent);
        if (control != null) {
            this.triggerListeners(4);
            this.setControl(control);
        }
    }

    private void createComposite() {
        Composite parentComposite;
        int style = 0;
        if (this.properties.getIntValue(this.sConfigID + ".border", 0) == 1) {
            style = 2048;
        }
        if (this.properties.getBooleanValue(this.sConfigID + ".doublebuffer", false)) {
            style |= 0x20000000;
        }
        Composite createOn = this.parent == null ? this.skin.getShell() : (Composite)this.parent.getControl();
        this.minWidth = this.properties.getIntValue(this.sConfigID + ".minwidth", -1);
        this.minHeight = this.properties.getIntValue(this.sConfigID + ".minheight", -1);
        if (this.skin.DEBUGLAYOUT) {
            System.out.println("linkIDtoParent: Create Composite " + this.sID + " on " + createOn);
            parentComposite = new Group(createOn, style);
            ((Group)parentComposite).setText(this.sConfigID == null ? this.sID : this.sConfigID);
            parentComposite.setData("DEBUG", "1");
        } else if (this.sTypeParams == null || this.sTypeParams.length < 2 || !this.sTypeParams[1].equalsIgnoreCase("group")) {
            parentComposite = new CompositeMinSize(createOn, style);
            ((CompositeMinSize)parentComposite).setMinSize(new Point(this.minWidth, this.minHeight));
        } else {
            parentComposite = new Group(createOn, style);
        }
        parentComposite.setLayout(new FormLayout());
        this.control = parentComposite;
        this.setControl(this.control);
    }

    public void setControl(Control control) {
        this.bPropogateDown = this.properties.getIntValue(this.sConfigID + ".propogateDown", 1) == 1;
        super.setControl(control);
    }

    protected void setViewID(String viewID) {
        super.setViewID(viewID);
        if (this.skin.DEBUGLAYOUT && this.control != null) {
            ((Group)this.control).setText("[" + viewID + "]");
        }
    }

    public SWTSkinObject[] getChildren() {
        if (this.isDisposed()) {
            return new SWTSkinObject[0];
        }
        SWTSkinObject[] so = (SWTSkinObject[])Utils.execSWTThreadWithObject("getChildren", new AERunnableObject(){

            public Object runSupport() {
                if (SWTSkinObjectContainer.this.control.isDisposed()) {
                    return new SWTSkinObject[0];
                }
                Control[] swtChildren = ((Composite)SWTSkinObjectContainer.this.control).getChildren();
                ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>(swtChildren.length);
                for (int i = 0; i < swtChildren.length; ++i) {
                    Control childControl = swtChildren[i];
                    SWTSkinObject so = (SWTSkinObject)childControl.getData("SkinObject");
                    if (so == null) continue;
                    list.add(so);
                }
                return list.toArray(new SWTSkinObject[list.size()]);
            }
        }, 2000L);
        if (so == null) {
            System.err.println("Tell Tux to fix this " + Debug.getCompressedStackTrace());
            return this.oldgetChildren();
        }
        return so;
    }

    public SWTSkinObject[] oldgetChildren() {
        String[] widgets = this.properties.getStringArray(this.sConfigID + ".widgets");
        if (widgets == null) {
            return new SWTSkinObject[0];
        }
        ArrayList<SWTSkinObject> list = new ArrayList<SWTSkinObject>();
        for (int i = 0; i < widgets.length; ++i) {
            String id = widgets[i];
            SWTSkinObject skinObject = this.skin.getSkinObjectByID(id, this);
            if (skinObject == null) continue;
            list.add(skinObject);
        }
        SWTSkinObject[] objects = new SWTSkinObject[list.size()];
        objects = list.toArray(objects);
        return objects;
    }

    public Composite getComposite() {
        return (Composite)this.control;
    }

    public String switchSuffix(final String suffix, final int level, boolean walkUp, boolean walkDown) {
        String sFullsuffix = super.switchSuffix(suffix, level, walkUp, walkDown);
        if (this.bPropogateDown && walkDown && suffix != null && this.control != null && !this.control.isDisposed()) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    SWTSkinObject[] children = SWTSkinObjectContainer.this.getChildren();
                    for (int i = 0; i < children.length; ++i) {
                        children[i].switchSuffix(suffix, level, false);
                    }
                }
            });
        }
        return sFullsuffix;
    }

    public void setPropogation(boolean propogate) {
        this.bPropogate = propogate;
        if (this.skin.DEBUGLAYOUT) {
            ((Group)this.control).setText(((Group)this.control).getText() + (this.bPropogate ? ";P" : ""));
        }
    }

    public boolean getPropogation() {
        return this.bPropogate;
    }

    public void setDebugAndChildren(boolean b) {
        this.setDebug(true);
        SWTSkinObject[] children = this.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (children[i] instanceof SWTSkinObjectContainer) {
                ((SWTSkinObjectContainer)children[i]).setDebugAndChildren(b);
                continue;
            }
            children[i].setDebug(b);
        }
    }

    protected boolean superSetIsVisible(boolean visible, boolean walkup) {
        boolean changed = super.setIsVisible(visible, walkup);
        return changed;
    }

    protected boolean setIsVisible(boolean visible, boolean walkup) {
        if (Utils.isThisThreadSWT() && !this.control.isDisposed() && !this.control.getShell().isVisible()) {
            return false;
        }
        boolean changed = super.setIsVisible(visible, walkup && visible);
        if (!changed) {
            return false;
        }
        Utils.execSWTThreadLater(0, new AERunnable(){

            public void runSupport() {
                SWTSkinObject[] children = SWTSkinObjectContainer.this.getChildren();
                if (children.length == 0) {
                    return;
                }
                for (int i = 0; i < children.length; ++i) {
                    SWTSkinObjectBasic child;
                    Control childControl;
                    if (!(children[i] instanceof SWTSkinObjectBasic) || (childControl = (child = (SWTSkinObjectBasic)children[i]).getControl()) == null || childControl.isDisposed()) continue;
                    child.setIsVisible(childControl.isVisible(), false);
                }
                SWTSkinObjectContainer.this.getComposite().layout();
            }
        });
        return changed;
    }

    public void childAdded(SWTSkinObject soChild) {
    }

    public Image obfusticatedImage(Image image) {
        if (!this.isVisible()) {
            return image;
        }
        Point ourOfs = Utils.getLocationRelativeToShell(this.control);
        Control[] swtChildren = ((Composite)this.control).getChildren();
        for (int i = 0; i < swtChildren.length; ++i) {
            TableView tv;
            Control childControl = swtChildren[i];
            TableOrTreeSWT tableOrTree = TableOrTreeUtils.getTableOrTreeSWT(childControl);
            TableView tableView = tv = tableOrTree == null ? null : (TableView)tableOrTree.getData("TableView");
            if (tv instanceof ObfusticateImage) {
                ObfusticateImage oi = (ObfusticateImage)((Object)tv);
                oi.obfusticatedImage(image);
                continue;
            }
            SWTSkinObject so = (SWTSkinObject)childControl.getData("SkinObject");
            if (so instanceof ObfusticateImage) {
                ObfusticateImage oi = (ObfusticateImage)((Object)so);
                oi.obfusticatedImage(image);
                continue;
            }
            if (so != null || !(childControl instanceof Composite)) continue;
            this.obfusticatedImage((Composite)childControl, image);
        }
        return super.obfusticatedImage(image);
    }

    private void obfusticatedImage(Composite c, Image image) {
        Control[] children;
        if (c == null || c.isDisposed() || !c.isVisible()) {
            return;
        }
        for (Control childControl : children = c.getChildren()) {
            ObfusticateImage oi;
            TableView tv;
            if (!childControl.isVisible()) continue;
            TableOrTreeSWT tableOrTree = TableOrTreeUtils.getTableOrTreeSWT(childControl);
            TableView tableView = tv = tableOrTree == null ? null : (TableView)tableOrTree.getData("TableView");
            if (tv instanceof ObfusticateImage) {
                oi = (ObfusticateImage)((Object)tv);
                oi.obfusticatedImage(image);
                continue;
            }
            oi = (ObfusticateImage)childControl.getData("ObfusticateImage");
            if (oi != null) {
                oi.obfusticatedImage(image);
                continue;
            }
            if (!(childControl instanceof Composite)) continue;
            this.obfusticatedImage((Composite)childControl, image);
        }
    }
}

