/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.skin;

import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatable;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.skin.SWTBGImagePainter;
import com.aelitis.azureus.ui.swt.skin.SWTSkin;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObject;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectContainer;
import com.aelitis.azureus.ui.swt.skin.SWTSkinObjectListener;
import com.aelitis.azureus.ui.swt.skin.SWTSkinProperties;
import com.aelitis.azureus.ui.swt.skin.SWTSkinUtils;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import com.aelitis.azureus.ui.swt.views.skin.SkinView;
import com.aelitis.azureus.util.StringCompareUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;

public class SWTSkinObjectBasic
implements SWTSkinObject,
PaintListener,
ObfusticateImage {
    protected static final int BORDER_ROUNDED = 1;
    protected static final int BORDER_ROUNDED_FILL = 2;
    protected static final int BORDER_GRADIENT = 3;
    protected Control control;
    protected String type;
    protected String sConfigID;
    protected SWTBGImagePainter painter;
    protected SWTSkinProperties properties;
    protected String sID;
    protected SWTSkinObject parent;
    protected SWTSkin skin;
    protected String[] suffixes = null;
    protected ArrayList<SWTSkinObjectListener> listeners = new ArrayList();
    protected AEMonitor listeners_mon = new AEMonitor("SWTSkinObjectBasic::listener");
    private String sViewID;
    private int isVisible = -1;
    protected Color bgColor;
    private Color colorBorder;
    private int[] colorBorderParams = null;
    private int[] colorFillParams;
    private int colorFillType;
    boolean initialized = false;
    boolean paintListenerHooked = false;
    boolean alwaysHookPaintListener = false;
    private Map mapData = Collections.EMPTY_MAP;
    private boolean disposed = false;
    protected boolean debug = false;
    private List<GradientInfo> listGradients = new ArrayList<GradientInfo>();
    private Image bgImage;
    private String tooltipID;
    protected boolean customTooltipID = false;
    private Listener resizeGradientBGListener;
    private SkinView skinView;
    private Object datasource;
    private boolean firstVisibility;
    private boolean layoutComplete;
    private ObfusticateImage obfusticatedImageGenerator;

    public SWTSkinObjectBasic(SWTSkin skin, SWTSkinProperties properties, Control control, String sID, String sConfigID, String type, SWTSkinObject parent) {
        this(skin, properties, sID, sConfigID, type, parent);
        this.setControl(control);
    }

    public SWTSkinObjectBasic(SWTSkin skin, SWTSkinProperties properties, String sID, String sConfigID, String type, SWTSkinObject parent) {
        this.skin = skin;
        this.properties = properties;
        this.sConfigID = sConfigID;
        this.sID = sID;
        this.type = type;
        this.parent = parent;
        this.setViewID(properties.getStringValue(sConfigID + ".view"));
        this.setDebug(properties.getBooleanValue(sConfigID + ".debug", false));
    }

    public void setControl(Control _control) {
        this.firstVisibility = this.properties.getBooleanValue(this.sConfigID + ".visible", true);
        if (!Utils.isThisThreadSWT()) {
            Debug.out("Warning: setControl not called in SWT thread for " + this);
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    SWTSkinObjectBasic.this.setControl(SWTSkinObjectBasic.this.control);
                }
            });
            return;
        }
        this.resizeGradientBGListener = new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                if (SWTSkinObjectBasic.this.bgImage != null && !SWTSkinObjectBasic.this.bgImage.isDisposed()) {
                    SWTSkinObjectBasic.this.bgImage.dispose();
                }
                Rectangle bounds = SWTSkinObjectBasic.this.control.getBounds();
                if (bounds.height <= 0) {
                    return;
                }
                SWTSkinObjectBasic.this.bgImage = new Image((Device)SWTSkinObjectBasic.this.control.getDisplay(), 5, bounds.height);
                GC gc = new GC(SWTSkinObjectBasic.this.bgImage);
                try {
                    try {
                        gc.setAdvanced(true);
                        gc.setInterpolation(2);
                        gc.setAntialias(1);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    GradientInfo lastGradInfo = new GradientInfo(SWTSkinObjectBasic.this.bgColor, 0.0);
                    for (GradientInfo gradInfo : SWTSkinObjectBasic.this.listGradients) {
                        if (gradInfo.startPoint != lastGradInfo.startPoint) {
                            gc.setForeground(lastGradInfo.color);
                            gc.setBackground(gradInfo.color);
                            int y = (int)((double)bounds.height * lastGradInfo.startPoint);
                            int height = (int)((double)bounds.height * gradInfo.startPoint) - y;
                            gc.fillGradientRectangle(0, y, 5, height, true);
                        }
                        lastGradInfo = gradInfo;
                    }
                    if (lastGradInfo.startPoint < 1.0) {
                        gc.setForeground(lastGradInfo.color);
                        gc.setBackground(lastGradInfo.color);
                        int y = (int)((double)bounds.height * lastGradInfo.startPoint);
                        int height = bounds.height - y;
                        gc.fillGradientRectangle(0, y, 5, height, true);
                    }
                    Object var10_12 = null;
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    gc.dispose();
                    throw throwable;
                }
                gc.dispose();
                if (SWTSkinObjectBasic.this.painter == null) {
                    SWTSkinObjectBasic.this.painter = new SWTBGImagePainter(SWTSkinObjectBasic.this.control, null, null, SWTSkinObjectBasic.this.bgImage, 3);
                } else {
                    SWTSkinObjectBasic.this.painter.setImage(null, null, SWTSkinObjectBasic.this.bgImage);
                }
            }
        };
        this.control = _control;
        this.control.setData("ConfigID", this.sConfigID);
        this.control.setData("SkinObject", this);
        SWTSkinUtils.addMouseImageChangeListeners(this.control);
        this.switchSuffix(null, 0, false);
        if (!this.properties.getBooleanValue(this.sConfigID + ".visible", true)) {
            this.setVisible(false);
        }
        final Listener lShowHide = new Listener(){

            public void handleEvent(final Event event2) {
                final boolean toBeVisible = event2.type == 22;
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        if (SWTSkinObjectBasic.this.control == null || SWTSkinObjectBasic.this.control.isDisposed()) {
                            SWTSkinObjectBasic.this.setIsVisible(false, true);
                            return;
                        }
                        if (toBeVisible == SWTSkinObjectBasic.this.control.isVisible() && SWTSkinObjectBasic.this.isVisible == 1 == toBeVisible) {
                            return;
                        }
                        if (event2.widget == SWTSkinObjectBasic.this.control) {
                            SWTSkinObjectBasic.this.setIsVisible(toBeVisible, true);
                            return;
                        }
                        if (!toBeVisible || SWTSkinObjectBasic.this.control.isVisible()) {
                            SWTSkinObjectBasic.this.setIsVisible(toBeVisible, true);
                            return;
                        }
                        SWTSkinObjectBasic.this.setIsVisible(SWTSkinObjectBasic.this.control.isVisible(), true);
                    }
                });
            }
        };
        this.control.addListener(22, lShowHide);
        this.control.addListener(23, lShowHide);
        final Shell shell = this.control.getShell();
        shell.addListener(22, lShowHide);
        shell.addListener(23, lShowHide);
        this.control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SWTSkinObjectBasic.this.disposed = true;
                shell.removeListener(22, lShowHide);
                shell.removeListener(23, lShowHide);
                SWTSkinObjectBasic.this.skin.removeSkinObject(SWTSkinObjectBasic.this);
            }
        });
        this.control.addListener(32, new Listener(){

            public void handleEvent(Event event2) {
                String id = SWTSkinObjectBasic.this.getTooltipID(true);
                if (id == null) {
                    SWTSkinObjectBasic.this.control.setToolTipText(null);
                } else if (id.startsWith("!") && id.endsWith("!")) {
                    SWTSkinObjectBasic.this.control.setToolTipText(id.substring(1, id.length() - 1));
                } else {
                    SWTSkinObjectBasic.this.control.setToolTipText(MessageText.getString(id, (String)null));
                }
            }
        });
        if (this.parent instanceof SWTSkinObjectContainer) {
            ((SWTSkinObjectContainer)this.parent).childAdded(this);
        }
    }

    protected boolean setIsVisible(boolean visible, boolean walkup) {
        if ((visible ? 1 : 0) == this.isVisible) {
            return false;
        }
        this.isVisible = visible ? 1 : 0;
        this.switchSuffix(null, 0, false);
        this.triggerListeners(visible ? 0 : 1);
        if (walkup && visible) {
            SWTSkinObject p = this.parent;
            while (p instanceof SWTSkinObjectBasic) {
                ((SWTSkinObjectBasic)p).setIsVisible(visible, false);
                p = ((SWTSkinObjectBasic)p).getParent();
            }
        }
        return true;
    }

    public Control getControl() {
        return this.control;
    }

    public String getType() {
        return this.type;
    }

    public String getConfigID() {
        return this.sConfigID;
    }

    public String getSkinObjectID() {
        return this.sID;
    }

    public SWTSkinObject getParent() {
        return this.parent;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setBackground(String sConfigID, String sSuffix) {
        String idRight;
        String idLeft;
        String id;
        ImageLoader imageLoader;
        block7: {
            String s;
            block8: {
                Image[] images;
                block9: {
                    if (sConfigID == null) {
                        return;
                    }
                    imageLoader = this.skin.getImageLoader(this.properties);
                    id = null;
                    idLeft = null;
                    idRight = null;
                    s = this.properties.getStringValue(sConfigID + sSuffix, (String)null);
                    if (s == null || s.length() <= 0) break block8;
                    images = imageLoader.getImages(sConfigID + sSuffix);
                    if (images.length != 1 || !ImageLoader.isRealImage(images[0])) break block9;
                    id = sConfigID + sSuffix;
                    idLeft = id + "-left";
                    idRight = id + "-right";
                    break block7;
                }
                if (images.length == 3 && ImageLoader.isRealImage(images[2])) {
                    idLeft = id = sConfigID + sSuffix;
                    idRight = id;
                    break block7;
                } else if (images.length == 2 && ImageLoader.isRealImage(images[1])) {
                    idLeft = id = sConfigID + sSuffix;
                    idRight = id + "-right";
                    break block7;
                } else {
                    id = sConfigID + sSuffix;
                    return;
                }
            }
            if (s != null && this.painter != null) {
                this.painter.dispose();
                this.painter = null;
            }
            if (s != null) return;
            return;
        }
        if (this.painter == null) {
            String sTileMode = this.properties.getStringValue(sConfigID + ".drawmode");
            int tileMode = SWTSkinUtils.getTileMode(sTileMode);
            this.painter = new SWTBGImagePainter(this.control, imageLoader, idLeft, idRight, id, tileMode);
            return;
        }
        this.painter.setImage(imageLoader, idLeft, idRight, id);
    }

    public String toString() {
        String s = "SWTSkinObjectBasic {" + this.sID;
        if (!this.sID.equals(this.sConfigID)) {
            s = s + "/" + this.sConfigID;
        }
        if (this.sViewID != null) {
            s = s + "/v=" + this.sViewID;
        }
        s = s + ", " + this.type + "; parent=" + (this.parent == null ? null : this.parent.getSkinObjectID() + "}");
        return s;
    }

    public SWTSkin getSkin() {
        return this.skin;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SWTSkinObject) {
            SWTSkinObject skinObject = (SWTSkinObject)obj;
            boolean bEquals = skinObject.getSkinObjectID().equals(this.sID);
            if (this.parent != null) {
                return bEquals && this.parent.equals(skinObject.getParent());
            }
            return bEquals;
        }
        return super.equals(obj);
    }

    public void setVisible(final boolean visible) {
        if (!this.layoutComplete) {
            this.firstVisibility = visible;
            this.setIsVisible(visible, true);
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SWTSkinObjectBasic.this.control != null && !SWTSkinObjectBasic.this.control.isDisposed()) {
                    boolean changed = visible != SWTSkinObjectBasic.this.control.isVisible() || (visible ? 1 : 0) != SWTSkinObjectBasic.this.isVisible;
                    Object ld = SWTSkinObjectBasic.this.control.getLayoutData();
                    if (ld instanceof FormData) {
                        FormData fd = (FormData)ld;
                        if (!visible) {
                            if (fd.width > 0 && fd.height > 0) {
                                SWTSkinObjectBasic.this.control.setData("oldSize", new Point(fd.width, fd.height));
                                changed = true;
                            }
                            fd.width = 0;
                            fd.height = 0;
                        } else {
                            Point oldSizePoint;
                            Object oldSize = SWTSkinObjectBasic.this.control.getData("oldSize");
                            Point point = oldSizePoint = oldSize instanceof Point ? (Point)oldSize : new Point(-1, -1);
                            if (fd.width <= 0) {
                                changed = true;
                                fd.width = oldSizePoint.x;
                            }
                            if (fd.height <= 0) {
                                changed = true;
                                fd.height = oldSizePoint.y;
                            }
                        }
                        if (changed) {
                            SWTSkinObjectBasic.this.control.setLayoutData(fd);
                            SWTSkinObjectBasic.this.control.getParent().layout(true);
                            Utils.relayout(SWTSkinObjectBasic.this.control);
                        }
                    } else if (ld == null && !visible) {
                        FormData fd = new FormData();
                        fd.width = 0;
                        fd.height = 0;
                        SWTSkinObjectBasic.this.control.setLayoutData(fd);
                    }
                    if (!changed) {
                        // empty if block
                    }
                    SWTSkinObjectBasic.this.control.setVisible(visible);
                    SWTSkinObjectBasic.this.setIsVisible(visible, true);
                }
            }
        });
    }

    public void setDefaultVisibility() {
        if (this.sConfigID == null) {
            return;
        }
        this.setVisible(this.getDefaultVisibility());
    }

    public boolean getDefaultVisibility() {
        return this.firstVisibility;
    }

    public boolean isVisible() {
        if (this.control == null || this.control.isDisposed()) {
            return false;
        }
        if (!this.layoutComplete) {
            return this.firstVisibility;
        }
        return this.isVisible == -1 ? this.firstVisibility : this.isVisible == 1;
    }

    public String switchSuffix(String suffix) {
        return this.switchSuffix(suffix, 1, false);
    }

    public final String switchSuffix(String suffix, int level, boolean walkUp) {
        return this.switchSuffix(suffix, level, walkUp, true);
    }

    public String switchSuffix(String newSuffixEntry, int level, boolean walkUp, boolean walkDown) {
        if (walkUp) {
            SWTSkinObject parentSkinObject = this.parent;
            SWTSkinObject skinObject = this;
            while (parentSkinObject instanceof SWTSkinObjectContainer && ((SWTSkinObjectContainer)parentSkinObject).getPropogation()) {
                skinObject = parentSkinObject;
                parentSkinObject = parentSkinObject.getParent();
            }
            if (skinObject != this) {
                skinObject.switchSuffix(newSuffixEntry, level, false);
                return null;
            }
        }
        String old = this.getSuffix();
        if (level > 0) {
            if (this.suffixes == null) {
                old = null;
                this.suffixes = new String[level];
            } else if (this.suffixes.length < level) {
                String[] newSuffixes = new String[level];
                System.arraycopy(this.suffixes, 0, newSuffixes, 0, this.suffixes.length);
                this.suffixes = newSuffixes;
            }
            this.suffixes[level - 1] = newSuffixEntry;
        }
        String fullSuffix = this.getSuffix();
        if (newSuffixEntry != null && (this.sConfigID == null || this.control == null || this.control.isDisposed() || !this.isVisible() || newSuffixEntry != null && fullSuffix.equals(old))) {
            return fullSuffix;
        }
        final String sSuffix = fullSuffix;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String[] split;
                if (SWTSkinObjectBasic.this.control == null || SWTSkinObjectBasic.this.control.isDisposed()) {
                    return;
                }
                boolean needPaintHook = false;
                if (SWTSkinObjectBasic.this.properties.hasKey(SWTSkinObjectBasic.this.sConfigID + ".color" + sSuffix)) {
                    Color color;
                    SWTSkinObjectBasic.this.control.removeListener(11, SWTSkinObjectBasic.this.resizeGradientBGListener);
                    SWTSkinObjectBasic.this.bgColor = color = SWTSkinObjectBasic.this.properties.getColor(SWTSkinObjectBasic.this.sConfigID + ".color" + sSuffix);
                    String colorStyle = SWTSkinObjectBasic.this.properties.getStringValue(SWTSkinObjectBasic.this.sConfigID + ".color.style" + sSuffix);
                    if (colorStyle != null) {
                        split = Constants.PAT_SPLIT_COMMA.split(colorStyle);
                        if (split.length > 2) {
                            try {
                                SWTSkinObjectBasic.access$502(SWTSkinObjectBasic.this, new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])});
                            }
                            catch (NumberFormatException e) {
                                // empty catch block
                            }
                        }
                        if (split[0].equals("rounded")) {
                            SWTSkinObjectBasic.this.colorFillType = 1;
                            needPaintHook = true;
                        } else if (split[0].equals("rounded-fill")) {
                            SWTSkinObjectBasic.this.colorFillType = 2;
                            needPaintHook = true;
                        } else if (split[0].equals("gradient")) {
                            SWTSkinObjectBasic.this.colorFillType = 3;
                            Display device = Display.getDefault();
                            for (int i = 1; i < split.length; i += 2) {
                                Color colorStop = ColorCache.getSchemedColor(device, split[i]);
                                double posStop = 1.0;
                                if (i != split.length - 1) {
                                    try {
                                        posStop = Double.parseDouble(split[i + 1]);
                                    }
                                    catch (Exception ignore) {
                                        // empty catch block
                                    }
                                }
                                SWTSkinObjectBasic.this.listGradients.add(new GradientInfo(colorStop, posStop));
                            }
                            SWTSkinObjectBasic.this.control.addListener(11, SWTSkinObjectBasic.this.resizeGradientBGListener);
                            SWTSkinObjectBasic.this.resizeGradientBGListener.handleEvent(null);
                        }
                        SWTSkinObjectBasic.this.control.redraw();
                        SWTSkinObjectBasic.this.control.setBackground(null);
                    } else {
                        SWTSkinObjectBasic.this.control.setBackground(SWTSkinObjectBasic.this.bgColor);
                    }
                }
                Color fg = SWTSkinObjectBasic.this.getColor_SuffixWalkback(SWTSkinObjectBasic.this.sConfigID + ".fgcolor");
                SWTSkinObjectBasic.this.control.setForeground(fg);
                String sBorderStyle = SWTSkinObjectBasic.this.properties.getStringValue(SWTSkinObjectBasic.this.sConfigID + ".border" + sSuffix);
                SWTSkinObjectBasic.this.colorBorder = null;
                SWTSkinObjectBasic.access$902(SWTSkinObjectBasic.this, null);
                if (sBorderStyle != null) {
                    split = Constants.PAT_SPLIT_COMMA.split(sBorderStyle);
                    SWTSkinObjectBasic.this.colorBorder = ColorCache.getSchemedColor(SWTSkinObjectBasic.this.control.getDisplay(), split[0]);
                    needPaintHook |= SWTSkinObjectBasic.this.colorBorder != null;
                    if (split.length > 2) {
                        SWTSkinObjectBasic.access$902(SWTSkinObjectBasic.this, new int[]{Integer.parseInt(split[1]), Integer.parseInt(split[2])});
                    }
                }
                SWTSkinObjectBasic.this.setBackground(SWTSkinObjectBasic.this.sConfigID + ".background", sSuffix);
                String sCursor = SWTSkinObjectBasic.this.properties.getStringValue(SWTSkinObjectBasic.this.sConfigID + ".cursor");
                if (sCursor != null && sCursor.length() > 0 && sCursor.equalsIgnoreCase("hand")) {
                    Listener handCursorListener = SWTSkinObjectBasic.this.skin.getHandCursorListener(SWTSkinObjectBasic.this.control.getDisplay());
                    SWTSkinObjectBasic.this.control.removeListener(6, handCursorListener);
                    SWTSkinObjectBasic.this.control.removeListener(7, handCursorListener);
                    SWTSkinObjectBasic.this.control.addListener(6, handCursorListener);
                    SWTSkinObjectBasic.this.control.addListener(7, handCursorListener);
                }
                if (!SWTSkinObjectBasic.this.customTooltipID) {
                    String newToolTipID = SWTSkinObjectBasic.this.properties.getReferenceID(SWTSkinObjectBasic.this.sConfigID + ".tooltip" + sSuffix);
                    if (newToolTipID == null && sSuffix.length() > 0) {
                        newToolTipID = SWTSkinObjectBasic.this.properties.getReferenceID(SWTSkinObjectBasic.this.sConfigID + ".tooltip");
                    }
                    SWTSkinObjectBasic.this.tooltipID = newToolTipID;
                }
                if (!SWTSkinObjectBasic.this.alwaysHookPaintListener && needPaintHook != SWTSkinObjectBasic.this.paintListenerHooked) {
                    if (needPaintHook) {
                        SWTSkinObjectBasic.this.control.addPaintListener(SWTSkinObjectBasic.this);
                    } else {
                        SWTSkinObjectBasic.this.control.removePaintListener(SWTSkinObjectBasic.this);
                    }
                    SWTSkinObjectBasic.this.paintListenerHooked = needPaintHook;
                }
            }
        });
        return fullSuffix;
    }

    public String getSuffix() {
        String suffix = "";
        if (this.suffixes == null) {
            return suffix;
        }
        for (int i = 0; i < this.suffixes.length; ++i) {
            if (this.suffixes[i] == null) continue;
            suffix = suffix + this.suffixes[i];
        }
        if (suffix.indexOf("-down-over") >= 0) {
            return suffix.replaceAll("-down-over", "-down");
        }
        return suffix;
    }

    public SWTSkinProperties getProperties() {
        return this.properties;
    }

    public void setProperties(SWTSkinProperties skinProperties) {
        this.properties = skinProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(final SWTSkinObjectListener listener) {
        this.listeners_mon.enter();
        try {
            this.listeners.add(listener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
        if (this.initialized) {
            listener.eventOccured(this, 4, null);
        }
        if (this.datasource != null) {
            listener.eventOccured(this, 7, this.datasource);
        }
        if (this.isVisible == 1 && this.initialized) {
            Utils.execSWTThreadLater(0, new AERunnable(){

                public void runSupport() {
                    listener.eventOccured(SWTSkinObjectBasic.this, 0, null);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(SWTSkinObjectListener listener) {
        this.listeners_mon.enter();
        try {
            this.listeners.remove(listener);
            Object var3_2 = null;
            this.listeners_mon.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.listeners_mon.exit();
            throw throwable;
        }
    }

    public SWTSkinObjectListener[] getListeners() {
        return this.listeners.toArray(new SWTSkinObjectListener[0]);
    }

    public void triggerListeners(int eventType) {
        this.triggerListeners(eventType, null);
    }

    public void triggerListeners(int eventType, Object params) {
        String initClass;
        SWTSkinObjectListener[] listeners;
        SWTSkinObjectListener[] listenersArray;
        if (eventType == 0 || eventType == 1) {
            if (!this.initialized) {
                return;
            }
            if (eventType == 0 && !this.isVisible()) {
                return;
            }
            if (eventType == 1 && this.isVisible()) {
                return;
            }
        } else if (eventType == 4) {
            this.initialized = true;
        } else if (eventType == 7) {
            this.datasource = params;
        }
        if ((listenersArray = this.getListeners()).length > 0) {
            for (SWTSkinObjectListener l : listenersArray) {
                try {
                    l.eventOccured(this, eventType, params);
                }
                catch (Exception e) {
                    Debug.out("Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " caused an error for listener added locally", e);
                }
            }
        }
        if ((listeners = this.skin.getSkinObjectListeners(this.sViewID)).length > 0) {
            for (int i = 0; i < listeners.length; ++i) {
                try {
                    SWTSkinObjectListener l = listeners[i];
                    l.eventOccured(this, eventType, params);
                    continue;
                }
                catch (Exception e) {
                    Debug.out("Skin Event " + SWTSkinObjectListener.NAMES[eventType] + " caused an error for listener added to skin", e);
                }
            }
        }
        if (eventType == 4 && this.isVisible >= 0) {
            this.triggerListeners(this.isVisible() ? 0 : 1);
        }
        if (eventType == 0 && this.skinView == null && (initClass = this.properties.getStringValue(this.sConfigID + ".onshow.skinviewclass")) != null) {
            try {
                String[] initClassItems = Constants.PAT_SPLIT_COMMA.split(initClass);
                ClassLoader claLoader = this.getClass().getClassLoader();
                if (initClassItems.length > 1) {
                    try {
                        PluginInterface pi = PluginInitializer.getDefaultInterface().getPluginManager().getPluginInterfaceByID(initClassItems[1]);
                        if (pi != null) {
                            claLoader = pi.getPluginClassLoader();
                        }
                    }
                    catch (Exception e) {
                        Debug.out(e);
                    }
                }
                Class<?> cla = Class.forName(initClassItems[0], true, claLoader);
                this.skinView = (SkinView)cla.newInstance();
                this.skinView.setMainSkinObject(this);
                this.addListener(this.skinView);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    protected void setViewID(String viewID) {
        this.sViewID = viewID;
    }

    public String getViewID() {
        return this.sViewID;
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        Utils.disposeSWTObjects(new Object[]{this.control});
        if (this.skinView != null) {
            this.removeListener(this.skinView);
            if (this.skinView instanceof UIUpdatable) {
                UIUpdatable updateable = (UIUpdatable)((Object)this.skinView);
                try {
                    UIFunctionsManager.getUIFunctions().getUIUpdater().removeUpdater(updateable);
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        }
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    public void setTooltipID(String id) {
        if (this.isDisposed()) {
            return;
        }
        if (StringCompareUtils.equals(id, this.tooltipID)) {
            return;
        }
        this.tooltipID = id;
        this.customTooltipID = true;
    }

    public String getTooltipID(boolean walkup) {
        if (this.tooltipID != null || !walkup) {
            return this.tooltipID;
        }
        if (this.parent != null) {
            return this.parent.getTooltipID(true);
        }
        return null;
    }

    public void paintControl(GC gc) {
    }

    public final void paintControl(PaintEvent e) {
        Rectangle bounds;
        if (this.bgColor != null) {
            e.gc.setBackground(this.bgColor);
        }
        this.paintControl(e.gc);
        try {
            e.gc.setAdvanced(true);
            e.gc.setAntialias(1);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (this.colorFillType > 0) {
            Rectangle rectangle = bounds = this.control instanceof Composite ? ((Composite)this.control).getClientArea() : this.control.getBounds();
            if (this.colorFillParams != null) {
                if (this.colorFillType == 2) {
                    e.gc.fillRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, this.colorFillParams[0], this.colorFillParams[1]);
                    e.gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, this.colorFillParams[0], this.colorFillParams[1]);
                } else if (this.colorFillType == 1) {
                    Color oldFG = e.gc.getForeground();
                    e.gc.setForeground(this.bgColor);
                    e.gc.drawRoundRectangle(0, 0, bounds.width - 1, bounds.height - 1, this.colorFillParams[0], this.colorFillParams[1]);
                    e.gc.setForeground(oldFG);
                }
            }
        }
        if (this.colorBorder != null) {
            e.gc.setForeground(this.colorBorder);
            bounds = this.control instanceof Composite ? ((Composite)this.control).getClientArea() : this.control.getBounds();
            --bounds.width;
            --bounds.height;
            if (this.colorBorderParams == null) {
                e.gc.drawRectangle(bounds);
            } else {
                e.gc.drawRoundRectangle(bounds.x, bounds.y, bounds.width, bounds.height, this.colorBorderParams[0], this.colorBorderParams[1]);
            }
        }
    }

    public boolean isAlwaysHookPaintListener() {
        return this.alwaysHookPaintListener;
    }

    public void setAlwaysHookPaintListener(boolean alwaysHookPaintListener) {
        this.alwaysHookPaintListener = alwaysHookPaintListener;
        if (alwaysHookPaintListener && !this.paintListenerHooked) {
            this.control.addPaintListener(this);
            this.paintListenerHooked = true;
        }
    }

    public Object getData(String id) {
        return this.mapData.get(id);
    }

    public void setData(String id, Object data) {
        if (this.mapData == Collections.EMPTY_MAP) {
            this.mapData = new HashMap(1);
        }
        this.mapData.put(id, data);
    }

    public Image obfusticatedImage(Image image) {
        if (!this.isVisible()) {
            return image;
        }
        Point ourOfs = Utils.getLocationRelativeToShell(this.control);
        if (this.obfusticatedImageGenerator == null) {
            if (this.skinView instanceof ObfusticateImage) {
                return ((ObfusticateImage)((Object)this.skinView)).obfusticatedImage(image);
            }
            return image;
        }
        return this.obfusticatedImageGenerator.obfusticatedImage(image);
    }

    public void setObfusticatedImageGenerator(ObfusticateImage obfusticatedImageGenerator) {
        this.obfusticatedImageGenerator = obfusticatedImageGenerator;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void relayout() {
        if (!this.disposed) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (SWTSkinObjectBasic.this.control.isDisposed()) {
                        return;
                    }
                    SWTSkinObjectBasic.this.control.getShell().layout(new Control[]{SWTSkinObjectBasic.this.control});
                }
            });
        }
    }

    public void layoutComplete() {
        if (!this.layoutComplete) {
            this.layoutComplete = true;
            if (this.control != null && !this.control.isDisposed()) {
                this.control.setVisible(this.firstVisibility);
            }
        }
    }

    private Color getColor_SuffixWalkback(String id) {
        int max;
        int n = max = this.suffixes == null ? 0 : this.suffixes.length;
        while (max >= 0) {
            String suffix = "";
            for (int i = 0; i < max; ++i) {
                if (this.suffixes[i] == null) continue;
                suffix = suffix + this.suffixes[i];
            }
            Color color = this.properties.getColor(id + suffix);
            if (color != null) {
                return color;
            }
            --max;
        }
        return null;
    }

    static /* synthetic */ int[] access$502(SWTSkinObjectBasic x0, int[] x1) {
        x0.colorFillParams = x1;
        return x1;
    }

    static /* synthetic */ int[] access$902(SWTSkinObjectBasic x0, int[] x1) {
        x0.colorBorderParams = x1;
        return x1;
    }

    class GradientInfo {
        public Color color;
        public double startPoint;

        public GradientInfo(Color c, double d) {
            this.color = c;
            this.startPoint = d;
        }
    }
}

