/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.shells.uiswitcher;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.UISwitcherUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class UISwitcherWindow {
    private static String CFG_PREFIX = "window.uiswitcher.";
    private static String RESOURCE_LOC = "com/aelitis/azureus/ui/swt/shells/uiswitcher/images/";
    private static String[] IMAGES = new String[]{"NewUI_130.jpg", "ClassicUI_130.jpg"};
    private static String[] IDS = new String[]{"NewUI", "ClassicUI"};
    private Shell shell;
    private Button btnOk;
    private int ui = -1;
    private List disposeList = new ArrayList();

    public UISwitcherWindow() {
        this(null, true);
    }

    public UISwitcherWindow(Shell parentShell, final boolean allowCancel) {
        String originalUIMode = UISwitcherUtil.calcUIMode();
        try {
            Image[] images = new Image[IMAGES.length];
            final Button[] buttons = new Button[IMAGES.length];
            int style = 2096;
            if (allowCancel) {
                style |= 0x40;
            }
            this.shell = ShellFactory.createShell(parentShell, style);
            this.shell.setText(MessageText.getString(CFG_PREFIX + "title"));
            Utils.setShellIcon(this.shell);
            this.shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Utils.disposeSWTObjects(UISwitcherWindow.this.disposeList);
                    if (UISwitcherWindow.this.ui == 0) {
                        COConfigurationManager.setParameter("ui", "az3");
                    } else if (UISwitcherWindow.this.ui == 1) {
                        COConfigurationManager.setParameter("ui", "az2");
                    }
                    if (UISwitcherWindow.this.ui != -1) {
                        COConfigurationManager.setParameter("ui.asked", true);
                        UISwitcherUtil.triggerListeners(UISwitcherUtil.calcUIMode());
                    }
                }
            });
            Display display = this.shell.getDisplay();
            ClassLoader cl = UISwitcherWindow.class.getClassLoader();
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 0;
            layout.marginWidth = 5;
            layout.marginHeight = 0;
            layout.verticalSpacing = 1;
            this.shell.setLayout(layout);
            Label title = new Label(this.shell, 64);
            GridData gd = new GridData(768);
            gd.verticalIndent = 3;
            title.setLayoutData(gd);
            Messages.setLanguageText(title, CFG_PREFIX + "text");
            Listener radioListener = new Listener(){

                public void handleEvent(Event event2) {
                    int idx;
                    if (event2.widget instanceof Composite) {
                        Long l = (Long)event2.widget.getData("INDEX");
                        idx = l.intValue();
                    } else {
                        Composite c = ((Control)event2.widget).getParent();
                        Long l = (Long)c.getData("INDEX");
                        idx = l.intValue();
                    }
                    for (int i = 0; i < buttons.length; ++i) {
                        boolean selected = idx == i;
                        Composite c = buttons[i].getParent();
                        c.getParent().setBackground(selected ? c.getDisplay().getSystemColor(26) : null);
                        Color fg = selected ? c.getDisplay().getSystemColor(27) : null;
                        Control[] children = c.getChildren();
                        for (int j = 0; j < children.length; ++j) {
                            Control control = children[j];
                            control.setForeground(fg);
                        }
                        buttons[i].setSelection(selected);
                    }
                }
            };
            FontData[] fontData = this.shell.getFont().getFontData();
            fontData[0].setHeight((int)((double)fontData[0].getHeight() * 1.5));
            fontData[0].setStyle(1);
            Font headerFont = new Font((Device)this.shell.getDisplay(), fontData);
            this.disposeList.add(headerFont);
            for (int i = 0; i < IMAGES.length; ++i) {
                String id = IMAGES[i];
                Composite c = new Composite(this.shell, 0);
                c.setBackgroundMode(1);
                gd = new GridData(1808);
                gd.verticalIndent = 0;
                c.setLayoutData(gd);
                GridLayout gridLayout = new GridLayout(2, false);
                gridLayout.horizontalSpacing = 0;
                gridLayout.marginWidth = 5;
                gridLayout.marginHeight = 3;
                gridLayout.verticalSpacing = 0;
                c.setLayout(gridLayout);
                c.setData("INDEX", new Long(i));
                c.addListener(3, radioListener);
                Label label = new Label(c, 0x1000000);
                label.addListener(3, radioListener);
                try {
                    InputStream is = cl.getResourceAsStream(RESOURCE_LOC + id);
                    if (is != null) {
                        images[i] = new Image((Device)display, is);
                        label.setImage(images[i]);
                        this.disposeList.add(images[i]);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                Composite c2 = new Composite(c, 0);
                c2.setBackgroundMode(2);
                c2.setData("INDEX", new Long(i));
                c2.setLayout(new GridLayout());
                c2.setLayoutData(new GridData(1808));
                buttons[i] = new Button(c2, 16);
                buttons[i].setLayoutData(new GridData(256));
                Messages.setLanguageText(buttons[i], CFG_PREFIX + IDS[i] + ".title");
                buttons[i].setData("INDEX", new Long(i));
                buttons[i].addListener(13, radioListener);
                buttons[i].setFont(headerFont);
                buttons[i].addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 64) {
                            e.doit = true;
                            e.detail = 16;
                        } else if (e.detail == 32) {
                            e.detail = 8;
                            e.doit = true;
                        } else if (e.detail == 16 || e.detail == 8) {
                            UISwitcherWindow.this.btnOk.setFocus();
                            e.doit = false;
                        } else if (e.detail == 4) {
                            e.doit = true;
                        } else if (e.detail == 2) {
                            e.doit = false;
                            if (allowCancel) {
                                UISwitcherWindow.this.ui = -1;
                                UISwitcherWindow.this.shell.dispose();
                            }
                        } else {
                            e.doit = false;
                        }
                    }
                });
                buttons[i].addListener(1, new Listener(){

                    public void handleEvent(Event event2) {
                        if (event2.keyCode == 0x1000001) {
                            UISwitcherWindow.this.shell.getDisplay().getFocusControl().traverse(32);
                        } else if (event2.keyCode == 0x1000002) {
                            UISwitcherWindow.this.shell.getDisplay().getFocusControl().traverse(64);
                        }
                    }
                });
                Label info = new Label(c2, 64);
                gd = new GridData(1808);
                gd.horizontalIndent = 20;
                info.setLayoutData(gd);
                Messages.setLanguageText(info, CFG_PREFIX + IDS[i] + ".text");
                info.addListener(3, radioListener);
            }
            Event eventSelectFirst = new Event();
            eventSelectFirst.widget = buttons[0];
            radioListener.handleEvent(eventSelectFirst);
            Composite cBottom = new Composite(this.shell, 0);
            layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            cBottom.setLayout(layout);
            cBottom.setLayoutData(new GridData(768));
            this.btnOk = new Button(cBottom, 8);
            Messages.setLanguageText(this.btnOk, "Button.ok");
            this.shell.setDefaultButton(this.btnOk);
            this.btnOk.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    for (int i = 0; i < buttons.length; ++i) {
                        if (!buttons[i].getSelection()) continue;
                        UISwitcherWindow.this.ui = i;
                        break;
                    }
                    UISwitcherWindow.this.shell.dispose();
                }
            });
            gd = new GridData(128);
            gd.widthHint = 80;
            this.btnOk.setLayoutData(gd);
            Point point = this.shell.computeSize(630, -1);
            this.shell.setSize(point);
            Utils.centreWindow(this.shell);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void open() {
        this.shell.open();
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        UISwitcherWindow window = new UISwitcherWindow(null, false);
        Shell shell = window.shell;
        while (!shell.isDisposed()) {
            if (shell.getDisplay().readAndDispatch()) continue;
            shell.getDisplay().sleep();
        }
        System.out.println(window.ui);
    }
}

