/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt.devices.columns;

import com.aelitis.azureus.core.devices.DeviceOfflineDownload;
import java.util.Locale;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableColumnExtraInfoListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;

public class ColumnOD_Status
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static final String COLUMN_ID = "od_status";
    private static final String[] js_resource_keys = new String[]{"devices.od.idle", "devices.od.xfering"};
    private static String[] js_resources = new String[js_resource_keys.length];

    public ColumnOD_Status(final TableColumn column) {
        column.initialize(3, -2, 80);
        column.addListeners(this);
        column.setRefreshInterval(-1);
        column.setType(3);
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            public void localeChanged(Locale old_locale, Locale new_locale) {
                for (int i = 0; i < js_resources.length; ++i) {
                    js_resources[i] = MessageText.getString(js_resource_keys[i]);
                }
                column.invalidateCells();
            }
        });
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public void refresh(TableCell cell) {
        String text;
        DeviceOfflineDownload od = (DeviceOfflineDownload)cell.getDataSource();
        if (od == null) {
            return;
        }
        String string = text = od.isTransfering() ? js_resources[1] : js_resources[0];
        if (text == null || text.length() == 0) {
            return;
        }
        cell.setText(text);
    }
}

