/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreLifecycleAdapter;
import java.io.File;
import java.util.Map;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationChecker;
import org.gudy.azureus2.core3.config.impl.ConfigurationDefaults;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationParameterNotFoundException;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SystemProperties;

public class UIConfigDefaultsSWTv3 {
    public static void initialize(AzureusCore core) {
        Map map;
        ConfigurationManager config = ConfigurationManager.getInstance();
        if ("az2".equalsIgnoreCase(config.getStringParameter("ui", "az3"))) {
            return;
        }
        boolean configNeedsSave = false;
        if (System.getProperty("FORCE_PROGRESSIVE", "").length() > 0) {
            config.setParameter("Prioritize First Piece", true);
            configNeedsSave = true;
        }
        String sFirstVersion = config.getStringParameter("First Recorded Version");
        final ConfigurationDefaults defaults = ConfigurationDefaults.getInstance();
        defaults.addParameter("ui", "az3");
        if (Constants.compareVersions(sFirstVersion, "2.5.0.0") == 0) {
            String sDefSavePath = config.getStringParameter("Default save path");
            System.out.println(sDefSavePath);
            String sDefPath = null;
            try {
                sDefPath = defaults.getStringParameter("Default save path");
            }
            catch (ConfigurationParameterNotFoundException e) {
                e.printStackTrace();
            }
            if (sDefPath != null) {
                File fNewPath = new File(sDefPath);
                if (sDefSavePath != null && fNewPath.equals(new File(sDefSavePath))) {
                    sFirstVersion = "3.0.0.5";
                    config.setParameter("First Recorded Version", sFirstVersion);
                    configNeedsSave = true;
                }
            }
        }
        boolean immediateSwitch = config.getBooleanParameter("az3.switch.immediate", false);
        if (Constants.compareVersions(sFirstVersion, "3.0.0.0") >= 0 || immediateSwitch) {
            if (!config.isNewInstall() && Constants.compareVersions(sFirstVersion, "3.0.0.4") < 0) {
                String userPath = SystemProperties.getUserPath();
                File fOldPath = new File(userPath, "data");
                String sDefSavePath = config.getStringParameter("Default save path");
                String sDefPath = "";
                try {
                    sDefPath = defaults.getStringParameter("Default save path");
                }
                catch (ConfigurationParameterNotFoundException e) {
                    // empty catch block
                }
                File fNewPath = new File(sDefPath);
                if (sDefSavePath != null && fNewPath.equals(new File(sDefSavePath))) {
                    sFirstVersion = "3.0.0.5";
                    config.setParameter("First Recorded Version", sFirstVersion);
                    configNeedsSave = true;
                } else {
                    if (sDefSavePath == null || !fOldPath.equals(new File(sDefSavePath))) {
                        sFirstVersion = "2.5.0.0";
                        config.setParameter("First Recorded Version", sFirstVersion);
                        config.save();
                        return;
                    }
                    config.removeParameter("Default save path");
                }
            }
            defaults.addParameter("Auto Upload Speed Enabled", true);
            defaults.addParameter("Use default data dir", true);
            defaults.addParameter("Add URL Silently", true);
            defaults.addParameter("add_torrents_silently", true);
            defaults.addParameter("Popup Download Finished", false);
            defaults.addParameter("Popup Download Added", false);
            defaults.addParameter("Status Area Show SR", false);
            defaults.addParameter("Status Area Show NAT", false);
            defaults.addParameter("Status Area Show IPF", false);
            defaults.addParameter("Message Popup Autoclose in Seconds", 10);
            defaults.addParameter("window.maximized", true);
            defaults.addParameter("update.autodownload", true);
            defaults.addParameter("suppress_file_download_dialog", true);
            defaults.addParameter("auto_remove_inactive_items", false);
            defaults.addParameter("show_torrents_menu", false);
        }
        defaults.addParameter("v3.topbar.show.frog", false);
        config.removeParameter("v3.home-tab.starttab");
        defaults.addParameter("MyTorrentsView.table.style", 0);
        defaults.addParameter("v3.Show Welcome", true);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean startAdvanced = userMode > 1;
        defaults.addParameter("Library.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("LibraryDL.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("LibraryUnopened.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("LibraryCD.viewmode", startAdvanced ? 1 : 0);
        defaults.addParameter("Library.CatInSideBar", startAdvanced ? 1 : 0);
        defaults.addParameter("list.dm.dblclick", "0");
        defaults.addParameter("NameColumn.showProgramIcon", startAdvanced);
        defaults.addParameter("vista.adminquit", false);
        defaults.addParameter("Start Minimized", false);
        defaults.addParameter("Password enabled", false);
        defaults.addParameter("ToolBar.showText", true);
        defaults.addParameter("burninfo.shownonce", false);
        defaults.addParameter("Table.extendedErase", !Constants.isWindowsXP);
        defaults.addParameter("Table.useTree", true);
        core.addLifecycleListener(new AzureusCoreLifecycleAdapter(){

            public void started(AzureusCore core) {
                defaults.addParameter("Plugin.DHT.dht.warn.user", false);
                defaults.addParameter("Plugin.UPnP.upnp.alertothermappings", false);
                defaults.addParameter("Plugin.UPnP.upnp.alertdeviceproblems", false);
            }
        });
        if ((!COConfigurationManager.hasParameter("v3.StartTab", true) || ConfigurationChecker.isNewVersion() && Constants.compareVersions(Constants.getBaseVersion(), "4.2.1.0") == 0) && (map = FileUtil.readResilientConfigFile("tables.config")) != null && map.size() > 0) {
            Object[] keys = map.keySet().toArray();
            boolean removedSome = false;
            for (int i = 0; i < keys.length; ++i) {
                String sKey;
                if (!(keys[i] instanceof String) || !(sKey = (String)keys[i]).endsWith(".big") && !sKey.startsWith("Table.library-") && !sKey.startsWith("Table.Media") && !sKey.startsWith("Table.activity.table") && !sKey.equals("Table.Activity.big") && !sKey.equals("Table.Activity_SB")) continue;
                map.remove(sKey);
                removedSome = true;
            }
            if (removedSome) {
                FileUtil.writeResilientConfigFile("tables.config", map);
            }
        }
        if (!config.getBooleanParameter("IconBar.enabled")) {
            config.setParameter("IconBar.enabled", true);
        }
        if (configNeedsSave) {
            config.save();
        }
    }
}

