/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.ui.selectedcontent;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.selectedcontent.DownloadUrlInfo;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.HashWrapper;

public class SelectedContent
implements ISelectedContent {
    private String hash;
    private DownloadManager dm;
    private int file_index = -1;
    private TOTorrent torrent;
    private String displayName;
    private DownloadUrlInfo downloadInfo;

    public SelectedContent(DownloadManager dm) {
        this.setDownloadManager(dm);
    }

    public SelectedContent(DownloadManager dm, int _file_index) {
        this.setDownloadManager(dm);
        this.file_index = _file_index;
    }

    public SelectedContent(String hash, String displayName) {
        this.hash = hash;
        this.displayName = displayName;
    }

    public SelectedContent() {
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public DownloadManager getDownloadManager() {
        if (this.dm == null && this.hash != null) {
            try {
                GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                return gm.getDownloadManager(new HashWrapper(Base32.decode(this.hash)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.dm;
    }

    public void setDownloadManager(DownloadManager _dm) {
        this.dm = _dm;
        if (this.dm != null) {
            this.setTorrent(this.dm.getTorrent());
            this.setDisplayName(this.dm.getDisplayName());
        }
    }

    public int getFileIndex() {
        return this.file_index;
    }

    public TOTorrent getTorrent() {
        return this.torrent;
    }

    public void setTorrent(TOTorrent _torrent) {
        this.torrent = _torrent;
        if (this.torrent != null) {
            try {
                this.hash = this.torrent.getHashWrapper().toBase32String();
            }
            catch (Exception e) {
                this.hash = null;
            }
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public DownloadUrlInfo getDownloadInfo() {
        return this.downloadInfo;
    }

    public void setDownloadInfo(DownloadUrlInfo info) {
        this.downloadInfo = info;
    }

    public boolean sameAs(ISelectedContent _other) {
        if (_other instanceof SelectedContent) {
            SelectedContent other = (SelectedContent)_other;
            if (!(this.hash == other.hash || this.hash != null && other.hash != null && this.hash.equals(other.hash))) {
                return false;
            }
            if (this.dm != other.dm || this.torrent != other.torrent || this.file_index != other.file_index) {
                return false;
            }
            if (!(this.displayName == other.displayName || this.displayName != null && other.displayName != null && this.displayName.equals(other.displayName))) {
                return false;
            }
            return this.downloadInfo == other.downloadInfo || this.downloadInfo != null && other.downloadInfo != null && this.downloadInfo.sameAs(other.downloadInfo);
        }
        return false;
    }
}

