/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.magnet;

import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.core.util.FeatureAvailability;
import com.aelitis.azureus.plugins.magnet.MagnetPluginListener;
import com.aelitis.azureus.plugins.magnet.MagnetPluginProgressListener;
import com.aelitis.net.magneturi.MagnetURIHandler;
import com.aelitis.net.magneturi.MagnetURIHandlerException;
import com.aelitis.net.magneturi.MagnetURIHandlerListener;
import com.aelitis.net.magneturi.MagnetURIHandlerProgressListener;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabase;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseContact;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseEvent;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseProgressListener;
import org.gudy.azureus2.plugins.ddb.DistributedDatabaseValue;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.plugins.torrent.Torrent;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;

public class MagnetPlugin
implements Plugin {
    private static final String SECONDARY_LOOKUP = "http://magnet.vuze.com/";
    private static final int SECONDARY_LOOKUP_DELAY = 20000;
    private static final int SECONDARY_LOOKUP_MAX_TIME = 120000;
    private static final String PLUGIN_NAME = "Magnet URI Handler";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.magnetplugin";
    private PluginInterface plugin_interface;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean first_download = true;
    private BooleanParameter secondary_lookup;

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        this.secondary_lookup = config.addBooleanParameter2("MagnetPlugin.use.lookup.service", "MagnetPlugin.use.lookup.service", true);
        MenuItemListener listener = new MenuItemListener(){

            public void selected(MenuItem _menu, Object _target) {
                Download download = (Download)((TableRow)_target).getDataSource();
                if (download == null || download.getTorrent() == null) {
                    return;
                }
                Torrent torrent = download.getTorrent();
                String cb_data = "magnet:?xt=urn:btih:" + Base32.encode(torrent.getHash());
                try {
                    MagnetPlugin.this.plugin_interface.getUIManager().copyToClipBoard(cb_data);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        final TableContextMenuItem menu1 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MyTorrents", "MagnetPlugin.contextmenu.exporturi");
        final TableContextMenuItem menu2 = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem("MySeeders", "MagnetPlugin.contextmenu.exporturi");
        menu1.addListener(listener);
        menu2.addListener(listener);
        MagnetURIHandler.getSingleton().addListener(new MagnetURIHandlerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public byte[] badge() {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/aelitis/azureus/plugins/magnet/Magnet.gif");
                if (is == null) {
                    return null;
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                        Object var6_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_7 = null;
                        is.close();
                        throw throwable;
                    }
                    is.close();
                    return baos.toByteArray();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }

            public byte[] download(final MagnetURIHandlerProgressListener muh_listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
                try {
                    Torrent torrent;
                    Download dl = MagnetPlugin.this.plugin_interface.getDownloadManager().getDownload(hash);
                    if (dl != null && (torrent = dl.getTorrent()) != null) {
                        return torrent.writeToBEncodedData();
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                return MagnetPlugin.this.download(new MagnetPluginProgressListener(){

                    public void reportSize(long size) {
                        muh_listener.reportSize(size);
                    }

                    public void reportActivity(String str) {
                        muh_listener.reportActivity(str);
                    }

                    public void reportCompleteness(int percent) {
                        muh_listener.reportCompleteness(percent);
                    }

                    public void reportContributor(InetSocketAddress address) {
                    }

                    public boolean verbose() {
                        return muh_listener.verbose();
                    }
                }, hash, args, sources, timeout);
            }

            public boolean download(URL url) throws MagnetURIHandlerException {
                try {
                    MagnetPlugin.this.plugin_interface.getDownloadManager().addDownload(url, false);
                    return true;
                }
                catch (DownloadException e) {
                    throw new MagnetURIHandlerException("Operation failed", e);
                }
            }

            public boolean set(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                for (int i = 0; i < l.size(); ++i) {
                    if (!((MagnetPluginListener)l.get(i)).set(name, values)) continue;
                    return true;
                }
                return false;
            }

            public int get(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                for (int i = 0; i < l.size(); ++i) {
                    int res = ((MagnetPluginListener)l.get(i)).get(name, values);
                    if (res == Integer.MIN_VALUE) continue;
                    return res;
                }
                return Integer.MIN_VALUE;
            }
        });
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                AEThread2 t = new AEThread2("MagnetPlugin:init", true){

                    public void run() {
                        MagnetPlugin.this.plugin_interface.getDistributedDatabase();
                    }
                };
                t.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UISWTInstance swt = (UISWTInstance)instance;
                    Image image = swt.loadImage("com/aelitis/azureus/plugins/magnet/icons/magnet.gif");
                    menu1.setGraphic(swt.createGraphic(image));
                    menu2.setGraphic(swt.createGraphic(image));
                }
            }

            public void UIDetached(UIInstance instance) {
            }
        });
    }

    public URL getMagnetURL(Download d) {
        Torrent torrent = d.getTorrent();
        if (torrent == null) {
            return null;
        }
        return this.getMagnetURL(torrent.getHash());
    }

    public URL getMagnetURL(byte[] hash) {
        try {
            return new URL("magnet:?xt=urn:btih:" + Base32.encode(hash));
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return null;
        }
    }

    public byte[] badge() {
        return null;
    }

    public byte[] download(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
        byte[] torrent_data = this.downloadSupport(listener, hash, args, sources, timeout);
        if (args != null) {
            String[] bits = args.split("&");
            ArrayList<String> new_web_seeds = new ArrayList<String>();
            for (String bit : bits) {
                String[] x = bit.split("=");
                if (x.length != 2 || !x[0].equalsIgnoreCase("ws")) continue;
                try {
                    new_web_seeds.add(new URL(UrlUtils.decode(x[1])).toExternalForm());
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (new_web_seeds.size() > 0) {
                try {
                    TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(torrent_data);
                    Object obj = torrent.getAdditionalProperty("url-list");
                    ArrayList<String> existing = new ArrayList<String>();
                    if (obj instanceof byte[]) {
                        try {
                            new_web_seeds.remove(new URL(new String((byte[])obj, "UTF-8")).toExternalForm());
                        }
                        catch (Throwable e) {}
                    } else if (obj instanceof List) {
                        List l = (List)obj;
                        for (byte[] b : l) {
                            try {
                                existing.add(new URL(new String(b, "UTF-8")).toExternalForm());
                            }
                            catch (Throwable e) {}
                        }
                    }
                    boolean update = false;
                    for (String e : new_web_seeds) {
                        if (existing.contains(e)) continue;
                        existing.add(e);
                        update = true;
                    }
                    if (update) {
                        ArrayList<byte[]> l = new ArrayList<byte[]>();
                        for (String s : existing) {
                            l.add(s.getBytes("UTF-8"));
                        }
                        torrent.setAdditionalProperty("url-list", l);
                        torrent_data = BEncoder.encode(torrent.serialiseToMap());
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        return torrent_data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] downloadSupport(final MagnetPluginProgressListener listener, byte[] hash, String args, final InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
        try {
            if (this.first_download) {
                listener.reportActivity(this.getMessageText("report.waiting_ddb"));
                this.first_download = false;
            }
            final DistributedDatabase db = this.plugin_interface.getDistributedDatabase();
            final ArrayList potential_contacts = new ArrayList();
            final AESemaphore potential_contacts_sem = new AESemaphore("MagnetPlugin:liveones");
            final AEMonitor potential_contacts_mon = new AEMonitor("MagnetPlugin:liveones");
            final int[] outstanding = new int[]{0};
            final boolean[] lookup_complete = new boolean[]{false};
            listener.reportActivity(this.getMessageText("report.searching"));
            DistributedDatabaseListener ddb_listener = new DistributedDatabaseListener(){
                private Set found_set = new HashSet();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void event(DistributedDatabaseEvent event2) {
                    int type = event2.getType();
                    if (type == 7) {
                        if (sources.length > 0) {
                            new DelayedEvent("MP:sourceAdd", 10000L, new AERunnable(){

                                public void runSupport() {
                                    this.addExplicitSources();
                                }
                            });
                        }
                    } else if (type == 2) {
                        this.contactFound(event2.getValue().getContact());
                    } else if (type == 4 || type == 5) {
                        listener.reportActivity(MagnetPlugin.this.getMessageText("report.found", String.valueOf(this.found_set.size())));
                        this.addExplicitSources();
                        try {
                            potential_contacts_mon.enter();
                            lookup_complete[0] = true;
                            Object var4_3 = null;
                            potential_contacts_mon.exit();
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            potential_contacts_mon.exit();
                            throw throwable;
                        }
                        potential_contacts_sem.release();
                    }
                }

                protected void addExplicitSources() {
                    for (int i = 0; i < sources.length; ++i) {
                        try {
                            this.contactFound(db.importContact(sources[i]));
                            continue;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void contactFound(final DistributedDatabaseContact contact) {
                    String key = contact.getAddress().toString();
                    Set set = this.found_set;
                    synchronized (set) {
                        if (this.found_set.contains(key)) {
                            return;
                        }
                        this.found_set.add(key);
                    }
                    if (listener.verbose()) {
                        listener.reportActivity(MagnetPlugin.this.getMessageText("report.found", contact.getName()));
                    }
                    try {
                        potential_contacts_mon.enter();
                        outstanding[0] = outstanding[0] + 1;
                        Object var6_5 = null;
                        potential_contacts_mon.exit();
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        potential_contacts_mon.exit();
                        throw throwable;
                    }
                    contact.isAlive(20000L, new DistributedDatabaseListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void event(DistributedDatabaseEvent event2) {
                            Object v2;
                            block11: {
                                try {
                                    boolean alive;
                                    boolean bl = alive = event2.getType() == 4;
                                    if (listener.verbose()) {
                                        listener.reportActivity(MagnetPlugin.this.getMessageText(alive ? "report.alive" : "report.dead", contact.getName()));
                                    }
                                    try {
                                        potential_contacts_mon.enter();
                                        Object[] entry = new Object[]{new Boolean(alive), contact};
                                        boolean added = false;
                                        if (alive) {
                                            for (int i = 0; i < potential_contacts.size(); ++i) {
                                                if (((Boolean)((Object[])potential_contacts.get(i))[0]).booleanValue()) continue;
                                                potential_contacts.add(i, entry);
                                                added = true;
                                                break;
                                            }
                                        }
                                        if (!added) {
                                            potential_contacts.add(entry);
                                        }
                                        Object var7_6 = null;
                                        potential_contacts_mon.exit();
                                    }
                                    catch (Throwable throwable) {
                                        Object var7_7 = null;
                                        potential_contacts_mon.exit();
                                        throw throwable;
                                    }
                                    Object var9_9 = null;
                                }
                                catch (Throwable throwable) {
                                    Object v1;
                                    Object var9_10 = null;
                                    try {
                                        potential_contacts_mon.enter();
                                        outstanding[0] = outstanding[0] - 1;
                                        v1 = null;
                                    }
                                    catch (Throwable throwable2) {
                                        v1 = null;
                                    }
                                    Object var11_14 = v1;
                                    potential_contacts_mon.exit();
                                    throw throwable;
                                }
                                try {
                                    potential_contacts_mon.enter();
                                    outstanding[0] = outstanding[0] - 1;
                                    v2 = null;
                                    break block11;
                                }
                                catch (Throwable throwable) {
                                    v2 = null;
                                }
                                {
                                }
                            }
                            Object var11_13 = v2;
                            potential_contacts_mon.exit();
                        }
                    });
                }
            };
            db.read(ddb_listener, db.createKey(hash, "Torrent download lookup for '" + ByteFormatter.encodeString(hash) + "'"), timeout, 3);
            long remaining = timeout;
            long overall_start = SystemTime.getMonotonousTime();
            boolean sl_enabled = this.secondary_lookup.getValue() && FeatureAvailability.isMagnetSLEnabled();
            long secondary_lookup_time = -1L;
            long last_found = -1L;
            Object[] secondary_result = new Object[]{null};
            while (remaining > 0L) {
                DistributedDatabaseContact contact;
                boolean live_contact;
                Object var34_40;
                try {
                    potential_contacts_mon.enter();
                    if (lookup_complete[0] && potential_contacts.size() == 0 && outstanding[0] == 0) {
                        Object var25_25 = null;
                        potential_contacts_mon.exit();
                        break;
                    }
                    Object var25_26 = null;
                    potential_contacts_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var25_27 = null;
                    potential_contacts_mon.exit();
                    throw throwable;
                }
                while (remaining > 0L) {
                    long wait_start = SystemTime.getMonotonousTime();
                    boolean got_sem = potential_contacts_sem.reserve(1000L);
                    long now = SystemTime.getMonotonousTime();
                    remaining -= now - wait_start;
                    if (got_sem) {
                        last_found = now;
                        break;
                    }
                    if (!sl_enabled) continue;
                    if (secondary_lookup_time == -1L) {
                        long base_time = last_found == -1L || now - overall_start > 60000L ? overall_start : last_found;
                        long time_so_far = now - base_time;
                        if (time_so_far <= 20000L) continue;
                        secondary_lookup_time = SystemTime.getMonotonousTime();
                        this.doSecondaryLookup(listener, secondary_result, hash, args);
                        continue;
                    }
                    try {
                        byte[] torrent = this.getSecondaryLookupResult(secondary_result);
                        if (torrent == null) continue;
                        return torrent;
                    }
                    catch (ResourceDownloaderException e) {
                    }
                }
                try {
                    potential_contacts_mon.enter();
                    if (potential_contacts.size() == 0) {
                        if (outstanding[0] == 0) {
                            var34_40 = null;
                            potential_contacts_mon.exit();
                            break;
                        }
                        var34_40 = null;
                        potential_contacts_mon.exit();
                        continue;
                    }
                    Object[] entry = (Object[])potential_contacts.remove(0);
                    live_contact = (Boolean)entry[0];
                    contact = (DistributedDatabaseContact)entry[1];
                }
                catch (Throwable throwable) {
                    var34_40 = null;
                    potential_contacts_mon.exit();
                    throw throwable;
                }
                var34_40 = null;
                potential_contacts_mon.exit();
                if (!live_contact) {
                    listener.reportActivity(this.getMessageText("report.tunnel", contact.getName()));
                    contact.openTunnel();
                }
                try {
                    listener.reportActivity(this.getMessageText("report.downloading", contact.getName()));
                    DistributedDatabaseValue value = contact.read(new DistributedDatabaseProgressListener(){

                        public void reportSize(long size) {
                            listener.reportSize(size);
                        }

                        public void reportActivity(String str) {
                            listener.reportActivity(str);
                        }

                        public void reportCompleteness(int percent) {
                            listener.reportCompleteness(percent);
                        }
                    }, db.getStandardTransferType(1), db.createKey(hash, "Torrent download content for '" + ByteFormatter.encodeString(hash) + "'"), timeout);
                    if (value == null) continue;
                    byte[] data = (byte[])value.getValue(byte[].class);
                    try {
                        TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(data);
                        if (Arrays.equals(hash, torrent.getHash())) {
                            listener.reportContributor(contact.getAddress());
                            return data;
                        }
                        listener.reportActivity(this.getMessageText("report.error", "torrent invalid (hash mismatch)"));
                    }
                    catch (Throwable e) {
                        listener.reportActivity(this.getMessageText("report.error", "torrent invalid (decode failed)"));
                    }
                }
                catch (Throwable e) {
                    listener.reportActivity(this.getMessageText("report.error", Debug.getNestedExceptionMessage(e)));
                    Debug.printStackTrace(e);
                }
            }
            if (sl_enabled) {
                if (secondary_lookup_time == -1L) {
                    secondary_lookup_time = SystemTime.getMonotonousTime();
                    this.doSecondaryLookup(listener, secondary_result, hash, args);
                }
                while (SystemTime.getMonotonousTime() - secondary_lookup_time < 120000L) {
                    try {
                        byte[] torrent = this.getSecondaryLookupResult(secondary_result);
                        if (torrent != null) {
                            return torrent;
                        }
                        Thread.sleep(500L);
                    }
                    catch (ResourceDownloaderException e) {
                        // empty catch block
                        break;
                    }
                }
            }
            return null;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            listener.reportActivity(this.getMessageText("report.error", Debug.getNestedExceptionMessage(e)));
            throw new MagnetURIHandlerException("MagnetURIHandler failed", e);
        }
    }

    protected void doSecondaryLookup(final MagnetPluginProgressListener listener, final Object[] result, byte[] hash, String args) {
        listener.reportActivity(this.getMessageText("report.secondarylookup", null));
        try {
            ResourceDownloaderFactory rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
            URL sl_url = new URL("http://magnet.vuze.com/magnetLookup?hash=" + Base32.encode(hash) + (args.length() == 0 ? "" : "&args=" + UrlUtils.encode(args)));
            ResourceDownloader rd = rdf.create(sl_url);
            rd.addListener(new ResourceDownloaderAdapter(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean completed(ResourceDownloader downloader, InputStream data) {
                    listener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.ok", null));
                    Object[] objectArray = result;
                    synchronized (result) {
                        result[0] = data;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void failed(ResourceDownloader downloader, ResourceDownloaderException e) {
                    Object[] objectArray = result;
                    synchronized (result) {
                        result[0] = e;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        listener.reportActivity(MagnetPlugin.this.getMessageText("report.secondarylookup.fail"));
                        return;
                    }
                }
            });
            rd.asyncDownload();
        }
        catch (Throwable e) {
            listener.reportActivity(this.getMessageText("report.secondarylookup.fail", Debug.getNestedExceptionMessage(e)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getSecondaryLookupResult(Object[] result) throws ResourceDownloaderException {
        Object[] objectArray = result;
        synchronized (result) {
            Object x = result[0];
            result[0] = null;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (x instanceof InputStream) {
                InputStream is = (InputStream)x;
                try {
                    TOTorrent t = TOTorrentFactory.deserialiseFromBEncodedInputStream(is);
                    TorrentUtils.setPeerCacheValid(t);
                    return BEncoder.encode(t.serialiseToMap());
                }
                catch (Throwable e) {}
            } else if (x instanceof ResourceDownloaderException) {
                throw (ResourceDownloaderException)x;
            }
            return null;
        }
    }

    protected String getMessageText(String resource) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource);
    }

    protected String getMessageText(String resource, String param) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource, new String[]{param});
    }

    public void addListener(MagnetPluginListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MagnetPluginListener listener) {
        this.listeners.remove(listener);
    }
}

