/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.launcher.classloading;

import com.aelitis.azureus.launcher.classloading.PeeringClassloader;
import com.aelitis.azureus.launcher.classloading.SecondaryClassLoader;
import java.io.File;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class PrimaryClassloader
extends URLClassLoader
implements PeeringClassloader {
    private final ArrayList peersLoaders = new ArrayList();
    private final ClassLoader packageLoader;
    private static final String packageName = PrimaryClassloader.class.getPackage().getName();

    private PrimaryClassloader() {
        super(PrimaryClassloader.generateURLs(), PrimaryClassloader.getSystemClassLoader().getParent());
        this.packageLoader = PrimaryClassloader.getSystemClassLoader();
    }

    public PrimaryClassloader(ClassLoader parent) {
        super(PrimaryClassloader.generateURLs(), parent.getParent());
        this.packageLoader = parent;
    }

    private static URL[] generateURLs() {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(File.pathSeparator);
        URL[] urls = new URL[paths.length + 1];
        try {
            for (int i = 0; i < paths.length; ++i) {
                urls[i] = new File(paths[i]).getCanonicalFile().toURI().toURL();
                System.out.print(urls[i] + " ; ");
            }
            urls[urls.length - 1] = new File(".").getCanonicalFile().toURI().toURL();
            System.out.println(urls[urls.length - 1]);
        }
        catch (Exception e) {
            System.err.println("Invalid classpath detected\n");
            e.printStackTrace();
            System.exit(1);
        }
        return urls;
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<Object> c;
        block4: {
            try {
                c = !name.startsWith(packageName) ? super.loadClass(name, resolve) : this.packageLoader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                c = this.peerFindLoadedClass(name);
                if (c == null) {
                    c = this.peerLoadClass(name);
                }
                if (c == null) {
                    throw e;
                }
                if (!resolve) break block4;
                this.resolveClass(c);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class peerFindLoadedClass(String className) {
        Class c = null;
        ArrayList arrayList = this.peersLoaders;
        synchronized (arrayList) {
            for (int i = 0; i < this.peersLoaders.size() && c == null; ++i) {
                WeakReference ref = (WeakReference)this.peersLoaders.get(i);
                SecondaryClassLoader loader = (SecondaryClassLoader)ref.get();
                if (loader != null) {
                    c = loader.findLoadedClassHelper(className);
                    continue;
                }
                this.peersLoaders.remove(i--);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class peerLoadClass(String className) {
        Class c = null;
        ArrayList arrayList = this.peersLoaders;
        synchronized (arrayList) {
            for (int i = 0; i < this.peersLoaders.size() && c == null; ++i) {
                WeakReference ref = (WeakReference)this.peersLoaders.get(i);
                SecondaryClassLoader loader = (SecondaryClassLoader)ref.get();
                if (loader == null) continue;
                c = loader.findClassHelper(className);
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSecondaryClassloader(SecondaryClassLoader loader) {
        ArrayList arrayList = this.peersLoaders;
        synchronized (arrayList) {
            this.peersLoaders.add(new WeakReference<SecondaryClassLoader>(loader));
        }
    }

    public static ClassLoader getBootstrappedLoader() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        try {
            return (ClassLoader)loader.loadClass(PrimaryClassloader.class.getName()).newInstance();
        }
        catch (Exception e) {
            System.err.println("Could not instantiate Classloader\n");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }
}

