/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.proxy.socks.impl;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.proxy.AEProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxy;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyAddress;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyConnection;
import com.aelitis.azureus.core.proxy.socks.AESocksProxyPlugableConnection;
import com.aelitis.azureus.core.proxy.socks.impl.AESocksProxyState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;

public class AESocksProxyPlugableConnectionDefault
implements AESocksProxyPlugableConnection {
    protected AESocksProxyConnection socks_connection;
    protected AEProxyConnection connection;
    protected SocketChannel source_channel;
    protected SocketChannel target_channel;
    protected proxyStateRelayData relay_data_state;

    public AESocksProxyPlugableConnectionDefault(AESocksProxyConnection _socks_connection) {
        this.socks_connection = _socks_connection;
        this.connection = this.socks_connection.getConnection();
        this.source_channel = this.connection.getSourceChannel();
    }

    public String getName() {
        if (this.target_channel != null) {
            return this.target_channel.socket().getInetAddress() + ":" + this.target_channel.socket().getPort();
        }
        return "";
    }

    public InetAddress getLocalAddress() {
        return this.target_channel.socket().getInetAddress();
    }

    public int getLocalPort() {
        return this.target_channel.socket().getPort();
    }

    public void connect(AESocksProxyAddress _address) throws IOException {
        if (_address.getAddress() == null) {
            throw new IOException("DNS lookup of '" + _address.getUnresolvedAddress() + "' fails");
        }
        new proxyStateRelayConnect(new InetSocketAddress(_address.getAddress(), _address.getPort()));
    }

    public void relayData() throws IOException {
        new proxyStateRelayData();
    }

    public void close() {
        if (this.target_channel != null) {
            try {
                this.connection.cancelReadSelect(this.target_channel);
                this.connection.cancelWriteSelect(this.target_channel);
                this.target_channel.close();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (this.relay_data_state != null) {
            this.relay_data_state.destroy();
        }
    }

    protected class proxyStateRelayConnect
    extends AESocksProxyState {
        protected InetSocketAddress address;

        protected proxyStateRelayConnect(InetSocketAddress _address) throws IOException {
            super(AESocksProxyPlugableConnectionDefault.this.socks_connection);
            this.address = _address;
            AESocksProxyPlugableConnectionDefault.this.connection.cancelReadSelect(AESocksProxyPlugableConnectionDefault.this.source_channel);
            AESocksProxyPlugableConnectionDefault.this.connection.setConnectState(this);
            AESocksProxyPlugableConnectionDefault.this.target_channel = SocketChannel.open();
            InetAddress bindIP = NetworkAdmin.getSingleton().getMultiHomedOutgoingRoundRobinBindAddress(this.address.getAddress());
            if (bindIP != null) {
                AESocksProxyPlugableConnectionDefault.this.target_channel.socket().bind(new InetSocketAddress(bindIP, 0));
            }
            AESocksProxyPlugableConnectionDefault.this.target_channel.configureBlocking(false);
            AESocksProxyPlugableConnectionDefault.this.target_channel.connect(this.address);
            AESocksProxyPlugableConnectionDefault.this.connection.requestConnectSelect(AESocksProxyPlugableConnectionDefault.this.target_channel);
        }

        protected boolean connectSupport(SocketChannel sc) throws IOException {
            if (!sc.finishConnect()) {
                throw new IOException("finishConnect returned false");
            }
            AESocksProxy proxy = AESocksProxyPlugableConnectionDefault.this.socks_connection.getProxy();
            if (proxy.getNextSOCKSProxyHost() != null) {
                // empty if block
            }
            AESocksProxyPlugableConnectionDefault.this.socks_connection.connected();
            return true;
        }
    }

    protected class proxyStateRelayData
    extends AESocksProxyState {
        protected DirectByteBuffer source_buffer;
        protected DirectByteBuffer target_buffer;
        protected long outward_bytes;
        protected long inward_bytes;

        protected proxyStateRelayData() throws IOException {
            super(AESocksProxyPlugableConnectionDefault.this.socks_connection);
            this.outward_bytes = 0L;
            this.inward_bytes = 0L;
            this.source_buffer = DirectByteBufferPool.getBuffer((byte)11, 1024);
            this.target_buffer = DirectByteBufferPool.getBuffer((byte)11, 1024);
            AESocksProxyPlugableConnectionDefault.this.relay_data_state = this;
            if (AESocksProxyPlugableConnectionDefault.this.connection.isClosed()) {
                this.destroy();
                throw new IOException("connection closed");
            }
            AESocksProxyPlugableConnectionDefault.this.connection.setReadState(this);
            AESocksProxyPlugableConnectionDefault.this.connection.setWriteState(this);
            AESocksProxyPlugableConnectionDefault.this.connection.requestReadSelect(AESocksProxyPlugableConnectionDefault.this.source_channel);
            AESocksProxyPlugableConnectionDefault.this.connection.requestReadSelect(AESocksProxyPlugableConnectionDefault.this.target_channel);
            AESocksProxyPlugableConnectionDefault.this.connection.setConnected();
        }

        protected void destroy() {
            if (this.source_buffer != null) {
                this.source_buffer.returnToPool();
                this.source_buffer = null;
            }
            if (this.target_buffer != null) {
                this.target_buffer.returnToPool();
                this.target_buffer = null;
            }
        }

        protected boolean readSupport(SocketChannel sc) throws IOException {
            AESocksProxyPlugableConnectionDefault.this.connection.setTimeStamp();
            SocketChannel chan1 = sc;
            SocketChannel chan2 = sc == AESocksProxyPlugableConnectionDefault.this.source_channel ? AESocksProxyPlugableConnectionDefault.this.target_channel : AESocksProxyPlugableConnectionDefault.this.source_channel;
            DirectByteBuffer read_buffer = sc == AESocksProxyPlugableConnectionDefault.this.source_channel ? this.source_buffer : this.target_buffer;
            int len = read_buffer.read((byte)10, chan1);
            if (len == -1) {
                AESocksProxyPlugableConnectionDefault.this.connection.close();
            } else if (read_buffer.position((byte)10) > 0) {
                read_buffer.flip((byte)10);
                int written = read_buffer.write((byte)10, chan2);
                if (chan1 == AESocksProxyPlugableConnectionDefault.this.source_channel) {
                    this.outward_bytes += (long)written;
                } else {
                    this.inward_bytes += (long)written;
                }
                if (read_buffer.hasRemaining((byte)10)) {
                    AESocksProxyPlugableConnectionDefault.this.connection.cancelReadSelect(chan1);
                    AESocksProxyPlugableConnectionDefault.this.connection.requestWriteSelect(chan2);
                } else {
                    read_buffer.position((byte)10, 0);
                    read_buffer.limit((byte)10, read_buffer.capacity((byte)10));
                }
            }
            return len > 0;
        }

        protected boolean writeSupport(SocketChannel sc) throws IOException {
            SocketChannel chan1 = sc;
            SocketChannel chan2 = sc == AESocksProxyPlugableConnectionDefault.this.source_channel ? AESocksProxyPlugableConnectionDefault.this.target_channel : AESocksProxyPlugableConnectionDefault.this.source_channel;
            DirectByteBuffer read_buffer = sc == AESocksProxyPlugableConnectionDefault.this.source_channel ? this.target_buffer : this.source_buffer;
            int written = read_buffer.write((byte)10, chan1);
            if (chan1 == AESocksProxyPlugableConnectionDefault.this.target_channel) {
                this.outward_bytes += (long)written;
            } else {
                this.inward_bytes += (long)written;
            }
            if (read_buffer.hasRemaining((byte)10)) {
                AESocksProxyPlugableConnectionDefault.this.connection.requestWriteSelect(chan1);
            } else {
                read_buffer.position((byte)10, 0);
                read_buffer.limit((byte)10, read_buffer.capacity((byte)10));
                AESocksProxyPlugableConnectionDefault.this.connection.requestReadSelect(chan2);
            }
            return written > 0;
        }

        public String getStateName() {
            String state = this.getClass().getName();
            int pos = state.indexOf("$");
            state = state.substring(pos + 1);
            return state + " [out=" + this.outward_bytes + ",in=" + this.inward_bytes + "] " + this.source_buffer + " / " + this.target_buffer;
        }
    }
}

