/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.peermanager.control.impl;

import com.aelitis.azureus.core.peermanager.control.PeerControlInstance;
import com.aelitis.azureus.core.peermanager.control.SpeedTokenDispenser;
import com.aelitis.azureus.core.peermanager.control.impl.PeerControlSchedulerImpl;
import com.aelitis.azureus.core.peermanager.control.impl.SpeedTokenDispenserBasic;
import com.aelitis.azureus.core.stats.AzureusCoreStatsProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class PeerControlSchedulerBasic
extends PeerControlSchedulerImpl
implements AzureusCoreStatsProvider {
    private Random random = new Random();
    private Map<PeerControlInstance, instanceWrapper> instance_map = new HashMap<PeerControlInstance, instanceWrapper>();
    private List<instanceWrapper> pending_registrations = new ArrayList<instanceWrapper>();
    private volatile boolean registrations_changed;
    protected AEMonitor this_mon = new AEMonitor("PeerControlSchedulerBasic");
    private final SpeedTokenDispenserBasic tokenDispenser = new SpeedTokenDispenserBasic();
    private long latest_time;
    private long last_lag_log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void schedule() {
        SystemTime.registerMonotonousConsumer(new SystemTime.TickConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(long time) {
                PeerControlSchedulerBasic peerControlSchedulerBasic = PeerControlSchedulerBasic.this;
                synchronized (peerControlSchedulerBasic) {
                    PeerControlSchedulerBasic.this.notify();
                }
            }
        });
        LinkedList<instanceWrapper> instances = new LinkedList<instanceWrapper>();
        long tick_count = 0L;
        long last_stats_time = SystemTime.getMonotonousTime();
        while (true) {
            if (this.registrations_changed) {
                try {
                    this.this_mon.enter();
                    Iterator it = instances.iterator();
                    while (it.hasNext()) {
                        if (!((instanceWrapper)it.next()).isUnregistered()) continue;
                        it.remove();
                    }
                    for (int i = 0; i < this.pending_registrations.size(); ++i) {
                        instances.add(this.pending_registrations.get(i));
                    }
                    this.pending_registrations.clear();
                    this.registrations_changed = false;
                    Object var9_10 = null;
                    this.this_mon.exit();
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    this.this_mon.exit();
                    throw throwable;
                }
            }
            this.latest_time = SystemTime.getMonotonousTime();
            long current_schedule_count = this.schedule_count;
            for (instanceWrapper inst : instances) {
                long target = inst.getNextTick();
                long diff = this.latest_time - target;
                if (diff < 0L) continue;
                ++tick_count;
                inst.schedule(this.latest_time);
                ++this.schedule_count;
                long new_target = target + (long)SCHEDULE_PERIOD_MILLIS;
                if (new_target <= this.latest_time) {
                    new_target = this.latest_time + target % (long)SCHEDULE_PERIOD_MILLIS;
                }
                inst.setNextTick(new_target);
            }
            PeerControlSchedulerBasic i$ = this;
            synchronized (i$) {
                if (current_schedule_count == this.schedule_count) {
                    ++this.wait_count;
                    try {
                        long wait_start = SystemTime.getHighPrecisionCounter();
                        this.wait(SCHEDULE_PERIOD_MILLIS);
                        long wait_time = SystemTime.getHighPrecisionCounter() - wait_start;
                        this.total_wait_time += wait_time;
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                } else {
                    ++this.yield_count;
                    Thread.yield();
                }
            }
            long stats_diff = this.latest_time - last_stats_time;
            if (stats_diff <= 10000L) continue;
            last_stats_time = this.latest_time;
            tick_count = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(PeerControlInstance instance) {
        instanceWrapper wrapper2 = new instanceWrapper(instance);
        wrapper2.setNextTick(this.latest_time + (long)this.random.nextInt(SCHEDULE_PERIOD_MILLIS));
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            new_map.put(instance, wrapper2);
            this.instance_map = new_map;
            this.pending_registrations.add(wrapper2);
            this.registrations_changed = true;
            Object var5_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(PeerControlInstance instance) {
        try {
            this.this_mon.enter();
            HashMap<PeerControlInstance, instanceWrapper> new_map = new HashMap<PeerControlInstance, instanceWrapper>(this.instance_map);
            instanceWrapper wrapper2 = (instanceWrapper)new_map.remove(instance);
            if (wrapper2 == null) {
                Debug.out("instance wrapper not found");
                Object var5_4 = null;
                this.this_mon.exit();
                return;
            }
            wrapper2.unregister();
            this.instance_map = new_map;
            this.registrations_changed = true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.this_mon.exit();
            throw throwable;
        }
        Object var5_5 = null;
        this.this_mon.exit();
    }

    public SpeedTokenDispenser getSpeedTokenDispenser() {
        return this.tokenDispenser;
    }

    public void updateScheduleOrdering() {
    }

    protected class instanceWrapper {
        private PeerControlInstance instance;
        private boolean unregistered;
        private long next_tick;
        private long last_schedule;

        protected instanceWrapper(PeerControlInstance _instance) {
            this.instance = _instance;
        }

        protected void unregister() {
            this.unregistered = true;
        }

        protected boolean isUnregistered() {
            return this.unregistered;
        }

        protected void setNextTick(long t) {
            this.next_tick = t;
        }

        protected long getNextTick() {
            return this.next_tick;
        }

        protected String getName() {
            return this.instance.getName();
        }

        protected void schedule(long mono_now) {
            if (mono_now < 100000L) {
                Debug.out("eh?");
            }
            if (this.last_schedule > 0L && mono_now - this.last_schedule > 1000L && mono_now - PeerControlSchedulerBasic.this.last_lag_log > 1000L) {
                PeerControlSchedulerBasic.this.last_lag_log = mono_now;
                System.out.println("Scheduling lagging: " + (mono_now - this.last_schedule) + " - instances=" + PeerControlSchedulerBasic.this.instance_map.size());
            }
            this.last_schedule = mono_now;
            try {
                this.instance.schedule();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }
}

