/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.pairing.impl;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterfaceAddress;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.pairing.PairedNode;
import com.aelitis.azureus.core.pairing.PairedService;
import com.aelitis.azureus.core.pairing.PairingConnectionData;
import com.aelitis.azureus.core.pairing.PairingException;
import com.aelitis.azureus.core.pairing.PairingManager;
import com.aelitis.azureus.core.pairing.PairingManagerListener;
import com.aelitis.azureus.core.pairing.PairingTest;
import com.aelitis.azureus.core.pairing.PairingTestListener;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.util.CopyOnWriteList;
import com.aelitis.azureus.plugins.upnp.UPnPPlugin;
import com.aelitis.azureus.plugins.upnp.UPnPPluginService;
import com.aelitis.azureus.util.JSONUtils;
import com.aelitis.net.upnp.UPnPRootDevice;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DelayedEvent;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.BooleanParameter;
import org.gudy.azureus2.plugins.ui.config.HyperlinkParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.utils.DelayedTask;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PairingManagerImpl
implements PairingManager {
    private static final boolean DEBUG = false;
    private static final String SERVICE_URL;
    private static final PairingManagerImpl singleton;
    private static final int GLOBAL_UPDATE_PERIOD = 60000;
    private static final int CD_REFRESH_PERIOD = 82800000;
    private static final int CD_REFRESH_TICKS = 1380;
    private static final int CONNECT_TEST_PERIOD_MILLIS = 1800000;
    private AzureusCore azureus_core;
    private BooleanParameter param_enable;
    private InfoParameter param_ac_info;
    private InfoParameter param_status_info;
    private InfoParameter param_last_error;
    private HyperlinkParameter param_view;
    private BooleanParameter param_e_enable;
    private StringParameter param_public_ipv4;
    private StringParameter param_public_ipv6;
    private StringParameter param_host;
    private StringParameter param_local_ipv4;
    private StringParameter param_local_ipv6;
    private Map<String, PairedServiceImpl> services = new HashMap<String, PairedServiceImpl>();
    private AESemaphore init_sem = new AESemaphore("PM:init");
    private TimerEventPeriodic global_update_event;
    private InetAddress current_v4;
    private InetAddress current_v6;
    private String local_v4 = "";
    private String local_v6 = "";
    private boolean update_outstanding;
    private boolean updates_enabled;
    private static final int MIN_UPDATE_PERIOD_DEFAULT = 10000;
    private static final int MAX_UPDATE_PERIOD_DEFAULT = 3600000;
    private int min_update_period = 10000;
    private int max_update_period = 3600000;
    private AsyncDispatcher dispatcher = new AsyncDispatcher();
    private boolean must_update_once;
    private boolean update_in_progress;
    private TimerEvent deferred_update_event;
    private long last_update_time = -1L;
    private int consec_update_fails;
    private String last_message;
    private Map<String, Object[]> local_address_checks = new HashMap<String, Object[]>();
    private CopyOnWriteList<PairingManagerListener> listeners = new CopyOnWriteList();

    public static PairingManager getSingleton() {
        return singleton;
    }

    protected PairingManagerImpl() {
        this.must_update_once = COConfigurationManager.getBooleanParameter("pairing.updateoutstanding");
        PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        final UIManager ui_manager = default_pi.getUIManager();
        BasicPluginConfigModel configModel = ui_manager.createBasicPluginConfigModel("server", "Pairing");
        configModel.addHyperlinkParameter2("ConfigView.label.please.visit.here", MessageText.getString("ConfigView.section.connection.pairing.url"));
        this.param_enable = configModel.addBooleanParameter2("pairing.enable", "pairing.enable", false);
        String access_code = this.readAccessCode();
        this.param_ac_info = configModel.addInfoParameter2("pairing.accesscode", access_code);
        this.param_status_info = configModel.addInfoParameter2("pairing.status.info", "");
        this.param_last_error = configModel.addInfoParameter2("pairing.last.error", "");
        this.param_view = configModel.addHyperlinkParameter2("pairing.view.registered", SERVICE_URL + "/web/view?ac=" + access_code);
        if (access_code.length() == 0) {
            this.param_view.setEnabled(false);
        }
        final ActionParameter ap = configModel.addActionParameter2("pairing.ac.getnew", "pairing.ac.getnew.create");
        ap.addListener(new ParameterListener(){

            public void parameterChanged(Parameter param) {
                try {
                    ap.setEnabled(false);
                    PairingManagerImpl.this.allocateAccessCode(false);
                    SimpleTimer.addEvent("PM:enabler", SystemTime.getOffsetTime(30000L), new TimerEventPerformer(){

                        public void perform(TimerEvent event2) {
                            ap.setEnabled(true);
                        }
                    });
                }
                catch (Throwable e) {
                    ap.setEnabled(true);
                    String details = MessageText.getString("pairing.alloc.fail", new String[]{Debug.getNestedExceptionMessage(e)});
                    ui_manager.showMessageBox("pairing.op.fail", "!" + details + "!", 1L);
                }
            }
        });
        LabelParameter param_e_info = configModel.addLabelParameter2("pairing.explicit.info");
        this.param_e_enable = configModel.addBooleanParameter2("pairing.explicit.enable", "pairing.explicit.enable", false);
        this.param_public_ipv4 = configModel.addStringParameter2("pairing.ipv4", "pairing.ipv4", "");
        this.param_public_ipv6 = configModel.addStringParameter2("pairing.ipv6", "pairing.ipv6", "");
        this.param_host = configModel.addStringParameter2("pairing.host", "pairing.host", "");
        LabelParameter spacer = configModel.addLabelParameter2("blank.resource");
        this.param_local_ipv4 = configModel.addStringParameter2("pairing.local.ipv4", "pairing.local.ipv4", "");
        this.param_local_ipv6 = configModel.addStringParameter2("pairing.local.ipv6", "pairing.local.ipv6", "");
        this.param_public_ipv4.setGenerateIntermediateEvents(false);
        this.param_public_ipv6.setGenerateIntermediateEvents(false);
        this.param_host.setGenerateIntermediateEvents(false);
        ParameterListener change_listener = new ParameterListener(){

            public void parameterChanged(Parameter param) {
                PairingManagerImpl.this.updateNeeded();
                if (param == PairingManagerImpl.this.param_enable) {
                    PairingManagerImpl.this.fireChanged();
                }
            }
        };
        this.param_enable.addListener(change_listener);
        this.param_e_enable.addListener(change_listener);
        this.param_public_ipv4.addListener(change_listener);
        this.param_public_ipv6.addListener(change_listener);
        this.param_local_ipv4.addListener(change_listener);
        this.param_local_ipv6.addListener(change_listener);
        this.param_host.addListener(change_listener);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_public_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv4);
        this.param_e_enable.addEnabledOnSelection(this.param_local_ipv6);
        this.param_e_enable.addEnabledOnSelection(this.param_host);
        configModel.createGroup("pairing.group.explicit", new Parameter[]{param_e_info, this.param_e_enable, this.param_public_ipv4, this.param_public_ipv6, this.param_host, spacer, this.param_local_ipv4, this.param_local_ipv6});
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                PairingManagerImpl.this.initialise(core);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(AzureusCore _core) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.azureus_core = _core;
        }
        try {
            PluginInterface default_pi = PluginInitializer.getDefaultInterface();
            DelayedTask dt = default_pi.getUtilities().createDelayedTask(new Runnable(){

                public void run() {
                    new DelayedEvent("PM:delayinit", 10000L, new AERunnable(){

                        public void runSupport() {
                            PairingManagerImpl.this.enableUpdates();
                        }
                    });
                }
            });
            dt.queue();
            Object var5_5 = null;
            this.init_sem.releaseForever();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.init_sem.releaseForever();
            throw throwable;
        }
    }

    protected void waitForInitialisation() throws PairingException {
        if (!this.init_sem.reserve(30000L)) {
            throw new PairingException("Timeout waiting for initialisation");
        }
    }

    @Override
    public boolean isEnabled() {
        return this.param_enable.getValue();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.param_enable.setValue(enabled);
    }

    @Override
    public void setGroup(String group) {
        COConfigurationManager.setParameter("pairing.groupcode", group);
        this.updateNeeded();
    }

    @Override
    public String getGroup() {
        return COConfigurationManager.getStringParameter("pairing.groupcode", null);
    }

    @Override
    public List<PairedNode> listGroup() throws PairingException {
        try {
            URL url = new URL(SERVICE_URL + "/remote/listGroup?gc=" + this.getGroup());
            InputStream is = new ResourceDownloaderFactoryImpl().create(url).download();
            Map json = JSONUtils.decodeJSON(new String(FileUtil.readInputStreamAsByteArray(is), "UTF-8"));
            List list = (List)json.get("result");
            ArrayList<PairedNode> result = new ArrayList<PairedNode>();
            String my_ac = this.peekAccessCode();
            if (list != null) {
                for (Map m : list) {
                    PairedNodeImpl node = new PairedNodeImpl(m);
                    if (my_ac != null && my_ac.equals(node.getAccessCode())) continue;
                    result.add(node);
                }
            }
            return result;
        }
        catch (Throwable e) {
            throw new PairingException("Failed to list group", e);
        }
    }

    protected void setStatus(String str) {
        String last_status = this.param_status_info.getValue();
        if (!last_status.equals(str)) {
            this.param_status_info.setValue(str);
            this.fireChanged();
        }
    }

    @Override
    public String getStatus() {
        return this.param_status_info.getValue();
    }

    protected void setLastServerError(String error) {
        String last_error = this.param_last_error.getValue();
        if (error == null) {
            error = "";
        }
        if (!last_error.equals(error)) {
            this.param_last_error.setValue(error);
            this.fireChanged();
        }
    }

    @Override
    public String getLastServerError() {
        String last_error = this.param_last_error.getValue();
        if (last_error.length() == 0) {
            last_error = null;
        }
        return last_error;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasActionOutstanding() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (!this.isEnabled()) {
                return false;
            }
            return !this.updates_enabled || this.update_outstanding || this.deferred_update_event != null || this.update_in_progress;
        }
    }

    protected String readAccessCode() {
        return COConfigurationManager.getStringParameter("pairing.accesscode", "");
    }

    protected void writeAccessCode(String ac) {
        COConfigurationManager.setParameter("pairing.accesscode", ac);
        COConfigurationManager.save();
        this.param_ac_info.setValue(ac);
        this.param_view.setHyperlink(SERVICE_URL + "/web/view?ac=" + ac);
        this.param_view.setEnabled(ac.length() > 0);
    }

    protected String allocateAccessCode(boolean updating) throws PairingException {
        HashMap<String, Object> request2 = new HashMap<String, Object>();
        String existing = this.readAccessCode();
        request2.put("ac", existing);
        Map<String, Object> response = this.sendRequest("allocate", request2);
        try {
            String code = this.getString(response, "ac");
            this.writeAccessCode(code);
            if (!updating) {
                this.updateNeeded();
            }
            this.fireChanged();
            return code;
        }
        catch (Throwable e) {
            throw new PairingException("allocation failed", e);
        }
    }

    @Override
    public String peekAccessCode() {
        return this.readAccessCode();
    }

    @Override
    public String getAccessCode() throws PairingException {
        this.waitForInitialisation();
        String ac = this.readAccessCode();
        if (ac == null || ac.length() == 0) {
            ac = this.allocateAccessCode(false);
        }
        return ac;
    }

    public void getAccessCode(final PairingManagerListener listener) throws PairingException {
        new AEThread2("PM:gac", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    PairingManagerImpl.this.getAccessCode();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    listener.somethingChanged(PairingManagerImpl.this);
                    throw throwable;
                }
            }
        }.start();
    }

    @Override
    public String getReplacementAccessCode() throws PairingException {
        this.waitForInitialisation();
        String new_code = this.allocateAccessCode(false);
        return new_code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService addService(String sid) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedServiceImpl result = this.services.get(sid);
            if (result == null) {
                result = new PairedServiceImpl(sid);
                this.services.put(sid, result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PairedService getService(String sid) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            PairedService result = this.services.get(sid);
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(PairedServiceImpl service) {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            String sid = service.getSID();
            if (this.services.remove(sid) != null) {
                // empty if block
            }
        }
        this.updateNeeded();
    }

    protected void sync(PairedServiceImpl service) {
        this.updateNeeded();
    }

    protected InetAddress updateAddress(InetAddress current, InetAddress latest, boolean v6) {
        if (v6 ? latest instanceof Inet4Address : latest instanceof Inet6Address) {
            return current;
        }
        if (current == latest) {
            return current;
        }
        if (current == null || latest == null) {
            return latest;
        }
        if (!current.equals(latest)) {
            return latest;
        }
        return current;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void updateGlobals(boolean is_updating) {
        final long now = SystemTime.getMonotonousTime();
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            void var17_20;
            NetworkAdmin network_admin = NetworkAdmin.getSingleton();
            InetAddress latest_v4 = this.azureus_core.getInstanceManager().getMyInstance().getExternalAddress();
            InetAddress temp_v4 = this.updateAddress(this.current_v4, latest_v4, false);
            InetAddress latest_v6 = network_admin.getDefaultPublicAddressV6();
            InetAddress temp_v6 = this.updateAddress(this.current_v6, latest_v6, true);
            final TreeSet<String> latest_v4_locals = new TreeSet<String>();
            final TreeSet<String> latest_v6_locals = new TreeSet<String>();
            NetworkAdminNetworkInterface[] interfaces = network_admin.getInterfaces();
            ArrayList<6> to_do = new ArrayList<6>();
            HashSet<String> existing_checked = new HashSet<String>(this.local_address_checks.keySet());
            NetworkAdminNetworkInterface[] arr$ = interfaces;
            int len$ = arr$.length;
            boolean bl = false;
            while (var17_20 < len$) {
                NetworkAdminNetworkInterfaceAddress[] addresses;
                NetworkAdminNetworkInterface intf = arr$[var17_20];
                for (NetworkAdminNetworkInterfaceAddress address : addresses = intf.getAddresses()) {
                    boolean run_check;
                    Object[] check;
                    final InetAddress ia = address.getAddress();
                    if (ia.isLoopbackAddress() || !ia.isLinkLocalAddress() && !ia.isSiteLocalAddress()) continue;
                    final String a_str = ia.getHostAddress();
                    existing_checked.remove(a_str);
                    Map<String, Object[]> map = this.local_address_checks;
                    synchronized (map) {
                        check = this.local_address_checks.get(a_str);
                    }
                    boolean bl2 = run_check = check == null || now - (Long)check[0] > 1800000L;
                    if (run_check) {
                        to_do.add(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void run() {
                                Socket socket = new Socket();
                                String result = a_str;
                                try {
                                    socket.bind(new InetSocketAddress(ia, 0));
                                    socket.connect(new InetSocketAddress("www.google.com", 80), 10000);
                                    result = result + "*";
                                }
                                catch (Throwable throwable) {
                                    Object var5_5 = null;
                                    try {
                                        socket.close();
                                    }
                                    catch (Throwable e) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                        });
                        continue;
                    }
                    Map<String, Object[]> map2 = this.local_address_checks;
                    synchronized (map2) {
                        if (ia instanceof Inet4Address) {
                            latest_v4_locals.add((String)check[1]);
                        } else {
                            latest_v6_locals.add((String)check[1]);
                        }
                    }
                }
                ++var17_20;
            }
            if (to_do.size() > 0) {
                final AESemaphore sem = new AESemaphore("PM:check");
                for (final Runnable runnable : to_do) {
                    new AEThread2("PM:check:", true){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                runnable.run();
                                Object var2_1 = null;
                                sem.release();
                            }
                            catch (Throwable throwable) {
                                Object var2_2 = null;
                                sem.release();
                                throw throwable;
                            }
                        }
                    }.start();
                }
                for (int i = 0; i < to_do.size(); ++i) {
                    sem.reserve();
                }
            }
            for (String excess : existing_checked) {
                this.local_address_checks.remove(excess);
            }
            String v4_locals_str = this.getString(latest_v4_locals);
            String v6_locals_str = this.getString(latest_v6_locals);
            if (temp_v4 != this.current_v4 || temp_v6 != this.current_v6 || !v4_locals_str.equals(this.local_v4) || !v6_locals_str.equals(this.local_v6)) {
                this.current_v4 = temp_v4;
                this.current_v6 = temp_v6;
                this.local_v4 = v4_locals_str;
                this.local_v6 = v6_locals_str;
                if (!is_updating) {
                    this.updateNeeded();
                }
            }
        }
    }

    protected String getString(Set<String> set) {
        String str = "";
        for (String s : set) {
            str = str + (str.length() == 0 ? "" : ",") + s;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enableUpdates() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            this.updates_enabled = true;
            if (this.update_outstanding) {
                this.update_outstanding = false;
                this.updateNeeded();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateNeeded() {
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (this.updates_enabled) {
                this.dispatcher.dispatch(new AERunnable(){

                    public void runSupport() {
                        PairingManagerImpl.this.doUpdate();
                    }
                });
            } else {
                this.setStatus(MessageText.getString("pairing.status.initialising"));
                this.update_outstanding = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doUpdate() {
        block57: {
            PairingManagerImpl pairingManagerImpl;
            block56: {
                long now = SystemTime.getMonotonousTime();
                PairingManagerImpl pairingManagerImpl2 = this;
                synchronized (pairingManagerImpl2) {
                    if (this.deferred_update_event != null) {
                        return;
                    }
                    long time_since_last_update = now - this.last_update_time;
                    if (this.last_update_time > 0L && time_since_last_update < (long)this.min_update_period) {
                        this.deferUpdate((long)this.min_update_period - time_since_last_update);
                        return;
                    }
                    this.update_in_progress = true;
                }
                try {
                    try {
                        HashMap<String, Object> payload = new HashMap<String, Object>();
                        boolean is_enabled = this.param_enable.getValue();
                        PairingManagerImpl pairingManagerImpl3 = this;
                        synchronized (pairingManagerImpl3) {
                            ArrayList<Map<String, String>> list = new ArrayList<Map<String, String>>();
                            payload.put("s", list);
                            if (this.services.size() > 0 && is_enabled) {
                                if (this.global_update_event == null) {
                                    this.global_update_event = SimpleTimer.addPeriodicEvent("PM:updater", 60000L, new TimerEventPerformer(){
                                        private int tick_count;

                                        public void perform(TimerEvent event2) {
                                            ++this.tick_count;
                                            PairingManagerImpl.this.updateGlobals(false);
                                            if (this.tick_count % 1380 == 0) {
                                                PairingManagerImpl.this.updateNeeded();
                                            }
                                        }
                                    });
                                    this.updateGlobals(true);
                                }
                                for (PairedServiceImpl service : this.services.values()) {
                                    list.add(service.toMap());
                                }
                            } else if (this.global_update_event == null) {
                                if (this.consec_update_fails == 0 && !this.must_update_once) {
                                    this.update_in_progress = false;
                                    this.setStatus(MessageText.getString(is_enabled ? "pairing.status.noservices" : "pairing.status.disabled"));
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 51, 53, 54, 15] lbl38 : MonitorExitStatement: MONITOREXIT : var5_7
                                    Object var25_15 = null;
                                    pairingManagerImpl = this;
                                    break block56;
                                }
                            } else {
                                this.global_update_event.cancel();
                                this.global_update_event = null;
                            }
                            this.last_update_time = now;
                        }
                        String ac = this.readAccessCode();
                        if (ac.length() == 0) {
                            ac = this.allocateAccessCode(true);
                        }
                        payload.put("ac", ac);
                        String gc = this.getGroup();
                        if (gc != null && gc.length() > 0) {
                            payload.put("gc", gc);
                        }
                        Object i$ = this;
                        synchronized (i$) {
                            if (this.current_v4 != null) {
                                payload.put("c_v4", this.current_v4.getHostAddress());
                            }
                            if (this.current_v6 != null) {
                                payload.put("c_v6", this.current_v6.getHostAddress());
                            }
                            if (this.local_v4.length() > 0) {
                                payload.put("l_v4", this.local_v4);
                            }
                            if (this.local_v6.length() > 0) {
                                payload.put("l_v6", this.local_v6);
                            }
                            if (this.param_e_enable.getValue()) {
                                String l_v6;
                                String l_v4;
                                String v6;
                                String v4;
                                String host = this.param_host.getValue().trim();
                                if (host.length() > 0) {
                                    payload.put("e_h", host);
                                }
                                if ((v4 = this.param_public_ipv4.getValue().trim()).length() > 0) {
                                    payload.put("e_v4", v4);
                                }
                                if ((v6 = this.param_public_ipv6.getValue().trim()).length() > 0) {
                                    payload.put("e_v6", v6);
                                }
                                if ((l_v4 = this.param_local_ipv4.getValue().trim()).length() > 0) {
                                    payload.put("e_l_v4", l_v4);
                                }
                                if ((l_v6 = this.param_local_ipv6.getValue().trim()).length() > 0) {
                                    payload.put("e_l_v6", l_v6);
                                }
                            }
                            try {
                                UPnPPlugin upnp;
                                PluginInterface pi_upnp = this.azureus_core.getPluginManager().getPluginInterfaceByClass(UPnPPlugin.class);
                                if (pi_upnp != null && (upnp = (UPnPPlugin)pi_upnp.getPlugin()).isEnabled()) {
                                    ArrayList upnp_list = new ArrayList();
                                    payload.put("upnp", upnp_list);
                                    UPnPPluginService[] services = upnp.getServices();
                                    HashSet<UPnPRootDevice> devices = new HashSet<UPnPRootDevice>();
                                    for (UPnPPluginService service : services) {
                                        UPnPRootDevice root_device = service.getService().getGenericService().getDevice().getRootDevice();
                                        if (devices.contains(root_device)) continue;
                                        devices.add(root_device);
                                        HashMap<String, String> map = new HashMap<String, String>();
                                        upnp_list.add(map);
                                        map.put("i", root_device.getInfo());
                                    }
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            try {
                                NetworkAdminSocksProxy[] socks_proxies;
                                NetworkAdmin admin = NetworkAdmin.getSingleton();
                                NetworkAdminHTTPProxy http_proxy = admin.getHTTPProxy();
                                if (http_proxy != null) {
                                    payload.put("hp", http_proxy.getName());
                                }
                                if ((socks_proxies = admin.getSocksProxies()).length > 0) {
                                    payload.put("sp", socks_proxies[0].getName());
                                }
                            }
                            catch (Throwable e) {
                                // empty catch block
                            }
                            payload.put("_enabled", is_enabled ? 1L : 0L);
                        }
                        this.sendRequest("update", payload);
                        i$ = this;
                        synchronized (i$) {
                            this.consec_update_fails = 0;
                            this.must_update_once = false;
                            if (this.deferred_update_event == null) {
                                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                            }
                            this.update_in_progress = false;
                            if (this.global_update_event == null) {
                                this.setStatus(MessageText.getString(is_enabled ? "pairing.status.noservices" : "pairing.status.disabled"));
                            } else {
                                this.setStatus(MessageText.getString("pairing.status.registered", new String[]{new SimpleDateFormat().format(new Date(SystemTime.getCurrentTime()))}));
                            }
                            break block57;
                        }
                    }
                    catch (Throwable e) {
                        PairingManagerImpl pairingManagerImpl4 = this;
                        synchronized (pairingManagerImpl4) {
                            try {
                                ++this.consec_update_fails;
                                long back_off = this.min_update_period;
                                for (int i = 0; i < this.consec_update_fails; ++i) {
                                    if ((back_off *= 2L) <= (long)this.max_update_period) continue;
                                    back_off = this.max_update_period;
                                    break;
                                }
                                this.deferUpdate(back_off);
                                Object var22_33 = null;
                                this.update_in_progress = false;
                            }
                            catch (Throwable throwable) {
                                Object var22_34 = null;
                                this.update_in_progress = false;
                                throw throwable;
                            }
                        }
                        Object var25_17 = null;
                        PairingManagerImpl pairingManagerImpl5 = this;
                        synchronized (pairingManagerImpl5) {
                            if (!this.update_in_progress) return;
                            Debug.out("Something didn't clear update_in_progress!!!!");
                            this.update_in_progress = false;
                            return;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var25_18 = null;
                    PairingManagerImpl pairingManagerImpl6 = this;
                    synchronized (pairingManagerImpl6) {
                        if (!this.update_in_progress) throw throwable;
                        Debug.out("Something didn't clear update_in_progress!!!!");
                        this.update_in_progress = false;
                        throw throwable;
                    }
                }
            }
            synchronized (pairingManagerImpl) {
                if (!this.update_in_progress) return;
                Debug.out("Something didn't clear update_in_progress!!!!");
                this.update_in_progress = false;
                return;
            }
        }
        Object var25_16 = null;
        PairingManagerImpl pairingManagerImpl = this;
        synchronized (pairingManagerImpl) {
            if (!this.update_in_progress) return;
            Debug.out("Something didn't clear update_in_progress!!!!");
            this.update_in_progress = false;
            return;
        }
    }

    protected void deferUpdate(long millis) {
        long target = SystemTime.getOffsetTime(millis += 5000L);
        this.deferred_update_event = SimpleTimer.addEvent("PM:defer", target, new TimerEventPerformer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void perform(TimerEvent event2) {
                PairingManagerImpl pairingManagerImpl = PairingManagerImpl.this;
                synchronized (pairingManagerImpl) {
                    PairingManagerImpl.this.deferred_update_event = null;
                }
                COConfigurationManager.setParameter("pairing.updateoutstanding", false);
                PairingManagerImpl.this.updateNeeded();
            }
        });
        this.setStatus(MessageText.getString("pairing.status.pending", new String[]{new SimpleDateFormat().format(new Date(target))}));
        COConfigurationManager.setParameter("pairing.updateoutstanding", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> sendRequest(String command, Map<String, Object> payload) throws PairingException {
        try {
            String error;
            HashMap<String, Map<String, Object>> request2 = new HashMap<String, Map<String, Object>>();
            CryptoManager cman = CryptoManagerFactory.getSingleton();
            String azid = Base32.encode(cman.getSecureID());
            payload.put("_azid", azid);
            try {
                String pk = Base32.encode(cman.getECCHandler().getPublicKey("pairing"));
                payload.put("_pk", pk);
            }
            catch (Throwable e) {
                // empty catch block
            }
            request2.put("req", payload);
            String request_str = Base32.encode(BEncoder.encode(request2));
            String sig = null;
            try {
                sig = Base32.encode(cman.getECCHandler().sign(request_str.getBytes("UTF-8"), "pairing"));
            }
            catch (Throwable e) {
                // empty catch block
            }
            String other_params = "&ver=" + UrlUtils.encode("4.6.0.4") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
            if (sig != null) {
                other_params = other_params + "&sig=" + sig;
            }
            URL target = new URL(SERVICE_URL + "/client/" + command + "?request=" + request_str + other_params);
            HttpURLConnection connection = (HttpURLConnection)target.openConnection();
            connection.setConnectTimeout(30000);
            InputStream is = connection.getInputStream();
            Map response = BDecoder.decode(new BufferedInputStream(is));
            PairingManagerImpl pairingManagerImpl = this;
            synchronized (pairingManagerImpl) {
                Long max_retry;
                Long min_retry = (Long)response.get("min_secs");
                if (min_retry != null) {
                    this.min_update_period = min_retry.intValue() * 1000;
                }
                if ((max_retry = (Long)response.get("max_secs")) != null) {
                    this.max_update_period = max_retry.intValue() * 1000;
                }
            }
            final String message = this.getString(response, "message");
            if (!(message == null || this.last_message != null && this.last_message.equals(message))) {
                this.last_message = message;
                try {
                    byte[] message_sig = (byte[])response.get("message_sig");
                    AEVerifier.verifyData(message, message_sig);
                    new AEThread2("PairMsg", true){

                        public void run() {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            if (ui_manager != null) {
                                ui_manager.showMessageBox("pairing.server.warning.title", "!" + message + "!", 1L);
                            }
                        }
                    }.start();
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if ((error = this.getString(response, "error")) != null) {
                throw new PairingException(error);
            }
            this.setLastServerError(null);
            return (Map)response.get("rep");
        }
        catch (Throwable e) {
            this.setLastServerError(Debug.getNestedExceptionMessage(e));
            if (e instanceof PairingException) {
                throw (PairingException)e;
            }
            throw new PairingException("invocation failed", e);
        }
    }

    @Override
    public PairingTest testService(String sid, PairingTestListener listener) throws PairingException {
        return new TestServiceImpl(sid, listener);
    }

    protected void fireChanged() {
        for (PairingManagerListener l : this.listeners) {
            try {
                l.somethingChanged(this);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    @Override
    public void addListener(PairingManagerListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeListener(PairingManagerListener l) {
        this.listeners.remove(l);
    }

    protected String getString(Map<String, Object> map, String name) throws IOException {
        byte[] bytes = (byte[])map.get(name);
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    static /* synthetic */ Map access$100(PairingManagerImpl x0) {
        return x0.local_address_checks;
    }

    static {
        String url = System.getProperty("az.pairing.url", "");
        SERVICE_URL = url.length() == 0 ? "http://pair.vuze.com/pairing" : url;
        singleton = new PairingManagerImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PairedNodeImpl
    implements PairedNode {
        private Map map;

        protected PairedNodeImpl(Map _map) {
            this.map = _map;
        }

        @Override
        public String getAccessCode() {
            return (String)this.map.get("ac");
        }

        @Override
        public List<InetAddress> getAddresses() {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            this.addAddress(addresses, "c_v4");
            this.addAddress(addresses, "c_v6");
            this.addAddress(addresses, "l_v4");
            this.addAddress(addresses, "l_v6");
            this.addAddress(addresses, "e_v4");
            this.addAddress(addresses, "e_v6");
            this.addAddress(addresses, "e_l_v4");
            this.addAddress(addresses, "e_l_v6");
            this.addAddress(addresses, "e_h");
            return new ArrayList<InetAddress>(addresses);
        }

        private void addAddress(Set<InetAddress> addresses, String key) {
            String str = (String)this.map.get(key);
            if (str != null) {
                String[] bits;
                for (String bit : bits = str.split(",")) {
                    if ((bit = bit.trim()).length() == 0) continue;
                    if (bit.endsWith("*")) {
                        bit = bit.substring(0, bit.length() - 1);
                    }
                    try {
                        addresses.add(InetAddress.getByName(bit));
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        }

        @Override
        public List<PairedService> getServices() {
            Map smap = (Map)this.map.get("services");
            ArrayList<PairedService> services = new ArrayList<PairedService>();
            for (Map.Entry entry : smap.entrySet()) {
                services.add(new PairedService2Impl((String)entry.getKey(), (Map)entry.getValue()));
            }
            return services;
        }
    }

    private class PairedService2Impl
    implements PairedService {
        private String sid;
        private Map map;

        protected PairedService2Impl(String _sid, Map _map) {
            this.sid = _sid;
            this.map = _map;
        }

        public String getSID() {
            return this.sid;
        }

        public PairingConnectionData getConnectionData() {
            return new PairingConnectionData2(this.map);
        }

        public void remove() {
            throw new RuntimeException("Not supported");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PairedServiceImpl
    implements PairedService,
    PairingConnectionData {
        private String sid;
        private Map<String, String> attributes = new HashMap<String, String>();

        protected PairedServiceImpl(String _sid) {
            this.sid = _sid;
        }

        @Override
        public String getSID() {
            return this.sid;
        }

        @Override
        public PairingConnectionData getConnectionData() {
            return this;
        }

        @Override
        public void remove() {
            PairingManagerImpl.this.remove(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setAttribute(String name, String value) {
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                if (value == null) {
                    this.attributes.remove(name);
                } else {
                    this.attributes.put(name, value);
                }
            }
        }

        @Override
        public String getAttribute(String name) {
            return this.attributes.get(name);
        }

        @Override
        public void sync() {
            PairingManagerImpl.this.sync(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> toMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("sid", this.sid);
            PairedServiceImpl pairedServiceImpl = this;
            synchronized (pairedServiceImpl) {
                result.putAll(this.attributes);
            }
            return result;
        }
    }

    private class PairingConnectionData2
    implements PairingConnectionData {
        private Map map;

        protected PairingConnectionData2(Map _map) {
            this.map = _map;
        }

        public void setAttribute(String name, String value) {
            throw new RuntimeException("Not supported");
        }

        public String getAttribute(String name) {
            return (String)this.map.get(name);
        }

        public void sync() {
            throw new RuntimeException("Not supported");
        }
    }

    protected class TestServiceImpl
    implements PairingTest {
        private final String sid;
        private final PairingTestListener listener;
        private volatile int outcome = 0;
        private volatile String error_message;
        private volatile boolean cancelled;

        protected TestServiceImpl(String _sid, PairingTestListener _listener) {
            this.sid = _sid;
            this.listener = _listener;
            new AEThread2("PM:test"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    block20: {
                        try {
                            try {
                                String access_code;
                                block19: {
                                    access_code = null;
                                    long sid_wait_start = -1L;
                                    do {
                                        if (!PairingManagerImpl.this.isEnabled()) {
                                            throw new Exception("Pairing is disabled");
                                        }
                                        access_code = PairingManagerImpl.this.peekAccessCode();
                                        if (access_code != null && !PairingManagerImpl.this.hasActionOutstanding()) {
                                            if (PairingManagerImpl.this.getService(TestServiceImpl.this.sid) != null) break block19;
                                            long now = SystemTime.getMonotonousTime();
                                            if (sid_wait_start == -1L) {
                                                sid_wait_start = now;
                                            } else if (now - sid_wait_start > 5000L) break block19;
                                        }
                                        Thread.sleep(500L);
                                    } while (!TestServiceImpl.this.cancelled);
                                    TestServiceImpl.this.outcome = 6;
                                    Object var12_6 = null;
                                    TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                    return;
                                }
                                PairedService service = PairingManagerImpl.this.getService(TestServiceImpl.this.sid);
                                if (service == null) {
                                    throw new Exception("Service not found");
                                }
                                TestServiceImpl.this.listener.testStarted(TestServiceImpl.this);
                                String other_params = "&ver=" + UrlUtils.encode("4.6.0.4") + "&app=" + UrlUtils.encode(SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode(MessageText.getCurrentLocale().toString());
                                URL target = new URL(SERVICE_URL + "/web/test?sid=" + TestServiceImpl.this.sid + "&ac=" + access_code + "&format=bencode" + other_params);
                                HttpURLConnection connection = (HttpURLConnection)target.openConnection();
                                connection.setConnectTimeout(10000);
                                try {
                                    InputStream is = connection.getInputStream();
                                    Map response = BDecoder.decode(new BufferedInputStream(is));
                                    response = BDecoder.decodeStrings(response);
                                    Long code = (Long)response.get("code");
                                    if (code == null) {
                                        throw new Exception("Code missing from reply");
                                    }
                                    TestServiceImpl.this.error_message = (String)response.get("msg");
                                    if (code == 1L) {
                                        TestServiceImpl.this.outcome = 1;
                                        break block20;
                                    }
                                    if (code == 2L) {
                                        TestServiceImpl.this.outcome = 4;
                                        break block20;
                                    }
                                    if (code == 3L) {
                                        TestServiceImpl.this.outcome = 5;
                                        break block20;
                                    }
                                    if (code == 4L) {
                                        TestServiceImpl.this.outcome = 2;
                                        TestServiceImpl.this.error_message = "Connect timeout";
                                        break block20;
                                    }
                                    if (code == 5L) {
                                        TestServiceImpl.this.outcome = 2;
                                        break block20;
                                    }
                                    TestServiceImpl.this.outcome = 5;
                                    TestServiceImpl.this.error_message = "Unknown response code " + code;
                                }
                                catch (SocketTimeoutException e) {
                                    TestServiceImpl.this.outcome = 3;
                                    TestServiceImpl.this.error_message = "Connect timeout";
                                }
                            }
                            catch (Throwable e) {
                                TestServiceImpl.this.outcome = 3;
                                TestServiceImpl.this.error_message = Debug.getNestedExceptionMessage(e);
                                Object var12_8 = null;
                                TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_9 = null;
                            TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                            throw throwable;
                        }
                    }
                    Object var12_7 = null;
                    TestServiceImpl.this.listener.testComplete(TestServiceImpl.this);
                }
            }.start();
        }

        public int getOutcome() {
            return this.outcome;
        }

        public String getErrorMessage() {
            return this.error_message;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

