/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.neuronal;

import com.aelitis.azureus.core.neuronal.ActivationFunction;
import com.aelitis.azureus.core.neuronal.NeuralNetworkLayer;

public class NeuralNetwork {
    NeuralNetworkLayer inputLayer;
    NeuralNetworkLayer hiddenLayer;
    NeuralNetworkLayer outputLayer;

    public NeuralNetwork(int nbInputNodes, int nbHiddenNodes, int nbOutputNodes) {
        this.inputLayer = new NeuralNetworkLayer(nbInputNodes);
        this.hiddenLayer = new NeuralNetworkLayer(nbHiddenNodes);
        this.outputLayer = new NeuralNetworkLayer(nbOutputNodes);
        this.inputLayer.initialize(null, this.hiddenLayer);
        this.inputLayer.randomizeWeights();
        this.hiddenLayer.initialize(this.inputLayer, this.outputLayer);
        this.hiddenLayer.randomizeWeights();
        this.outputLayer.initialize(this.hiddenLayer, null);
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.inputLayer.setActivationFunction(activationFunction);
        this.hiddenLayer.setActivationFunction(activationFunction);
        this.outputLayer.setActivationFunction(activationFunction);
    }

    public void setInput(int i, double value) {
        if (i >= 0 && i < this.inputLayer.getNumberOfNodes()) {
            this.inputLayer.neuronValues[i] = value;
        }
    }

    public double getOutput(int i) {
        if (i >= 0 && i < this.outputLayer.getNumberOfNodes()) {
            return this.outputLayer.neuronValues[i];
        }
        return Double.NaN;
    }

    public void setDesiredOutput(int i, double value) {
        if (i >= 0 && i < this.outputLayer.getNumberOfNodes()) {
            this.outputLayer.desiredValues[i] = value;
        }
    }

    public void setMomentum(boolean useMomentum, double factor) {
        this.inputLayer.setMomentum(useMomentum, factor);
        this.hiddenLayer.setMomentum(useMomentum, factor);
        this.outputLayer.setMomentum(useMomentum, factor);
    }

    public void setLearningRate(double rate) {
        this.inputLayer.setLearningRate(rate);
        this.hiddenLayer.setLearningRate(rate);
        this.outputLayer.setLearningRate(rate);
    }

    public void feedForward() {
        this.inputLayer.calculateNeuronValues();
        this.hiddenLayer.calculateNeuronValues();
        this.outputLayer.calculateNeuronValues();
    }

    public void backPropagate() {
        this.outputLayer.calculateErrors();
        this.hiddenLayer.calculateErrors();
        this.hiddenLayer.adjustWeights();
        this.inputLayer.adjustWeights();
    }

    public double calculateError() {
        double error = 0.0;
        for (int i = 0; i < this.outputLayer.numberOfNodes; ++i) {
            error += Math.pow(this.outputLayer.neuronValues[i] - this.outputLayer.desiredValues[i], 2.0);
        }
        return error /= (double)this.outputLayer.numberOfNodes;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Input Layer :\n");
        sb.append(this.inputLayer.toString());
        sb.append("\n\n");
        sb.append("Hidden Layer :\n");
        sb.append(this.hiddenLayer.toString());
        sb.append("\n\n");
        return sb.toString();
    }
}

