/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.VirtualServerChannelSelector;
import com.aelitis.azureus.core.networkmanager.impl.tcp.VirtualAcceptSelector;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;

public class VirtualNonBlockingServerChannelSelector
implements VirtualServerChannelSelector {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private List server_channels = new ArrayList();
    private final InetAddress bind_address;
    private int start_port;
    private int num_ports;
    private final int receive_buffer_size;
    private final VirtualServerChannelSelector.SelectListener listener;
    protected AEMonitor this_mon = new AEMonitor("VirtualNonBlockingServerChannelSelector");
    private long last_accept_time;

    public VirtualNonBlockingServerChannelSelector(InetSocketAddress bind_address, int so_rcvbuf_size, VirtualServerChannelSelector.SelectListener listener) {
        this(bind_address.getAddress(), bind_address.getPort(), 1, so_rcvbuf_size, listener);
    }

    public VirtualNonBlockingServerChannelSelector(InetAddress _bind_address, int _start_port, int _num_ports, int _so_rcvbuf_size, VirtualServerChannelSelector.SelectListener _listener) {
        this.bind_address = _bind_address;
        this.start_port = _start_port;
        this.num_ports = _num_ports;
        this.receive_buffer_size = _so_rcvbuf_size;
        this.listener = _listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            this.this_mon.enter();
            if (!this.isRunning()) {
                for (int i = this.start_port; i < this.start_port + this.num_ports; ++i) {
                    try {
                        final ServerSocketChannel server_channel = ServerSocketChannel.open();
                        this.server_channels.add(server_channel);
                        server_channel.socket().setReuseAddress(true);
                        if (this.receive_buffer_size > 0) {
                            server_channel.socket().setReceiveBufferSize(this.receive_buffer_size);
                        }
                        server_channel.socket().bind(new InetSocketAddress(this.bind_address, i), 1024);
                        if (Logger.isEnabled()) {
                            Logger.log(new LogEvent(LOGID, "TCP incoming server socket " + this.bind_address));
                        }
                        server_channel.configureBlocking(false);
                        VirtualAcceptSelector.getSingleton().register(server_channel, new VirtualAcceptSelector.AcceptListener(){

                            public void newConnectionAccepted(SocketChannel channel2) {
                                VirtualNonBlockingServerChannelSelector.this.last_accept_time = SystemTime.getCurrentTime();
                                VirtualNonBlockingServerChannelSelector.this.listener.newConnectionAccepted(server_channel, channel2);
                            }
                        });
                        continue;
                    }
                    catch (Throwable t) {
                        Debug.out(t);
                        Logger.log(new LogAlert(false, "ERROR, unable to bind TCP incoming server socket to " + i, t));
                    }
                }
                this.last_accept_time = SystemTime.getCurrentTime();
            }
            Object var4_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            this.this_mon.enter();
            for (int i = 0; i < this.server_channels.size(); ++i) {
                try {
                    ServerSocketChannel server_channel = (ServerSocketChannel)this.server_channels.get(i);
                    VirtualAcceptSelector.getSingleton().cancel(server_channel);
                    server_channel.close();
                    continue;
                }
                catch (Throwable t) {
                    Debug.out(t);
                }
            }
            this.server_channels.clear();
            Object var4_4 = null;
            this.this_mon.exit();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.this_mon.exit();
            throw throwable;
        }
    }

    public boolean isRunning() {
        if (this.server_channels.size() == 0) {
            return false;
        }
        ServerSocketChannel server_channel = (ServerSocketChannel)this.server_channels.get(0);
        return server_channel != null && server_channel.isOpen();
    }

    public InetAddress getBoundToAddress() {
        if (this.server_channels.size() == 0) {
            return null;
        }
        ServerSocketChannel server_channel = (ServerSocketChannel)this.server_channels.get(0);
        return server_channel.socket().getInetAddress();
    }

    public long getTimeOfLastAccept() {
        return this.last_accept_time;
    }
}

