/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl.tcp;

import com.aelitis.azureus.core.networkmanager.ConnectionEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpoint;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointFactory;
import com.aelitis.azureus.core.networkmanager.ProtocolEndpointHandler;
import com.aelitis.azureus.core.networkmanager.Transport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.LightweightTCPTransport;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportHelperFilterFactory;
import com.aelitis.azureus.core.networkmanager.impl.tcp.TCPTransportImpl;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import org.gudy.azureus2.core3.util.AddressUtils;

public class ProtocolEndpointTCP
implements ProtocolEndpoint {
    private ConnectionEndpoint ce;
    private InetSocketAddress address;

    public static void register() {
        ProtocolEndpointFactory.registerHandler(new ProtocolEndpointHandler(){

            public int getType() {
                return 1;
            }

            public ProtocolEndpoint create(InetSocketAddress address) {
                return new ProtocolEndpointTCP(address);
            }

            public ProtocolEndpoint create(ConnectionEndpoint connection_endpoint, InetSocketAddress address) {
                return new ProtocolEndpointTCP(connection_endpoint, address);
            }
        });
    }

    private ProtocolEndpointTCP(ConnectionEndpoint _ce, InetSocketAddress _address) {
        this.ce = _ce;
        this.address = _address;
        this.ce.addProtocol(this);
    }

    private ProtocolEndpointTCP(InetSocketAddress _address) {
        this.ce = new ConnectionEndpoint(_address);
        this.address = _address;
        this.ce.addProtocol(this);
    }

    public void setConnectionEndpoint(ConnectionEndpoint _ce) {
        this.ce = _ce;
        this.ce.addProtocol(this);
    }

    public int getType() {
        return 1;
    }

    public ConnectionEndpoint getConnectionEndpoint() {
        return this.ce;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public InetSocketAddress getAdjustedAddress(boolean to_lan) {
        return AddressUtils.adjustTCPAddress(this.address, to_lan);
    }

    public Transport connectOutbound(boolean connect_with_crypto, boolean allow_fallback, byte[][] shared_secrets, ByteBuffer initial_data, int priority, Transport.ConnectListener listener) {
        TCPTransportImpl t = new TCPTransportImpl(this, connect_with_crypto, allow_fallback, shared_secrets);
        t.connectOutbound(initial_data, listener, priority);
        return t;
    }

    public Transport connectLightWeight(SocketChannel sc) {
        return new LightweightTCPTransport(this, TCPTransportHelperFilterFactory.createTransparentFilter(sc));
    }

    public String getDescription() {
        return this.address.toString();
    }
}

