/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.EventWaiter;
import com.aelitis.azureus.core.networkmanager.NetworkConnectionBase;
import com.aelitis.azureus.core.networkmanager.RateHandler;
import com.aelitis.azureus.core.networkmanager.impl.RateControlledEntity;
import java.io.IOException;
import org.gudy.azureus2.core3.util.Debug;

public class SinglePeerDownloader
implements RateControlledEntity {
    private final NetworkConnectionBase connection;
    private final RateHandler rate_handler;

    public SinglePeerDownloader(NetworkConnectionBase connection, RateHandler rate_handler) {
        this.connection = connection;
        this.rate_handler = rate_handler;
    }

    public RateHandler getRateHandler() {
        return this.rate_handler;
    }

    public boolean canProcess(EventWaiter waiter) {
        if (this.connection.getTransportBase().isReadyForRead(waiter) != 0L) {
            return false;
        }
        return this.rate_handler.getCurrentNumBytesAllowed() >= 1;
    }

    public int doProcessing(EventWaiter waiter, int max_bytes) {
        if (this.connection.getTransportBase().isReadyForRead(waiter) != 0L) {
            return 0;
        }
        int num_bytes_allowed = this.rate_handler.getCurrentNumBytesAllowed();
        if (num_bytes_allowed < 1) {
            return 0;
        }
        if (max_bytes > 0 && max_bytes < num_bytes_allowed) {
            num_bytes_allowed = max_bytes;
        }
        int bytes_read = 0;
        try {
            bytes_read = this.connection.getIncomingMessageQueue().receiveFromTransport(num_bytes_allowed);
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) {
                Debug.printStackTrace(e);
            }
            this.connection.notifyOfException(e);
            return 0;
        }
        if (bytes_read < 1) {
            return 0;
        }
        this.rate_handler.bytesProcessed(bytes_read);
        return bytes_read;
    }

    public int getPriority() {
        return 0;
    }

    public boolean getPriorityBoost() {
        return false;
    }

    public long getBytesReadyToWrite() {
        return 0L;
    }

    public int getConnectionCount() {
        return 1;
    }

    public int getReadyConnectionCount(EventWaiter waiter) {
        if (this.connection.getTransportBase().isReadyForRead(waiter) == 0L) {
            return 1;
        }
        return 0;
    }

    public String getString() {
        return "SPD: " + this.connection.getString();
    }
}

