/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.impl;

import com.aelitis.azureus.core.networkmanager.NetworkManager;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoder;
import com.aelitis.azureus.core.networkmanager.impl.ProtocolDecoderAdapter;
import com.aelitis.azureus.core.networkmanager.impl.TransportCipher;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelper;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterInserter;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStreamCipher;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterStreamXOR;
import com.aelitis.azureus.core.networkmanager.impl.TransportHelperFilterTransparent;
import com.aelitis.azureus.core.util.bloom.BloomFilter;
import com.aelitis.azureus.core.util.bloom.BloomFilterFactory;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Map;
import java.util.Random;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.LightHashMap;
import org.gudy.azureus2.core3.util.RandomUtils;
import org.gudy.azureus2.core3.util.SHA1Hasher;
import org.gudy.azureus2.core3.util.SystemTime;

public class ProtocolDecoderPHE
extends ProtocolDecoder {
    private static final LogIDs LOGID = LogIDs.NWMAN;
    private static final byte CRYPTO_PLAIN = 1;
    private static final byte CRYPTO_RC4 = 2;
    private static final byte CRYPTO_XOR = 4;
    private static final byte CRYPTO_AES = 8;
    private static final String DH_P = "FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A63A36210000000000090563";
    private static final String DH_G = "02";
    private static final int DH_L = 160;
    private static final int DH_SIZE_BYTES;
    public static final int MIN_INCOMING_INITIAL_PACKET_SIZE;
    private static final BigInteger DH_P_BI;
    private static final BigInteger DH_G_BI;
    private static KeyPairGenerator dh_key_generator;
    private static long last_dh_incoming_key_generate;
    private static final int BLOOM_RECREATE = 30000;
    private static final int BLOOM_INCREASE = 1000;
    private static BloomFilter generate_bloom;
    private static long generate_bloom_create_time;
    private static boolean crypto_setup_done;
    private static boolean crypto_ok;
    private static final String RC4_STREAM_ALG = "RC4";
    private static final String RC4_STREAM_CIPHER = "RC4";
    private static final int RC4_STREAM_KEY_SIZE = 128;
    private static final int RC4_STREAM_KEY_SIZE_BYTES = 16;
    private static final int PADDING_MAX = 512;
    private static final int PADDING_MAX_NORMAL = 512;
    private static final int PADDING_MAX_LIMITED = 128;
    private static Random random;
    private static Map global_shared_secrets;
    private static final byte SUPPORTED_PROTOCOLS = 3;
    private static byte MIN_CRYPTO;
    private static final int PS_OUTBOUND_1 = 0;
    private static final int PS_OUTBOUND_2 = 1;
    private static final int PS_OUTBOUND_3 = 2;
    private static final int PS_OUTBOUND_4 = 3;
    private static final int PS_INBOUND_1 = 10;
    private static final int PS_INBOUND_2 = 11;
    private static final int PS_INBOUND_3 = 12;
    private static final int PS_INBOUND_4 = 13;
    public static final byte[] KEYA_IV;
    public static final byte[] KEYB_IV;
    public static final byte[] REQ1_IV;
    public static final byte[] REQ2_IV;
    public static final byte[] REQ3_IV;
    public static final byte[] VC;
    private TransportHelper transport;
    private ByteBuffer write_buffer;
    private ByteBuffer read_buffer;
    private ProtocolDecoderAdapter adapter;
    private KeyAgreement key_agreement;
    private byte[] dh_public_key_bytes;
    private byte[] shared_secret;
    private byte[] secret_bytes;
    private ByteBuffer initial_data_out;
    private ByteBuffer initial_data_in;
    private TransportCipher write_cipher;
    private TransportCipher read_cipher;
    private byte[] padding_skip_marker;
    private byte my_supported_protocols;
    private byte selected_protocol;
    private boolean outbound;
    private int protocol_state;
    private int protocol_substate;
    private boolean handshake_complete;
    private int bytes_read;
    private int bytes_written;
    private long last_read_time = SystemTime.getCurrentTime();
    private TransportHelperFilter filter;
    private boolean delay_outbound_4;
    private boolean processing_complete;
    private AEMonitor process_mon = new AEMonitor("ProtocolDecoderPHE:process");

    public static int getMaxIncomingInitialPacketSize(boolean min_overheads) {
        return MIN_INCOMING_INITIAL_PACKET_SIZE + (min_overheads ? 128 : 512) / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cryptoSetup() {
        Map map = global_shared_secrets;
        synchronized (map) {
            if (crypto_setup_done) {
                return;
            }
            crypto_setup_done = true;
            try {
                DHParameterSpec dh_param_spec = new DHParameterSpec(DH_P_BI, DH_G_BI, 160);
                dh_key_generator = KeyPairGenerator.getInstance("DH");
                dh_key_generator.initialize(dh_param_spec);
                dh_key_generator.generateKeyPair();
                byte[] rc4_test_secret = new byte[16];
                SecretKeySpec rc4_test_secret_key_spec = new SecretKeySpec(rc4_test_secret, 0, 16, "RC4");
                TransportCipher rc4_cipher = new TransportCipher("RC4", 1, rc4_test_secret_key_spec);
                rc4_cipher = new TransportCipher("RC4", 2, rc4_test_secret_key_spec);
                crypto_ok = true;
                if (Logger.isEnabled()) {
                    Logger.log(new LogEvent(LOGID, "PHE crypto initialised"));
                }
            }
            catch (NoClassDefFoundError e) {
                Logger.log(new LogEvent(LOGID, "PHE crypto disabled as classes unavailable"));
                crypto_ok = false;
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "PHE crypto initialisation failed", e));
                crypto_ok = false;
            }
        }
    }

    public static boolean isCryptoOK() {
        ProtocolDecoderPHE.cryptoSetup();
        return crypto_ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSecretsSupport(byte[][] secrets) {
        for (int i = 0; i < secrets.length; ++i) {
            SHA1Hasher hasher = new SHA1Hasher();
            hasher.update(REQ2_IV);
            hasher.update(secrets[i]);
            byte[] encoded = hasher.getDigest();
            Map map = global_shared_secrets;
            synchronized (map) {
                global_shared_secrets.put(new HashWrapper(encoded), secrets[i]);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSecretsSupport(byte[][] secrets) {
        for (int i = 0; i < secrets.length; ++i) {
            SHA1Hasher hasher = new SHA1Hasher();
            hasher.update(REQ2_IV);
            hasher.update(secrets[i]);
            byte[] encoded = hasher.getDigest();
            Map map = global_shared_secrets;
            synchronized (map) {
                global_shared_secrets.remove(new HashWrapper(encoded));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolDecoderPHE(TransportHelper _transport, byte[][] _shared_secrets, ByteBuffer _header, ByteBuffer _initial_data, ProtocolDecoderAdapter _adapter) throws IOException {
        super(false);
        if (!ProtocolDecoderPHE.isCryptoOK()) {
            throw new IOException("PHE crypto broken");
        }
        this.transport = _transport;
        this.transport.setScatteringMode(768 + random.nextInt(256));
        this.initial_data_out = _initial_data;
        this.adapter = _adapter;
        this.shared_secret = _shared_secrets == null || _shared_secrets.length == 0 ? new byte[0] : (_shared_secrets.length == 1 ? _shared_secrets[0] : _shared_secrets[random.nextInt(_shared_secrets.length)]);
        this.outbound = _header == null;
        this.my_supported_protocols = (byte)3;
        if (this.outbound) {
            this.my_supported_protocols = MIN_CRYPTO;
        } else if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE) {
            this.my_supported_protocols = MIN_CRYPTO;
        }
        this.initCrypto();
        try {
            this.process_mon.enter();
            this.transport.registerForReadSelects(new TransportHelper.selectListener(){

                public boolean selectSuccess(TransportHelper helper, Object attachment) {
                    return ProtocolDecoderPHE.this.selectSuccess(helper, attachment, false);
                }

                public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                    ProtocolDecoderPHE.this.selectFailure(helper, attachment, msg);
                }
            }, null);
            this.transport.registerForWriteSelects(new TransportHelper.selectListener(){

                public boolean selectSuccess(TransportHelper helper, Object attachment) {
                    return ProtocolDecoderPHE.this.selectSuccess(helper, attachment, true);
                }

                public void selectFailure(TransportHelper helper, Object attachment, Throwable msg) {
                    ProtocolDecoderPHE.this.selectFailure(helper, attachment, msg);
                }
            }, null);
            this.transport.pauseWriteSelects();
            if (this.outbound) {
                this.protocol_state = 0;
                this.transport.pauseReadSelects();
            } else {
                this.protocol_state = 10;
                this.read_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length);
                this.read_buffer.put(_header);
                this.bytes_read += _header.limit();
            }
            Object var7_6 = null;
            this.process_mon.exit();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.process_mon.exit();
            throw throwable;
        }
        this.process();
    }

    protected void initCrypto() throws IOException {
        try {
            KeyPair key_pair = ProtocolDecoderPHE.generateDHKeyPair(this.transport, this.outbound);
            this.key_agreement = KeyAgreement.getInstance("DH");
            this.key_agreement.init(key_pair.getPrivate());
            DHPublicKey dh_public_key = (DHPublicKey)key_pair.getPublic();
            BigInteger dh_y = dh_public_key.getY();
            this.dh_public_key_bytes = this.bigIntegerToBytes(dh_y, DH_SIZE_BYTES);
        }
        catch (Throwable e) {
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
    }

    protected void completeDH(byte[] buffer) throws IOException {
        try {
            BigInteger other_dh_y = this.bytesToBigInteger(buffer, 0, DH_SIZE_BYTES);
            KeyFactory dh_key_factory = KeyFactory.getInstance("DH");
            PublicKey other_public_key = dh_key_factory.generatePublic(new DHPublicKeySpec(other_dh_y, DH_P_BI, DH_G_BI));
            this.key_agreement.doPhase(other_public_key, true);
            this.secret_bytes = this.key_agreement.generateSecret();
            this.adapter.gotSecret(this.secret_bytes);
        }
        catch (Throwable e) {
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
    }

    protected void setupCrypto() throws IOException {
        try {
            SHA1Hasher hasher = new SHA1Hasher();
            hasher.update(KEYA_IV);
            hasher.update(this.secret_bytes);
            hasher.update(this.shared_secret);
            byte[] a_key = hasher.getDigest();
            hasher = new SHA1Hasher();
            hasher.update(KEYB_IV);
            hasher.update(this.secret_bytes);
            hasher.update(this.shared_secret);
            byte[] b_key = hasher.getDigest();
            SecretKeySpec secret_key_spec_a = new SecretKeySpec(a_key, "RC4");
            SecretKeySpec secret_key_spec_b = new SecretKeySpec(b_key, "RC4");
            this.write_cipher = new TransportCipher("RC4", 1, this.outbound ? secret_key_spec_a : secret_key_spec_b);
            this.read_cipher = new TransportCipher("RC4", 2, this.outbound ? secret_key_spec_b : secret_key_spec_a);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IOException(Debug.getNestedExceptionMessage(e));
        }
    }

    protected void handshakeComplete() throws IOException {
        if (this.selected_protocol == 1) {
            this.filter = new TransportHelperFilterTransparent(this.transport, true);
        } else if (this.selected_protocol == 4) {
            this.filter = new TransportHelperFilterStreamXOR(this.transport, this.secret_bytes);
        } else if (this.selected_protocol == 2) {
            this.filter = new TransportHelperFilterStreamCipher(this.transport, this.read_cipher, this.write_cipher);
        } else {
            throw new IOException("Invalid selected protocol '" + this.selected_protocol + "'");
        }
        if (this.initial_data_in != null) {
            this.filter = new TransportHelperFilterInserter(this.filter, this.initial_data_in);
        }
        this.handshake_complete = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() throws IOException {
        try {
            try {
                this.process_mon.enter();
                if (this.handshake_complete) {
                    Debug.out("Handshake process already completed");
                    Object var13_1 = null;
                    this.process_mon.exit();
                    return;
                }
                boolean loop = true;
                while (loop) {
                    block76: {
                        if (this.protocol_state == 0) {
                            if (this.write_buffer == null) {
                                byte[] padding_a = ProtocolDecoderPHE.getRandomPadding(this.getPaddingMax() / 2);
                                this.write_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length + padding_a.length);
                                this.write_buffer.put(this.dh_public_key_bytes);
                                this.write_buffer.put(padding_a);
                                this.write_buffer.flip();
                            }
                            this.write(this.write_buffer);
                            if (!this.write_buffer.hasRemaining()) {
                                this.write_buffer = null;
                                this.protocol_state = 11;
                            }
                        } else if (this.protocol_state == 10) {
                            this.read(this.read_buffer);
                            if (!this.read_buffer.hasRemaining()) {
                                this.read_buffer.flip();
                                byte[] other_dh_public_key_bytes = new byte[this.read_buffer.remaining()];
                                this.read_buffer.get(other_dh_public_key_bytes);
                                this.completeDH(other_dh_public_key_bytes);
                                this.read_buffer = null;
                                this.protocol_state = 1;
                            }
                        } else if (this.protocol_state == 1) {
                            if (this.write_buffer == null) {
                                byte[] padding_b = ProtocolDecoderPHE.getRandomPadding(this.getPaddingMax() / 2);
                                this.write_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length + padding_b.length);
                                this.write_buffer.put(this.dh_public_key_bytes);
                                this.write_buffer.put(padding_b);
                                this.write_buffer.flip();
                            }
                            this.write(this.write_buffer);
                            if (!this.write_buffer.hasRemaining()) {
                                this.write_buffer = null;
                                this.protocol_state = 12;
                            }
                        } else if (this.protocol_state == 11) {
                            if (this.read_buffer == null) {
                                this.read_buffer = ByteBuffer.allocate(this.dh_public_key_bytes.length);
                            }
                            this.read(this.read_buffer);
                            if (!this.read_buffer.hasRemaining()) {
                                this.read_buffer.flip();
                                byte[] other_dh_public_key_bytes = new byte[this.read_buffer.remaining()];
                                this.read_buffer.get(other_dh_public_key_bytes);
                                this.completeDH(other_dh_public_key_bytes);
                                this.setupCrypto();
                                this.read_buffer = null;
                                this.protocol_state = 2;
                            }
                        } else if (this.protocol_state == 2) {
                            if (this.write_buffer == null) {
                                int initial_data_out_len = this.initial_data_out == null ? 0 : this.initial_data_out.remaining();
                                int pad_max = this.getPaddingMax();
                                byte[] padding_a = ProtocolDecoderPHE.getRandomPadding(pad_max / 2);
                                byte[] padding_c = ProtocolDecoderPHE.getZeroPadding(pad_max);
                                this.write_buffer = ByteBuffer.allocate(padding_a.length + 20 + 20 + (VC.length + 4 + 2 + padding_c.length + 2) + initial_data_out_len);
                                this.write_buffer.put(padding_a);
                                SHA1Hasher hasher = new SHA1Hasher();
                                hasher.update(REQ1_IV);
                                hasher.update(this.secret_bytes);
                                byte[] sha1 = hasher.getDigest();
                                this.write_buffer.put(sha1);
                                hasher = new SHA1Hasher();
                                hasher.update(REQ2_IV);
                                hasher.update(this.shared_secret);
                                byte[] sha1_1 = hasher.getDigest();
                                hasher = new SHA1Hasher();
                                hasher.update(REQ3_IV);
                                hasher.update(this.secret_bytes);
                                byte[] sha1_2 = hasher.getDigest();
                                for (int i = 0; i < sha1_1.length; ++i) {
                                    int n = i;
                                    sha1_1[n] = (byte)(sha1_1[n] ^ sha1_2[i]);
                                }
                                this.write_buffer.put(sha1_1);
                                this.write_buffer.put(this.write_cipher.update(VC));
                                this.write_buffer.put(this.write_cipher.update(new byte[]{0, 0, 0, this.my_supported_protocols}));
                                this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(padding_c.length >> 8), (byte)padding_c.length}));
                                this.write_buffer.put(this.write_cipher.update(padding_c));
                                this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(initial_data_out_len >> 8), (byte)initial_data_out_len}));
                                if (initial_data_out_len > 0) {
                                    int save_pos = this.initial_data_out.position();
                                    this.write_cipher.update(this.initial_data_out, this.write_buffer);
                                    this.initial_data_out.position(save_pos);
                                    this.initial_data_out = null;
                                }
                                this.write_buffer.flip();
                            }
                            this.write(this.write_buffer);
                            if (!this.write_buffer.hasRemaining()) {
                                this.write_buffer = null;
                                this.protocol_state = 13;
                            }
                        } else if (this.protocol_state == 12) {
                            if (this.read_buffer == null) {
                                this.read_buffer = ByteBuffer.allocate(532);
                                this.read_buffer.limit(20);
                                SHA1Hasher hasher = new SHA1Hasher();
                                hasher.update(REQ1_IV);
                                hasher.update(this.secret_bytes);
                                this.padding_skip_marker = hasher.getDigest();
                                this.protocol_substate = 1;
                            }
                            while (true) {
                                this.read(this.read_buffer);
                                if (this.read_buffer.hasRemaining()) break block76;
                                if (this.protocol_substate == 1) {
                                    int limit = this.read_buffer.limit();
                                    this.read_buffer.position(limit - 20);
                                    boolean match = true;
                                    for (int i = 0; i < 20; ++i) {
                                        if (this.read_buffer.get() == this.padding_skip_marker[i]) continue;
                                        match = false;
                                        break;
                                    }
                                    if (match) {
                                        this.read_buffer = ByteBuffer.allocate(20 + VC.length + 4 + 2);
                                        this.protocol_substate = 2;
                                        break block76;
                                    }
                                    if (limit == this.read_buffer.capacity()) {
                                        throw new IOException("PHE skip to SHA1 marker failed");
                                    }
                                    this.read_buffer.limit(limit + 1);
                                    this.read_buffer.position(limit);
                                    continue;
                                }
                                if (this.protocol_substate == 2) {
                                    this.read_buffer.flip();
                                    byte[] decode = new byte[20];
                                    this.read_buffer.get(decode);
                                    SHA1Hasher hasher = new SHA1Hasher();
                                    hasher.update(REQ3_IV);
                                    hasher.update(this.secret_bytes);
                                    byte[] sha1 = hasher.getDigest();
                                    for (int i = 0; i < decode.length; ++i) {
                                        int n = i;
                                        decode[n] = (byte)(decode[n] ^ sha1[i]);
                                    }
                                    Map i = global_shared_secrets;
                                    synchronized (i) {
                                        this.shared_secret = (byte[])global_shared_secrets.get(new HashWrapper(decode));
                                    }
                                    if (this.shared_secret == null) {
                                        throw new IOException("No matching shared secret");
                                    }
                                    this.setupCrypto();
                                    byte[] crypted = new byte[VC.length + 4 + 2];
                                    this.read_buffer.get(crypted);
                                    byte[] plain = this.read_cipher.update(crypted);
                                    byte other_supported_protocols = plain[VC.length + 3];
                                    int common_protocols = this.my_supported_protocols & other_supported_protocols;
                                    if ((common_protocols & 1) != 0) {
                                        this.selected_protocol = 1;
                                    } else if ((common_protocols & 4) != 0) {
                                        this.selected_protocol = (byte)4;
                                    } else if ((common_protocols & 2) != 0) {
                                        this.selected_protocol = (byte)2;
                                    } else if ((common_protocols & 8) != 0) {
                                        this.selected_protocol = (byte)8;
                                    } else {
                                        throw new IOException("No crypto protocol in common: mine = " + Integer.toHexString(this.my_supported_protocols) + ", theirs = " + Integer.toHexString(other_supported_protocols));
                                    }
                                    int padding = ((plain[VC.length + 4] & 0xFF) << 8) + (plain[VC.length + 5] & 0xFF);
                                    if (padding > 512) {
                                        throw new IOException("Invalid padding '" + padding + "'");
                                    }
                                    this.read_buffer = ByteBuffer.allocate(padding + 2);
                                    this.protocol_substate = 3;
                                    continue;
                                }
                                if (this.protocol_substate == 3) {
                                    this.read_buffer.flip();
                                    byte[] data = new byte[this.read_buffer.remaining()];
                                    this.read_buffer.get(data);
                                    data = this.read_cipher.update(data);
                                    int ia_len = 0xFFFF & ((data[data.length - 2] & 0xFF) << 8) + (data[data.length - 1] & 0xFF);
                                    if (ia_len > 65535) {
                                        throw new IOException("Invalid IA length '" + ia_len + "'");
                                    }
                                    if (ia_len > 0) {
                                        this.read_buffer = ByteBuffer.allocate(ia_len);
                                        this.protocol_substate = 4;
                                        continue;
                                    }
                                    this.read_buffer = null;
                                    this.protocol_state = 3;
                                    break block76;
                                }
                                if (this.protocol_substate == 4) break;
                            }
                            this.read_buffer.flip();
                            byte[] data = new byte[this.read_buffer.remaining()];
                            this.read_buffer.get(data);
                            data = this.read_cipher.update(data);
                            this.delay_outbound_4 = new String(data).indexOf("BitTorrent") != -1;
                            this.initial_data_in = ByteBuffer.wrap(data);
                            this.read_buffer = null;
                            this.protocol_state = 3;
                        } else if (this.protocol_state == 3) {
                            if (this.write_buffer == null) {
                                int pad_max = this.getPaddingMax();
                                byte[] padding_b = ProtocolDecoderPHE.getRandomPadding(pad_max / 2);
                                byte[] padding_d = ProtocolDecoderPHE.getZeroPadding(pad_max);
                                this.write_buffer = ByteBuffer.allocate(padding_b.length + VC.length + 4 + 2 + padding_d.length);
                                this.write_buffer.put(padding_b);
                                this.write_buffer.put(this.write_cipher.update(VC));
                                this.write_buffer.put(this.write_cipher.update(new byte[]{0, 0, 0, this.selected_protocol}));
                                this.write_buffer.put(this.write_cipher.update(new byte[]{(byte)(padding_d.length >> 8), (byte)padding_d.length}));
                                this.write_buffer.put(this.write_cipher.update(padding_d));
                                this.write_buffer.flip();
                            }
                            if (this.delay_outbound_4) {
                                if (this.transport.delayWrite(this.write_buffer)) {
                                    this.write_buffer = null;
                                    this.handshakeComplete();
                                } else {
                                    this.delay_outbound_4 = false;
                                }
                            }
                            if (!this.delay_outbound_4) {
                                this.write(this.write_buffer);
                                if (!this.write_buffer.hasRemaining()) {
                                    this.write_buffer = null;
                                    this.handshakeComplete();
                                }
                            }
                        } else if (this.protocol_state == 13) {
                            if (this.read_buffer == null) {
                                this.read_buffer = ByteBuffer.allocate(VC.length + 512);
                                this.read_buffer.limit(VC.length);
                                this.padding_skip_marker = new byte[VC.length];
                                this.padding_skip_marker = this.read_cipher.update(this.padding_skip_marker);
                                this.protocol_substate = 1;
                            }
                            while (true) {
                                this.read(this.read_buffer);
                                if (this.read_buffer.hasRemaining()) break block76;
                                if (this.protocol_substate == 1) {
                                    int limit = this.read_buffer.limit();
                                    this.read_buffer.position(limit - VC.length);
                                    boolean match = true;
                                    for (int i = 0; i < VC.length; ++i) {
                                        if (this.read_buffer.get() == this.padding_skip_marker[i]) continue;
                                        match = false;
                                        break;
                                    }
                                    if (match) {
                                        this.read_buffer = ByteBuffer.allocate(6);
                                        this.protocol_substate = 2;
                                        break block76;
                                    }
                                    if (limit == this.read_buffer.capacity()) {
                                        throw new IOException("PHE skip to SHA1 marker failed");
                                    }
                                    this.read_buffer.limit(limit + 1);
                                    this.read_buffer.position(limit);
                                    continue;
                                }
                                if (this.protocol_substate == 2) {
                                    this.read_buffer.flip();
                                    byte[] crypted = new byte[6];
                                    this.read_buffer.get(crypted);
                                    byte[] plain = this.read_cipher.update(crypted);
                                    this.selected_protocol = plain[3];
                                    if ((this.selected_protocol & this.my_supported_protocols) == 0) {
                                        throw new IOException("Selected protocol has nothing in common: mine = " + Integer.toHexString(this.my_supported_protocols) + ", theirs = " + Integer.toHexString(this.selected_protocol));
                                    }
                                    int pad_len = 0xFFFF & ((plain[4] & 0xFF) << 8) + (plain[5] & 0xFF);
                                    if (pad_len > 65535) {
                                        throw new IOException("Invalid pad length '" + pad_len + "'");
                                    }
                                    this.read_buffer = ByteBuffer.allocate(pad_len);
                                    this.protocol_substate = 3;
                                    continue;
                                }
                                if (this.protocol_substate == 3) break;
                            }
                            this.read_buffer.flip();
                            byte[] data = new byte[this.read_buffer.remaining()];
                            this.read_buffer.get(data);
                            data = this.read_cipher.update(data);
                            this.handshakeComplete();
                            this.read_buffer = null;
                        }
                    }
                    if (this.handshake_complete) {
                        this.transport.cancelReadSelects();
                        this.transport.cancelWriteSelects();
                        loop = false;
                        this.complete();
                        continue;
                    }
                    if (this.read_buffer == null) {
                        this.transport.pauseReadSelects();
                    } else {
                        this.transport.resumeReadSelects();
                        loop = false;
                    }
                    if (this.write_buffer == null) {
                        this.transport.pauseWriteSelects();
                        continue;
                    }
                    this.transport.resumeWriteSelects();
                    loop = false;
                }
            }
            catch (Throwable e) {
                this.failed(e);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(Debug.getNestedExceptionMessage(e));
            }
        }
        catch (Throwable throwable) {
            Object var13_3 = null;
            this.process_mon.exit();
            throw throwable;
        }
        Object var13_2 = null;
        this.process_mon.exit();
    }

    protected void read(ByteBuffer buffer) throws IOException {
        int len = this.transport.read(buffer);
        if (len < 0) {
            throw new IOException("end of stream on socket read - phe: " + this.getString());
        }
        this.bytes_read += len;
    }

    protected void write(ByteBuffer buffer) throws IOException {
        int len = this.transport.write(buffer, false);
        if (len < 0) {
            throw new IOException("bytes written < 0 ");
        }
        this.bytes_written += len;
    }

    public boolean selectSuccess(TransportHelper transport, Object attachment, boolean write_operation) {
        try {
            boolean progress;
            int old_bytes_read = this.bytes_read;
            int old_bytes_written = this.bytes_written;
            this.process();
            if (write_operation) {
                return this.bytes_written != old_bytes_written;
            }
            boolean bl = progress = this.bytes_read != old_bytes_read;
            if (progress) {
                this.last_read_time = SystemTime.getCurrentTime();
            }
            return progress;
        }
        catch (Throwable e) {
            this.failed(e);
            return false;
        }
    }

    public void selectFailure(TransportHelper transport, Object attachment, Throwable msg) {
        this.failed(msg);
    }

    protected byte[] bigIntegerToBytes(BigInteger bi, int num_bytes) {
        String str = bi.toString(16);
        while (str.length() < num_bytes * 2) {
            str = "0" + str;
        }
        return ByteFormatter.decodeString(str);
    }

    protected BigInteger bytesToBigInteger(byte[] bytes, int offset, int len) {
        return new BigInteger(ByteFormatter.encodeString(bytes, offset, len), 16);
    }

    protected int getPaddingMax() {
        if (this.transport.minimiseOverheads()) {
            return 128;
        }
        return 512;
    }

    protected static synchronized byte[] getRandomPadding(int max_len) {
        byte[] bytes = new byte[random.nextInt(max_len)];
        random.nextBytes(bytes);
        return bytes;
    }

    protected static synchronized byte[] getZeroPadding(int max_len) {
        byte[] bytes = new byte[random.nextInt(max_len)];
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static KeyPair generateDHKeyPair(TransportHelper transport, boolean outbound) throws IOException {
        if (dh_key_generator == null) {
            throw new IOException("Crypto not setup");
        }
        KeyPairGenerator keyPairGenerator = dh_key_generator;
        synchronized (keyPairGenerator) {
            if (!outbound) {
                byte[] address = transport.getAddress().getAddress().getAddress();
                int hit_count = generate_bloom.add(address);
                long now = SystemTime.getCurrentTime();
                if (generate_bloom.getSize() / generate_bloom.getEntryCount() < 10) {
                    generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize() + 1000);
                    generate_bloom_create_time = now;
                    Logger.log(new LogEvent(LOGID, "PHE bloom: size increased to " + generate_bloom.getSize()));
                } else if (now < generate_bloom_create_time || now - generate_bloom_create_time > 30000L) {
                    generate_bloom = BloomFilterFactory.createAddRemove4Bit(generate_bloom.getSize());
                    generate_bloom_create_time = now;
                }
                if (hit_count >= 15) {
                    Logger.log(new LogEvent(LOGID, "PHE bloom: too many recent connection attempts from " + transport.getAddress()));
                    throw new IOException("Too many recent connection attempts (phe)");
                }
                long since_last = now - last_dh_incoming_key_generate;
                long delay = 100L - since_last;
                if (delay > 0L && delay < 100L) {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                last_dh_incoming_key_generate = now;
            }
            KeyPair res = dh_key_generator.generateKeyPair();
            return res;
        }
    }

    protected void complete() {
        this.processing_complete = true;
        this.transport.setScatteringMode(0L);
        this.adapter.decodeComplete(this, this.initial_data_out);
    }

    protected void failed(Throwable cause) {
        this.processing_complete = true;
        this.transport.cancelReadSelects();
        this.transport.cancelWriteSelects();
        this.adapter.decodeFailed(this, cause);
    }

    public boolean isComplete(long now) {
        return this.processing_complete;
    }

    public TransportHelperFilter getFilter() {
        return this.filter;
    }

    public long getLastReadTime() {
        long now = SystemTime.getCurrentTime();
        if (this.last_read_time > now) {
            this.last_read_time = now;
        }
        return this.last_read_time;
    }

    public String getString() {
        return "state=" + this.protocol_state + ",sub=" + this.protocol_substate + ",in=" + this.bytes_read + ",out=" + this.bytes_written;
    }

    static {
        MIN_INCOMING_INITIAL_PACKET_SIZE = DH_SIZE_BYTES = DH_P.length() / 2;
        DH_P_BI = new BigInteger(DH_P, 16);
        DH_G_BI = new BigInteger(DH_G, 16);
        generate_bloom = BloomFilterFactory.createAddRemove4Bit(1000);
        generate_bloom_create_time = SystemTime.getCurrentTime();
        random = RandomUtils.SECURE_RANDOM;
        global_shared_secrets = new LightHashMap();
        COConfigurationManager.addAndFireParameterListeners(new String[]{"network.transport.encrypted.min_level"}, new ParameterListener(){

            public void parameterChanged(String ignore) {
                String min;
                if (NetworkManager.REQUIRE_CRYPTO_HANDSHAKE && !ProtocolDecoderPHE.isCryptoOK()) {
                    Logger.log(new LogAlert(true, 3, "Connection encryption unavailable, please update your Java version"));
                }
                if ((min = COConfigurationManager.getStringParameter("network.transport.encrypted.min_level")).equals("XOR")) {
                    MIN_CRYPTO = (byte)14;
                } else if (min.equals("RC4")) {
                    MIN_CRYPTO = (byte)10;
                } else if (min.equals("AES")) {
                    MIN_CRYPTO = (byte)8;
                } else {
                    MIN_CRYPTO = (byte)15;
                }
                MIN_CRYPTO = (byte)(MIN_CRYPTO & 3);
            }
        });
        KEYA_IV = "keyA".getBytes();
        KEYB_IV = "keyB".getBytes();
        REQ1_IV = "req1".getBytes();
        REQ2_IV = "req2".getBytes();
        REQ3_IV = "req3".getBytes();
        VC = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    }
}

