/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.networkmanager.admin;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASN;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminASNListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminException;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminHTTPProxy;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNATDevice;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminNetworkInterface;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminPropertyChangeListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminProtocol;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminRoutesListener;
import com.aelitis.azureus.core.networkmanager.admin.NetworkAdminSocksProxy;
import com.aelitis.azureus.core.networkmanager.admin.impl.NetworkAdminImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.UnsupportedAddressTypeException;
import org.gudy.azureus2.core3.util.IndentWriter;

public abstract class NetworkAdmin {
    private static NetworkAdmin singleton;
    public static final String PR_NETWORK_INTERFACES = "Network Interfaces";
    public static final String PR_DEFAULT_BIND_ADDRESS = "Default Bind IP";
    public static final String PR_AS = "AS";
    public static final int IP_PROTOCOL_VERSION_AUTO = 0;
    public static final int IP_PROTOCOL_VERSION_REQUIRE_V4 = 1;
    public static final int IP_PROTOCOL_VERSION_REQUIRE_V6 = 2;
    public static final String[] PR_NAMES;

    public static synchronized NetworkAdmin getSingleton() {
        if (singleton == null) {
            singleton = new NetworkAdminImpl();
        }
        return singleton;
    }

    public InetAddress getSingleHomedServiceBindAddress() {
        return this.getSingleHomedServiceBindAddress(0);
    }

    public abstract InetAddress getSingleHomedServiceBindAddress(int var1) throws UnsupportedAddressTypeException;

    public abstract InetAddress[] getMultiHomedServiceBindAddresses(boolean var1);

    public abstract InetAddress getMultiHomedOutgoingRoundRobinBindAddress(InetAddress var1);

    public abstract String getNetworkInterfacesAsString();

    public abstract InetAddress[] getAllBindAddresses(boolean var1);

    public abstract InetAddress guessRoutableBindAddress();

    public abstract InetAddress[] getBindableAddresses();

    public abstract int getBindablePort(int var1) throws IOException;

    public abstract NetworkAdminNetworkInterface[] getInterfaces();

    public abstract boolean hasIPV4Potential();

    public boolean hasIPV6Potential() {
        return this.hasIPV6Potential(false);
    }

    public abstract boolean hasIPV6Potential(boolean var1);

    public abstract NetworkAdminProtocol[] getOutboundProtocols(AzureusCore var1);

    public abstract NetworkAdminProtocol[] getInboundProtocols(AzureusCore var1);

    public abstract NetworkAdminProtocol createInboundProtocol(AzureusCore var1, int var2, int var3);

    public abstract InetAddress testProtocol(NetworkAdminProtocol var1) throws NetworkAdminException;

    public abstract NetworkAdminSocksProxy[] getSocksProxies();

    public abstract NetworkAdminHTTPProxy getHTTPProxy();

    public abstract NetworkAdminNATDevice[] getNATDevices(AzureusCore var1);

    public abstract NetworkAdminASN lookupCurrentASN(InetAddress var1) throws NetworkAdminException;

    public abstract NetworkAdminASN getCurrentASN();

    public abstract NetworkAdminASN lookupASN(InetAddress var1) throws NetworkAdminException;

    public abstract void lookupASN(InetAddress var1, NetworkAdminASNListener var2);

    public abstract boolean canTraceRoute();

    public abstract void getRoutes(InetAddress var1, int var2, NetworkAdminRoutesListener var3) throws NetworkAdminException;

    public abstract boolean canPing();

    public abstract void pingTargets(InetAddress var1, int var2, NetworkAdminRoutesListener var3) throws NetworkAdminException;

    public abstract InetAddress getDefaultPublicAddress();

    public abstract InetAddress getDefaultPublicAddressV6();

    public abstract boolean hasDHTIPV6();

    public abstract void addPropertyChangeListener(NetworkAdminPropertyChangeListener var1);

    public abstract void addAndFirePropertyChangeListener(NetworkAdminPropertyChangeListener var1);

    public abstract void removePropertyChangeListener(NetworkAdminPropertyChangeListener var1);

    public abstract void runInitialChecks(AzureusCore var1);

    public abstract void logNATStatus(IndentWriter var1);

    public abstract void generateDiagnostics(IndentWriter var1);

    static {
        PR_NAMES = new String[]{PR_NETWORK_INTERFACES, PR_DEFAULT_BIND_ADDRESS, PR_AS};
    }
}

