/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.web;

import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchLoginException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.DateParser;
import com.aelitis.azureus.core.metasearch.impl.DateParserRegex;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.web.CookieParser;
import com.aelitis.azureus.core.metasearch.impl.web.FieldMapping;
import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.core.vuzefile.VuzeFile;
import com.aelitis.azureus.core.vuzefile.VuzeFileHandler;
import com.aelitis.azureus.util.ImportExportUtils;
import com.aelitis.azureus.util.UrlFilter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebEngine
extends EngineImpl {
    public static final String AM_TRANSPARENT = "transparent";
    public static final String AM_PROXY = "proxy";
    private static final boolean NEEDS_AUTH_DEFAULT = false;
    private static final boolean AUTOMATIC_DATE_PARSER_DEFAULT = true;
    private static final Pattern baseTagPattern = Pattern.compile("(?i)<base.*?href=\"([^\"]+)\".*?>");
    private static final Pattern rootURLPattern = Pattern.compile("(https?://[^/]+)");
    private static final Pattern baseURLPattern = Pattern.compile("(https?://.*/)");
    private String searchURLFormat;
    private String timeZone;
    private boolean automaticDateParser;
    private String userDateFormat;
    private String downloadLinkCSS;
    private FieldMapping[] mappings;
    private String rootPage;
    private String basePage;
    private DateParser dateParser;
    private boolean needsAuth;
    private String authMethod;
    private String loginPageUrl;
    private String[] requiredCookies;
    private String local_cookies;

    public WebEngine(MetaSearchImpl meta_search, int type, long id, long last_updated, float rank_bias, String name, String searchURLFormat, String timeZone, boolean automaticDateParser, String userDateFormat, FieldMapping[] mappings, boolean needs_auth, String auth_method, String login_url, String[] required_cookies) {
        super(meta_search, type, id, last_updated, rank_bias, name);
        this.searchURLFormat = searchURLFormat;
        this.timeZone = timeZone;
        this.automaticDateParser = automaticDateParser;
        this.userDateFormat = userDateFormat;
        this.mappings = mappings;
        this.needsAuth = needs_auth;
        this.authMethod = auth_method;
        this.loginPageUrl = login_url;
        this.requiredCookies = required_cookies;
        this.init();
    }

    protected WebEngine(MetaSearchImpl meta_search, Map map) throws IOException {
        super(meta_search, map);
        this.searchURLFormat = ImportExportUtils.importString(map, "web.search_url_format");
        this.timeZone = ImportExportUtils.importString(map, "web.time_zone");
        this.userDateFormat = ImportExportUtils.importString(map, "web.date_format");
        this.downloadLinkCSS = ImportExportUtils.importString(map, "web.dl_link_css");
        this.needsAuth = ImportExportUtils.importBoolean(map, "web.needs_auth", false);
        this.authMethod = ImportExportUtils.importString(map, "web.auth_method", AM_TRANSPARENT);
        this.loginPageUrl = ImportExportUtils.importString(map, "web.login_page");
        this.requiredCookies = ImportExportUtils.importStringArray(map, "web.required_cookies");
        this.automaticDateParser = ImportExportUtils.importBoolean(map, "web.auto_date", true);
        List maps = (List)map.get("web.maps");
        this.mappings = new FieldMapping[maps.size()];
        for (int i = 0; i < this.mappings.length; ++i) {
            Map m = (Map)maps.get(i);
            this.mappings[i] = new FieldMapping(ImportExportUtils.importString(m, "name"), ((Long)m.get("field")).intValue());
        }
        this.init();
    }

    @Override
    protected void exportToBencodedMap(Map map, boolean generic) throws IOException {
        super.exportToBencodedMap(map, generic);
        if (generic) {
            if (this.searchURLFormat != null) {
                ImportExportUtils.exportString(map, "web.search_url_format", this.searchURLFormat);
            }
            if (this.timeZone != null) {
                ImportExportUtils.exportString(map, "web.time_zone", this.timeZone);
            }
            if (this.userDateFormat != null) {
                ImportExportUtils.exportString(map, "web.date_format", this.userDateFormat);
            }
            if (this.downloadLinkCSS != null) {
                ImportExportUtils.exportString(map, "web.dl_link_css", this.downloadLinkCSS);
            }
            if (this.needsAuth) {
                ImportExportUtils.exportBoolean(map, "web.needs_auth", this.needsAuth);
            }
            if (this.authMethod != null && !this.authMethod.equals(AM_TRANSPARENT)) {
                ImportExportUtils.exportString(map, "web.auth_method", this.authMethod);
            }
            if (this.loginPageUrl != null) {
                ImportExportUtils.exportString(map, "web.login_page", this.loginPageUrl);
            }
            if (this.requiredCookies != null && this.requiredCookies.length > 0) {
                ImportExportUtils.exportStringArray(map, "web.required_cookies", this.requiredCookies);
            }
            if (!this.automaticDateParser) {
                ImportExportUtils.exportBoolean(map, "web.auto_date", this.automaticDateParser);
            }
        } else {
            ImportExportUtils.exportString(map, "web.search_url_format", this.searchURLFormat);
            ImportExportUtils.exportString(map, "web.time_zone", this.timeZone);
            ImportExportUtils.exportString(map, "web.date_format", this.userDateFormat);
            ImportExportUtils.exportString(map, "web.dl_link_css", this.downloadLinkCSS);
            ImportExportUtils.exportBoolean(map, "web.needs_auth", this.needsAuth);
            ImportExportUtils.exportString(map, "web.auth_method", this.authMethod);
            ImportExportUtils.exportString(map, "web.login_page", this.loginPageUrl);
            ImportExportUtils.exportStringArray(map, "web.required_cookies", this.requiredCookies);
            ImportExportUtils.exportBoolean(map, "web.auto_date", this.automaticDateParser);
        }
        ArrayList maps = new ArrayList();
        map.put("web.maps", maps);
        for (int i = 0; i < this.mappings.length; ++i) {
            FieldMapping fm = this.mappings[i];
            HashMap<String, Long> m = new HashMap<String, Long>();
            ImportExportUtils.exportString(m, "name", fm.getName());
            m.put("field", new Long(fm.getField()));
            maps.add(m);
        }
    }

    protected WebEngine(MetaSearchImpl meta_search, int type, long id, long last_updated, float rank_bias, String name, JSONObject map) throws IOException {
        super(meta_search, type, id, last_updated, rank_bias, name, map);
        this.searchURLFormat = ImportExportUtils.importURL(map, "searchURL");
        this.timeZone = ImportExportUtils.importString(map, "timezone");
        this.userDateFormat = ImportExportUtils.importString(map, "time_format");
        this.downloadLinkCSS = ImportExportUtils.importURL(map, "download_link");
        this.needsAuth = ImportExportUtils.importBoolean(map, "needs_auth", false);
        this.authMethod = ImportExportUtils.importString(map, "auth_method", AM_TRANSPARENT);
        this.loginPageUrl = ImportExportUtils.importURL(map, "login_page");
        this.requiredCookies = ImportExportUtils.importStringArray(map, "required_cookies");
        this.automaticDateParser = this.userDateFormat == null || this.userDateFormat.trim().length() == 0;
        List maps = (List)map.get("column_map");
        ArrayList<FieldMapping> conv_maps = new ArrayList<FieldMapping>();
        for (int i = 0; i < maps.size(); ++i) {
            int field_id;
            Map m = (Map)maps.get(i);
            Map test = (Map)m.get("mapping");
            if (test != null) {
                m = test;
            }
            String vuze_field = ImportExportUtils.importString(m, "vuze_field").toUpperCase();
            String field_name = ImportExportUtils.importString(m, "group_nb");
            if (field_name == null) {
                field_name = ImportExportUtils.importString(m, "field_name");
            }
            if (vuze_field == null || field_name == null) {
                this.log("Missing field mapping name/value in '" + m + "'");
            }
            if ((field_id = this.vuzeFieldToID(vuze_field)) == -1) {
                this.log("Unrecognised field mapping '" + vuze_field + "'");
                continue;
            }
            conv_maps.add(new FieldMapping(field_name, field_id));
        }
        this.mappings = conv_maps.toArray(new FieldMapping[conv_maps.size()]);
        this.init();
    }

    @Override
    protected void exportToJSONObject(JSONObject res) throws IOException {
        super.exportToJSONObject(res);
        ImportExportUtils.exportJSONURL(res, "searchURL", this.searchURLFormat);
        ImportExportUtils.exportJSONString(res, "timezone", this.timeZone);
        if (this.downloadLinkCSS != null) {
            ImportExportUtils.exportJSONURL(res, "download_link", this.downloadLinkCSS);
        }
        ImportExportUtils.exportJSONBoolean(res, "needs_auth", this.needsAuth);
        ImportExportUtils.exportJSONString(res, "auth_method", this.authMethod);
        ImportExportUtils.exportJSONURL(res, "login_page", this.loginPageUrl);
        ImportExportUtils.exportJSONStringArray(res, "required_cookies", this.requiredCookies);
        if (!this.automaticDateParser) {
            ImportExportUtils.exportJSONString(res, "time_format", this.userDateFormat);
        }
        JSONArray maps = new JSONArray();
        res.put("column_map", maps);
        for (int i = 0; i < this.mappings.length; ++i) {
            FieldMapping fm = this.mappings[i];
            int field_id = fm.getField();
            String field_value = this.vuzeIDToField(field_id);
            if (field_value == null) {
                this.log("JSON export: unknown field id " + field_id);
                continue;
            }
            JSONObject entry = new JSONObject();
            maps.add(entry);
            entry.put("vuze_field", field_value);
            if (this.getType() == 2) {
                entry.put("field_name", fm.getName());
                continue;
            }
            entry.put("group_nb", fm.getName());
        }
    }

    protected void init() {
        Matcher m;
        try {
            m = rootURLPattern.matcher(this.searchURLFormat);
            if (m.find()) {
                this.rootPage = m.group(1);
            }
        }
        catch (Exception e) {
            this.rootPage = null;
        }
        try {
            m = baseURLPattern.matcher(this.searchURLFormat);
            if (m.find()) {
                this.basePage = m.group(1);
            }
        }
        catch (Exception e) {
            this.basePage = null;
        }
        this.dateParser = new DateParserRegex(this.timeZone, this.automaticDateParser, this.userDateFormat);
        this.local_cookies = this.getLocalString("cookies");
        this.authMethod = this.authMethod.intern();
        int cook_pos = this.searchURLFormat.indexOf(":COOKIE:");
        if (cook_pos != -1) {
            String explicit_cookie = this.searchURLFormat.substring(cook_pos + 8);
            this.setNeedsAuth(true);
            this.setCookies(explicit_cookie);
            this.setRequiredCookies(CookieParser.getCookiesNames(explicit_cookie));
            this.searchURLFormat = this.searchURLFormat.substring(0, cook_pos);
            this.setPublic(false);
            String name = this.getName();
            int n_pos = name.indexOf(":COOKIE:");
            if (n_pos != -1) {
                this.setName(name.substring(0, n_pos));
            }
        }
    }

    @Override
    public String getNameEx() {
        String name;
        String url = this.getRootPage();
        if (url == null || url.length() == 0) {
            url = this.searchURLFormat;
        }
        if ((name = this.getName()).indexOf(url) == -1) {
            return name + " (" + url + ")";
        }
        return name;
    }

    @Override
    public String getReferer() {
        return this.getRootPage();
    }

    @Override
    public boolean supportsContext(String context_key) {
        try {
            URL url = new URL(this.searchURLFormat);
            String host = url.getHost();
            if (Constants.isAzureusDomain(host)) {
                return true;
            }
            if (UrlFilter.getInstance().isWhitelisted(this.searchURLFormat)) {
                return true;
            }
            InetAddress iad = InetAddress.getByName(host);
            if (iad.isLoopbackAddress() || iad.isLinkLocalAddress() || iad.isSiteLocalAddress()) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isShareable() {
        try {
            return !UrlUtils.containsPasskey(new URL(this.searchURLFormat));
        }
        catch (Throwable e) {
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected pageDetails getWebPageContent(SearchParameter[] searchParameters, Map<String, String> searchContext, String headers, boolean only_if_modified) throws SearchException {
        pageDetails pageDetails2;
        block64: {
            pageDetails e4;
            block63: {
                try {
                    try {
                        URL x;
                        int pos2;
                        byte[] data;
                        ResourceDownloader mr_rd;
                        String content_charset;
                        URL initial_url;
                        block62: {
                            InputStream is;
                            ResourceDownloader initial_url_rd;
                            TorrentUtils.setTLSDescription("Search: " + this.getName());
                            if (this.requiresLogin()) {
                                throw new SearchLoginException("login required");
                            }
                            String searchURL = this.searchURLFormat;
                            boolean vuze_file = searchURL.toLowerCase().startsWith("vuze:");
                            if (!vuze_file) {
                                String[] from_strs = new String[searchParameters.length];
                                String[] to_strs = new String[searchParameters.length];
                                for (int i = 0; i < searchParameters.length; ++i) {
                                    SearchParameter parameter = searchParameters[i];
                                    from_strs[i] = "%" + parameter.getMatchPattern();
                                    to_strs[i] = URLEncoder.encode(parameter.getValue(), "UTF-8");
                                }
                                searchURL = GeneralUtils.replaceAll(searchURL, from_strs, to_strs);
                                for (Map.Entry<String, String> entry : searchContext.entrySet()) {
                                    String key = entry.getKey();
                                    if (!this.supportsContext(key)) continue;
                                    searchURL = searchURL.indexOf(63) == -1 ? searchURL + "?" : searchURL + "&";
                                    String value = entry.getValue();
                                    searchURL = searchURL + key + "=" + URLEncoder.encode(value, "UTF-8");
                                }
                            }
                            ResourceDownloaderFactory rdf = StaticUtilities.getResourceDownloaderFactory();
                            int post_pos = searchURL.indexOf("azmethod=");
                            if (post_pos > 0) {
                                String post_params = searchURL.substring(post_pos + 9);
                                searchURL = searchURL.substring(0, post_pos - 1);
                                this.debugLog("search_url: " + searchURL + ", post=" + post_params);
                                initial_url = new URL(searchURL);
                                int sep = post_params.indexOf(58);
                                String type = post_params.substring(0, sep);
                                if (!type.equals("post_basic")) {
                                    throw new SearchException("Only basic type supported");
                                }
                                post_params = post_params.substring(sep + 1);
                                initial_url_rd = rdf.create(initial_url, post_params);
                                initial_url_rd.setProperty("URL_Content-Type", "application/x-www-form-urlencoded");
                            } else {
                                this.debugLog("search_url: " + searchURL);
                                initial_url = new URL(searchURL);
                                initial_url_rd = rdf.create(initial_url);
                            }
                            this.setHeaders(initial_url_rd, headers);
                            if (this.needsAuth && this.local_cookies != null) {
                                initial_url_rd.setProperty("URL_Cookie", this.local_cookies);
                            }
                            if (only_if_modified) {
                                String last_modified = this.getLocalString("last_mod");
                                String etag = this.getLocalString("etag");
                                if (last_modified != null) {
                                    initial_url_rd.setProperty("URL_If-Modified-Since", last_modified);
                                }
                                if (etag != null) {
                                    initial_url_rd.setProperty("URL_If-None-Match", etag);
                                }
                            }
                            content_charset = "UTF-8";
                            mr_rd = null;
                            if (initial_url.getProtocol().equalsIgnoreCase("file")) {
                                int pos;
                                String str = initial_url.toExternalForm();
                                if (initial_url.getAuthority() != null) {
                                    str = str.replaceFirst("://", ":/");
                                }
                                if ((pos = str.indexOf(63)) != -1) {
                                    str = str.substring(0, pos);
                                }
                                is = new FileInputStream(new File(new URL(str).toURI()));
                            } else {
                                String content_type;
                                int pos;
                                List cts;
                                mr_rd = rdf.getMetaRefreshDownloader(initial_url_rd);
                                try {
                                    is = mr_rd.download();
                                }
                                catch (ResourceDownloaderException e2) {
                                    Long response = (Long)mr_rd.getProperty("URL_HTTP_Response");
                                    if (response == null) throw e2;
                                    if (response != 304L) throw e2;
                                    pageDetails pageDetails3 = new pageDetails(initial_url, initial_url, "");
                                    Object var30_30 = null;
                                    TorrentUtils.setTLSDescription(null);
                                    return pageDetails3;
                                }
                                if (this.needsAuth) {
                                    List cookies_list = (List)mr_rd.getProperty("URL_Set-Cookie");
                                    ArrayList<String> cookies_set = new ArrayList<String>();
                                    if (cookies_list != null) {
                                        for (int i = 0; i < cookies_list.size(); ++i) {
                                            String[] cookies = ((String)cookies_list.get(i)).split(";");
                                            for (int j = 0; j < cookies.length; ++j) {
                                                String cookie = cookies[j].trim();
                                                if (cookie.indexOf(61) == -1) continue;
                                                cookies_set.add(cookie);
                                            }
                                        }
                                    }
                                }
                                if (only_if_modified) {
                                    String last_modified = this.extractProperty(mr_rd.getProperty("URL_Last-Modified"));
                                    String etag = this.extractProperty(mr_rd.getProperty("URL_ETag"));
                                    if (last_modified != null) {
                                        this.setLocalString("last_mod", last_modified);
                                    }
                                    if (etag != null) {
                                        this.setLocalString("etag", etag);
                                    }
                                }
                                if ((cts = (List)mr_rd.getProperty("URL_Content-Type")) != null && cts.size() > 0 && (pos = (content_type = (String)cts.get(0)).toLowerCase().indexOf("charset")) != -1 && (pos = (content_type = content_type.substring(pos + 1)).indexOf(61)) != -1) {
                                    if ((pos = (content_type = content_type.substring(pos + 1).trim()).indexOf(59)) != -1) {
                                        content_type = content_type.substring(0, pos).trim();
                                    }
                                    try {
                                        if (Charset.isSupported(content_type)) {
                                            this.debugLog("charset: " + content_type);
                                            content_charset = content_type;
                                        }
                                    }
                                    catch (Throwable e3) {
                                        try {
                                            content_type = content_type.toUpperCase();
                                            if (Charset.isSupported(content_type)) {
                                                this.debugLog("charset: " + content_type);
                                                content_charset = content_type;
                                            }
                                        }
                                        catch (Throwable f) {
                                            this.log("Content type '" + content_type + "' not supported", f);
                                        }
                                    }
                                }
                            }
                            ByteArrayOutputStream baos = new ByteArrayOutputStream(8192);
                            byte[] buffer = new byte[8192];
                            while (true) {
                                int len;
                                if ((len = is.read(buffer)) <= 0) {
                                    data = baos.toByteArray();
                                    if (vuze_file) {
                                        break;
                                    }
                                    break block62;
                                }
                                baos.write(buffer, 0, len);
                            }
                            try {
                                VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                                VuzeFile vf = vfh.loadVuzeFile(data);
                                vfh.handleFiles(new VuzeFile[]{vf}, 0);
                            }
                            catch (Throwable e4) {
                                Debug.out(e4);
                            }
                            e4 = new pageDetails(initial_url, initial_url, null);
                            Object var30_31 = null;
                            break block63;
                        }
                        String page = null;
                        String content = new String(data, 0, Math.min(data.length, 2048), content_charset);
                        String lc_content = content.toLowerCase();
                        int pos1 = lc_content.indexOf("<?xml");
                        if (pos1 != -1 && (pos2 = lc_content.indexOf("?>")) != -1) {
                            int pos4;
                            int pos3 = lc_content.indexOf("encoding", pos1);
                            if (pos3 != -1) {
                                pos3 = lc_content.indexOf("\"", pos3);
                            }
                            if (pos3 > pos1 && pos3 < pos2 && (pos4 = lc_content.indexOf("\"", ++pos3)) > pos3 && pos4 < pos2) {
                                String encoding = content.substring(pos3, pos4).trim();
                                try {
                                    if (Charset.isSupported(encoding)) {
                                        this.debugLog("charset from xml tag: " + encoding);
                                        content_charset = encoding;
                                        int data_start = pos2;
                                        int max_skip = 64;
                                        while (data[data_start] != 63 && max_skip-- > 0) {
                                            ++data_start;
                                        }
                                        page = content.substring(0, pos3) + "utf-8" + content.substring(pos4, pos2) + new String(data, data_start, data.length - data_start, content_charset);
                                    }
                                }
                                catch (Throwable e5) {
                                    this.log("Content type '" + encoding + "' not supported", e5);
                                }
                            }
                        }
                        if (page == null) {
                            int pos22;
                            int pos12;
                            int pos = 0;
                            while ((pos12 = lc_content.indexOf("http-equiv", pos)) != -1 && (pos22 = lc_content.indexOf(">", pos12)) != -1) {
                                int pos4;
                                int pos3 = lc_content.indexOf("charset", pos12);
                                if (pos3 != -1 && pos3 < pos22 && (pos3 = lc_content.indexOf("=", pos3)) != -1 && (pos4 = lc_content.indexOf("\"", ++pos3)) != -1) {
                                    int pos5 = lc_content.indexOf(";", pos3);
                                    if (pos5 != -1 && pos5 < pos4) {
                                        pos4 = pos5;
                                    }
                                    String encoding = content.substring(pos3, pos4).trim();
                                    try {
                                        if (!Charset.isSupported(encoding)) break;
                                        this.debugLog("charset from http-equiv : " + encoding);
                                        content_charset = encoding;
                                        int data_start = pos22;
                                        int max_skip = 64;
                                        while (data[data_start] != 63 && max_skip-- > 0) {
                                            ++data_start;
                                        }
                                        page = content.substring(0, pos3) + "utf-8" + content.substring(pos4, pos22) + new String(data, data_start, data.length - data_start, content_charset);
                                    }
                                    catch (Throwable e6) {
                                        this.log("Content type '" + encoding + "' not supported", e6);
                                    }
                                    break;
                                }
                                pos = pos22;
                            }
                        }
                        if (page == null) {
                            page = new String(data, content_charset);
                        }
                        this.debugLog("page:");
                        this.debugLog(page);
                        try {
                            Matcher m = baseTagPattern.matcher(page);
                            if (m.find()) {
                                this.basePage = m.group(1);
                                this.debugLog("base_page: " + this.basePage);
                            }
                        }
                        catch (Exception e7) {
                            // empty catch block
                        }
                        URL final_url = initial_url;
                        if (mr_rd != null && (x = (URL)mr_rd.getProperty("URL_URL")) != null) {
                            final_url = x;
                        }
                        pageDetails2 = new pageDetails(initial_url, final_url, page);
                        break block64;
                    }
                    catch (SearchException e8) {
                        throw e8;
                    }
                    catch (Throwable e9) {
                        this.debugLog("Failed to load page: " + Debug.getNestedExceptionMessageAndStack(e9));
                        throw new SearchException("Failed to load page", e9);
                    }
                }
                catch (Throwable throwable) {
                    Object var30_33 = null;
                    TorrentUtils.setTLSDescription(null);
                    throw throwable;
                }
            }
            TorrentUtils.setTLSDescription(null);
            return e4;
        }
        Object var30_32 = null;
        TorrentUtils.setTLSDescription(null);
        return pageDetails2;
    }

    protected String extractProperty(Object o) {
        List l;
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof List && (l = (List)o).size() > 0) {
            Object x;
            if (l.size() > 1) {
                Debug.out("Property has multiple values!");
            }
            if ((x = l.get(0)) instanceof String) {
                return (String)x;
            }
            Debug.out("Property value isn't a String:" + x);
        }
        return null;
    }

    protected void setHeaders(ResourceDownloader rd, String encoded_headers) {
        UrlUtils.setBrowserHeaders(rd, encoded_headers, this.rootPage);
    }

    @Override
    public String getIcon() {
        if (this.rootPage != null) {
            return this.rootPage + "/favicon.ico";
        }
        return null;
    }

    protected FieldMapping[] getMappings() {
        return this.mappings;
    }

    @Override
    public boolean supportsField(int field_id) {
        for (int i = 0; i < this.mappings.length; ++i) {
            if (this.mappings[i].getField() != field_id) continue;
            return true;
        }
        return false;
    }

    protected String getRootPage() {
        return this.rootPage;
    }

    protected String getBasePage() {
        return this.basePage;
    }

    protected DateParser getDateParser() {
        return this.dateParser;
    }

    @Override
    public String getDownloadLinkCSS() {
        if (this.downloadLinkCSS == null) {
            return "";
        }
        return this.downloadLinkCSS;
    }

    public boolean requiresLogin() {
        return this.needsAuth && !CookieParser.cookiesContain(this.requiredCookies, this.local_cookies);
    }

    public void setCookies(String cookies) {
        this.local_cookies = cookies;
        this.setLocalString("cookies", cookies);
    }

    public String getSearchUrl(boolean raw) {
        if (raw) {
            return this.searchURLFormat;
        }
        return this.getSearchUrl();
    }

    public String getSearchUrl() {
        return this.searchURLFormat.replaceAll("%s", "");
    }

    public String getLoginPageUrl() {
        return this.searchURLFormat.replaceAll("%s", "");
    }

    public void setLoginPageUrl(String loginPageUrl) {
        this.loginPageUrl = loginPageUrl;
    }

    public String[] getRequiredCookies() {
        return this.requiredCookies;
    }

    public void setRequiredCookies(String[] requiredCookies) {
        this.requiredCookies = requiredCookies;
    }

    public boolean isNeedsAuth() {
        return this.needsAuth;
    }

    @Override
    public boolean isAuthenticated() {
        return this.isNeedsAuth();
    }

    protected void setNeedsAuth(boolean b) {
        this.needsAuth = b;
    }

    public String getAuthMethod() {
        return this.authMethod;
    }

    public String getCookies() {
        return this.local_cookies;
    }

    @Override
    public String getString() {
        return this.getString(false);
    }

    @Override
    public String getString(boolean full) {
        return super.getString() + (full ? ", url=" + this.searchURLFormat : "") + ", auth=" + this.isNeedsAuth() + (this.isNeedsAuth() ? " [cookies=" + this.local_cookies + "]" : "");
    }

    public static class pageDetails {
        private URL initial_url;
        private URL final_url;
        private String content;

        protected pageDetails(URL _initial_url, URL _final_url, String _content) {
            this.initial_url = _initial_url;
            this.final_url = _final_url;
            this.content = _content;
        }

        public URL getInitialURL() {
            return this.initial_url;
        }

        public URL getFinalURL() {
            return this.final_url;
        }

        public String getContent() {
            return this.content;
        }
    }
}

