/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.metasearch.impl.plugin;

import com.aelitis.azureus.core.metasearch.Result;
import com.aelitis.azureus.core.metasearch.ResultListener;
import com.aelitis.azureus.core.metasearch.SearchException;
import com.aelitis.azureus.core.metasearch.SearchParameter;
import com.aelitis.azureus.core.metasearch.impl.EngineImpl;
import com.aelitis.azureus.core.metasearch.impl.MetaSearchImpl;
import com.aelitis.azureus.core.metasearch.impl.plugin.PluginResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.search.SearchInstance;
import org.gudy.azureus2.plugins.utils.search.SearchObserver;
import org.gudy.azureus2.plugins.utils.search.SearchProvider;
import org.gudy.azureus2.plugins.utils.search.SearchResult;

public class PluginEngine
extends EngineImpl {
    private static int[][] FIELD_MAP = new int[][]{{7, 6}, {8, 7}, {10, 8}, {11, 103}, {16, 105}, {12, 102}, {15, 13}, {4, 4}, {1, 1}, {13, 104}, {14, 12}, {2, 2}, {5, 5}, {3, 3}, {6, 11}, {9, 10}};
    private SearchProvider provider;

    public static EngineImpl importFromBEncodedMap(MetaSearchImpl meta_search, Map map) throws IOException {
        return new PluginEngine(meta_search, map);
    }

    public PluginEngine(MetaSearchImpl _meta_search, long _id, SearchProvider _provider) {
        super(_meta_search, 3, _id, 0L, 1.0f, (String)_provider.getProperty(1));
        this.provider = _provider;
        this.setSource(2);
    }

    protected PluginEngine(MetaSearchImpl _meta_search, Map _map) throws IOException {
        super(_meta_search, _map);
        if (this.getRankBias() == 0.0f) {
            this.setRankBias(1.0f);
        }
        this.setSource(2);
    }

    public Map exportToBencodedMap() throws IOException {
        return this.exportToBencodedMap(false);
    }

    public Map exportToBencodedMap(boolean generic) throws IOException {
        HashMap res = new HashMap();
        super.exportToBencodedMap(res, generic);
        return res;
    }

    public void setProvider(SearchProvider _provider) {
        this.provider = _provider;
    }

    protected boolean useAccuracyForRank() {
        if (this.provider == null) {
            return false;
        }
        Boolean val = (Boolean)this.provider.getProperty(6);
        if (val == null) {
            return false;
        }
        return val;
    }

    public boolean isActive() {
        return this.provider != null && super.isActive();
    }

    public String getNameEx() {
        return super.getName() + ": (plugin)";
    }

    public String getDownloadLinkCSS() {
        if (this.provider == null) {
            return null;
        }
        return (String)this.provider.getProperty(3);
    }

    public boolean supportsField(int field) {
        if (this.provider == null) {
            return false;
        }
        int[] supports = (int[])this.provider.getProperty(5);
        if (supports == null) {
            return true;
        }
        for (int i = 0; i < FIELD_MAP.length; ++i) {
            int[] entry = FIELD_MAP[i];
            if (entry[1] != field) continue;
            for (int j = 0; j < supports.length; ++j) {
                if (supports[j] != entry[0]) continue;
                return true;
            }
            break;
        }
        return false;
    }

    public boolean supportsContext(String context_key) {
        return false;
    }

    public boolean isShareable() {
        return false;
    }

    public String getIcon() {
        if (this.provider == null) {
            return null;
        }
        return (String)this.provider.getProperty(2);
    }

    public String getReferer() {
        if (this.provider == null) {
            return null;
        }
        return (String)this.provider.getProperty(4);
    }

    protected Result[] searchSupport(SearchParameter[] params, Map searchContext, final int desired_max_matches, final int absolute_max_matches, String headers, final ResultListener listener) throws SearchException {
        if (this.provider == null) {
            return new Result[0];
        }
        HashMap<String, Object> search_parameters = new HashMap<String, Object>();
        String term = null;
        for (int i = 0; i < params.length; ++i) {
            SearchParameter param = params[i];
            String pattern = param.getMatchPattern();
            String value = param.getValue();
            if (pattern.equals("s")) {
                term = value;
                search_parameters.put("s", value);
                continue;
            }
            if (pattern.equals("m")) {
                search_parameters.put("m", new Boolean(value));
                continue;
            }
            Debug.out("Unrecognised search parameter '" + pattern + "=" + value + "' ignored");
        }
        final String f_term = term;
        try {
            final ArrayList results = new ArrayList();
            final AESemaphore sem = new AESemaphore("waiter");
            this.provider.search(search_parameters, new SearchObserver(){
                private boolean complete = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resultReceived(SearchInstance search, SearchResult result) {
                    PluginResult p_result = new PluginResult(PluginEngine.this, result, f_term);
                    1 var4_4 = this;
                    synchronized (var4_4) {
                        if (this.complete) {
                            return;
                        }
                        results.add(p_result);
                    }
                    if (listener != null) {
                        listener.resultsReceived(PluginEngine.this, new Result[]{p_result});
                    }
                    var4_4 = this;
                    synchronized (var4_4) {
                        if (absolute_max_matches >= 0 && results.size() >= absolute_max_matches) {
                            this.complete = true;
                            sem.release();
                        }
                    }
                }

                public void cancelled() {
                    sem.release();
                }

                public void complete() {
                    sem.release();
                }

                public Object getProperty(int property) {
                    if (property == 1) {
                        return new Long(desired_max_matches);
                    }
                    return null;
                }
            });
            sem.reserve();
            if (listener != null) {
                listener.resultsComplete(this);
            }
            return results.toArray(new Result[results.size()]);
        }
        catch (Throwable e) {
            throw new SearchException("Search failed", e);
        }
    }
}

