/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.activities.VuzeActivitiesEntry;
import com.aelitis.azureus.activities.VuzeActivitiesManager;
import com.aelitis.azureus.core.messenger.PlatformMessage;
import com.aelitis.azureus.core.messenger.PlatformMessenger;
import com.aelitis.azureus.core.messenger.PlatformMessengerListener;
import com.aelitis.azureus.util.MapUtils;
import java.util.List;
import java.util.Map;

public class PlatformVuzeActivitiesMessenger {
    public static final String LISTENER_ID = "vuzenews";
    public static final String OP_GET = "get-entries";
    public static final long DEFAULT_RETRY_MS = 86400000L;

    public static void getEntries(final long contentNetworkID, long agoMS, long maxDelayMS, String reason, final GetEntriesReplyListener replyListener) {
        PlatformMessage message = new PlatformMessage("AZMSG", reason.equals("shown") ? "vznews" : LISTENER_ID, OP_GET, new Object[]{"ago-ms", new Long(agoMS), "reason", reason}, maxDelayMS);
        message.setContentNetworkID(contentNetworkID);
        PlatformMessengerListener listener = null;
        if (replyListener != null) {
            listener = new PlatformMessengerListener(){

                public void messageSent(PlatformMessage message) {
                }

                public void replyReceived(PlatformMessage message, String replyType, Map reply) {
                    VuzeActivitiesEntry[] entries = new VuzeActivitiesEntry[]{};
                    List entriesList = (List)MapUtils.getMapObject(reply, "entries", null, List.class);
                    if (entriesList != null && entriesList.size() > 0) {
                        entries = new VuzeActivitiesEntry[entriesList.size()];
                        int i = 0;
                        for (Map platformEntry : entriesList) {
                            if (platformEntry == null) continue;
                            entries[i] = VuzeActivitiesManager.createEntryFromMap(contentNetworkID, platformEntry, false);
                            if (entries[i] == null) continue;
                            ++i;
                        }
                    }
                    long refreshInMS = MapUtils.getMapLong(reply, "refresh-in-ms", 86400000L);
                    replyListener.gotVuzeNewsEntries(entries, refreshInMS);
                }
            };
        }
        PlatformMessenger.queueMessage(message, listener);
    }

    public static interface GetEntriesReplyListener {
        public void gotVuzeNewsEntries(VuzeActivitiesEntry[] var1, long var2);
    }
}

