/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.messenger.config;

import com.aelitis.azureus.core.messenger.PlatformMessengerException;
import com.aelitis.azureus.core.messenger.config.PlatformMessengerConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformMetaDataMessenger {
    private static final PlatformMessengerConfig dispatcher = new PlatformMessengerConfig("metadata", false);
    private static final String OP_LOOKUP = "lookup";
    private static final String OP_SEARCH = "search";
    private static final String OP_SUBMIT = "submit";

    public static Association getAssociation(String hash) throws PlatformMessengerException {
        Map reply = dispatcher.syncInvoke(OP_LOOKUP, PlatformMetaDataMessenger.getParameter(hash));
        Association assoc = PlatformMetaDataMessenger.getAssociation(reply);
        if (assoc == null) {
            throw new PlatformMessengerException("Invalid reply: " + reply);
        }
        return assoc;
    }

    private static Association getAssociation(Map reply) {
        try {
            Map result = (Map)reply.get("result");
            return PlatformMetaDataMessenger.getAssociationFromMap(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Association getAssociationFromMap(Map assoc) {
        try {
            String title = (String)assoc.get("title");
            String db = (String)assoc.get("db");
            String db_id = (String)assoc.get("db_id");
            String hash = (String)assoc.get("hash");
            String type = (String)assoc.get("type");
            if (type == null) {
                EmptyAssociation result = new EmptyAssociation();
                result.hash = hash;
                return result;
            }
            if ("movie".equals(type)) {
                String quality = (String)assoc.get("quality");
                String language = (String)assoc.get("language");
                MovieAssociation association2 = new MovieAssociation();
                association2.db = db;
                association2.db_id = db_id;
                association2.title = title;
                association2.quality = VideoQuality.fromString(quality);
                association2.language = new Locale(language);
                association2.hash = hash;
                return association2;
            }
            if ("tv".equals(type)) {
                String quality = (String)assoc.get("quality");
                String language = (String)assoc.get("language");
                TvShowAssociation association3 = new TvShowAssociation();
                association3.db = db;
                association3.db_id = db_id;
                association3.title = title;
                association3.quality = VideoQuality.fromString(quality);
                association3.language = new Locale(language);
                association3.hash = hash;
                return association3;
            }
            if ("music".equals(type)) {
                String quality = (String)assoc.get("quality");
                MusicAssociation association4 = new MusicAssociation();
                association4.db = db;
                association4.db_id = db_id;
                association4.title = title;
                association4.quality = AudioQuality.fromString(quality);
                association4.hash = hash;
                return association4;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Map<String, Association> getAssociations(Map reply) {
        try {
            Map result = (Map)reply.get("results");
            HashMap<String, Association> results = new HashMap<String, Association>();
            for (String key : result.keySet()) {
                results.put(key, PlatformMetaDataMessenger.getAssociationFromMap((Map)result.get(key)));
            }
            return results;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashMap<String, Association>();
        }
    }

    public static Map<String, Association> getAssociations(String[] hashes) throws PlatformMessengerException {
        HashMap<String, Association> result = new HashMap<String, Association>();
        if (hashes.length == 0) {
            return result;
        }
        Map reply = dispatcher.syncInvoke(OP_LOOKUP, PlatformMetaDataMessenger.getParameters(hashes));
        return PlatformMetaDataMessenger.getAssociations(reply);
    }

    public static void addSubmission(Association assoc) throws PlatformMessengerException {
        HashMap parameters = new HashMap();
        HashMap<String, String> submission = new HashMap<String, String>();
        submission.put("hash", assoc.hash);
        submission.put("db", assoc.db);
        submission.put("db_id", assoc.db_id);
        if (assoc instanceof MovieAssociation) {
            submission.put("type", "movie");
            submission.put("quality", ((MovieAssociation)assoc).quality.quality);
            submission.put("language", ((MovieAssociation)assoc).language.getLanguage());
        }
        if (assoc instanceof TvShowAssociation) {
            submission.put("type", "tv");
            submission.put("quality", ((MovieAssociation)assoc).quality.quality);
            submission.put("language", ((MovieAssociation)assoc).language.getLanguage());
        }
        if (assoc instanceof MusicAssociation) {
            submission.put("type", "music");
            submission.put("quality", ((MovieAssociation)assoc).quality.quality);
        }
        parameters.put("submission", submission);
        dispatcher.syncInvoke(OP_SUBMIT, parameters);
    }

    public static SearchResult[] search(String title) throws PlatformMessengerException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("title", title);
        Map reply = dispatcher.syncInvoke(OP_SEARCH, parameters);
        List results = (List)reply.get("results");
        SearchResult[] searchResults = new SearchResult[results.size()];
        int i = 0;
        for (Map result : results) {
            SearchResult searchResult = new SearchResult();
            searchResult.title = (String)result.get("title");
            searchResult.db = (String)result.get("db");
            searchResult.db_id = (String)result.get("db_id");
            searchResults[i++] = searchResult;
        }
        return searchResults;
    }

    protected static Map getParameter(String hash) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("hash", hash);
        return parameters;
    }

    protected static Map getParameters(String[] hashes) {
        HashMap<String, String[]> parameters = new HashMap<String, String[]>();
        parameters.put("hashes", hashes);
        return parameters;
    }

    public static void main(String[] args) throws Exception {
        SearchResult[] results;
        for (SearchResult result : results = PlatformMetaDataMessenger.search("Dark Knight")) {
            System.out.println(result);
        }
        MovieAssociation assoc = new MovieAssociation();
        assoc.db = "tmdb";
        assoc.db_id = "155";
        assoc.hash = "test";
        assoc.quality = VideoQuality.DVD;
        assoc.language = new Locale("en");
        PlatformMetaDataMessenger.addSubmission(assoc);
        Association assocL = PlatformMetaDataMessenger.getAssociation("test");
        System.out.println(assocL);
    }

    public static abstract class Association {
        public String hash;
        public String db;
        public String db_id;
        public String title;

        public String toString() {
            return this.hash + " > " + this.db + "." + this.db_id + " : " + this.title;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AudioQuality {
        LOW("low"),
        HIGH("high"),
        LOSSLESS("lossless");

        String quality;

        private AudioQuality(String quality) {
            this.quality = quality;
        }

        public static AudioQuality fromString(String quality) {
            if (AudioQuality.LOW.quality.equals(quality = quality.toLowerCase())) {
                return LOW;
            }
            if (AudioQuality.HIGH.quality.equals(quality)) {
                return HIGH;
            }
            if (AudioQuality.LOSSLESS.quality.equals(quality)) {
                return LOSSLESS;
            }
            return null;
        }
    }

    public static class EmptyAssociation
    extends Association {
    }

    public static class MovieAssociation
    extends VideoAssociation {
    }

    public static class MusicAssociation
    extends Association {
        public AudioQuality quality;
    }

    public static class SearchResult {
        String title;
        String db;
        String db_id;

        public String toString() {
            return this.db + "." + this.db_id + " : " + this.title;
        }
    }

    public static class TvShowAssociation
    extends VideoAssociation {
    }

    public static abstract class VideoAssociation
    extends Association {
        public VideoQuality quality;
        public Locale language;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VideoQuality {
        LOW("low"),
        DVD("dvd"),
        HD_720p("720p"),
        HD_1080p("1080p");

        String quality;

        private VideoQuality(String quality) {
            this.quality = quality;
        }

        public static VideoQuality fromString(String quality) {
            if (VideoQuality.LOW.quality.equals(quality = quality.toLowerCase())) {
                return LOW;
            }
            if (VideoQuality.DVD.quality.equals(quality)) {
                return DVD;
            }
            if (VideoQuality.HD_720p.quality.equals(quality)) {
                return HD_720p;
            }
            if (VideoQuality.HD_1080p.quality.equals(quality)) {
                return HD_1080p;
            }
            return null;
        }
    }
}

