/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.helpers;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.TorrentUtils;

public class TorrentFolderWatcher {
    private static final LogIDs LOGID = LogIDs.CORE;
    private static final String PARAMID_FOLDER = "Watch Torrent Folder";
    private GlobalManager global_manager;
    private boolean running = false;
    private final ArrayList to_delete = new ArrayList();
    protected AEMonitor this_mon = new AEMonitor("TorrentFolderWatcher");
    private FilenameFilter filename_filter = new FilenameFilter(){

        public boolean accept(File dir, String name) {
            String lc_name = name.toLowerCase();
            return lc_name.endsWith(".torrent") || lc_name.endsWith(".tor");
        }
    };
    private ParameterListener param_listener = new ParameterListener(){

        public void parameterChanged(String parameterName) {
            if (COConfigurationManager.getBooleanParameter(TorrentFolderWatcher.PARAMID_FOLDER)) {
                if (!TorrentFolderWatcher.this.running) {
                    TorrentFolderWatcher.this.running = true;
                    TorrentFolderWatcher.this.watch_thread.setDaemon(true);
                    TorrentFolderWatcher.this.watch_thread.setPriority(1);
                    TorrentFolderWatcher.this.watch_thread.start();
                }
            } else {
                TorrentFolderWatcher.this.running = false;
            }
        }
    };
    private final Thread watch_thread = new AEThread("FolderWatcher"){

        public void runSupport() {
            while (TorrentFolderWatcher.this.running) {
                int sleepMS = COConfigurationManager.getIntParameter("Watch Torrent Folder Interval");
                try {
                    Thread.sleep(sleepMS * 60000);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
                TorrentFolderWatcher.this.importAddedFiles();
            }
        }
    };

    public TorrentFolderWatcher(GlobalManager _global_manager) {
        this.global_manager = _global_manager;
        if (COConfigurationManager.getBooleanParameter(PARAMID_FOLDER)) {
            this.running = true;
            this.watch_thread.setDaemon(true);
            this.watch_thread.setPriority(1);
            this.watch_thread.start();
        }
        COConfigurationManager.addParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    public void destroy() {
        this.running = false;
        this.global_manager = null;
        COConfigurationManager.removeParameterListener(PARAMID_FOLDER, this.param_listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void importAddedFiles() {
        block31: {
            block30: {
                block29: {
                    block28: {
                        try {
                            this.this_mon.enter();
                            if (!this.running) {
                                Object var15_1 = null;
                                this.this_mon.exit();
                                return;
                            }
                            boolean save_torrents = COConfigurationManager.getBooleanParameter("Save Torrent Files");
                            String torrent_save_path = COConfigurationManager.getStringParameter("General_sDefaultTorrent_Directory");
                            int start_state = COConfigurationManager.getBooleanParameter("Start Watched Torrents Stopped") ? 70 : 75;
                            String folder_path = COConfigurationManager.getStringParameter("Watch Torrent Folder Path");
                            String data_save_path = COConfigurationManager.getStringParameter("Default save path");
                            File folder = null;
                            if (folder_path != null && folder_path.length() > 0 && !(folder = new File(folder_path)).isDirectory()) {
                                if (!folder.exists()) {
                                    FileUtil.mkdirs(folder);
                                }
                                if (!folder.isDirectory()) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] does not exist or is not a dir"));
                                    }
                                    folder = null;
                                }
                            }
                            if (folder == null) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, 3, "[Watch Torrent Folder Path] not configured"));
                                }
                                break block28;
                            }
                            File f = null;
                            if (data_save_path != null && data_save_path.length() > 0 && !(f = new File(data_save_path)).isDirectory()) {
                                if (!f.exists()) {
                                    FileUtil.mkdirs(f);
                                }
                                if (!f.isDirectory()) {
                                    if (Logger.isEnabled()) {
                                        Logger.log(new LogEvent(LOGID, 3, "[Default save path] does not exist or is not a dir"));
                                    }
                                    Logger.log(new LogAlert(false, 3, "[Default save path] does not exist or is not a dir"));
                                    break block29;
                                }
                            }
                            if (f == null) {
                                if (Logger.isEnabled()) {
                                    Logger.log(new LogEvent(LOGID, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                                }
                                Logger.log(new LogAlert(false, 3, "[Default save path] needs to be set for auto-.torrent-import to work"));
                            }
                            if (torrent_save_path.length() == 0 || torrent_save_path.equals(folder_path) || !new File(torrent_save_path).isDirectory()) {
                                save_torrents = false;
                            }
                            for (int i = 0; i < this.to_delete.size(); ++i) {
                                TOTorrent torrent = (TOTorrent)this.to_delete.get(i);
                                try {
                                    TorrentUtils.delete(torrent);
                                    continue;
                                }
                                catch (Throwable e) {
                                    Debug.printStackTrace(e);
                                }
                            }
                            this.to_delete.clear();
                            String[] currentFileList = folder.list(this.filename_filter);
                            if (currentFileList == null) {
                                Logger.log(new LogEvent(LOGID, 3, "There was a problem trying to get a listing of torrents from " + folder));
                                break block30;
                            }
                            for (int i = 0; i < currentFileList.length; ++i) {
                                File file = new File(folder, currentFileList[i]);
                                try {
                                    TOTorrent torrent = TorrentUtils.readFromFile(file, false);
                                    if (this.global_manager.getDownloadManager(torrent) != null) {
                                        if (!Logger.isEnabled()) continue;
                                        Logger.log(new LogEvent(LOGID, file.getAbsolutePath() + " is already being downloaded"));
                                        continue;
                                    }
                                    byte[] hash = null;
                                    try {
                                        hash = torrent.getHash();
                                    }
                                    catch (Exception e) {
                                        // empty catch block
                                    }
                                    if (!save_torrents) {
                                        File imported = new File(folder, file.getName() + ".imported");
                                        TorrentUtils.move(file, imported);
                                        this.global_manager.addDownloadManager(imported.getAbsolutePath(), hash, data_save_path, start_state, true);
                                    } else {
                                        this.global_manager.addDownloadManager(file.getAbsolutePath(), hash, data_save_path, start_state, true);
                                        this.to_delete.add(torrent);
                                    }
                                    if (!Logger.isEnabled()) continue;
                                    Logger.log(new LogEvent(LOGID, "Auto-imported " + file.getAbsolutePath()));
                                    continue;
                                }
                                catch (Throwable e) {
                                    Debug.out("Failed to auto-import torrent file '" + file.getAbsolutePath() + "' - " + Debug.getNestedExceptionMessage(e));
                                    Debug.printStackTrace(e);
                                }
                            }
                            break block31;
                        }
                        catch (Throwable throwable) {
                            Object var15_6 = null;
                            this.this_mon.exit();
                            throw throwable;
                        }
                    }
                    Object var15_2 = null;
                    this.this_mon.exit();
                    return;
                }
                Object var15_3 = null;
                this.this_mon.exit();
                return;
            }
            Object var15_4 = null;
            this.this_mon.exit();
            return;
        }
        Object var15_5 = null;
        this.this_mon.exit();
    }
}

