/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.file.impl;

import com.aelitis.azureus.core.diskmanager.file.FMFileManagerException;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileAccess;
import com.aelitis.azureus.core.diskmanager.file.impl.FMFileImpl;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.SystemTime;

public class FMFileAccessLinear
implements FMFileAccess {
    private static final int WRITE_RETRY_LIMIT = 10;
    private static final int WRITE_RETRY_DELAY = 100;
    private static final int READ_RETRY_LIMIT = 10;
    private static final int READ_RETRY_DELAY = 100;
    private static final boolean DEBUG = true;
    private static final boolean DEBUG_VERBOSE = false;
    private static final boolean USE_MMAP = System.getProperty("azureus.io.usemmap", "false") == "true";
    private FMFileImpl owner;

    protected FMFileAccessLinear(FMFileImpl _owner) {
        this.owner = _owner;
    }

    public void aboutToOpen() throws FMFileManagerException {
    }

    public long getLength(RandomAccessFile raf) throws FMFileManagerException {
        try {
            AEThread2.setDebug(this.owner);
            return raf.length();
        }
        catch (Throwable e) {
            throw new FMFileManagerException("getLength fails", e);
        }
    }

    public void setLength(RandomAccessFile raf, long length) throws FMFileManagerException {
        try {
            AEThread2.setDebug(this.owner);
            raf.setLength(length);
        }
        catch (Throwable e) {
            throw new FMFileManagerException("setLength fails", e);
        }
    }

    public boolean isPieceCompleteProcessingNeeded(int piece_number) {
        return false;
    }

    public void setPieceComplete(RandomAccessFile raf, int piece_number, DirectByteBuffer piece_data) throws FMFileManagerException {
    }

    public void read(RandomAccessFile raf, DirectByteBuffer buffer, long offset) throws FMFileManagerException {
        if (raf == null) {
            throw new FMFileManagerException("read: raf is null");
        }
        FileChannel fc = raf.getChannel();
        if (!fc.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException("read - file is closed");
        }
        AEThread2.setDebug(this.owner);
        try {
            if (USE_MMAP) {
                long remainingInFile = fc.size() - offset;
                long remainingInTargetBuffer = buffer.remaining((byte)4);
                MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, offset, Math.min(remainingInFile, remainingInTargetBuffer));
                buffer.put((byte)4, buf);
            } else {
                fc.position(offset);
                while (fc.position() < fc.size() && buffer.hasRemaining((byte)4)) {
                    buffer.read((byte)4, fc);
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
            throw new FMFileManagerException("read fails", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void read(RandomAccessFile raf, DirectByteBuffer[] buffers, long offset) throws FMFileManagerException {
        if (raf == null) {
            throw new FMFileManagerException("read: raf is null");
        }
        FileChannel fc = raf.getChannel();
        if (!fc.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException("read - file is closed");
        }
        AEThread2.setDebug(this.owner);
        int[] original_positions = new int[buffers.length];
        long read_start = SystemTime.getHighPrecisionCounter();
        try {
            try {
                if (USE_MMAP) {
                    long size = 0L;
                    for (int i = 0; i < buffers.length; size += (long)buffers[i].remaining((byte)4), ++i) {
                        original_positions[i] = buffers[i].position((byte)4);
                    }
                    size = Math.min(size, fc.size() - offset);
                    MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, offset, size);
                    for (DirectByteBuffer b : buffers) {
                        buf.limit(buf.position() + b.remaining((byte)4));
                        b.put((byte)4, buf);
                    }
                } else {
                    fc.position(offset);
                    ByteBuffer[] bbs = new ByteBuffer[buffers.length];
                    Buffer last_bb = null;
                    for (int i = 0; i < bbs.length; ++i) {
                        bbs[i] = buffers[i].getBuffer((byte)4);
                        ByteBuffer bb = bbs[i];
                        original_positions[i] = bb.position();
                        int pos = original_positions[i];
                        if (pos == bb.limit()) continue;
                        last_bb = bbs[i];
                    }
                    if (last_bb != null) {
                        int loop = 0;
                        while (fc.position() < fc.size() && last_bb.hasRemaining()) {
                            long read = fc.read(bbs);
                            if (read > 0L) {
                                loop = 0;
                                continue;
                            }
                            if (++loop == 10) {
                                Debug.out("FMFile::read: zero length read - abandoning");
                                throw new FMFileManagerException("read fails: retry limit exceeded");
                            }
                            try {
                                Thread.sleep(100 * loop);
                            }
                            catch (InterruptedException e) {
                                throw new FMFileManagerException("read fails: interrupted");
                            }
                        }
                    }
                }
                Object var17_25 = null;
            }
            catch (Throwable e) {
                try {
                    Debug.out("Read failed: " + this.owner.getString() + ": raf open=" + raf.getChannel().isOpen() + ", len=" + raf.length() + ",off=" + offset);
                }
                catch (IOException f) {
                    // empty catch block
                }
                Debug.printStackTrace(e);
                if (original_positions == null) throw new FMFileManagerException("read fails", e);
                try {
                    int i = 0;
                    while (i < original_positions.length) {
                        buffers[i].position((byte)4, original_positions[i]);
                        ++i;
                    }
                    throw new FMFileManagerException("read fails", e);
                }
                catch (Throwable e2) {
                    Debug.out(e2);
                }
                throw new FMFileManagerException("read fails", e);
            }
        }
        catch (Throwable throwable) {
            Object var17_26 = null;
            long elapsed_millis = (SystemTime.getHighPrecisionCounter() - read_start) / 1000000L;
            if (elapsed_millis <= 10000L) throw throwable;
            System.out.println("read took " + elapsed_millis + " for " + this.owner.getString());
            throw throwable;
        }
        long elapsed_millis = (SystemTime.getHighPrecisionCounter() - read_start) / 1000000L;
        if (elapsed_millis <= 10000L) return;
        System.out.println("read took " + elapsed_millis + " for " + this.owner.getString());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(RandomAccessFile raf, DirectByteBuffer[] buffers, long position) throws FMFileManagerException {
        if (raf == null) {
            throw new FMFileManagerException("write fails: raf is null");
        }
        FileChannel fc = raf.getChannel();
        if (!fc.isOpen()) {
            Debug.out("FileChannel is closed: " + this.owner.getName());
            throw new FMFileManagerException("read - file is closed");
        }
        AEThread2.setDebug(this.owner);
        int[] original_positions = new int[buffers.length];
        try {
            if (USE_MMAP) {
                long size = 0L;
                for (int i = 0; i < buffers.length; ++i) {
                    size += (long)buffers[i].remaining((byte)4);
                    original_positions[i] = buffers[i].position((byte)4);
                }
                if (position + size > fc.size()) {
                    fc.position(position + size - 1L);
                    fc.write(ByteBuffer.allocate(1));
                    fc.force(true);
                }
                MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_WRITE, position, size);
                for (DirectByteBuffer b : buffers) {
                    buf.put(b.getBuffer((byte)4));
                }
                buf.force();
                return;
            }
            long expected_write = 0L;
            long actual_write = 0L;
            boolean partial_write = false;
            for (int i = 0; i < buffers.length; ++i) {
                expected_write += (long)(buffers[i].limit((byte)4) - buffers[i].position((byte)4));
            }
            fc.position(position);
            ByteBuffer[] bbs = new ByteBuffer[buffers.length];
            Buffer last_bb = null;
            for (int i = 0; i < bbs.length; ++i) {
                bbs[i] = buffers[i].getBuffer((byte)4);
                ByteBuffer bb = bbs[i];
                original_positions[i] = bb.position();
                int pos = original_positions[i];
                if (pos == bb.limit()) continue;
                last_bb = bbs[i];
            }
            if (last_bb != null) {
                int loop = 0;
                while (last_bb.position() != last_bb.limit()) {
                    long written = fc.write(bbs);
                    actual_write += written;
                    if (written > 0L) {
                        loop = 0;
                        if (last_bb.position() == last_bb.limit()) continue;
                        partial_write = true;
                        continue;
                    }
                    if (++loop == 10) {
                        Debug.out("FMFile::write: zero length write - abandoning");
                        throw new FMFileManagerException("write fails: retry limit exceeded");
                    }
                    try {
                        Thread.sleep(100 * loop);
                    }
                    catch (InterruptedException e) {
                        throw new FMFileManagerException("write fails: interrupted");
                    }
                }
            }
            if (expected_write != actual_write) {
                Debug.out("FMFile::write: **** partial write **** failed: expected = " + expected_write + ", actual = " + actual_write);
                throw new FMFileManagerException("write fails: expected write/actual write mismatch");
            }
            if (!partial_write) return;
        }
        catch (Throwable e) {
            if (original_positions == null) throw new FMFileManagerException("write fails", e);
            try {
                for (int i = 0; i < original_positions.length; ++i) {
                    buffers[i].position((byte)4, original_positions[i]);
                }
                throw new FMFileManagerException("write fails", e);
            }
            catch (Throwable e2) {
                Debug.out(e2);
            }
            throw new FMFileManagerException("write fails", e);
        }
    }

    public void flush() throws FMFileManagerException {
    }

    public FMFileImpl getFile() {
        return this.owner;
    }

    public String getString() {
        return "linear";
    }
}

