/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.diskmanager.cache.impl;

import com.aelitis.azureus.core.diskmanager.cache.CacheFile;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManager;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileManagerFactory;
import com.aelitis.azureus.core.diskmanager.cache.CacheFileOwner;
import com.aelitis.azureus.core.diskmanager.cache.impl.CacheFileManagerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.gudy.azureus2.core3.logging.ILogEventListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DirectByteBuffer;
import org.gudy.azureus2.core3.util.DirectByteBufferPool;
import org.gudy.azureus2.core3.util.FileUtil;

public class Test {
    public static void main(String[] args) {
        System.setProperty("azureus.log.stdout", "1");
        Logger.addListener(new ILogEventListener(){

            public void log(LogEvent event2) {
                System.out.println(event2.text);
            }
        });
        try {
            CacheFileManagerImpl manager = (CacheFileManagerImpl)CacheFileManagerFactory.getSingleton();
            manager.initialise(true, true, true, 0xA00000L, 1024L);
            new Test().pieceReorderTest(manager);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pieceReorderTest(CacheFileManagerImpl manager) {
        try {
            long total_size;
            File target_file_or_dir;
            File source_file_or_dir;
            Random random = new Random(0L);
            int num_files = 100;
            int piece_size = 1024;
            int file_size_average = piece_size * 30;
            int chunk_fixed_size = 0;
            int chunk_random_size = 1024;
            int write_order = 2;
            int[] file_sizes = new int[num_files];
            for (int i = 0; i < num_files; ++i) {
                file_sizes[i] = random.nextInt(2 * file_size_average) + 1;
            }
            final File control_dir = new File("C:\\temp\\filetestcontrol");
            FileUtil.recursiveDelete(control_dir);
            control_dir.mkdirs();
            File torrent_file = new File("C:\\temp\\filetest.torrent");
            torrent_file.delete();
            if (num_files == 1) {
                source_file_or_dir = new File("C:\\temp\\filetest1.dat");
                target_file_or_dir = new File("C:\\temp\\filetest2.dat");
                source_file_or_dir.delete();
                target_file_or_dir.delete();
            } else {
                source_file_or_dir = new File("C:\\temp\\filetest1.dir");
                target_file_or_dir = new File("C:\\temp\\filetest2.dir");
                FileUtil.recursiveDelete(source_file_or_dir);
                FileUtil.recursiveDelete(target_file_or_dir);
                source_file_or_dir.mkdirs();
                target_file_or_dir.mkdirs();
            }
            File[] source_files = new File[num_files];
            File[] target_files = new File[num_files];
            RandomAccessFile[] source_file_rafs = new RandomAccessFile[num_files];
            for (int i = 0; i < num_files; ++i) {
                int to_write;
                File target_file;
                File source_file;
                if (num_files == 1) {
                    source_file = source_file_or_dir;
                    target_file = target_file_or_dir;
                } else {
                    source_file = new File(source_file_or_dir, "file" + i);
                    target_file = new File(target_file_or_dir, "file" + i);
                }
                source_files[i] = source_file;
                target_files[i] = target_file;
                FileOutputStream fos = new FileOutputStream(source_file);
                byte[] buffer = new byte[65536];
                for (int rem = file_sizes[i]; rem > 0; rem -= to_write) {
                    random.nextBytes(buffer);
                    to_write = rem > buffer.length ? buffer.length : rem;
                    fos.write(buffer, 0, to_write);
                }
                fos.close();
                source_file_rafs[i] = new RandomAccessFile(source_file, "r");
            }
            TOTorrent torrent = TOTorrentFactory.createFromFileOrDirWithFixedPieceLength(source_file_or_dir, new URL("http://a.b.c/"), piece_size).create();
            final TOTorrentFile[] torrent_files = torrent.getFiles();
            for (int i = 0; i < torrent_files.length; ++i) {
                TOTorrentFile tf = torrent_files[i];
                String rel_path = tf.getRelativePath();
                boolean found = false;
                for (int j = 0; j < source_files.length; ++j) {
                    if (!source_files[j].getName().equals(rel_path)) continue;
                    found = true;
                    if (j == i) break;
                    int temp = file_sizes[i];
                    file_sizes[i] = file_sizes[j];
                    file_sizes[j] = temp;
                    File femp = source_files[i];
                    source_files[i] = source_files[j];
                    source_files[j] = femp;
                    femp = target_files[i];
                    target_files[i] = target_files[j];
                    target_files[j] = femp;
                    RandomAccessFile remp = source_file_rafs[i];
                    source_file_rafs[i] = source_file_rafs[j];
                    source_file_rafs[j] = remp;
                    break;
                }
                if (found) continue;
                Debug.out("eh?");
                return;
            }
            CacheFile[] cache_files = new CacheFile[torrent_files.length];
            for (int i = 0; i < torrent_files.length; ++i) {
                final int f_i = i;
                File target_file = target_files[i];
                final File source_file = source_files[i];
                System.out.println("file " + i + ": e_size=" + file_sizes[i] + ", t_size=" + torrent_files[i].getLength() + ", d_size=" + source_file.length());
                cache_files[i] = manager.createFile(new CacheFileOwner(){

                    public String getCacheFileOwnerName() {
                        return source_file.getAbsolutePath();
                    }

                    public TOTorrentFile getCacheFileTorrentFile() {
                        return torrent_files[f_i];
                    }

                    public File getCacheFileControlFileDir() {
                        return control_dir;
                    }

                    public int getCacheMode() {
                        return 2;
                    }
                }, target_file, 3);
                cache_files[i].setAccessMode(2);
            }
            ArrayList<Chunk> chunks = new ArrayList<Chunk>();
            List[] piece_map = new List[torrent.getNumberOfPieces()];
            long pos = 0L;
            int file_index = 0;
            long file_offset = 0L;
            long rem = total_size = torrent.getSize();
            while (rem > 0L) {
                long chunk_length = chunk_fixed_size != 0 ? (long)chunk_fixed_size : (long)(random.nextInt(chunk_random_size) + 1);
                if (rem < chunk_length) {
                    chunk_length = (int)rem;
                }
                ArrayList<ChunkSlice> slices = new ArrayList<ChunkSlice>();
                Chunk chunk = new Chunk(pos, chunk_length, slices);
                chunks.add(chunk);
                while (chunk_length > 0L) {
                    long file_size = file_sizes[file_index];
                    long file_rem = file_size - file_offset;
                    long avail = Math.min(file_rem, chunk_length);
                    if (avail > 0L) {
                        int piece_start = (int)(pos / (long)piece_size);
                        rem -= avail;
                        int piece_end = (int)(((pos += avail) - 1L) / (long)piece_size);
                        slices.add(new ChunkSlice(file_index, file_offset, avail, piece_start, piece_end));
                    }
                    if ((chunk_length -= avail) > 0L) {
                        file_offset = 0L;
                        ++file_index;
                        continue;
                    }
                    file_offset += avail;
                    break;
                }
                int piece_start = ((ChunkSlice)slices.get(0)).getPieceStart();
                int piece_end = ((ChunkSlice)slices.get(slices.size() - 1)).getPieceEnd();
                for (int i = piece_start; i <= piece_end; ++i) {
                    if (piece_map[i] == null) {
                        piece_map[i] = new ArrayList();
                    }
                    piece_map[i].add(chunk);
                }
                chunk.setPieces(piece_start, piece_end);
                System.out.println(chunk.getString());
            }
            for (int i = 0; i < piece_map.length; ++i) {
                System.out.println(i + ": " + piece_map[i].size());
            }
            while (chunks.size() > 0) {
                Chunk chunk = write_order == 0 ? (Chunk)chunks.remove(0) : (write_order == 1 ? (Chunk)chunks.remove(chunks.size() - 1) : (Chunk)chunks.remove(random.nextInt(chunks.size())));
                System.out.println("Processing chunk " + chunk.getString());
                ArrayList<ChunkSlice> slices = new ArrayList<ChunkSlice>(chunk.getSlices());
                if (write_order == 1) {
                    Collections.reverse(slices);
                }
                for (ChunkSlice slice : slices) {
                    int file_index2 = slice.getFileIndex();
                    long file_offset2 = slice.getFileOffset();
                    long length = slice.getLength();
                    System.out.println("Processing slice " + slice.getString() + "[file size=" + file_sizes[file_index2]);
                    DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)2, (int)length);
                    try {
                        RandomAccessFile raf = source_file_rafs[file_index2];
                        raf.seek(file_offset2);
                        raf.getChannel().read(buffer.getBuffer((byte)1));
                        buffer.flip((byte)1);
                        cache_files[file_index2].write(buffer, file_offset2);
                    }
                    finally {
                        buffer.returnToPool();
                    }
                }
                chunk.setDone();
                int chunk_piece_start = chunk.getPieceStart();
                int chunk_piece_end = chunk.getPieceEnd();
                for (int i = chunk_piece_start; i <= chunk_piece_end; ++i) {
                    List pieces = piece_map[i];
                    boolean complete = true;
                    for (Chunk c : pieces) {
                        if (c.isDone()) continue;
                        complete = false;
                        break;
                    }
                    if (!complete) continue;
                    for (ChunkSlice slice : slices) {
                        int piece_length;
                        if (i < slice.getPieceStart() || i > slice.getPieceEnd()) continue;
                        long piece_offset = i * piece_size;
                        if (i < piece_map.length - 1) {
                            piece_length = piece_size;
                        } else {
                            long total = torrent.getSize();
                            piece_length = (int)(total - total / (long)piece_size * (long)piece_size);
                            if (piece_length == 0) {
                                piece_length = piece_size;
                            }
                        }
                        DirectByteBuffer piece_data = DirectByteBufferPool.getBuffer((byte)2, piece_length);
                        long pos2 = 0L;
                        int file_index3 = 0;
                        int rem2 = piece_length;
                        while (rem2 > 0) {
                            long file_size = file_sizes[file_index3];
                            long file_end = pos2 + file_size;
                            long avail = file_end - piece_offset;
                            if (avail > 0L) {
                                int to_use = (int)Math.min(avail, (long)rem2);
                                long file_offset3 = piece_offset - pos2;
                                int lim = piece_data.limit((byte)2);
                                piece_data.limit((byte)2, piece_data.position((byte)2) + to_use);
                                cache_files[file_index3].read(piece_data, file_offset3, (short)0);
                                piece_data.limit((byte)2, lim);
                                piece_offset += (long)to_use;
                                rem2 -= to_use;
                            }
                            ++file_index3;
                            pos2 += file_size;
                        }
                        try {
                            cache_files[slice.getFileIndex()].setPieceComplete(i, piece_data);
                        }
                        finally {
                            piece_data.returnToPool();
                        }
                    }
                }
            }
            for (int i = 0; i < num_files; ++i) {
                source_file_rafs[i].close();
                cache_files[i].close();
                byte[] buffer1 = new byte[262144];
                byte[] buffer2 = new byte[262144];
                if (source_files[i].length() != target_files[i].length()) {
                    System.err.println("File sizes differ for " + i);
                }
                FileInputStream fis1 = new FileInputStream(source_files[i]);
                FileInputStream fis2 = new FileInputStream(target_files[i]);
                long len = file_sizes[i];
                long pos3 = 0L;
                boolean failed = false;
                while (len > 0L) {
                    int r2;
                    int avail = (int)Math.min(len, (long)buffer1.length);
                    int r1 = fis1.read(buffer1, 0, avail);
                    if (r1 != (r2 = fis2.read(buffer2, 0, avail))) {
                        System.err.println("read lens different: file=" + i + ",pos=" + pos3);
                        failed = true;
                        break;
                    }
                    if (Arrays.equals(buffer1, buffer2)) {
                        len -= (long)r1;
                        pos3 += (long)r1;
                        continue;
                    }
                    int diff_at = -1;
                    for (int j = 0; j < avail; ++j) {
                        if (buffer1[j] == buffer2[j]) continue;
                        diff_at = j;
                        break;
                    }
                    System.err.println("mismatch: file=" + i + ",pos=" + pos3 + " + " + diff_at);
                    failed = true;
                    break;
                }
                if (failed) continue;
                System.out.println("file " + i + ": matched " + pos3 + " of " + file_sizes[i]);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void writeTest(CacheFileManagerImpl manager) {
        try {
            final File f = new File("C:\\temp\\cachetest.dat");
            f.delete();
            CacheFile cf = manager.createFile(new CacheFileOwner(){

                public String getCacheFileOwnerName() {
                    return "file " + f.toString();
                }

                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }

                public File getCacheFileControlFileDir() {
                    return null;
                }

                public int getCacheMode() {
                    return 1;
                }
            }, f, 1);
            cf.setAccessMode(2);
            long start = System.currentTimeMillis();
            int loop = 10000;
            int block = 1024;
            for (int i = 0; i < loop; ++i) {
                DirectByteBuffer buffer = DirectByteBufferPool.getBuffer((byte)2, block);
                cf.writeAndHandoverBuffer(buffer, i * block);
            }
            cf.close();
            long now = System.currentTimeMillis();
            long total = loop * block;
            long elapsed = now - start;
            System.out.println("time = " + elapsed + ", speed = " + total / elapsed);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void manualTest(CacheFileManager manager) {
        try {
            final File f = new File("C:\\temp\\cachetest.dat");
            f.delete();
            CacheFile cf = manager.createFile(new CacheFileOwner(){

                public String getCacheFileOwnerName() {
                    return "file " + f.toString();
                }

                public TOTorrentFile getCacheFileTorrentFile() {
                    return null;
                }

                public File getCacheFileControlFileDir() {
                    return null;
                }

                public int getCacheMode() {
                    return 1;
                }
            }, f, 1);
            DirectByteBuffer write_buffer1 = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer write_buffer2 = DirectByteBufferPool.getBuffer((byte)2, 512);
            DirectByteBuffer write_buffer3 = DirectByteBufferPool.getBuffer((byte)2, 512);
            cf.writeAndHandoverBuffer(write_buffer2, 512L);
            cf.flushCache();
            cf.writeAndHandoverBuffer(write_buffer3, 1024L);
            cf.writeAndHandoverBuffer(write_buffer1, 0L);
            cf.flushCache();
            write_buffer1 = DirectByteBufferPool.getBuffer((byte)2, 512);
            cf.writeAndHandoverBuffer(write_buffer1, 0L);
            cf.flushCache();
            cf.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    public void randomTest(CacheFileManager manager) {
        try {
            CacheFile[] files = new CacheFile[3];
            byte[][] file_data = new byte[3][];
            for (int i = 0; i < files.length; ++i) {
                final int f_i = i;
                file_data[i] = new byte[Test.randomInt(200000)];
                files[i] = manager.createFile(new CacheFileOwner(){

                    public String getCacheFileOwnerName() {
                        return "file" + f_i;
                    }

                    public TOTorrentFile getCacheFileTorrentFile() {
                        return null;
                    }

                    public File getCacheFileControlFileDir() {
                        return null;
                    }

                    public int getCacheMode() {
                        return 1;
                    }
                }, new File("C:\\temp\\cachetest" + i + ".dat"), 1);
                files[i].setAccessMode(2);
                DirectByteBuffer bb = DirectByteBufferPool.getBuffer((byte)2, file_data[i].length);
                bb.put((byte)3, file_data[i]);
                bb.position((byte)3, 0);
                files[i].write(bb, 0L);
            }
            int quanitize_to = 100;
            int quanitize_to_max_consec_write = 1;
            int quanitize_to_max_consec_read = 3;
            for (int x = 0; x < 10000000; ++x) {
                DirectByteBuffer buffer;
                int file_index = Test.randomInt(files.length);
                CacheFile cf = files[file_index];
                byte[] bytes = file_data[file_index];
                int p1 = Test.randomInt(bytes.length);
                int p2 = Test.randomInt(bytes.length);
                if ((p1 = p1 / quanitize_to * quanitize_to) == (p2 = p2 / quanitize_to * quanitize_to)) continue;
                int start = Math.min(p1, p2);
                int len = Math.max(p1, p2) - start;
                int function = Test.randomInt(100);
                if (function < 30) {
                    if (len > quanitize_to * quanitize_to_max_consec_read) {
                        len = quanitize_to * quanitize_to_max_consec_read;
                    }
                    buffer = DirectByteBufferPool.getBuffer((byte)2, len);
                    System.out.println("read:" + start + "/" + len);
                    cf.read(buffer, (long)start, (short)1);
                    buffer.position((byte)3, 0);
                    byte[] data_read = new byte[len];
                    buffer.get((byte)3, data_read);
                    for (int i = 0; i < data_read.length; ++i) {
                        if (data_read[i] == bytes[i + start]) continue;
                        throw new Exception("data read mismatch");
                    }
                    buffer.returnToPool();
                    continue;
                }
                if (function < 80) {
                    if (len > quanitize_to * quanitize_to_max_consec_write) {
                        len = quanitize_to * quanitize_to_max_consec_write;
                    }
                    System.out.println("write:" + start + "/" + len);
                    buffer = DirectByteBufferPool.getBuffer((byte)2, len);
                    for (int i = 0; i < len; ++i) {
                        bytes[start + i] = (byte)Test.randomInt(256);
                        buffer.put((byte)3, bytes[start + i]);
                    }
                    buffer.position((byte)3, 0);
                    cf.writeAndHandoverBuffer(buffer, start);
                    continue;
                }
                if (function < 90) {
                    cf.flushCache();
                    continue;
                }
                if (function >= 91) continue;
                cf.clearCache();
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    static int randomInt(int num) {
        return (int)(Math.random() * (double)num);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class Chunk {
        private long offset;
        private long length;
        private List<ChunkSlice> slices;
        private int piece_start;
        private int piece_end;
        private boolean is_done;

        protected Chunk(long _offset, long _length, List<ChunkSlice> _slices) {
            this.offset = _offset;
            this.length = _length;
            this.slices = _slices;
        }

        protected List<ChunkSlice> getSlices() {
            return this.slices;
        }

        protected void setPieces(int _piece_start, int _piece_end) {
            this.piece_start = _piece_start;
            this.piece_end = _piece_end;
        }

        protected int getPieceStart() {
            return this.piece_start;
        }

        protected int getPieceEnd() {
            return this.piece_end;
        }

        protected void setDone() {
            this.is_done = true;
        }

        protected boolean isDone() {
            return this.is_done;
        }

        protected String getString() {
            String str = "";
            for (ChunkSlice s : this.slices) {
                str = str + (str.length() == 0 ? "" : ",") + s.getString();
            }
            return "offset=" + this.offset + ",length=" + this.length + ",slices={" + str + "}";
        }
    }

    protected static class ChunkSlice {
        private int file_index;
        private long file_offset;
        private long length;
        private int piece_start;
        private int piece_end;

        protected ChunkSlice(int _file_index, long _file_offset, long _length, int _piece_start, int _piece_end) {
            this.file_index = _file_index;
            this.file_offset = _file_offset;
            this.length = _length;
            this.piece_start = _piece_start;
            this.piece_end = _piece_end;
        }

        protected int getFileIndex() {
            return this.file_index;
        }

        protected long getFileOffset() {
            return this.file_offset;
        }

        protected long getLength() {
            return this.length;
        }

        protected int getPieceStart() {
            return this.piece_start;
        }

        protected int getPieceEnd() {
            return this.piece_end;
        }

        protected String getString() {
            return "fi=" + this.file_index + ",fo=" + this.file_offset + ",len=" + this.length + ",ps=" + this.piece_start + ",pe=" + this.piece_end;
        }
    }
}

