/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.dht.transport.udp.impl;

import com.aelitis.azureus.core.dht.transport.DHTTransportContact;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTTransportUDPImpl;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPPacketReply;
import com.aelitis.azureus.core.dht.transport.udp.impl.DHTUDPUtils;
import com.aelitis.azureus.core.dht.transport.udp.impl.packethandler.DHTUDPPacketNetworkHandler;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetSocketAddress;

public class DHTUDPPacketReplyStore
extends DHTUDPPacketReply {
    private byte[] diversify;

    public DHTUDPPacketReplyStore(DHTTransportUDPImpl transport, int trans_id, long conn_id, DHTTransportContact local_contact, DHTTransportContact remote_contact) {
        super(transport, 1027, trans_id, conn_id, local_contact, remote_contact);
    }

    protected DHTUDPPacketReplyStore(DHTUDPPacketNetworkHandler network_handler, InetSocketAddress originator, DataInputStream is, int trans_id) throws IOException {
        super(network_handler, originator, is, 1027, trans_id);
        if (this.getProtocolVersion() >= 6) {
            this.diversify = DHTUDPUtils.deserialiseByteArray(is, 255);
        }
    }

    public void serialise(DataOutputStream os) throws IOException {
        super.serialise(os);
        if (this.getProtocolVersion() >= 6) {
            DHTUDPUtils.serialiseByteArray(os, this.diversify, 255);
        }
    }

    public void setDiversificationTypes(byte[] _diversify) {
        this.diversify = _diversify;
    }

    public byte[] getDiversificationTypes() {
        return this.diversify;
    }
}

