/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.devices.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.Average;
import org.gudy.azureus2.core3.util.Debug;

public abstract class TranscodePipe {
    private final int BUFFER_SIZE = 131072;
    private final int BUFFER_CACHE_SIZE = 393216;
    protected volatile boolean paused;
    protected volatile boolean destroyed;
    protected volatile int bytes_available;
    protected volatile int max_bytes_per_sec;
    protected List<Socket> sockets = new ArrayList<Socket>();
    private ServerSocket server_socket;
    private AEThread2 refiller;
    private LinkedList<bufferCache> buffer_cache = new LinkedList();
    private int buffer_cache_size;
    private Average connection_speed = Average.getInstance(1000, 10);
    private Average write_speed = Average.getInstance(1000, 10);
    private errorListener error_listener;

    protected TranscodePipe(errorListener _error_listener) throws IOException {
        this.error_listener = _error_listener;
        this.server_socket = new ServerSocket(0, 50, InetAddress.getByName("127.0.0.1"));
        new AEThread2("TranscodePipe", true){

            public void run() {
                while (!TranscodePipe.this.destroyed) {
                    try {
                        final Socket socket = TranscodePipe.this.server_socket.accept();
                        TranscodePipe.this.connection_speed.addValue(1L);
                        new AEThread2("TranscodePipe", true){

                            public void run() {
                                TranscodePipe.this.handleSocket(socket);
                            }
                        }.start();
                    }
                    catch (Throwable e) {
                        if (TranscodePipe.this.destroyed) break;
                        TranscodePipe.this.destroy();
                        break;
                    }
                }
            }
        }.start();
    }

    public long getConnectionRate() {
        return this.connection_speed.getAverage();
    }

    public long getWriteSpeed() {
        return this.write_speed.getAverage();
    }

    protected abstract void handleSocket(Socket var1);

    protected void handlePipe(final InputStream is, final OutputStream os) {
        new AEThread2("TranscodePipe:c", true){

            public void run() {
                int BUFFER_SIZE = 131072;
                byte[] buffer = new byte[131072];
                while (!TranscodePipe.this.destroyed) {
                    try {
                        int limit;
                        if (TranscodePipe.this.paused) {
                            Thread.sleep(250L);
                            limit = 1;
                        } else if (TranscodePipe.this.max_bytes_per_sec > 0) {
                            limit = TranscodePipe.this.bytes_available;
                            if (limit <= 0) {
                                Thread.sleep(25L);
                                continue;
                            }
                            limit = Math.min(131072, limit);
                        } else {
                            limit = 131072;
                        }
                        int len = is.read(buffer, 0, limit);
                        if (len <= 0) break;
                        if (TranscodePipe.this.max_bytes_per_sec > 0) {
                            TranscodePipe.this.bytes_available -= len;
                        }
                        os.write(buffer, 0, len);
                        TranscodePipe.this.write_speed.addValue(len);
                    }
                    catch (Throwable e) {
                        // empty catch block
                        break;
                    }
                }
                try {
                    os.flush();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    is.close();
                }
                catch (Throwable e) {
                    // empty catch block
                }
                try {
                    os.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }.start();
    }

    protected RandomAccessFile reserveRAF() throws IOException {
        throw new IOException("Not implemented");
    }

    protected void releaseRAF(RandomAccessFile raf) {
    }

    protected void handleRAF(final OutputStream os, final long position, final long length) {
        new AEThread2("TranscodePipe:c", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                block35: {
                    RandomAccessFile raf = null;
                    raf = TranscodePipe.this.reserveRAF();
                    long pos = position;
                    long rem = length;
                    while (!TranscodePipe.this.destroyed && rem > 0L) {
                        int limit;
                        if (TranscodePipe.this.paused) {
                            Thread.sleep(250L);
                            limit = 1;
                        } else {
                            if (TranscodePipe.this.max_bytes_per_sec > 0) {
                                limit = TranscodePipe.this.bytes_available;
                                if (limit <= 0) {
                                    Thread.sleep(25L);
                                    continue;
                                }
                                limit = Math.min(131072, limit);
                            } else {
                                limit = 131072;
                            }
                            limit = (int)Math.min(rem, (long)limit);
                        }
                        int read_length = 0;
                        int buffer_start = 0;
                        byte[] buffer = null;
                        TranscodePipe transcodePipe = TranscodePipe.this;
                        synchronized (transcodePipe) {
                            bufferCache b;
                            int c_num = 0;
                            Iterator it = TranscodePipe.this.buffer_cache.iterator();
                            while (it.hasNext()) {
                                byte[] data;
                                long avail;
                                b = (bufferCache)it.next();
                                long rel_offset = pos - b.offset;
                                if (rel_offset >= 0L && (avail = (long)(data = b.data).length - rel_offset) > 0L) {
                                    read_length = (int)Math.min(avail, (long)limit);
                                    buffer = data;
                                    buffer_start = (int)rel_offset;
                                    if (c_num <= 0) break;
                                    it.remove();
                                    TranscodePipe.this.buffer_cache.addFirst(b);
                                    break;
                                }
                                ++c_num;
                            }
                            if (buffer == null) {
                                buffer = new byte[limit];
                                raf.seek(pos);
                                read_length = raf.read(buffer);
                                if (read_length != limit) {
                                    Debug.out("eh?");
                                    throw new IOException("Inconsistent");
                                }
                                b = new bufferCache(pos, buffer);
                                TranscodePipe.this.buffer_cache.addFirst(b);
                                TranscodePipe.this.buffer_cache_size += limit;
                                while (TranscodePipe.this.buffer_cache_size > 393216) {
                                    b = (bufferCache)TranscodePipe.this.buffer_cache.removeLast();
                                    TranscodePipe.this.buffer_cache_size -= b.data.length;
                                }
                            }
                        }
                        if (read_length <= 0) break;
                        rem -= (long)read_length;
                        pos += (long)read_length;
                        if (TranscodePipe.this.max_bytes_per_sec > 0) {
                            TranscodePipe.this.bytes_available -= read_length;
                        }
                        os.write(buffer, buffer_start, read_length);
                        TranscodePipe.this.write_speed.addValue(read_length);
                    }
                    os.flush();
                    Object var22_17 = null;
                    try {
                        os.close();
                    }
                    catch (Throwable e2) {
                        // empty catch block
                    }
                    if (raf != null) {
                        TranscodePipe.this.releaseRAF(raf);
                    }
                    break block35;
                    {
                        catch (Throwable e) {
                            if (raf != null) {
                                try {
                                    TranscodePipe transcodePipe = TranscodePipe.this;
                                    synchronized (transcodePipe) {
                                        raf.seek(0L);
                                        raf.read(new byte[1]);
                                    }
                                }
                                catch (Throwable f) {
                                    TranscodePipe.this.reportError(e);
                                }
                            }
                            Object var22_18 = null;
                            try {
                                os.close();
                            }
                            catch (Throwable e2) {
                                // empty catch block
                            }
                            if (raf != null) {
                                TranscodePipe.this.releaseRAF(raf);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var22_19 = null;
                        try {
                            os.close();
                        }
                        catch (Throwable e2) {
                            // empty catch block
                        }
                        if (raf != null) {
                            TranscodePipe.this.releaseRAF(raf);
                        }
                        throw throwable;
                    }
                }
            }
        }.start();
    }

    protected void pause() {
        this.paused = true;
    }

    protected void resume() {
        this.paused = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBytesPerSecond(int max) {
        if (max == this.max_bytes_per_sec) {
            return;
        }
        this.max_bytes_per_sec = max;
        TranscodePipe transcodePipe = this;
        synchronized (transcodePipe) {
            if (this.refiller == null) {
                this.refiller = new AEThread2("refiller", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        int count = 0;
                        while (!TranscodePipe.this.destroyed) {
                            if (TranscodePipe.this.max_bytes_per_sec == 0) {
                                4 var2_2 = this;
                                synchronized (var2_2) {
                                    if (TranscodePipe.this.max_bytes_per_sec == 0) {
                                        TranscodePipe.this.refiller = null;
                                        break;
                                    }
                                }
                            }
                            TranscodePipe.this.bytes_available += TranscodePipe.this.max_bytes_per_sec / 10;
                            if (++count % 10 == 0) {
                                TranscodePipe.this.bytes_available += TranscodePipe.this.max_bytes_per_sec % 10;
                            }
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                                break;
                            }
                        }
                    }
                };
                this.refiller.start();
            }
        }
    }

    protected int getPort() {
        return this.server_socket.getLocalPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean destroy() {
        TranscodePipe transcodePipe = this;
        synchronized (transcodePipe) {
            if (this.destroyed) {
                return false;
            }
            this.destroyed = true;
        }
        for (Socket s : this.sockets) {
            try {
                s.close();
            }
            catch (Throwable throwable) {}
        }
        this.sockets.clear();
        try {
            this.server_socket.close();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return true;
    }

    protected void reportError(Throwable error) {
        if (this.error_listener != null) {
            this.error_listener.error(error);
        } else {
            Debug.out(error);
        }
    }

    private class bufferCache {
        private long offset;
        private byte[] data;

        protected bufferCache(long _offset, byte[] _data) {
            this.offset = _offset;
            this.data = _data;
        }
    }

    protected static interface errorListener {
        public void error(Throwable var1);
    }
}

