/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.core.content;

import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.plugins.download.Download;

public abstract class RelatedContent {
    private final String title;
    private final byte[] hash;
    private final String tracker;
    private final long size;
    private int date;
    private int seeds_leechers;
    private byte content_network;
    private byte[] related_to_hash;

    public RelatedContent(byte[] _related_to_hash, String _title, byte[] _hash, String _tracker, long _size, int _date, int _seeds_leechers, byte _cnet) {
        this.related_to_hash = _related_to_hash;
        this.title = _title;
        this.hash = _hash;
        this.tracker = _tracker;
        this.size = _size;
        this.date = _date;
        this.seeds_leechers = _seeds_leechers;
        this.content_network = _cnet;
    }

    public RelatedContent(String _title, byte[] _hash, String _tracker, long _size, int _date, int _seeds_leechers, byte _cnet) {
        this.title = _title;
        this.hash = _hash;
        this.tracker = _tracker;
        this.size = _size;
        this.date = _date;
        this.seeds_leechers = _seeds_leechers;
        this.content_network = _cnet;
    }

    protected void setRelatedToHash(byte[] h) {
        this.related_to_hash = h;
    }

    public byte[] getRelatedToHash() {
        return this.related_to_hash;
    }

    public abstract Download getRelatedToDownload();

    public String getTitle() {
        return this.title;
    }

    public abstract int getRank();

    public byte[] getHash() {
        return this.hash;
    }

    public abstract int getLevel();

    public abstract boolean isUnread();

    public abstract void setUnread(boolean var1);

    public abstract int getLastSeenSecs();

    public String getTracker() {
        return this.tracker;
    }

    public long getSize() {
        return this.size;
    }

    public long getPublishDate() {
        return (long)(this.date * 60 * 60) * 1000L;
    }

    protected int getDateHours() {
        return this.date;
    }

    protected void setDateHours(int _date) {
        this.date = _date;
    }

    public int getLeechers() {
        if (this.seeds_leechers == -1) {
            return -1;
        }
        return this.seeds_leechers & 0xFFFF;
    }

    public int getSeeds() {
        if (this.seeds_leechers == -1) {
            return -1;
        }
        return this.seeds_leechers >> 16 & 0xFFFF;
    }

    protected int getSeedsLeechers() {
        return this.seeds_leechers;
    }

    protected void setSeedsLeechers(int _sl) {
        this.seeds_leechers = _sl;
    }

    public long getContentNetwork() {
        return (this.content_network & 0xFF) == 255 ? -1L : (long)(this.content_network & 0xFF);
    }

    protected void setContentNetwork(long cnet) {
        this.content_network = (byte)cnet;
    }

    public abstract void delete();

    public String getString() {
        return "title=" + this.title + ", hash=" + (this.hash == null ? "null" : Base32.encode(this.hash)) + ", tracker=" + this.tracker + ", date=" + this.date + ", sl=" + this.seeds_leechers + ", cnet=" + this.content_network;
    }
}

