/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.rating.updater;

import com.aelitis.azureus.plugins.rating.updater.RatingData;

public class RatingResults {
    float averageRating;
    int nbRatings;
    int nbComments = 0;
    StringBuffer comments = new StringBuffer();

    public synchronized void addRating(RatingData rating) {
        if (rating.getScore() > 0) {
            this.averageRating = this.averageRating * (float)this.nbRatings + (float)rating.getScore();
            ++this.nbRatings;
            this.averageRating /= (float)this.nbRatings;
            String comment = rating.getComment();
            if (comment.length() > 0) {
                ++this.nbComments;
                this.comments.append(rating.getNick());
                this.comments.append(" :\n");
                this.comments.append(rating.getScore());
                this.comments.append("/5 . ");
                this.comments.append(rating.getComment());
                this.comments.append("\n====================\n");
            }
        }
    }

    public String getComments() {
        return this.comments.toString();
    }

    public int getAverageScoreRound() {
        return (int)((double)this.averageRating + 0.5);
    }

    public float getRealAverageScore() {
        return this.averageRating;
    }

    public String getAverageScore() {
        int average = (int)(this.averageRating * 10.0f);
        return average / 10 + "." + average % 10;
    }

    public int getNbRatings() {
        return this.nbRatings;
    }

    public int getNbComments() {
        return this.nbComments;
    }

    public void setAverage(float average) {
        this.averageRating = average;
    }
}

