# All paths given relative to ${CMAKE_INSTALL_PREFIX}
if (WIN32)
	set(INSTALL_BINS ".")
	set(INSTALL_LIBS "${INSTALL_LIB_DIR}")
	set(INSTALL_PLUGINS "${INSTALL_LIB_DIR}/plugins")
	set(INSTALL_RESOURCES "${INSTALL_RES_DIR}/resources")
	set(INSTALL_DOCUMENTS ".")
	set(INSTALL_TRANSLATIONS "${INSTALL_RES_DIR}/translations")
	set(INSTALL_INCLUDES "sdk")
elseif (HAIKU)
	set(INSTALL_BINS "${INSTALL_APP_DIR}")
	set(INSTALL_LIBS "${INSTALL_LIB_DIR}")
	set(INSTALL_PLUGINS "${INSTALL_APP_DIR}/plugins")
	set(INSTALL_RESOURCES "${INSTALL_APP_DIR}/resources")
	set(INSTALL_DOCUMENTS "${INSTALL_APP_DIR}/doc")
	set(INSTALL_TRANSLATIONS "${INSTALL_APP_DIR}/translations")
	set(INSTALL_INCLUDES "${INSTALL_APP_DIR}/sdk")
elseif (APPLE)
	set(INSTALL_BINS ".")
	set(INSTALL_LIBS "${INSTALL_APP_DIR}/Contents/${INSTALL_LIB_DIR}")
	set(INSTALL_PLUGINS "${INSTALL_APP_DIR}/Contents/PlugIns")
	set(INSTALL_RESOURCES "${INSTALL_APP_DIR}/Contents/${INSTALL_RES_DIR}")
	set(INSTALL_DOCUMENTS "${INSTALL_APP_DIR}/Contents/${INSTALL_RES_DIR}")
	set(INSTALL_TRANSLATIONS "${INSTALL_APP_DIR}/Contents/${INSTALL_RES_DIR}/translations")
	set(INSTALL_INCLUDES "${INSTALL_APP_DIR}/Contents/${INSTALL_RES_DIR}/include")
elseif (UNIX)
	set(INSTALL_BINS "bin")
	set(INSTALL_LIBS "${INSTALL_LIB_DIR}")
	set(INSTALL_PLUGINS "${INSTALL_LIB_DIR}/${INSTALL_APP_DIR}/plugins")
	set(INSTALL_RESOURCES "${INSTALL_RES_DIR}/${INSTALL_APP_DIR}/resources")
	set(INSTALL_DOCUMENTS "${INSTALL_RES_DIR}/doc/${INSTALL_APP_DIR}")
	set(INSTALL_TRANSLATIONS "${INSTALL_RES_DIR}/${INSTALL_APP_DIR}/translations")
	set(INSTALL_INCLUDES "include/${INSTALL_APP_DIR}")
endif (WIN32)
