/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

static const char rcsid[] = "$Id: sig.c 96 2009-01-20 15:34:19Z loos-br $";

#include <signal.h>
#include "sig.h"

void sig_catch(int sig, void (*f)()) {
    struct sigaction sa;
    sa.sa_handler = f;
    sa.sa_flags = 0;
    sigemptyset(&sa.sa_mask);
    sigaction(sig,&sa,(struct sigaction *) 0);
}

void sig_block(int sig) {
    sigset_t ss;
    sigemptyset(&ss);
    sigaddset(&ss,sig);
    sigprocmask(SIG_BLOCK,&ss,(sigset_t *) 0);
}

void sig_unblock(int sig) {
    sigset_t ss;
    sigemptyset(&ss);
    sigaddset(&ss,sig);
    sigprocmask(SIG_UNBLOCK,&ss,(sigset_t *) 0);
}

void sig_blocknone(void) {
    sigset_t ss;
    sigemptyset(&ss);
    sigprocmask(SIG_SETMASK,&ss,(sigset_t *) 0);
}

void sig_pipeignore(void) { sig_catch(SIGPIPE,SIG_IGN); }
void sig_pipedefault(void) { sig_catch(SIGPIPE,SIG_DFL); }

void sig_miscignore(void) {
    sig_catch(SIGVTALRM,SIG_IGN);
    sig_catch(SIGPROF,SIG_IGN);
    sig_catch(SIGQUIT,SIG_IGN);
    sig_catch(SIGINT,SIG_IGN);
    sig_catch(SIGHUP,SIG_IGN);
#ifdef SIGXCPU
    sig_catch(SIGXCPU,SIG_IGN);
#endif
#ifdef SIGXFSZ
    sig_catch(SIGXFSZ,SIG_IGN);
#endif
}

void sig_alarmblock(void) { sig_block(SIGALRM); }
void sig_alarmunblock(void) { sig_unblock(SIGALRM); }
void sig_alarmcatch(void (*f)()) { sig_catch(SIGALRM,f); }
void sig_alarmdefault(void) { sig_catch(SIGALRM,SIG_DFL); }

void sig_bugcatch(void (*f)()) {
    sig_catch(SIGILL,f);
    sig_catch(SIGABRT,f);
    sig_catch(SIGFPE,f);
    sig_catch(SIGBUS,f);
    sig_catch(SIGSEGV,f);
#ifdef SIGSYS
    sig_catch(SIGSYS,f);
#endif
#ifdef SIGEMT
    sig_catch(SIGEMT,f);
#endif
}

