/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: msn-proxy.h 112 2009-03-15 17:30:28Z loos-br $
 */

#ifndef MSN_PROXY_H
#define MSN_PROXY_H

#define CVR0			0x00000001
#define MSNP8			0x00000002
#define MSNP9			0x00000004
#define MSNP10			0x00000008
#define MSNP11			0x00000010
#define MSNP12			0x00000020
#define MSNP13			0x00000040
#define MSNP14			0x00000080
#define MSNP15			0x00000100
#define MSNP16			0x00000200
#define MSNP17			0x00000400
#define MSNP18			0x00000800
#define UNKNOWN			0xF0000FFF

#define	LAST			0x00001000
#define	FAIL			0x00002000
#define	AGAIN			0x00003000
#define	UPDATE			0x00004000
#define	END			0x00005000
#define	OK			0x00006000
#define	YES			0x00007000
#define	NO			0x00008000
#define	RETURN			0x00009000
#define	DISCONNECT		0x0000a000
#define	SERVER			0x0000b000
#define	CLIENT			0x0000c000
#define PRE_AUTH		0x0000d000
#define USR_TWN_I		0x0000e000
#define USR_TWN_S		0x0000f000
#define CONNECTED		0x00010000
#define SERVER_CMD		0x00020000
#define SERVER_SB_CMD		0x00030000
#define SERVER_PRE_CMD		0x00040000
#define SERVER_POST_CMD		0x00050000
#define SERVER_SB_POST_CMD	0x00060000
#define CLIENT_CMD		0x00070000
#define CLIENT_SB_CMD		0x00080000
#define CLIENT_PRE_CMD		0x00090000
#define CLIENT_POST_CMD		0x000a0000
#define CLIENT_SB_POST_CMD	0x000b0000
#define HEADER                  0x000c0000
#define VALUE			0x000d0000
#define BODY			0x000e0000
#define START_VALUE		0x000f0000
#define TYPE_P2P		0x00100000
#define TYPE_TEXTUTF8		0x00200000
#define TYPE_MSGSCONTROL	0x00300000
#define TYPE_CLIENTCAPS		0x00400000
#define TYPE_DATACAST		0x00500000
#define TYPE_FILETRANSF		0x00600000
#define	TYPE_EMOTICON		0x00700000
#define	TYPE_KEEPALIVE		0x00800000
#define NEW			0x00900000
#define NONE			0x00a00000
#define INFO			0x00b00000

#define P2P_INVITING		0x00000800
#define P2P_COMPLETE		0x00000900

#define	FL			0x00000001
#define AL			0x00000002
#define	BL			0x00000004
#define RL			0x00000008
#define PL			0x00000010

#define P2P_ACK			0x00000002
#define P2P_FILE		0x00002000

#ifndef MSNPROXY_VERSION
#define MSNPROXY_VERSION	"0.7a"
#endif

#ifndef MSNPROXY_RELEASE
#define MSNPROXY_RELEASE	"$Id: msn-proxy.h 112 2009-03-15 17:30:28Z loos-br $"
#endif

#ifndef MAX_BUF
#define MAX_BUF			1024
#endif

#ifndef LOG_IDENT
#define LOG_IDENT		"msn-proxy"
#endif

#ifndef MSNPROXYCTL
#define MSNPROXYCTL		"/var/run/msn-proxy.ctl"
#endif

#include "config.h"
#include "syslog.h"

void	die_nomem(void);
void	die_err(char *msg);
void 	die_bug(void);
void	die_suc(char *msg);
void	cleanup(void);
void	sigdie(void);

extern config_		config;

#endif
