/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: contacts-data.h 102 2009-02-05 18:37:40Z loos-br $
 */

#ifndef CONTACTS_DATA_H
#define CONTACTS_DATA_H

#include "string.h"

struct contact_ {
    RB_ENTRY(contact_)	contact__;	/* RB list contact data */

    int			chat;		/* has chat ? (yes/no) */
    int			updated;	/* saved in db */
    string		status;		/* status */
    string		group;		/* group */
    string		info;		/* general info */
    string		uid;		/* uid */
    string		dn;		/* display name */
    string		c;		/* email */
    string		o;		/* object */
    unsigned long	deny;		/* commands and data */
    unsigned long	lists;		/* lists information */
    struct contact_	*save;		/* update data */
    unsigned long long	flags;		/* client flags */
    unsigned long long	flags2;		/* client flags */
};

struct contacts {
    struct contact_	*rbh_root;	/* root of the tree */
};

#endif

