/*
 * Copyright (c) 2004-2009, Luiz Otavio O Souza <loos.br@gmail.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * $Id: check-cmd.h 96 2009-01-20 15:34:19Z loos-br $
 */

#ifndef CHECK_CMD_H
#define CHECK_CMD_H

typedef struct {
    char	*cmd;
    int		args;
    int		(*func)(struct user_ *user, command *cmd, int args);
} CMD;

typedef struct {
    __uint32_t		type;
    char		*label;
    CMD			*cmd;
} CMDS_;

typedef struct {
    char	*cmd;
    int		args;
    int		(*func)(struct sb_ *sb, command *cmd, int args);
} SBCMD;

typedef struct {
    __uint32_t		type;
    char		*label;
    SBCMD		*sbcmd;
} SBCMDS_;

int check_ok(struct user_ *user, command *cmd, int args);
int check_cmd(struct user_ *user, command *cmd, int type);
int check_sb_cmd(struct sb_ *sb, command *cmd, int type);
int check_args(struct user_ *user, command *cmd, int args);
int check_sb_args(struct sb_ *sb, command *cmd, int args);

#endif
