dnl matlabarch.m4 --- check for Matlab machine architecture.
dnl
dnl Copyright (C) 2002, 2003 Ralph Schleicher
dnl
dnl This program is free software; you can redistribute it and/or
dnl modify it under the terms of the GNU General Public License as
dnl published by the Free Software Foundation; either version 2,
dnl or (at your option) any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; see the file COPYING.  If not, write to
dnl the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
dnl Boston, MA 02111-1307, USA.
dnl
dnl As a special exception to the GNU General Public License, if
dnl you distribute this file as part of a program that contains a
dnl configuration script generated by GNU Autoconf, you may include
dnl it under the same distribution terms that you use for the rest
dnl of that program.
dnl
dnl Code:

# AX_MATLAB_ARCH
# --------------
# Check for Matlab machine architecture.
AC_DEFUN([AX_MATLAB_ARCH],
[dnl
AC_PREREQ([2.50])
AC_REQUIRE([AX_MEXEXT])
AC_CACHE_CHECK([for Matlab machine architecture], [ax_cv_matlab_arch],
[if test "${MATLAB_ARCH+set}" = set ; then
    ax_cv_matlab_arch="$MATLAB_ARCH"
else
    case $MEXEXT in
      dll)
	ax_cv_matlab_arch=win32
	;;
      mex)
	ax_cv_matlab_arch=mac
	;;
      mexmaci)
	ax_cv_matlab_arch=mexmaci
	;;
      mexaxp)
	ax_cv_matlab_arch=alpha
	;;
      mexglx)
	ax_cv_matlab_arch=glnx86
	;;
      mexhp7)
	ax_cv_matlab_arch=hp700
	;;
      mexhpux)
	ax_cv_matlab_arch=hpux
	;;
      mexrs6)
	ax_cv_matlab_arch=ibm_rs
	;;
      mexsg)
	ax_cv_matlab_arch=sgi
	;;
      mexsol)
	ax_cv_matlab_arch=sol2
	;;
      mexa64)
        ax_cv_matlab_arch=glnxa64  
        ;;
      *)
	ax_cv_matlab_arch=unknown
	;;
    esac
fi])
MATLAB_ARCH="$ax_cv_matlab_arch"
AC_SUBST([MATLAB_ARCH])
])

dnl matlabarch.m4 ends here
