# How to Keep IcedCoffeeScript Up-to-Date with Mainline CoffeeScript

## Source

### Current Method: Fork/Merge

Here is the current system:

1. Add a remote upstream repo to pull in the mainline changes:
```sh
git remote add upstream git@github.com:jashkenas/coffee-script
```

1. Pull from the upstream into our master branch; push to our own origin/master while we are at it.
```sh
git checkout master
git pull upstream master
git push origin master
```

1. Make sure the local `iced2` branch is up-to-date:
```sh
git checkout iced2
git pull origin iced2
```

1. Then do the merge:
```sh
git merge master
```

1. Then, once the rebase has succeeded:
     a. Update the version number of `package.json`
     a. Update the version number in `src/coffee-script.coffee`

1. Then build a million different times:
```sh
./bin/cake build
./bin/cake build:parser
./bin/cake build
./bin/cake build
./bin/cake build:browser
./bin/cake test
```

1. You're good to push if it all looks good. First commit all the new changes post-rebase with:
```sh
git commit -a
```

1. Then do a push to the *<b>iced2</b>* branch.
```sh
git push origin iced2
```

1. Make and push a new tag (supplying whatever your new version is):
```
git tag -a -m vbump 1.6.2c
git push --tags
```

1. Finally, publish to npm.  It's usually worth cloning out a fresh
copy from github, and then running:
```sh
npm publish
```

## Documentation

The documentation system is totally separate.  Here is the general idea:

1. Make sure the *iced* branch is up-to-date:
```sh
git checkout iced2
git pull origin iced2
```

1. Checkout and update the *gh-pages* branch:
```sh
git checkout gh-pages
git pull origin gh-pages
```

1. Then do the merge:
```sh
git merge iced2
```

1. This will destroy you with conflicts, but most of them can be worked
through.  Basically, you want to call `theirs`, as below, on everything
*<b>but</b>* the `documentation/index.html.erb` file.

1. Edit `documentation/index.html.erb` by hand, changing the current version
number to whatever it is nowadays.

1. Rebuild the documentation like `index.html` and the
embedded examples.
```sh
rake doc
```

1. Run `docco` on the source files:
```sh
icake doc:source
```

1. Commit everything:
```sh
git commit -a
```

1. And push
```sh
git push origin gh-pages
```

1. Test that the `run` button still works on the front page, and that the
sandbox is still operational.

#### To Accept Their Changes

I wrote a little shell script called `theirs`:

```bash
#!/bin/sh

git checkout --theirs $*
git add $* 
```

I run this on any *autogenerated* file that has a
conflict.  For instance, those files in `lib/coffee-script/` 
or `documentation/js`.  For conflicts in `package.json`, `Cakefile`
or `src/`, you probably need to do a hand-merge.


