// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Base, Command, add_option_dict, env, iced, log, make_esc, path, path_eq, path_join, rewrite, run, strip, version_info, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  version_info = require('../version').version_info;

  run = require('iced-spawn').run;

  path = require('path');

  env = require('../env').env;

  make_esc = require('iced-error').make_esc;

  rewrite = function(s) {
    return s.replace(/-/g, "_");
  };

  path_eq = function(a, b) {
    var e, i, _i, _len;
    if (a.length !== b.length) {
      return false;
    }
    for (i = _i = 0, _len = a.length; _i < _len; i = ++_i) {
      e = a[i];
      if (e !== b[i]) {
        return false;
      }
    }
    return true;
  };

  path_join = function(arr) {
    var res, _ref;
    res = path.join.apply(path, arr);
    if (((_ref = arr[0]) != null ? _ref.length : void 0) === 0) {
      res = path.sep + res;
    }
    return res;
  };

  strip = function(s) {
    var m;
    if ((m = s.match(/(\S+)/))) {
      return m[1];
    } else {
      return s;
    }
  };

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      n: {
        alias: "npm",
        help: "an alternate path for NPM"
      },
      u: {
        alias: "url",
        help: "specify a URL prefix for fetching"
      },
      C: {
        alias: "skip-cleanup",
        action: "storeTrue",
        help: "Don't cleanup temporary stuff after install"
      },
      c: {
        alias: "cmd",
        help: "the command to run"
      },
      p: {
        alias: "prefix",
        help: "the prefix to install to"
      },
      g: {
        alias: 'global',
        help: "install globally; don't try to guess prefix",
        action: "storeTrue"
      }
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        aliases: [],
        help: "update the keybase client software"
      };
      name = "update";
      sub = scp.addParser(name, opts);
      add_option_dict(sub, this.OPTS);
      return opts.aliases.concat([name]);
    };

    Command.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      log.debug("+ Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
            funcname: "Command.run"
          });
          _this.tweak_path(esc(__iced_deferrals.defer({
            lineno: 76
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
              funcname: "Command.run"
            });
            _this.probe_npm(esc(__iced_deferrals.defer({
              lineno: 77
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
                funcname: "Command.run"
              });
              _this.probe_installer(esc(__iced_deferrals.defer({
                lineno: 78
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
                  funcname: "Command.run"
                });
                _this.compute_prefix(esc(__iced_deferrals.defer({
                  lineno: 79
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
                    funcname: "Command.run"
                  });
                  _this.run_install(esc(__iced_deferrals.defer({
                    lineno: 80
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  log.debug("- Command::run");
                  return cb(null);
                });
              });
            });
          });
        };
      })(this));
    };

    Command.prototype.npm = function(args, cb) {
      var err, name, out, p, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      name = this.argv.npm || "npm";
      if ((p = this.argv.prefix) != null) {
        args = ["--prefix", p].concat(args);
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
            funcname: "Command.npm"
          });
          run({
            name: name,
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 90
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, out);
        };
      })(this));
    };

    Command.prototype.kbi = function(_arg, cb) {
      var args, err, name, out, verbose, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      args = _arg.args, verbose = _arg.verbose;
      name = this.argv.cmd || "keybase-installer";
      if (verbose) {
        log.info("Running `" + name + " " + (args.join(' ')) + "`");
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
            funcname: "Command.kbi"
          });
          run({
            name: name,
            args: args
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 98
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err, out, name);
        };
      })(this));
    };

    Command.prototype.probe_installer = function(cb) {
      var err, name, vers, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
            funcname: "Command.probe_installer"
          });
          _this.kbi({
            args: ["--version"]
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                vers = arguments[1];
                return name = arguments[2];
              };
            })(),
            lineno: 104
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            err = new Error("Can't find `" + name + "` in your path: " + err.message);
          } else {
            log.info("Found keybase-installer: " + vers);
          }
          return cb(err);
        };
      })(this));
    };

    Command.prototype.probe_npm = function(cb) {
      var err, ret, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
            funcname: "Command.probe_npm"
          });
          _this.npm(["config", "get", "prefix"], __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return ret = arguments[1];
              };
            })(),
            lineno: 116
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          if (typeof err !== "undefined" && err !== null) {
            err = new Error("Can't launch `npm`: " + err.message);
          } else {
            _this.npm_install_prefix = strip(ret.toString('utf8'));
            log.info("Computed npm install prefix: " + _this.npm_install_prefix);
          }
          return cb(err);
        };
      })(this));
    };

    Command.prototype.compute_prefix = function(cb) {
      var implicit_path, _ref;
      if (this.argv.prefix) {
        this.prefix = this.argv.prefix;
      } else if (((_ref = process.env.PREFIX) != null ? _ref.length : void 0)) {

      } else if ((((implicit_path = this.my_bindir.split(path.sep)).pop() === 'bin') && !(path_eq(this.npm_install_prefix.split(path.sep), implicit_path))) && !this.argv.global) {
        this.prefix = path_join(implicit_path);
        log.info("Detected custom path '" + this.prefix + "'; preserving it!");
      } else {
        log.info("Using default npm install prefix");
      }
      return cb(null);
    };

    Command.prototype.tweak_path = function(cb) {
      this.my_bindir = path.dirname(process.argv[1]);
      process.env.path = [this.my_bindir, process.env.path].join(":");
      return cb(null);
    };

    Command.prototype.run_install = function(cb) {
      var a, args, err, g, out, v, ___iced_passed_deferral, __iced_deferrals, __iced_k, _i, _j, _len, _len1, _ref, _ref1;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      log.info("Attempting software upgrade.....");
      args = [];
      if ((g = env().get_gpg_cmd()) != null) {
        args.push("-g", g);
      }
      if (env().get_no_gpg_options()) {
        args.push("-O");
      }
      if (env().get_debug()) {
        args.push("-d");
      }
      if (this.prefix != null) {
        args.push("--prefix", this.prefix);
      }
      _ref = ["npm", "url"];
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        a = _ref[_i];
        if ((v = this.argv[rewrite(a)]) != null) {
          args.push("--" + a, v);
        }
      }
      _ref1 = ["skip-cleanup"];
      for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
        a = _ref1[_j];
        if ((v = this.argv[rewrite(a)])) {
          args.push("--" + a);
        }
      }
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/update.iced",
            funcname: "Command.run_install"
          });
          _this.kbi({
            args: args,
            verbose: true
          }, __iced_deferrals.defer({
            assign_fn: (function() {
              return function() {
                err = arguments[0];
                return out = arguments[1];
              };
            })(),
            lineno: 169
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
