// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Base, Command, E, PackageJson, RevokeProofSigGen, S, ST, User, add_option_dict, assert, constants, iced, log, make_esc, prompt_yn, proofs, req, session, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  PackageJson = require('../package').PackageJson;

  E = require('../err').E;

  make_esc = require('iced-error').make_esc;

  prompt_yn = require('../prompter').prompt_yn;

  RevokeProofSigGen = require('../sigs').RevokeProofSigGen;

  User = require('../user').User;

  req = require('../req').req;

  assert = require('assert');

  session = require('../session');

  S = require('../services');

  constants = require('../constants').constants;

  ST = constants.signature_types;

  prompt_yn = require('../prompter').prompt_yn;

  proofs = require('keybase-proofs');

  assert = require('assert');

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      q: {
        alias: 'seqno',
        action: 'storeTrue',
        help: 'specify signature as a sequence number'
      }
    };

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.needs_configuration = function() {
      return true;
    };

    Command.prototype.parse_args = function(cb) {
      var err, key;
      key = this.argv.sig[0];
      err = null;
      if (this.argv.seqno) {
        if (key.match(/^\d+$/)) {
          this.seqno = parseInt(key, 10);
        } else {
          err = new E.ArgsError("bad integer: " + key);
        }
      } else if (!key.match(/^[A-Fa-f0-9]+$/)) {
        err = new E.ArgsError("bad signature ID: " + key);
      } else if (key.length < 4) {
        err = new E.ArgsError("bad signature ID " + key + "; must provide at least a 4-char prefix");
      } else {
        this.sig_id = key.toLowerCase();
      }
      return cb(err);
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        help: "revoke a proof or signature",
        aliases: ["revoke-sig"]
      };
      name = "revoke-signatures";
      sub = scp.addParser(name, opts);
      sub.addArgument(["sig"], {
        nargs: 1,
        help: "the ID or seqno of the sig the revoke"
      });
      add_option_dict(sub, this.OPTS);
      return [name].concat(opts.aliases);
    };

    Command.prototype.allocate_proof_gen = function(cb) {
      var err, klass, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      klass = RevokeProofSigGen;
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/revoke_sig.iced",
            funcname: "Command.allocate_proof_gen"
          });
          _this.me.gen_remote_proof_gen({
            klass: klass,
            sig_id: _this.sig_id
          }, __iced_deferrals.defer({
            assign_fn: (function(__slot_1) {
              return function() {
                err = arguments[0];
                return __slot_1.gen = arguments[1];
              };
            })(_this),
            lineno: 69
          }));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          return cb(err);
        };
      })(this));
    };

    Command.prototype.find_sig_by_prefix = function(p) {
      var err, found, k, v, _ref;
      found = null;
      err = null;
      _ref = this.me.sig_chain.index;
      for (k in _ref) {
        v = _ref[k];
        if (k.indexOf(p) !== 0) {

        } else if (found != null) {
          err = new E.DuplicateError("Key '" + p + "' matches more than one signature");
          found = null;
          break;
        } else {
          found = v;
        }
      }
      return [err, found];
    };

    Command.prototype.find_sig = function(cb) {
      var err, key, sig, _ref;
      key = this.argv.sig[0];
      if (this.seqno) {
        sig = this.me.sig_chain.seq[this.seqno];
      } else {
        _ref = this.find_sig_by_prefix(this.sig_id), err = _ref[0], sig = _ref[1];
      }
      err = err != null ? err : sig == null ? new E.NotFoundError("Signature not found (key=" + key + ")") : sig.is_revoked() ? new E.RevokedError("Signature already revoked") : !sig.is_revocable() ? new E.RevokeError("signature is not revocable") : null;
      if (err == null) {
        this.sig_id = sig.sig_id();
      }
      return cb(err);
    };

    Command.prototype.run = function(cb) {
      var esc, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/revoke_sig.iced",
            funcname: "Command.run"
          });
          _this.parse_args(esc(__iced_deferrals.defer({
            lineno: 105
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            __iced_deferrals = new iced.Deferrals(__iced_k, {
              parent: ___iced_passed_deferral,
              filename: "/Users/max/src/keybase/node-client/src/command/revoke_sig.iced",
              funcname: "Command.run"
            });
            session.login(esc(__iced_deferrals.defer({
              lineno: 106
            })));
            __iced_deferrals._fulfill();
          })(function() {
            (function(__iced_k) {
              __iced_deferrals = new iced.Deferrals(__iced_k, {
                parent: ___iced_passed_deferral,
                filename: "/Users/max/src/keybase/node-client/src/command/revoke_sig.iced",
                funcname: "Command.run"
              });
              User.load_me({
                secret: true,
                verify_opts: {
                  show_perm_failures: true
                }
              }, esc(__iced_deferrals.defer({
                assign_fn: (function(__slot_1) {
                  return function() {
                    return __slot_1.me = arguments[0];
                  };
                })(_this),
                lineno: 107
              })));
              __iced_deferrals._fulfill();
            })(function() {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/command/revoke_sig.iced",
                  funcname: "Command.run"
                });
                _this.find_sig(esc(__iced_deferrals.defer({
                  lineno: 108
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/command/revoke_sig.iced",
                    funcname: "Command.run"
                  });
                  _this.allocate_proof_gen(esc(__iced_deferrals.defer({
                    lineno: 109
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  (function(__iced_k) {
                    __iced_deferrals = new iced.Deferrals(__iced_k, {
                      parent: ___iced_passed_deferral,
                      filename: "/Users/max/src/keybase/node-client/src/command/revoke_sig.iced",
                      funcname: "Command.run"
                    });
                    _this.gen.run(esc(__iced_deferrals.defer({
                      lineno: 110
                    })));
                    __iced_deferrals._fulfill();
                  })(function() {
                    log.info("Success!");
                    return cb(null);
                  });
                });
              });
            });
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
