// Generated by IcedCoffeeScript 1.7.1-c
(function() {
  var ArgumentParser, Base, Command, E, PackageJson, User, add_option_dict, env, format_fingerprint, iced, log, make_esc, session, util, __iced_k, __iced_k_noop,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor(); child.__super__ = parent.prototype; return child; };

  iced = require('iced-runtime').iced;
  __iced_k = __iced_k_noop = function() {};

  Base = require('./base').Base;

  log = require('../log');

  ArgumentParser = require('argparse').ArgumentParser;

  add_option_dict = require('./argparse').add_option_dict;

  PackageJson = require('../package').PackageJson;

  session = require('../session').session;

  make_esc = require('iced-error').make_esc;

  env = require('../env').env;

  log = require('../log');

  User = require('../user').User;

  format_fingerprint = require('pgp-utils').util.format_fingerprint;

  util = require('util');

  E = require('../err').E;

  exports.Command = Command = (function(_super) {
    __extends(Command, _super);

    function Command() {
      return Command.__super__.constructor.apply(this, arguments);
    }

    Command.prototype.OPTS = {
      v: {
        alias: 'verbose',
        action: 'storeTrue',
        help: 'a full dump, with more gory details'
      },
      j: {
        alias: 'json',
        action: 'storeTrue',
        help: 'output in json format; default is simple text list'
      }
    };

    Command.prototype.use_session = function() {
      return true;
    };

    Command.prototype.needs_configuration = function() {
      return true;
    };

    Command.prototype.add_subcommand_parser = function(scp) {
      var name, opts, sub;
      opts = {
        help: "list people you are tracking",
        aliases: []
      };
      name = "list-tracking";
      sub = scp.addParser(name, opts);
      sub.addArgument(["filter"], {
        nargs: '?',
        help: "a regex to filter by"
      });
      add_option_dict(sub, this.OPTS);
      return [name].concat(opts.aliases);
    };

    Command.prototype.sort_list = function(v) {
      var k, out, pj, sort_fn, val, _i, _len, _ref;
      sort_fn = function(a, b) {
        a = ("" + a).toLowerCase();
        b = ("" + b).toLowerCase();
        if (a < b) {
          return -1;
        } else if (a > b) {
          return 1;
        } else {
          return 0;
        }
      };
      if (v == null) {
        return {};
      } else {
        v = (function() {
          var _i, _len, _results;
          _results = [];
          for (_i = 0, _len = v.length; _i < _len; _i++) {
            pj = v[_i];
            _results.push([pj.body.track.basics.username, pj]);
          }
          return _results;
        })();
        v.sort(sort_fn);
        out = {};
        for (_i = 0, _len = v.length; _i < _len; _i++) {
          _ref = v[_i], k = _ref[0], val = _ref[1];
          out[k] = val;
        }
        return out;
      }
    };

    Command.prototype.condense_record = function(o) {
      var out, proofs, rp, rps, v, _ref;
      if ((rps = o.body.track.remote_proofs) == null) {
        rps = [];
      }
      proofs = (function() {
        var _i, _len, _ref, _results;
        _results = [];
        for (_i = 0, _len = rps.length; _i < _len; _i++) {
          rp = rps[_i];
          if ((v = rp != null ? (_ref = rp.remote_key_proof) != null ? _ref.check_data_json : void 0 : void 0)) {
            _results.push(v);
          }
        }
        return _results;
      })();
      out = {
        uid: o.body.track.id,
        key: (_ref = o.body.track.key.key_fingerprint) != null ? _ref.toUpperCase() : void 0,
        proofs: proofs,
        ctime: o.ctime
      };
      return out;
    };

    Command.prototype.condense_records = function(d) {
      var k, out, v;
      out = {};
      for (k in d) {
        v = d[k];
        out[k] = this.condense_record(v);
      }
      return out;
    };

    Command.prototype.display_json = function(d) {
      if (!this.argv.verbose) {
        d = this.condense_records(d);
      }
      return JSON.stringify(d, null, "  ");
    };

    Command.prototype.display = function(v) {
      if (this.argv.json) {
        return this.display_json(v);
      } else {
        return this.display_text(v);
      }
    };

    Command.prototype.display_text_line = function(k, v) {
      var fields, p, proofs, _i, _len, _ref;
      fields = [k];
      if (this.argv.verbose) {
        fields.push(v.key, v.ctime);
        proofs = [];
        _ref = v.proofs;
        for (_i = 0, _len = _ref.length; _i < _len; _i++) {
          p = _ref[_i];
          if ((p.name != null) && (p.username != null)) {
            proofs.push("" + p.name + ":" + p.username);
          }
        }
        proofs.sort();
        fields = fields.concat(proofs);
      }
      return fields.join("\t");
    };

    Command.prototype.display_text = function(d) {
      var k, lines, v;
      d = this.condense_records(d);
      lines = (function() {
        var _results;
        _results = [];
        for (k in d) {
          v = d[k];
          _results.push(this.display_text_line(k, v));
        }
        return _results;
      }).call(this);
      return lines.join("\n");
    };

    Command.prototype.filter_list = function(d) {
      var cd, k, out, proof, rps, v, _i, _len, _ref, _ref1, _ref2, _ref3, _ref4;
      if (this.filter_rxx != null) {
        out = {};
        for (k in d) {
          v = d[k];
          if (k.match(this.filter_rxx)) {
            out[k] = v;
          } else if ((rps = (_ref = v.body) != null ? (_ref1 = _ref.track) != null ? _ref1.remote_proofs : void 0 : void 0) != null) {
            for (_i = 0, _len = rps.length; _i < _len; _i++) {
              proof = rps[_i];
              if ((cd = proof != null ? (_ref2 = proof.remote_key_proof) != null ? _ref2.check_data_json : void 0 : void 0) != null) {
                if (((_ref3 = cd.username) != null ? _ref3.match(this.filter_rxx) : void 0) || ((_ref4 = cd.hostname) != null ? _ref4.match(this.filter_rxx) : void 0)) {
                  out[k] = v;
                  break;
                }
              }
            }
          }
        }
        d = out;
      }
      return d;
    };

    Command.prototype.parse_filter = function(cb) {
      var e, err, f;
      err = null;
      if (((f = this.argv.filter) != null) && f.length) {
        try {
          this.filter_rxx = new RegExp(f, "i");
        } catch (_error) {
          e = _error;
          err = new E.ArgsError("Bad regex specified: " + e.message);
        }
      }
      return cb(err);
    };

    Command.prototype.run = function(cb) {
      var esc, list, logged_in, me, un, ___iced_passed_deferral, __iced_deferrals, __iced_k;
      __iced_k = __iced_k_noop;
      ___iced_passed_deferral = iced.findDeferral(arguments);
      esc = make_esc(cb, "Command::run");
      (function(_this) {
        return (function(__iced_k) {
          __iced_deferrals = new iced.Deferrals(__iced_k, {
            parent: ___iced_passed_deferral,
            filename: "/Users/max/src/keybase/node-client/src/command/list_tracking.iced",
            funcname: "Command.run"
          });
          _this.parse_filter(esc(__iced_deferrals.defer({
            lineno: 153
          })));
          __iced_deferrals._fulfill();
        });
      })(this)((function(_this) {
        return function() {
          (function(__iced_k) {
            if ((un = env().get_username()) != null) {
              (function(__iced_k) {
                __iced_deferrals = new iced.Deferrals(__iced_k, {
                  parent: ___iced_passed_deferral,
                  filename: "/Users/max/src/keybase/node-client/src/command/list_tracking.iced",
                  funcname: "Command.run"
                });
                session.check(esc(__iced_deferrals.defer({
                  assign_fn: (function() {
                    return function() {
                      return logged_in = arguments[0];
                    };
                  })(),
                  lineno: 156
                })));
                __iced_deferrals._fulfill();
              })(function() {
                (function(__iced_k) {
                  __iced_deferrals = new iced.Deferrals(__iced_k, {
                    parent: ___iced_passed_deferral,
                    filename: "/Users/max/src/keybase/node-client/src/command/list_tracking.iced",
                    funcname: "Command.run"
                  });
                  User.load_me({
                    secret: false
                  }, esc(__iced_deferrals.defer({
                    assign_fn: (function() {
                      return function() {
                        return me = arguments[0];
                      };
                    })(),
                    lineno: 157
                  })));
                  __iced_deferrals._fulfill();
                })(function() {
                  list = _this.sort_list(me.list_trackees());
                  list = _this.filter_list(list);
                  return __iced_k(log.console.log(_this.display(list)));
                });
              });
            } else {
              return __iced_k(log.warn("Not logged in"));
            }
          })(function() {
            return cb(null);
          });
        };
      })(this));
    };

    return Command;

  })(Base);

}).call(this);
