/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api.listeners;

import com.ircclouds.irc.api.Callback;
import com.ircclouds.irc.api.IRCException;
import com.ircclouds.irc.api.domain.messages.ServerNumericMessage;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

public class AsyncMessageListener {
    private static final List<Integer> NUMERICS = Arrays.asList(401, 404);
    private Queue<AsyncTriple> myQueue = new LinkedList<AsyncTriple>();

    public void onServerMsg(ServerNumericMessage aMsg) {
        if (NUMERICS.contains(aMsg.getNumericCode())) {
            String aText = aMsg.getText();
            String[] cmpnts = aText.split(" :");
            AsyncTriple _aTrip = this.myQueue.peek();
            if (_aTrip != null) {
                if (_aTrip.asyncId.equals(cmpnts[0])) {
                    _aTrip = this.myQueue.poll();
                    if (!_aTrip.flag) {
                        _aTrip.callback.onSuccess("OK");
                    }
                } else {
                    _aTrip.callback.onFailure(new IRCException(aText));
                    _aTrip.flag = true;
                }
            }
        }
    }

    public void submit(int aAsyncId, Callback<String> aCallback) {
        this.myQueue.add(new AsyncTriple(aAsyncId + "", aCallback));
    }

    private class AsyncTriple {
        private String asyncId;
        private Callback<String> callback;
        private boolean flag;

        public AsyncTriple(String aSyncId, Callback<String> aCb) {
            this.asyncId = aSyncId;
            this.callback = aCb;
        }
    }
}

