/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.net;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jml.net.Message;
import net.sf.jml.net.MessageRecognizer;
import net.sf.jml.net.SessionListener;
import net.sf.jml.util.ByteBufferUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Session {
    private static final Log logger = LogFactory.getLog(Session.class);
    private final Collection<SessionListener> sessionListeners = new CopyOnWriteArrayList<SessionListener>();
    private Socket socket = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean isStarted = false;
    private SocketAddress socketAddress = null;
    private Object attachment = null;
    private MessageRecognizer messagerecognizer = null;
    private boolean isClosing = false;
    private boolean isAvailable = false;
    private MsgSender msgSender = null;
    private MsgDispatcher msgDispatcher = null;
    private Timer timoutTimer = null;

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocketAddress(SocketAddress socketaddress) throws IllegalStateException {
        if (this.isStarted) {
            throw new IllegalStateException("can't set socket address after session started");
        }
        this.socketAddress = socketaddress;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public void setAttachment(Object o) {
        this.attachment = o;
    }

    public void setMessageRecognizer(MessageRecognizer messagerecognizer) {
        this.messagerecognizer = messagerecognizer;
    }

    public void addSessionListener(SessionListener sessionlistener) {
        this.sessionListeners.add(sessionlistener);
    }

    public void removeSessionListener(SessionListener sessionlistener) {
        this.sessionListeners.remove(sessionlistener);
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }

    public void start(boolean flag) throws IllegalStateException {
        this.msgDispatcher = new MsgDispatcher();
        Thread msgDispatcherThread = new Thread((Runnable)this.msgDispatcher, "net.sf.jml.net.SocketSession.msgDispatcher");
        msgDispatcherThread.start();
        this.msgSender = new MsgSender();
        Thread msgSenderThread = new Thread((Runnable)this.msgSender, "net.sf.jml.net.SocketSession.msgSender");
        msgSenderThread.start();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block15: {
                    try {
                        Session.this.socket = new Socket();
                        Session.this.socket.connect(Session.this.socketAddress);
                        Session.this.socket.setKeepAlive(true);
                        Session.this.isAvailable = true;
                        Session.this.in = Session.this.socket.getInputStream();
                        Session.this.out = Session.this.socket.getOutputStream();
                        Session.this.fireSessionEstablished();
                    }
                    catch (Exception ex) {
                        logger.error((Object)"error establishing connection ", (Throwable)ex);
                        Session.this.firExceptionCaught(ex);
                        return;
                    }
                    ByteBuffer readBuffer = ByteBufferUtils.allocate(131072, false);
                    try {
                        int readBytesLen;
                        do {
                            ByteBuffer byteBuffer = readBuffer;
                            synchronized (byteBuffer) {
                                if (readBuffer == null) {
                                    readBuffer = ByteBufferUtils.allocate(131072, false);
                                } else if (!readBuffer.hasRemaining()) {
                                    readBuffer = ByteBufferUtils.increaseCapacity(readBuffer, 131072);
                                }
                                byte[] buff = new byte[4096];
                                readBytesLen = Session.this.in.read(buff);
                                if (readBytesLen < 0) {
                                    return;
                                }
                                byte[] readBytes = new byte[readBytesLen];
                                System.arraycopy(buff, 0, readBytes, 0, readBytesLen);
                                readBuffer.put(readBytes);
                                readBuffer.flip();
                                Session.this.recognizeMessageAndDispatch(readBuffer);
                                readBuffer.compact();
                            }
                        } while (readBytesLen > 0);
                    }
                    catch (SocketException ex) {
                        if (Session.this.isClosing) {
                            Session.this.isClosing = false;
                        } else {
                            logger.debug((Object)"Smth happen to connection", (Throwable)ex);
                            Session.this.fireSessionClosed();
                        }
                    }
                    catch (IOException ex) {
                        logger.error((Object)"Smth happen to connection - IO ex", (Throwable)ex);
                        if (Session.this.isClosing) break block15;
                        Session.this.fireSessionClosed();
                    }
                }
            }
        }, "net.sf.jml.net.SocketSession.reader").start();
    }

    protected void recognizeMessageAndDispatch(ByteBuffer bytebuffer) {
        Message message;
        while (bytebuffer.hasRemaining() && (message = this.recognizeMessage(bytebuffer)) != null) {
            this.msgDispatcher.dispacthMsg(message);
        }
    }

    protected Message recognizeMessage(ByteBuffer bytebuffer) {
        Message message = this.messagerecognizer.recognize(this, bytebuffer.asReadOnlyBuffer());
        if (message == null) {
            return null;
        }
        boolean flag = message.readFromBuffer(bytebuffer);
        if (flag) {
            return message;
        }
        return null;
    }

    private void fireMessageReceived(Message msg) {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.messageReceived(this, msg);
            }
            catch (Exception ex) {
                logger.error((Object)"error firing events for msg received", (Throwable)ex);
            }
        }
    }

    private void fireMessageSent(Message msg) {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.messageSent(this, msg);
            }
            catch (Exception ex) {
                logger.error((Object)"error firing events for msg sent", (Throwable)ex);
            }
        }
    }

    private void fireSessionClosed() {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.sessionClosed(this);
            }
            catch (Exception ex) {
                logger.error((Object)"error firing events for close", (Throwable)ex);
            }
        }
    }

    private void firExceptionCaught(Throwable e) {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.exceptionCaught(this, e);
            }
            catch (Exception ex) {
                logger.error((Object)"error firing events for firExceptionCaught", (Throwable)ex);
            }
        }
    }

    private void fireSessionEstablished() {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.sessionEstablished(this);
            }
            catch (Exception ex) {
                logger.error((Object)"error firing events for sessionEstablished", (Throwable)ex);
            }
        }
    }

    private void fireSessionTimeout() {
        for (SessionListener sessionListener : this.sessionListeners) {
            try {
                sessionListener.sessionTimeout(this);
            }
            catch (Exception ex) {
                logger.error((Object)"error firing events for sessionEstablished", (Throwable)ex);
            }
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean flag) {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        this.msgDispatcher.stopDispatcher();
        this.msgSender.stopSender();
        try {
            this.socket.shutdownInput();
        }
        catch (IOException e) {
            logger.error((Object)"error shutting down input on socket", (Throwable)e);
        }
        try {
            this.socket.getOutputStream().flush();
        }
        catch (IOException e) {
            logger.error((Object)"error flushing remaining output on socket", (Throwable)e);
        }
        if (this.timoutTimer != null) {
            this.timoutTimer.cancel();
            this.timoutTimer = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException ex) {
            logger.error((Object)"error closing socket", (Throwable)ex);
        }
        this.isAvailable = false;
        this.fireSessionClosed();
    }

    public void write(Message message) throws IllegalArgumentException, IllegalStateException {
        this.msgSender.sendMsg(message);
    }

    public boolean blockWrite(Message message) throws IllegalArgumentException, IllegalStateException {
        try {
            this.sendMessage(message);
        }
        catch (IOException ex) {
            logger.error((Object)"error sending msg", (Throwable)ex);
            return false;
        }
        this.fireMessageSent(message);
        return true;
    }

    private synchronized void sendMessage(Message message) throws IOException {
        ByteBuffer[] toSendBuffs;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        for (ByteBuffer buf : toSendBuffs = message.toByteBuffer()) {
            byte[] bsToWrite = new byte[buf.limit()];
            buf.get(bsToWrite, 0, bsToWrite.length);
            o.write(bsToWrite);
        }
        o.writeTo(this.out);
        this.out.flush();
    }

    public void setSessionTimeout(int i) {
        logger.debug((Object)("setSessionTimeout:" + i));
        if (this.socket != null) {
            if (this.timoutTimer == null) {
                this.timoutTimer = new Timer();
            }
            this.timoutTimer.schedule((TimerTask)new TimeoutFire(), i);
        }
    }

    private class TimeoutFire
    extends TimerTask {
        private TimeoutFire() {
        }

        public void run() {
            Session.this.fireSessionTimeout();
        }
    }

    private class MsgSender
    extends Thread {
        final Vector<Message> queue = new Vector();
        boolean isRunning = true;

        private MsgSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopSender() {
            this.isRunning = false;
            this.interrupt();
            while (!this.queue.isEmpty()) {
                Message message = this.queue.remove(0);
                try {
                    Session.this.sendMessage(message);
                    Session.this.fireMessageSent(message);
                }
                catch (IOException ex) {
                    logger.error((Object)("error sending msg: " + message), (Throwable)ex);
                }
            }
            Vector<Message> vector = this.queue;
            synchronized (vector) {
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning) {
                Vector<Message> vector = this.queue;
                synchronized (vector) {
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                    if (this.queue.isEmpty()) {
                        return;
                    }
                    Message message = this.queue.remove(0);
                    try {
                        Session.this.sendMessage(message);
                        Session.this.fireMessageSent(message);
                    }
                    catch (IOException ex) {
                        logger.error((Object)("error sending msg: " + message), (Throwable)ex);
                        ex.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void sendMsg(Message message) {
            Vector<Message> vector = this.queue;
            synchronized (vector) {
                this.queue.add(message);
                this.queue.notifyAll();
            }
        }
    }

    private class MsgDispatcher
    extends Thread {
        final Vector<Message> queue = new Vector();
        boolean isRunning = true;
        byte[] notDispatchedBuffer = null;

        private MsgDispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopDispatcher() {
            this.isRunning = false;
            this.interrupt();
            while (!this.queue.isEmpty()) {
                Message msg = this.queue.remove(0);
                Session.this.fireMessageReceived(msg);
            }
            Vector<Message> vector = this.queue;
            synchronized (vector) {
                this.queue.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning) {
                Vector<Message> vector = this.queue;
                synchronized (vector) {
                    if (this.queue.isEmpty()) {
                        try {
                            this.queue.wait();
                        }
                        catch (InterruptedException ex) {
                            return;
                        }
                    }
                }
                if (this.queue.isEmpty()) continue;
                Message msg = this.queue.remove(0);
                Session.this.fireMessageReceived(msg);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispacthMsg(Message msg) {
            Vector<Message> vector = this.queue;
            synchronized (vector) {
                this.queue.add(msg);
                this.queue.notifyAll();
            }
        }
    }
}

