/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.service.neomedia;

import java.net.InetAddress;
import java.net.InetSocketAddress;

public class MediaStreamTarget {
    private final InetSocketAddress rtpTarget;
    private final InetSocketAddress rtcpTarget;

    public MediaStreamTarget(InetSocketAddress rtpTarget, InetSocketAddress rtcpTarget) {
        this.rtpTarget = rtpTarget;
        this.rtcpTarget = rtcpTarget;
    }

    public MediaStreamTarget(InetAddress rtpAddr, int rtpPort, InetAddress rtcpAddr, int rtcpPort) {
        this(new InetSocketAddress(rtpAddr, rtpPort), new InetSocketAddress(rtcpAddr, rtcpPort));
    }

    public static boolean addressesAreEqual(InetSocketAddress addr1, InetSocketAddress addr2) {
        return addr1 == null ? addr2 == null : addr1.equals(addr2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        MediaStreamTarget mediaStreamTarget = (MediaStreamTarget)obj;
        return MediaStreamTarget.addressesAreEqual(this.getControlAddress(), mediaStreamTarget.getControlAddress()) && MediaStreamTarget.addressesAreEqual(this.getDataAddress(), mediaStreamTarget.getDataAddress());
    }

    public InetSocketAddress getDataAddress() {
        return this.rtpTarget;
    }

    public InetSocketAddress getControlAddress() {
        return this.rtcpTarget;
    }

    public int hashCode() {
        InetSocketAddress dataAddress;
        int hashCode = 0;
        InetSocketAddress controlAddress = this.getControlAddress();
        if (controlAddress != null) {
            hashCode |= controlAddress.hashCode();
        }
        if ((dataAddress = this.getDataAddress()) != null) {
            hashCode |= dataAddress.hashCode();
        }
        return hashCode;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " with dataAddress " + this.getDataAddress() + " and controlAddress " + this.getControlAddress();
    }
}

