/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.jmfext.media.protocol.directshow;

import java.awt.Dimension;
import java.io.IOException;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.control.FormatControl;
import javax.media.control.FrameRateControl;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.PushBufferStream;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.codec.video.AVFrame;
import org.jitsi.impl.neomedia.codec.video.AVFrameFormat;
import org.jitsi.impl.neomedia.codec.video.ByteBuffer;
import org.jitsi.impl.neomedia.jmfext.media.protocol.AbstractPushBufferStream;
import org.jitsi.impl.neomedia.jmfext.media.protocol.ByteBufferPool;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DSCaptureDevice;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DSFormat;
import org.jitsi.impl.neomedia.jmfext.media.protocol.directshow.DataSource;
import org.jitsi.util.Logger;

public class DirectShowStream
extends AbstractPushBufferStream<DataSource> {
    private static final Logger logger = Logger.getLogger(DirectShowStream.class);
    private final boolean automaticallyDropsLateVideoFrames = false;
    private final ByteBufferPool byteBufferPool = new ByteBufferPool();
    private ByteBuffer data;
    private final Object dataSyncRoot = new Object();
    private long dataTimeStamp;
    private final DSCaptureDevice.ISampleGrabberCB delegate = new DSCaptureDevice.ISampleGrabberCB(){

        @Override
        public void SampleCB(long source, long ptr, int length) {
            DirectShowStream.this.SampleCB(source, ptr, length);
        }
    };
    private DSCaptureDevice device;
    private Format format;
    private ByteBuffer nextData;
    private long nextDataTimeStamp;
    private Thread transferDataThread;
    private int nativePixelFormat = 0;
    private long avctx = 0L;
    private long avframe = 0L;

    static boolean isSupportedFormat(Format format) {
        Dimension size;
        AVFrameFormat avFrameFormat;
        long pixFmt;
        return format instanceof AVFrameFormat && (pixFmt = (long)(avFrameFormat = (AVFrameFormat)format).getDeviceSystemPixFmt()) != -1L && (size = avFrameFormat.getSize()) != null;
    }

    DirectShowStream(DataSource dataSource, FormatControl formatControl) {
        super(dataSource, formatControl);
    }

    private void connect() throws IOException {
        if (this.device == null) {
            throw new IOException("device == null");
        }
        this.device.setDelegate(this.delegate);
    }

    private void disconnect() throws IOException {
        try {
            this.stop();
        }
        finally {
            if (this.device != null) {
                this.device.setDelegate(null);
            }
        }
    }

    @Override
    protected Format doGetFormat() {
        return this.format == null ? super.doGetFormat() : this.format;
    }

    @Override
    protected Format doSetFormat(Format format) {
        if (DirectShowStream.isSupportedFormat(format)) {
            if (this.device == null) {
                return format;
            }
            try {
                this.setDeviceFormat(format);
            }
            catch (IOException ioe) {
                logger.error("Failed to set format on DirectShowStream: " + format, ioe);
            }
            return format.matches(this.format) ? format : null;
        }
        return super.doSetFormat(format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Buffer buffer) throws IOException {
        Object object = this.dataSyncRoot;
        synchronized (object) {
            if (this.data == null) {
                buffer.setLength(0);
                return;
            }
            Format bufferFormat = buffer.getFormat();
            if (bufferFormat == null && (bufferFormat = this.getFormat()) != null) {
                buffer.setFormat(bufferFormat);
            }
            if (bufferFormat instanceof AVFrameFormat) {
                if (this.nativePixelFormat == DSFormat.MJPG) {
                    Object out;
                    if (this.avctx == 0L) {
                        long avcodec = FFmpeg.avcodec_find_decoder(8);
                        this.avctx = FFmpeg.avcodec_alloc_context3(avcodec);
                        FFmpeg.avcodeccontext_set_workaround_bugs(this.avctx, 1);
                        if (FFmpeg.avcodec_open2(this.avctx, avcodec, new String[0]) < 0) {
                            throw new RuntimeException("Could not open codec CODEC_ID_MJPEG");
                        }
                        this.avframe = FFmpeg.avcodec_alloc_frame();
                    }
                    if (!(FFmpeg.avcodec_decode_video(this.avctx, this.avframe, this.data.getPtr(), this.data.getLength()) == -1 || (out = buffer.getData()) instanceof AVFrame && ((AVFrame)out).getPtr() == this.avframe)) {
                        buffer.setData((Object)new AVFrame(this.avframe));
                    }
                    this.data.free();
                    this.data = null;
                } else {
                    if (AVFrame.read(buffer, bufferFormat, this.data) < 0) {
                        this.data.free();
                    }
                    this.data = null;
                }
            } else {
                byte[] bytes;
                Object o = buffer.getData();
                int length = this.data.getLength();
                if (o instanceof byte[]) {
                    bytes = (byte[])o;
                    if (bytes.length < length) {
                        bytes = null;
                    }
                } else {
                    bytes = null;
                }
                if (bytes == null) {
                    bytes = new byte[length];
                    buffer.setData((Object)bytes);
                }
                this.data.free();
                this.data = null;
                buffer.setLength(length);
                buffer.setOffset(0);
            }
            buffer.setFlags(32896);
            buffer.setTimeStamp(this.dataTimeStamp);
            this.dataSyncRoot.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runInTransferDataThread() {
        boolean transferData = false;
        FrameRateControl frameRateControl = (FrameRateControl)((DataSource)this.dataSource).getControl(FrameRateControl.class.getName());
        long transferDataTimeStamp = -1L;
        while (Thread.currentThread().equals(this.transferDataThread)) {
            if (transferData) {
                BufferTransferHandler transferHandler = this.transferHandler;
                if (transferHandler != null) {
                    if (frameRateControl != null) {
                        long newTransferDataTimeStamp = System.currentTimeMillis();
                        if (transferDataTimeStamp != -1L) {
                            long t;
                            long minimumVideoFrameInterval;
                            float f;
                            float frameRate = frameRateControl.getFrameRate();
                            if (f > 0.0f && (minimumVideoFrameInterval = (long)(1000.0f / frameRate)) > 0L && (t = newTransferDataTimeStamp - transferDataTimeStamp) > 0L && t < minimumVideoFrameInterval) {
                                boolean interrupted = false;
                                try {
                                    Thread.sleep(minimumVideoFrameInterval - t);
                                }
                                catch (InterruptedException ie) {
                                    interrupted = true;
                                }
                                if (!interrupted) continue;
                                Thread.currentThread().interrupt();
                                continue;
                            }
                        }
                        transferDataTimeStamp = newTransferDataTimeStamp;
                    }
                    transferHandler.transferData((PushBufferStream)this);
                }
                Object frameRate = this.dataSyncRoot;
                synchronized (frameRate) {
                    if (this.data != null) {
                        this.data.free();
                    }
                    this.data = this.nextData;
                    this.dataTimeStamp = this.nextDataTimeStamp;
                    this.nextData = null;
                }
            }
            Object object = this.dataSyncRoot;
            synchronized (object) {
                if (this.data == null) {
                    this.data = this.nextData;
                    this.dataTimeStamp = this.nextDataTimeStamp;
                    this.nextData = null;
                }
                if (this.data == null) {
                    boolean interrupted = false;
                    try {
                        this.dataSyncRoot.wait();
                    }
                    catch (InterruptedException iex) {
                        interrupted = true;
                    }
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                    transferData = this.data != null;
                } else {
                    transferData = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SampleCB(long source, long ptr, int length) {
        BufferTransferHandler transferHandler;
        boolean transferData = false;
        Object object = this.dataSyncRoot;
        synchronized (object) {
            if (this.data != null) {
                if (this.nextData != null) {
                    this.nextData.free();
                    this.nextData = null;
                }
                this.nextData = this.byteBufferPool.getBuffer(length);
                if (this.nextData != null) {
                    this.nextData.setLength(DSCaptureDevice.samplecopy(source, ptr, this.nextData.getPtr(), length));
                    this.nextDataTimeStamp = System.nanoTime();
                }
                return;
            }
            if (this.data != null) {
                this.data.free();
                this.data = null;
            }
            this.data = this.byteBufferPool.getBuffer(length);
            if (this.data != null) {
                this.data.setLength(DSCaptureDevice.samplecopy(source, ptr, this.data.getPtr(), length));
                this.dataTimeStamp = System.nanoTime();
            }
            if (this.nextData != null) {
                this.nextData.free();
                this.nextData = null;
            }
            transferData = false;
            this.dataSyncRoot.notifyAll();
        }
        if (transferData && (transferHandler = this.transferHandler) != null) {
            transferHandler.transferData((PushBufferStream)this);
        }
    }

    void setDevice(DSCaptureDevice device) throws IOException {
        if (this.device != device) {
            if (this.device != null) {
                this.disconnect();
            }
            this.device = device;
            if (this.device != null) {
                this.connect();
            }
        }
    }

    private void setDeviceFormat(Format format) throws IOException {
        block7: {
            block6: {
                if (format == null) {
                    throw new IOException("format == null");
                }
                if (!(format instanceof AVFrameFormat)) break block6;
                AVFrameFormat avFrameFormat = (AVFrameFormat)format;
                this.nativePixelFormat = avFrameFormat.getDeviceSystemPixFmt();
                Dimension size = avFrameFormat.getSize();
                if (size == null) {
                    throw new IOException("format.size == null");
                }
                int hresult = this.device.setFormat(new DSFormat(size.width, size.height, avFrameFormat.getDeviceSystemPixFmt()));
                switch (hresult) {
                    case 0: 
                    case 1: {
                        this.format = format;
                        if (logger.isDebugEnabled()) {
                            logger.debug("Set format on DirectShowStream: " + format);
                            break;
                        }
                        break block7;
                    }
                    default: {
                        this.throwNewHResultException(hresult);
                        break;
                    }
                }
                break block7;
            }
            throw new IOException("!(format instanceof AVFrameFormat)");
        }
    }

    @Override
    public void start() throws IOException {
        super.start();
        boolean started = false;
        try {
            this.setDeviceFormat(this.getFormat());
            if (this.transferDataThread == null) {
                this.transferDataThread = new Thread(this.getClass().getSimpleName()){

                    @Override
                    public void run() {
                        DirectShowStream.this.runInTransferDataThread();
                    }
                };
                this.transferDataThread.start();
            }
            this.device.start();
            started = true;
        }
        finally {
            if (!started) {
                this.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        try {
            this.device.stop();
            this.transferDataThread = null;
            Object object = this.dataSyncRoot;
            synchronized (object) {
                if (this.data != null) {
                    this.data.free();
                    this.data = null;
                }
                if (this.nextData != null) {
                    this.nextData.free();
                    this.nextData = null;
                }
                this.dataSyncRoot.notifyAll();
            }
        }
        finally {
            super.stop();
            if (this.avctx != 0L) {
                FFmpeg.avcodec_close(this.avctx);
                FFmpeg.av_free(this.avctx);
                this.avctx = 0L;
            }
            if (this.avframe != 0L) {
                FFmpeg.avcodec_free_frame(this.avframe);
                this.avframe = 0L;
            }
            this.byteBufferPool.drain();
        }
    }

    private void throwNewHResultException(int hresult) throws IOException {
        throw new IOException("HRESULT 0x" + Long.toHexString((long)hresult & 0xFFFFFFFFL));
    }
}

