/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cryptozrtp.params;

import gnu.java.bigintcrypto.BigIntegerCrypto;
import java.math.BigInteger;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.mathzrtp.ec.ECConstants;
import org.bouncycastle.mathzrtp.ec.ECCurve;
import org.bouncycastle.mathzrtp.ec.ECPoint;

public class ECDomainParameters
implements ECConstants {
    org.bouncycastle.mathzrtp.ec.ECCurve curve;
    byte[] seed;
    ECPoint G;
    BigIntegerCrypto n;
    BigIntegerCrypto h;

    public ECDomainParameters(org.bouncycastle.mathzrtp.ec.ECCurve curve, ECPoint G, BigIntegerCrypto n) {
        this.curve = curve;
        this.G = G;
        this.n = n;
        this.h = ONE;
        this.seed = null;
    }

    public ECDomainParameters(org.bouncycastle.mathzrtp.ec.ECCurve curve, ECPoint G, BigIntegerCrypto n, BigIntegerCrypto h) {
        this.curve = curve;
        this.G = G;
        this.n = n;
        this.h = h;
        this.seed = null;
    }

    public ECDomainParameters(org.bouncycastle.mathzrtp.ec.ECCurve curve, ECPoint G, BigIntegerCrypto n, BigIntegerCrypto h, byte[] seed) {
        this.curve = curve;
        this.G = G;
        this.n = n;
        this.h = h;
        this.seed = seed;
    }

    public ECDomainParameters(ECCurve curveIn, org.bouncycastle.math.ec.ECPoint GIn, BigInteger nIn, BigInteger hIn, byte[] seed) {
        ECCurve.Fp fpCurve = (ECCurve.Fp)curveIn;
        BigIntegerCrypto q = new BigIntegerCrypto(fpCurve.getQ().toByteArray());
        BigIntegerCrypto a = new BigIntegerCrypto(curveIn.getA().toBigInteger().toByteArray());
        BigIntegerCrypto b = new BigIntegerCrypto(curveIn.getB().toBigInteger().toByteArray());
        this.curve = new ECCurve.Fp(q, a, b);
        byte[] encoded = GIn.getEncoded();
        this.G = this.curve.decodePoint(encoded);
        this.n = new BigIntegerCrypto(nIn.toByteArray());
        this.h = new BigIntegerCrypto(hIn.toByteArray());
        this.seed = seed;
    }

    public org.bouncycastle.mathzrtp.ec.ECCurve getCurve() {
        return this.curve;
    }

    public ECPoint getG() {
        return this.G;
    }

    public BigIntegerCrypto getN() {
        return this.n;
    }

    public BigIntegerCrypto getH() {
        return this.h;
    }

    public byte[] getSeed() {
        return this.seed;
    }
}

