/*
 * Decompiled with CFR 0.152.
 */
package ymsg.network;

import java.util.Properties;
import ymsg.network.DirectConnectionHandler;
import ymsg.network.NetworkConstants;

public class SOCKSConnectionHandler
extends DirectConnectionHandler
implements NetworkConstants {
    private String socksHost;
    private int socksPort;

    public SOCKSConnectionHandler() throws IllegalArgumentException {
        this.socksHost = System.getProperty("socksProxyHost", "");
        this.socksPort = Integer.parseInt(System.getProperty("socksProxyPort", "-1"));
        if (this.socksHost.length() <= 0 || this.socksPort <= 0) {
            throw new IllegalArgumentException("Bad SOCKS proxy properties: " + this.socksHost + ":" + this.socksPort);
        }
        System.getProperties().put("socksProxySet", "true");
    }

    public SOCKSConnectionHandler(String string, int n) {
        this.socksHost = string;
        this.socksPort = n;
        Properties properties = System.getProperties();
        properties.put("socksProxyHost", this.socksHost);
        properties.put("socksProxyPort", this.socksPort + "");
        properties.put("socksProxySet", "true");
    }

    @Override
    public String toString() {
        return "SOCKS connection: " + this.socksHost + ":" + this.socksPort;
    }
}

