/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.felix.scr.impl.helper.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.manager.AbstractComponentManager;

abstract class BaseMethod {
    protected static final Class COMPONENT_CONTEXT_CLASS = class$org$osgi$service$component$ComponentContext == null ? (class$org$osgi$service$component$ComponentContext = BaseMethod.class$("org.osgi.service.component.ComponentContext")) : class$org$osgi$service$component$ComponentContext;
    protected static final Class BUNDLE_CONTEXT_CLASS = class$org$osgi$framework$BundleContext == null ? (class$org$osgi$framework$BundleContext = BaseMethod.class$("org.osgi.framework.BundleContext")) : class$org$osgi$framework$BundleContext;
    protected static final Class SERVICE_REFERENCE_CLASS = class$org$osgi$framework$ServiceReference == null ? (class$org$osgi$framework$ServiceReference = BaseMethod.class$("org.osgi.framework.ServiceReference")) : class$org$osgi$framework$ServiceReference;
    protected static final Class MAP_CLASS = class$java$util$Map == null ? (class$java$util$Map = BaseMethod.class$("java.util.Map")) : class$java$util$Map;
    protected static final Class INTEGER_CLASS = class$java$lang$Integer == null ? (class$java$lang$Integer = BaseMethod.class$("java.lang.Integer")) : class$java$lang$Integer;
    private final AbstractComponentManager m_componentManager;
    private final String m_methodName;
    private final Class m_componentClass;
    private Method m_method = null;
    private final boolean m_methodRequired;
    private State m_state;
    static /* synthetic */ Class class$org$osgi$service$component$ComponentContext;
    static /* synthetic */ Class class$org$osgi$framework$BundleContext;
    static /* synthetic */ Class class$org$osgi$framework$ServiceReference;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$lang$Integer;

    protected BaseMethod(AbstractComponentManager componentManager, String methodName, Class componentClass) {
        this(componentManager, methodName, methodName != null, componentClass);
    }

    protected BaseMethod(AbstractComponentManager componentManager, String methodName, boolean methodRequired, Class componentClass) {
        this.m_componentManager = componentManager;
        this.m_methodName = methodName;
        this.m_methodRequired = methodRequired;
        this.m_componentClass = componentClass;
        this.m_state = this.m_methodName == null ? NotApplicable.INSTANCE : NotResolved.INSTANCE;
    }

    protected final AbstractComponentManager getComponentManager() {
        return this.m_componentManager;
    }

    protected final boolean isDS11() {
        return this.getComponentManager().getComponentMetadata().isDS11();
    }

    protected final String getMethodName() {
        return this.m_methodName;
    }

    protected final Class getComponentClass() {
        return this.m_componentClass;
    }

    synchronized void setMethod(Method method) {
        this.m_method = method;
        if (method != null) {
            this.m_state = Resolved.INSTANCE;
        } else if (this.m_methodRequired) {
            this.m_state = NotFound.INSTANCE;
        } else {
            this.getComponentManager().log(4, "{0} method [{1}] not found, ignoring", new Object[]{this.getMethodNamePrefix(), this.getMethodName()}, null);
            this.m_state = NotApplicable.INSTANCE;
        }
    }

    State getState() {
        return this.m_state;
    }

    private Method findMethod() throws InvocationTargetException {
        boolean acceptPrivate = this.isDS11();
        boolean acceptPackage = this.isDS11();
        Class targetClass = this.getComponentClass();
        ClassLoader targetClasslLoader = targetClass.getClassLoader();
        String targetPackage = BaseMethod.getPackageName(targetClass);
        Class theClass = targetClass;
        while (theClass != null) {
            try {
                Method method = this.doFindMethod(theClass, acceptPrivate, acceptPackage);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                this.getComponentManager().log(1, "DependencyManager : Suitable but non-accessible method found in class {0}", new Object[]{targetClass.getName()}, null);
                break;
            }
            theClass = theClass.getSuperclass();
            if (theClass == null) break;
            acceptPackage &= targetClasslLoader == theClass.getClassLoader() && targetPackage.equals(BaseMethod.getPackageName(theClass));
            acceptPrivate = false;
        }
        return null;
    }

    protected abstract Method doFindMethod(Class var1, boolean var2, boolean var3) throws SuitableMethodNotAccessibleException, InvocationTargetException;

    private boolean invokeMethod(Object componentInstance, Object rawParameter) {
        try {
            Object[] params = this.getParameters(this.m_method, rawParameter);
            this.m_method.invoke(componentInstance, params);
        }
        catch (IllegalStateException ise) {
            this.getComponentManager().log(3, ise.getMessage(), null);
            return false;
        }
        catch (IllegalAccessException ex) {
            this.getComponentManager().log(4, "Method {0} cannot be called", new Object[]{this.getMethodName()}, ex);
        }
        catch (InvocationTargetException ex) {
            this.getComponentManager().log(1, "The {0} method has thrown an exception", new Object[]{this.getMethodName()}, ex.getCause());
            return false;
        }
        catch (Throwable t) {
            this.getComponentManager().log(1, "The {0} method could not be called", new Object[]{this.getMethodName()}, t);
            return false;
        }
        return true;
    }

    protected abstract Object[] getParameters(Method var1, Object var2);

    protected String getMethodNamePrefix() {
        return "";
    }

    public Method getMethod(Class clazz, String name, Class[] parameterTypes, boolean acceptPrivate, boolean acceptPackage) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            if (BaseMethod.accept(method, acceptPrivate, acceptPackage)) {
                return method;
            }
            throw new SuitableMethodNotAccessibleException();
        }
        catch (NoSuchMethodException nsme) {
        }
        catch (NoClassDefFoundError cdfe) {
            if (this.getComponentManager().isLogEnabled(2)) {
                StringBuffer buf = new StringBuffer();
                buf.append("Failure loooking up method ").append(name).append('(');
                for (int i = 0; parameterTypes != null && i < parameterTypes.length; ++i) {
                    buf.append(parameterTypes[i].getName());
                    if (i <= 0) continue;
                    buf.append(", ");
                }
                buf.append(") in class class ").append(clazz.getName()).append(". Assuming no such method.");
                this.getComponentManager().log(2, buf.toString(), cdfe);
            }
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable, "Unexpected problem trying to get method " + name);
        }
        return null;
    }

    protected static boolean accept(Method method, boolean acceptPrivate, boolean acceptPackage) {
        if (Void.TYPE != method.getReturnType()) {
            return false;
        }
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
            method.setAccessible(true);
            return true;
        }
        if (Modifier.isPrivate(mod)) {
            if (acceptPrivate) {
                method.setAccessible(acceptPrivate);
                return true;
            }
            return false;
        }
        if (acceptPackage) {
            method.setAccessible(true);
            return true;
        }
        return false;
    }

    public static String getPackageName(Class clazz) {
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        return dot > 0 ? name.substring(0, dot) : "";
    }

    public boolean invoke(Object componentInstance, Object rawParameter) {
        return this.m_state.invoke(this, componentInstance, rawParameter);
    }

    public boolean methodExists() {
        return this.m_state.methodExists(this);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class NotApplicable
    implements State {
        private static final State INSTANCE = new NotApplicable();

        private NotApplicable() {
        }

        public boolean invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) {
            return true;
        }

        public boolean methodExists(BaseMethod baseMethod) {
            return true;
        }
    }

    private static class NotFound
    implements State {
        private static final State INSTANCE = new NotFound();

        private NotFound() {
        }

        public boolean invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) {
            baseMethod.getComponentManager().log(1, "{0} method [{1}] not found", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            return false;
        }

        public boolean methodExists(BaseMethod baseMethod) {
            return false;
        }
    }

    private static class NotResolved
    implements State {
        private static final State INSTANCE = new NotResolved();

        private NotResolved() {
        }

        private void resolve(BaseMethod baseMethod) {
            Method method;
            baseMethod.getComponentManager().log(4, "getting {0}: {1}", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            try {
                method = baseMethod.findMethod();
            }
            catch (InvocationTargetException ex) {
                method = null;
                baseMethod.getComponentManager().log(2, "{0} cannot be found", new Object[]{baseMethod.getMethodName()}, ex.getTargetException());
            }
            baseMethod.setMethod(method);
        }

        public boolean invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) {
            this.resolve(baseMethod);
            return baseMethod.getState().invoke(baseMethod, componentInstance, rawParameter);
        }

        public boolean methodExists(BaseMethod baseMethod) {
            this.resolve(baseMethod);
            return baseMethod.getState().methodExists(baseMethod);
        }
    }

    private static class Resolved
    implements State {
        private static final State INSTANCE = new Resolved();

        private Resolved() {
        }

        public boolean invoke(BaseMethod baseMethod, Object componentInstance, Object rawParameter) {
            baseMethod.getComponentManager().log(4, "invoking {0}: {1}", new Object[]{baseMethod.getMethodNamePrefix(), baseMethod.getMethodName()}, null);
            return baseMethod.invokeMethod(componentInstance, rawParameter);
        }

        public boolean methodExists(BaseMethod baseMethod) {
            return true;
        }
    }

    private static interface State {
        public boolean invoke(BaseMethod var1, Object var2, Object var3);

        public boolean methodExists(BaseMethod var1);
    }
}

