/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.mbean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.glassfish.admin.amx.core.AMXProxy;
import org.glassfish.admin.amx.util.StringUtil;

final class ParentChildren
implements Comparable<ParentChildren> {
    final AMXProxy mParent;
    final List<ParentChildren> mChildren;

    public ParentChildren(AMXProxy parent, List<ParentChildren> children) {
        this.mParent = parent;
        this.mChildren = children;
    }

    public void sortChildren() {
        Collections.sort(this.mChildren);
    }

    public boolean equals(Object rhs) {
        return rhs instanceof ParentChildren ? this.compareTo((ParentChildren)rhs) == 0 : false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 83 * hash + (this.mParent != null ? this.mParent.hashCode() : 0);
        hash = 83 * hash + (this.mChildren != null ? this.mChildren.hashCode() : 0);
        return hash;
    }

    @Override
    public int compareTo(ParentChildren rhs) {
        int cmp = this.mParent.type().compareTo(rhs.mParent.type());
        if (cmp == 0) {
            cmp = this.mParent.nameProp().compareTo(rhs.mParent.nameProp());
        }
        if (cmp == 0) {
            cmp = this.mChildren.size() - rhs.mChildren.size();
        }
        return cmp;
    }

    public AMXProxy parent() {
        return this.mParent;
    }

    public List<ParentChildren> children() {
        return this.mChildren;
    }

    public List<String> toLines(boolean details) {
        this.sortChildren();
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ParentChildren.descriptionFor(this.mParent));
        for (ParentChildren child : this.mChildren) {
            List<String> moreLines = ParentChildren.indentAll(child.toLines(details));
            lines.addAll(moreLines);
        }
        return lines;
    }

    public List<AMXProxy> asList() {
        ArrayList<AMXProxy> items = new ArrayList<AMXProxy>();
        items.add(this.mParent);
        for (ParentChildren child : this.mChildren) {
            items.addAll(child.asList());
        }
        return items;
    }

    public static ParentChildren hierarchy(AMXProxy top) {
        ArrayList<AMXProxy> children = new ArrayList<AMXProxy>();
        Map<String, Map<String, AMXProxy>> childrenMaps = top.childrenMaps();
        for (Map<String, AMXProxy> childrenOfType : childrenMaps.values()) {
            for (AMXProxy amx : childrenOfType.values()) {
                children.add(amx);
            }
        }
        ArrayList<ParentChildren> pcList = new ArrayList<ParentChildren>();
        for (AMXProxy child : children) {
            ParentChildren pc = ParentChildren.hierarchy(child);
            pcList.add(pc);
        }
        ParentChildren result = new ParentChildren(top, pcList);
        result.sortChildren();
        return result;
    }

    public static String descriptionFor(AMXProxy proxy) {
        String desc = proxy.type();
        String name = proxy.nameProp();
        if (name != null) {
            desc = desc + "=" + name;
        }
        return desc;
    }

    private static List<String> indentAll(List<String> lines) {
        ArrayList<String> linesIndented = new ArrayList<String>();
        String INDENT = "   ";
        for (String line : lines) {
            linesIndented.add("   " + line);
        }
        return linesIndented;
    }

    public static String getHierarchyString(AMXProxy top) {
        ParentChildren pc = ParentChildren.hierarchy(top);
        return StringUtil.toLines(pc.toLines(true));
    }
}

